/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef PCE_H
#define PCE_H

#include <stdint.h>
#include <Standalone.h>
#include <PceNativeCall.h>

#define ByteSwap16(n) ( ((((unsigned short) (n)) << 8) & 0xFF00) | \
                        ((((unsigned short) (n)) >> 8) & 0x00FF) )

#define ByteSwap32(n) ( ((((unsigned long) (n)) << 24) & 0xFF000000) | \
                        ((((unsigned long) (n)) <<  8) & 0x00FF0000) | \
                        ((((unsigned long) (n)) >>  8) & 0x0000FF00) | \
                        ((((unsigned long) (n)) >> 24) & 0x000000FF) )

#define Read68KUnaligned32(a) \
     ( ((((unsigned char *)(a))[0]) << 24) | \
       ((((unsigned char *)(a))[1]) << 16) | \
       ((((unsigned char *)(a))[2]) <<  8) | \
       ((((unsigned char *)(a))[3]) <<  0) )

#define Write68KUnaligned32(a, v) \
     ( ((unsigned char *)(a))[0]=(unsigned char)((unsigned long)(v) >> 24), \
       ((unsigned char *)(a))[1]=(unsigned char)((unsigned long)(v) >> 16), \
       ((unsigned char *)(a))[2]=(unsigned char)((unsigned long)(v) >>  8), \
       ((unsigned char *)(a))[3]=(unsigned char)((unsigned long)(v) >>  0) )


#endif
