#define SAMD51_PDM 1

#include <Arduino.h>

#include <Adafruit_ZeroI2S.h>
#include <math.h>

/* max volume for 32 bit data */
#define VOLUME ( (1UL << 31) - 1)

/* create a buffer for both the left and right channel data */
#define BUFSIZE 1
uint32_t left;
uint32_t right;

static int16_t filter2[192] = {
  0,-1,-1,-2,-4,-5,-6,-8,-9,-10,-11,-12,-12,-11,-10,-8,-5,-2,3,9,16,25,35,46,59,74,91,110,131,154,179,206,236,268,302,339,378,420,465,512,561,613,668,725,785,847,911,978,1047,1119,1192,1267,1345,1424,1504,1586,1670,1755,1841,1927,2015,2103,2192,2280,2369,2458,2546,2634,2721,2807,2892,2976,3058,3138,3217,3293,3367,3439,3508,3574,3638,3698,3755,3808,3858,3904,3947,3985,4019,4050,4076,4098,4115,4129,4138,4142,4142,4138,4129,4115,4098,4076,4050,4019,3985,3947,3904,3858,3808,3755,3698,3638,3574,3508,3439,3367,3293,3217,3138,3058,2976,2892,2807,2721,2634,2546,2458,2369,2280,2192,2103,2015,1927,1841,1755,1670,1586,1504,1424,1345,1267,1192,1119,1047,978,911,847,785,725,668,613,561,512,465,420,378,339,302,268,236,206,179,154,131,110,91,74,59,46,35,25,16,9,3,-2,-5,-8,-10,-11,-12,-12,-11,-10,-9,-8,-6,-5,-4,-2,-1,-1,0
};

// Use default pins in board variant
Adafruit_ZeroI2S i2s = Adafruit_ZeroI2S();

int16_t table[24][256] = {0};

void setup() {
  
  // make lookup tables
  for (byte k = 0; k < 24; k++) {
    for (int i = 0; i < 256; i++) {
      int temp1 = i;
      int32_t temp = 0;
      for (byte j = 0; j < 8; j++) {
        if (temp1 & 1) temp += filter2[j + (8 * k)];
        else temp -= filter2[j + (8 * k)];
        temp1 >>= 1;
      }
      table[k][i] = temp;
    }
  }

  i2s.begin(I2S_32_BIT, 22100);
  i2s.enableRx();
  pinMode(9,OUTPUT); // test pin
}

byte data = 0;
int32_t accumulator = 0;
uint32_t pastvalues[6] = {0};
byte pointer = 0;

void loop() {
 
    while(!(i2s.rxReady())) ; // wait for data
    i2s.read(&left, &right); // fetch a word (only fills left)
    
digitalWrite(9,1); // speed test

    pastvalues[pointer] = left; // store data in 6 word array
    pointer++;
    if (pointer == 6) pointer = 0;

    data--; // do decimation evey other word for /64
    if (data == 0) {
      for (byte m = 0; m < 6; m++) {
        byte j = pointer + m;
        if (j >= 6) j -= 6;
        uint32_t temp = pastvalues[j];
        byte n = (m << 2);
        accumulator += table[n][(temp & 0xff)];
        temp >>= 8;
        accumulator += table[n+1][(temp & 0xff)];
        temp >>= 8;
        accumulator += table[n+2][(temp & 0xff)];
        temp >>= 8;
        accumulator += table[n+3][(temp & 0xff)];
      } 

digitalWrite(9,0); // speed test

      analogWrite(A0, ((accumulator >> 3) + 0x0800)); // play data
      accumulator = 0;
      data = 2;
    }
    
digitalWrite(9,0); // speed test

}
