#!/usr/local/Cellar/gnuplot/5.2.1/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 5.2 patchlevel 1    last modified 2017-10-27 
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2017
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
# set terminal x11  nopersist enhanced font "Helvetica,16"
# set output
unset clip points
set clip one
unset clip two
set errorbars front 1.000000 
set border 31 front lt black linewidth 0.250 dashtype solid
set zdata 
set ydata 
set xdata 
set y2data 
set x2data 
set boxwidth
set style fill  empty border
set style rectangle back fc  bgnd fillstyle   solid 1.00 border lt -1
set style circle radius graph 0.02 
set style ellipse size graph 0.05, 0.03 angle 0 units xy
set dummy x, y
set format x "% h" 
set format y "% h" 
set format x2 "% h" 
set format y2 "% h" 
set format z "% h" 
set format cb "% h" 
set format r "% h" 
set ttics format "% h"
set timefmt "%d/%m/%y,%H:%M"
set angles radians
set tics back
set grid nopolar
set grid xtics nomxtics ytics nomytics noztics nomztics nortics nomrtics \
 nox2tics nomx2tics noy2tics nomy2tics nocbtics nomcbtics
set grid layerdefault   lt 0 linecolor 0 linewidth 0.500,  lt 0 linecolor 0 linewidth 0.500
unset raxis
set theta counterclockwise right
set style parallel front  lt black linewidth 2.000 dashtype solid
set key title "" center
set key fixed right top vertical Right noreverse enhanced autotitle nobox
set key noinvert samplen 4 spacing 1.5 width 0 height 0 
set key maxcolumns 0 maxrows 0
set key noopaque
unset label
unset arrow
set style increment default
unset style line
set style line 1  linecolor rgb "blue"  linewidth 5
set style line 2  linecolor rgb "#00ccdd"  linewidth 5
set style line 3  linecolor rgb "#00d500"  linewidth 5
set style line 4  linecolor rgb "#ee9900"  linewidth 5
set style line 5  linecolor rgb "red"  linewidth 5
set style line 6  linecolor rgb "magenta"  linewidth 5
set style line 9  linecolor rgb "black"  linewidth 5
unset style arrow
set style histogram clustered gap 2 title textcolor lt -1
unset object
set style textbox transparent margins  1.0,  1.0 border  lt -1 linewidth  1.0
set offsets 0, 0, 0, 0
set pointsize 1
set pointintervalbox 1
set encoding default
unset polar
unset parametric
unset decimalsign
unset micro
unset minussign
set view 60, 30, 1, 1
set view azimuth 0
set rgbmax 255
set samples 100, 100
set isosamples 41, 41
set surface 
unset contour
set cntrlabel  format '%8.3g' font '' start 5 interval 20
set mapping cartesian
set datafile separator whitespace
unset hidden3d
set cntrparam order 4
set cntrparam linear
set cntrparam levels auto 5
set cntrparam points 5
set size ratio 0 1,1
set origin 0,0
set style data points
set style function lines
unset xzeroaxis
unset yzeroaxis
unset zzeroaxis
unset x2zeroaxis
unset y2zeroaxis
set xyplane relative 0.5
set tics scale  1, 0.5, 1, 1, 1
set mxtics default
set mytics default
set mztics default
set mx2tics default
set my2tics default
set mcbtics default
set mrtics default
set nomttics
set xtics border in scale 1,0.5 mirror norotate  autojustify
set xtics  norangelimit autofreq 
set ytics border in scale 1,0.5 mirror norotate  autojustify
set ytics  norangelimit autofreq 
set ztics border in scale 1,0.5 nomirror norotate  autojustify
set ztics  norangelimit autofreq 
unset x2tics
unset y2tics
set cbtics border in scale 1,0.5 mirror norotate  autojustify
set cbtics  norangelimit autofreq 
set rtics axis in scale 1,0.5 nomirror norotate  autojustify
set rtics  norangelimit autofreq 
unset ttics
set title "" 
set title  font "" norotate
set timestamp bottom 
set timestamp "" 
set timestamp  font "" norotate
set trange [ * : * ] noreverse nowriteback
set urange [ * : * ] noreverse nowriteback
set vrange [ * : * ] noreverse nowriteback
set xlabel "" 
set xlabel  font "" textcolor lt -1 norotate
set x2label "" 
set x2label  font "" textcolor lt -1 norotate
set xrange [ * : * ] noreverse nowriteback
set x2range [ * : * ] noreverse nowriteback
set ylabel "" 
set ylabel  font "" textcolor lt -1 rotate
set y2label "" 
set y2label  font "" textcolor lt -1 rotate
set yrange [ * : * ] noreverse nowriteback
set y2range [ * : * ] noreverse nowriteback
set zlabel "" 
set zlabel  font "" textcolor lt -1 norotate
set zrange [ * : * ] noreverse nowriteback
set cblabel "" 
set cblabel  font "" textcolor lt -1 rotate
set cbrange [ * : * ] noreverse nowriteback
set rlabel "" 
set rlabel  font "" textcolor lt -1 norotate
set rrange [ * : * ] noreverse nowriteback
unset logscale
unset jitter
set zero 1e-08
set lmargin  -1
set bmargin  -1
set rmargin  -1
set tmargin  -1
set locale "en_US.UTF-8"
set pm3d explicit at s
set pm3d scansautomatic
set pm3d interpolate 1,1 flush begin noftriangles noborder corners2color mean
set pm3d nolighting
set palette positive nops_allcF maxcolors 0 gamma 1.5 color model RGB 
set palette rgbformulae 7, 5, 15
set colorbox default
set colorbox vertical origin screen 0.9, 0.2 size screen 0.05, 0.6 front  noinvert bdefault
set style boxplot candles range  1.50 outliers pt 7 separation 1 labels auto unsorted
set loadpath 
set fontpath 
set psdir
set fit brief errorvariables nocovariancevariables errorscaling prescale nowrap v5

xa = -10.0
xb =  10.0

cpx(x,y,z) = y*z - z*y
cpy(x,y,z) = z*(x-xb) - (x-xa)*z
cpz(x,y,z) = (x-xa)*y - y*(x-xb)

bb(x,y,z) = (x-xb)**2 + y**2 + z**2
aa(x,y,z) = (x-xa)**2 + y**2 + z**2
ab(x,y,z) = (x-xa)*(x-xb) + y**2 + z**2

a(x,y,z,eps) = sqrt(aa(x,y,z) + eps**2)
b(x,y,z,eps) = sqrt(bb(x,y,z) + eps**2)
csq(x,y,z,eps) = ab(x,y,z) + eps**2
dsq(x,y,z,eps) = cpx(x,y,z)**2 + cpy(x,y,z)**2 + cpz(x,y,z)**2 + (xb-xa)**2*eps**2

A(x,y,z,eps) = (b(x,y,z,eps) - csq(x,y,z,eps)/a(x,y,z,eps)) / dsq(x,y,z,eps)
B(x,y,z,eps) = (a(x,y,z,eps) - csq(x,y,z,eps)/b(x,y,z,eps)) / dsq(x,y,z,eps)

Ax(x,y,z,eps) = ((x-xa) + (x-xb))/a(x,y,z,eps) \
          - (x-xa)*csq(x,y,z,eps)/a(x,y,z,eps)**3 \
          - (x-xb)/b(x,y,z,eps)
Ay(x,y,z,eps) = (y + y)/a(x,y,z,eps) \
          - y*csq(x,y,z,eps)/a(x,y,z,eps)**3 \
          - y/b(x,y,z,eps)
Az(x,y,z,eps) = (z + z)/a(x,y,z,eps) \
          - z*csq(x,y,z,eps)/a(x,y,z,eps)**3 \
          - z/b(x,y,z,eps)

Bx(x,y,z,eps) = ((x-xa) + (x-xb))/b(x,y,z,eps) \
          - (x-xb)*csq(x,y,z,eps)/b(x,y,z,eps)**3 \
          - (x-xa)/a(x,y,z,eps)
By(x,y,z,eps) = (y + y)/b(x,y,z,eps) \
          - y*csq(x,y,z,eps)/b(x,y,z,eps)**3 \
          - y/a(x,y,z,eps)
Bz(x,y,z,eps) = (z + z)/b(x,y,z,eps) \
          - z*csq(x,y,z,eps)/b(x,y,z,eps)**3 \
          - z/a(x,y,z,eps)

Cx(x,y,z,eps) = (x-xa)*2*(b(x,y,z,eps)**2 - csq(x,y,z,eps)) \
              + (x-xb)*2*(a(x,y,z,eps)**2 - csq(x,y,z,eps))
Cy(x,y,z,eps) =  y    *2*(b(x,y,z,eps)**2 - csq(x,y,z,eps)) \
              +  y    *2*(a(x,y,z,eps)**2 - csq(x,y,z,eps))
Cz(x,y,z,eps) =  z    *2*(b(x,y,z,eps)**2 - csq(x,y,z,eps)) \
              +  z    *2*(a(x,y,z,eps)**2 - csq(x,y,z,eps))


wsx(x,y,z,eps) = (x-xa)*A(x,y,z,eps) + (x-xb)*B(x,y,z,eps) 
wsy(x,y,z,eps) =  y    *A(x,y,z,eps) +  y    *B(x,y,z,eps) 
wsz(x,y,z,eps) =  z    *A(x,y,z,eps) +  z    *B(x,y,z,eps) 
wsr(x,y,z,eps) = sqrt(wsy(x,y,z,eps)**2 + wsz(x,y,z,eps)**2)

divs(x,y,z,eps) = \
  (wsx(x+0.001,y,z,eps) - wsx(x-0.001,y,z,eps))/0.002 \
+ (wsy(x,y+0.001,z,eps) - wsy(x,y-0.001,z,eps))/0.002 \
+ (wsz(x,y,z+0.001,eps) - wsz(x,y,z-0.001,eps))/0.002

wdxx(x,y,z,eps) = \
-(Ax(x,y,z,eps) + A(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * (x-xa) \
-(Bx(x,y,z,eps) + B(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * (x-xb) \
+ A(x,y,z,eps) + B(x,y,z,eps)

wdxy(x,y,z,eps) = \
-(Ax(x,y,z,eps) + A(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * y \
-(Bx(x,y,z,eps) + B(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * y 

wdxz(x,y,z,eps) = \
-(Ax(x,y,z,eps) + A(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * z \
-(Bx(x,y,z,eps) + B(x,y,z,eps)*Cx(x,y,z,eps))/dsq(x,y,z,eps) * z 


wdyx(x,y,z,eps) = \
-(Ay(x,y,z,eps) + A(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * (x-xa) \
-(By(x,y,z,eps) + B(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * (x-xb) 

wdyy(x,y,z,eps) = \
-(Ay(x,y,z,eps) + A(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * y \
-(By(x,y,z,eps) + B(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * y \
+ A(x,y,z,eps) + B(x,y,z,eps)

wdyz(x,y,z,eps) = \
-(Ay(x,y,z,eps) + A(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * z \
-(By(x,y,z,eps) + B(x,y,z,eps)*Cy(x,y,z,eps))/dsq(x,y,z,eps) * z 


wdzx(x,y,z,eps) = \
-(Az(x,y,z,eps) + A(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * (x-xa) \
-(Bz(x,y,z,eps) + B(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * (x-xb) 

wdzy(x,y,z,eps) = \
-(Az(x,y,z,eps) + A(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * y \
-(Bz(x,y,z,eps) + B(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * y 

wdzz(x,y,z,eps) = \
-(Az(x,y,z,eps) + A(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * z \
-(Bz(x,y,z,eps) + B(x,y,z,eps)*Cz(x,y,z,eps))/dsq(x,y,z,eps) * z \
+ A(x,y,z,eps) + B(x,y,z,eps)




#    EOF
