;;
;; iceray_3gons.lsp
;; definitions for the 3 sided rules
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; 3-sided polygon -> 3-sided polygon (x1) +
;;                    4-sided polygon (x1)
;;
(defun 3->3+4 (vertices / return)
  (if (= (length vertices) 3)
      (progn
	(bisect_polyshape vertices '(1 2) *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 3->3+4

;;
;; 3-sided polygon -> inscribed triangle
;;                      3-sided polygon (x1) +
;;                      4-sided polygon (x3)
;;
(defun 3->tri (vertices / a1 a2 b1 b2 c1 c2 ax bx cx return)
  (if (= (length vertices) 3)
      (progn
	(setq a1 (pointbetween (nth 0 vertices) (nth 1 vertices) 33 33))
	(setq a2 (pointbetween (nth 1 vertices) (nth 2 vertices) 50 50))
	(setq b1 (pointbetween (nth 2 vertices) (nth 1 vertices) 66 66))
	(setq b2 (pointbetween (nth 2 vertices) (nth 0 vertices) 50 50))
	(setq c1 (pointbetween (nth 2 vertices) (nth 0 vertices) 33 33))
	(setq c2 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	
	(setq ax (inters a1 a2 c1 c2 nil))
	(setq bx (inters b1 b2 a1 a2 nil))
	(setq cx (inters c1 c2 b1 b2 nil))
	
	(drawpolygon (list ax bx cx))
	(drawpolygon (list (nth 0 vertices) c2 cx b2))
	(drawpolygon (list (nth 1 vertices) a2 ax c2))
	(drawpolygon (list (nth 2 vertices) b2 bx a2))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 3->tri

;;
;; 3-sided polygon -> inscribed hexagon
;;                      3-sided polygon (x3) +
;;                      4-sided polygon (x3) +
;;                      6-sided polygon (x1)
;;
(defun 3->hex (vertices / a1 a2 a3 a4 a5 a6 x1 x2 x3 x4 x5 x6 return)
  (if (= (length vertices) 3)
      (progn
	(setq a1 (pointbetween (nth 0 vertices) (nth 1 vertices) 33 33))
	(setq a2 (pointbetween (nth 0 vertices) (nth 1 vertices) 66 66))
	(setq a3 (pointbetween (nth 1 vertices) (nth 2 vertices) 33 33))
	(setq a4 (pointbetween (nth 1 vertices) (nth 2 vertices) 66 66))
	(setq a5 (pointbetween (nth 2 vertices) (nth 0 vertices) 33 33))
	(setq a6 (pointbetween (nth 2 vertices) (nth 0 vertices) 66 66))

	(setq x1 (inters a1 a5 a2 a6 nil))
	(setq x2 (inters a1 a3 a2 a6 nil))
	(setq x3 (inters a1 a3 a4 a2 nil))
	(setq x4 (inters a3 a5 a4 a2 nil))
	(setq x5 (inters a3 a5 a4 a6 nil))
	(setq x6 (inters a1 a5 a4 a6 nil))
	
	(drawpolygon (list x1 x2 x3 x4 x5 x6))
	(drawpolygon (list (nth 0 vertices) a1 x6 a6))
	(drawpolygon (list a1 a2 x1))
	(drawpolygon (list (nth 1 vertices) a3 x2 a2))
	(drawpolygon (list a3 a4 x3))
	(drawpolygon (list (nth 2 vertices) a5 x4 a4))
	(drawpolygon (list a5 a6 x5))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 3->hex

;; tests
;; (3->tri (list (list 91 40) (list 185 -98) (list 40 -95)))
;; (3->hex (list (list 91 40) (list 185 -98) (list 40 -95)))
