;;
;; icerays_4gons.lsp
;; definitions for the 4-sided rules
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; 4-sided polygon -> 3-sided polygon (x1) +
;;                    5-sided polygon (x1)
;;
(defun 4->3+5 (vertices / return)
  (if (= (length vertices) 4)
      (progn
	(bisect_polyshape vertices '(1 3) 
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 4->3+5

;;
;; 4-sided polygon -> 4-sided polygon (x2)
;;
(defun 4->4+4 (vertices / return)
  (if (= (length vertices) 4)
      (progn
	(bisect_polyshape vertices '(2)
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 4->4+4

;;
;; 4-sided polygon -> inscribed triangle
;;                      3-sided polygon (x1) +
;;                      4-sided polygon (x2) +
;;                      5-sided polygon (x1)
;;
(defun 4->tri (vertices / a0 a2 a3 n0 n1 n2 x0 x2 x3 return)
  (if (= (length vertices) 4)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 25 25))
	(setq a3 (pointbetween (nth 3 vertices) (nth 0 vertices) 25 25))
	
	(setq n0 (pointbetween (nth 0 vertices) (nth 1 vertices) 25 25))
	(setq n1 (pointbetween (nth 1 vertices) (nth 2 vertices) 25 25))
	(setq n2 (pointbetween (nth 2 vertices) (nth 3 vertices) 75 75))
	
	(setq x0 (inters a0 n2 n0 a2 nil))
	(setq x2 (inters n1 a3 n0 a2 nil))
	(setq x3 (inters n1 a3 a0 n2 nil))
	
	(drawpolygon (list x0 x2 x3))
	(drawpolygon (list (nth 0 vertices) a0 x3 a3))
	(drawpolygon (list (nth 1 vertices) (nth 2 vertices) a2 x0 a0))
	(drawpolygon (list (nth 3 vertices) a3 x2 a2))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 4->tri

;;
;; 4-sided polygon -> inscribed square
;;                      4-sided polygon (x5)
;;
(defun 4->squ (vertices / return)
  (if (= (length vertices) 4)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	(setq a1 (pointbetween (nth 1 vertices) (nth 2 vertices) 50 50))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 50 50))
	(setq a3 (pointbetween (nth 3 vertices) (nth 0 vertices) 50 50))
	
	(setq x0 (inters (nth 0 vertices) a1 (nth 3 vertices) a0 nil))
	(setq x1 (inters (nth 0 vertices) a1 (nth 1 vertices) a2 nil))
	(setq x2 (inters (nth 2 vertices) a3 (nth 1 vertices) a2 nil))
	(setq x3 (inters (nth 2 vertices) a3 (nth 3 vertices) a0 nil))
	
	(drawpolygon (list x0 x1 x2 x3))
	(drawpolygon (list (nth 0 vertices) a0 x3 a3))
	(drawpolygon (list (nth 1 vertices) a1 x0 a0))
	(drawpolygon (list (nth 2 vertices) a2 x1 a1))
	(drawpolygon (list (nth 3 vertices) a3 x2 a2))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 4->squ

;; tests
;; (4->tri (list (list 18 13) (list 55 13) (list 55 -13) (list 18 -13)))
;; (4->squ (list (list 69 23) (list 145 -54) (list 69 -130) (list -8 -54)))
