;;
;; iceray_5gons.lsp
;; definitions for the 5-sided rules
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; 5-sided polygon -> 3-sided polygon (x1) +
;;                    6-sided polygon (x1)
;;
(defun 5->3+6 (vertices / return)
  (if (= (length vertices) 5)
      (progn
	(bisect_polyshape vertices '(1 4)
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 5->3+6

;;
;; 5-sided polygon -> 4-sided polygon (x1) +
;;                    5-sided polygon (x1)
;;
(defun 5->4+5 (vertices / return)
  (if (= (length vertices) 5)
      (progn
	(bisect_polyshape vertices '(2 3)
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 5->4+5

;;
;; 5-sided polygon -> inscribed triangle
;;                      3-sided polygon (x1) +
;;                      4-sided polygon (x1) +
;;                      5-sided polygon (x2)
;;
(defun 5->tri (vertices / return)
  (if (= (length vertices) 5)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 66 66))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 50 50))
	(setq a3 (pointbetween (nth 3 vertices) (nth 4 vertices) 66 66))
	
	(setq n0 (pointbetween (nth 0 vertices) (nth 1 vertices) 33 33))
	(setq n1 (pointbetween (nth 1 vertices) (nth 2 vertices) 50 50))
	(setq n3 (pointbetween (nth 3 vertices) (nth 4 vertices) 33 33))
	
	(setq x0 (inters a0 n3 n0 a2 nil))
	(setq x2 (inters n0 a2 n1 a3 nil))
	(setq x3 (inters n1 a3 a0 n3 nil))
	
	(drawpolygon (list x0 x2 x3))
	(drawpolygon (list (nth 0 vertices) a0 x3 a3 (nth 4 vertices)))
	(drawpolygon (list (nth 1 vertices) (nth 2 vertices) a2 x0 a0))
	(drawpolygon (list (nth 3 vertices) a3 x2 a2))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 5->tri

;;
;; 5-sided polygon -> inscribed pentagon
;;                      4-sided polygon (x5) +
;;                      5-sided polygon (x1)
;;
(defun 5->pen (vertices / a0 a1 a2 a3 a4 x0 x1 x2 x3 x4 return)
  (if (= (length vertices) 5)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	(setq a1 (pointbetween (nth 1 vertices) (nth 2 vertices) 50 50))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 50 50))
	(setq a3 (pointbetween (nth 3 vertices) (nth 4 vertices) 50 50))
	(setq a4 (pointbetween (nth 4 vertices) (nth 0 vertices) 50 50))

	(setq x0 (inters a0 a3 a1 a4 nil))
	(setq x1 (inters a0 a2 a1 a4 nil))
	(setq x2 (inters a0 a2 a1 a3 nil))
	(setq x3 (inters a2 a4 a1 a3 nil))
	(setq x4 (inters a2 a4 a0 a3 nil))
	
	(drawpolygon (list x0 x1 x2 x3 x4))
	(drawpolygon (list (nth 0 vertices) a0 x4 a4))
	(drawpolygon (list (nth 1 vertices) a1 x0 a0))
	(drawpolygon (list (nth 2 vertices) a2 x1 a1))
	(drawpolygon (list (nth 3 vertices) a3 x2 a2))
	(drawpolygon (list (nth 4 vertices) a4 x3 a3))
	
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 5->pen

;; tests
;; (5->tri (list (list 31 12) 
;;	      (list 48 4) (list 45 -15) (list 26 -18) (list 18 0)))
;; (5->pen (list (list 0 32)
;;	      (list 115 32)(list 151 -77)(list 58 -145)(list -35 -78)))

