;;
;; iceray_6gons.lsp
;; definitions for the 6-sided rules
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; 6-sided polygon -> 4-sided polygon (x1) +
;;                    6-sided polygon (x1)
;;
(defun 6->4+6 (vertices / return)
  (if (= (length vertices) 6)
      (progn
	(bisect_polyshape vertices '(2 4)
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 6->4+6

;;
;; 6-sided polygon -> 5-sided polygon (x2)
;;
(defun 6->5+5 (vertices / return)
  (if (= (length vertices) 6)
      (progn
	(bisect_polyshape vertices '(3)
			  *min_line_percent* *max_line_percent*)
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 6->5+5

;;
;; 6-sided polygon -> inscribed triangle
;;                      3-sided polygon (x1) +
;;                      5-sided polygon (x3)
;;
(defun 6->tri (vertices / a0 a2 a4 x0 x2 x4 return)
  (if (= (length vertices) 6)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 50 50))
	(setq a4 (pointbetween (nth 4 vertices) (nth 5 vertices) 50 50))
	
	(setq x0 (inters (nth 0 vertices) a2 (nth 4 vertices) a0 nil))
	(setq x2 (inters (nth 2 vertices) a4 (nth 0 vertices) a2 nil))
	(setq x4 (inters (nth 4 vertices) a0 (nth 2 vertices) a4 nil))

	(drawpolygon (list x0 x2 x4))
	(drawpolygon (list (nth 0 vertices) a0 x4 a4 (nth 5 vertices)))
	(drawpolygon (list (nth 2 vertices) a2 x0 a0 (nth 1 vertices)))
	(drawpolygon (list (nth 4 vertices) a4 x2 a2 (nth 3 vertices)))
	
	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 6->tri

;;
;; 6-sided polygon -> inscribed hexagon
;;                      4-sided polygon (x6) +
;;                      6-sided polygon (x1)
;;
(defun 6->hex (vertices / a0 a1 a2 a3 a4 a5 x0 x1 x2 x3 x4 x5 return)
  (if (= (length vertices) 6)
      (progn
	(setq a0 (pointbetween (nth 0 vertices) (nth 1 vertices) 50 50))
	(setq a1 (pointbetween (nth 1 vertices) (nth 2 vertices) 50 50))
	(setq a2 (pointbetween (nth 2 vertices) (nth 3 vertices) 50 50))
	(setq a3 (pointbetween (nth 3 vertices) (nth 4 vertices) 50 50))
	(setq a4 (pointbetween (nth 4 vertices) (nth 5 vertices) 50 50))
	(setq a5 (pointbetween (nth 5 vertices) (nth 0 vertices) 50 50))
	
	(setq x0 (inters a0 a4 a1 a5 nil))
	(setq x1 (inters a0 a2 a1 a5 nil))
	(setq x2 (inters a0 a2 a1 a3 nil))
	(setq x3 (inters a2 a4 a1 a3 nil))
	(setq x4 (inters a2 a4 a3 a5 nil))
	(setq x5 (inters a0 a4 a3 a5 nil))

	(drawpolygon (list x0 x1 x2 x3 x4 x5))
	(drawpolygon (list (nth 0 vertices) a0 x5 a5))
	(drawpolygon (list (nth 1 vertices) a1 x0 a0))
	(drawpolygon (list (nth 2 vertices) a2 x1 a1))
	(drawpolygon (list (nth 3 vertices) a3 x2 a2))
	(drawpolygon (list (nth 4 vertices) a4 x3 a3))
	(drawpolygon (list (nth 5 vertices) a5 x4 a4))

	(setq return T)
	)
    (setq return nil)
    )
  return
  );_ end of 6->hex

