;;
;; iceray_dialog.lsp
;; get_dialog_input
;; min_slider_action
;; max_slider_action
;; min_ebox_action
;; max_ebox_action
;; color_popup_list_action
;; size_popup_list_action
;; make_3d_action
;;
;; haldane liew
;; june 12, 2000
;;

(defun get_dialog_input ( / dialogloaded dialogshow
			    3->3+4_flag 3->tri_flag 3->hex_flag
			    4->3+5_flag 4->4+4_flag 4->tri_flag 4->squ_flag 
			    5->3+6_flag 5->4+5_flag 5->tri_flag 5->pen_flag 
			    6->4+6_flag 6->5+5_flag 6->tri_flag 6->hex_flag )

  ;; initial options
  (setq 3->3+4_flag nil 3->tri_flag nil 3->hex_flag nil
	4->3+5_flag nil 4->4+4_flag nil 4->tri_flag nil 4->squ_flag nil
	5->3+6_flag nil	5->4+5_flag nil 5->tri_flag nil	5->pen_flag nil
	6->4+6_flag nil	6->5+5_flag nil	6->tri_flag nil	6->hex_flag nil)
  (setq *min_area_percent* 0.10)
  (setq *min_line_percent* 40)
  (setq *max_line_percent* 60)
  (setq *viable_functions* nil)
  (setq *make3d* nil)
  (setq *color_number* 7)
  (setq dialogloaded T)
  (setq dialogshow T)

  (if (= -1 (setq dcl_id (load_dialog "iceray_dialog.dcl")))
      (progn
	(princ "\nERROR: Cannot load iceray_dialog.dcl")
	(setq dialogLoaded nil)
	) ;_ end of progn
    ) ;_ end of if
  
  (if (and dialogLoaded
	   (not (new_dialog "iceraydialog" dcl_id))
	   ) ;_ end of and
      (progn
	(princ "\nERROR: Cannot show dialog iceraydialog")
	(setq dialogShow nil)
	) ;_ end of progn
    ) ;_ end of if

  (if (and dialogLoaded dialogShow)
      (progn
	;; 3 sided rules
	(action_tile "3->3+4"
		     "(if (= (atof $value) 1) (setq 3->3+4_flag T) (setq 3->3+4_flag nil))"
		     )
	(action_tile "3->tri"
		     "(if (= (atof $value) 1) (setq 3->tri_flag T) (setq 3->tri_flag nil))"
		     )
	(action_tile "3->hex"
		     "(if (= (atof $value) 1) (setq 3->hex_flag T) (setq 3->hex_flag nil))"
                     )
	;; 4 sided rules
	(action_tile "4->3+5"
		     "(if (= (atof $value) 1) (setq 4->3+5_flag T) (setq 4->3+5_flag nil))"
		     )
	(action_tile "4->4+4"
		     "(if (= (atof $value) 1) (setq 4->4+4_flag T) (setq 4->4+4_flag nil))"
		     )
	(action_tile "4->tri"
		     "(if (= (atof $value) 1) (setq 4->tri_flag T) (setq 4->tri_flag nil))"
		     )
	(action_tile "4->squ"
		     "(if (= (atof $value) 1) (setq 4->squ_flag T) (setq 4->squ_flag nil))"
		     )
	;; 5 sided rules
	(action_tile "5->3+6"
		     "(if (= (atof $value) 1) (setq 5->3+6_flag T) (setq 5->3+6_flag nil))"
		     )
	(action_tile "5->4+5"
		     "(if (= (atof $value) 1) (setq 5->4+5_flag T) (setq 5->4+5_flag nil))"
		     )
	(action_tile "5->tri"
		     "(if (= (atof $value) 1) (setq 5->tri_flag T) (setq 5->tri_flag nil))"
		     )
	(action_tile "5->pen"
		     "(if (= (atof $value) 1) (setq 5->pen_flag T) (setq 5->pen_flag nil))"
		     )
	;; 6 sided rules
	(action_tile "6->4+6"
		     "(if (= (atof $value) 1) (setq 6->4+6_flag T) (setq 6->4+6_flag nil))"
		     )
	(action_tile "6->5+5"
		     "(if (= (atof $value) 1) (setq 6->5+5_flag T) (setq 6->5+5_flag nil))"
		     )
	(action_tile "6->tri"
		     "(if (= (atof $value) 1) (setq 6->tri_flag T) (setq 6->tri_flag nil))"
		     )
	(action_tile "6->hex"
		     "(if (= (atof $value) 1) (setq 6->hex_flag T) (setq 6->hex_flag nil))"
		     )
	;; setup images
	(setq image_names '("3->3+4" "3->tri" "3->hex"
			    "4->3+5" "4->4+4" "4->tri" "4->squ"
			    "5->3+6" "5->4+5" "5->tri" "5->pen"
			    "6->4+6" "6->5+5" "6->tri" "6->hex"))
	(foreach item image_names
		 (setq item_name (strcat item "_img"))
		 (setq item_filename (strcat "iceraylib(" (substr item 1 2) (substr item 4) ")" ))
		 (start_image item_name)
		 (slide_image 0 0 (dimx_tile item_name) (dimy_tile item_name) item_filename)
		 (end_image)
		 )
	;; area stuff
	(setq list_of_sizes (list "Huge" "Big" "Medium" "Small" "Tiny"))
	(start_list "sizelist")
	(mapcar 'add_list list_of_sizes)
	(end_list)
	(set_tile "sizelist" "2")
	(action_tile "sizelist"
		     "(size_popup_list_action $value)"
		     )
	;; slider stuff
	(action_tile "min_slider_value"
		     "(min_slider_action $value)"
		     )
	(action_tile "max_slider_value"
		     "(max_slider_action $value)"
		     )
	;; edit boxes
	(action_tile "min_editbox_value"
		     "(min_ebox_action $value)"
		     )
	(action_tile "max_editbox_value"
		     "(max_ebox_action $value)"
		     )
	;; make3d toggle
	(action_tile "make_3d"
		     "(make_3d_action $value)"
		     )
	;; color list
	(setq list_of_colors (list "Red" "Yellow" "Green" "Cyan" "Blue"
				   "Magenta" "White" "Dark Grey" "Light Grey"))
	(start_list "colorlist")
	(mapcar 'add_list list_of_colors)
	(end_list)
	(set_tile "colorlist" "6")
	(action_tile "colorlist"
		     "(color_popup_list_action $value)"
		     )
	;; ok and cancel buttons
	(action_tile "accept"
		     (strcat "(progn"
			     "(setq *min_line_percent* (* 100 (atof (get_tile \"min_editbox_value\"))))"
			     "(setq *max_line_percent* (* 100 (atof (get_tile \"max_editbox_value\"))))"
			     "(done_dialog) (setq userclick T))"
			     );end of strcat
		     )
	(action_tile "cancel"
		     "(done_dialog) (setq userclick nil)"
		     )

	(start_dialog)
	(unload_dialog dcl_id)

	(if userclick
	    (progn
	      (if 3->3+4_flag (setq *viable_functions* (cons 3->3+4 *viable_functions*)))
	      (if 3->tri_flag (setq *viable_functions* (cons 3->tri *viable_functions*)))
              (if 3->hex_flag (setq *viable_functions* (cons 3->hex *viable_functions*)))
	      (if 4->3+5_flag (setq *viable_functions* (cons 4->3+5 *viable_functions*)))
	      (if 4->4+4_flag (setq *viable_functions* (cons 4->4+4 *viable_functions*)))
	      (if 4->tri_flag (setq *viable_functions* (cons 4->tri *viable_functions*)))
	      (if 4->squ_flag (setq *viable_functions* (cons 4->squ *viable_functions*)))
	      (if 5->3+6_flag (setq *viable_functions* (cons 5->3+6 *viable_functions*)))
	      (if 5->4+5_flag (setq *viable_functions* (cons 5->4+5 *viable_functions*)))
	      (if 5->tri_flag (setq *viable_functions* (cons 5->tri *viable_functions*)))
	      (if 5->pen_flag (setq *viable_functions* (cons 5->pen *viable_functions*)))
	      (if 6->4+6_flag (setq *viable_functions* (cons 6->4+6 *viable_functions*)))
	      (if 6->5+5_flag (setq *viable_functions* (cons 6->5+5 *viable_functions*)))
	      (if 6->tri_flag (setq *viable_functions* (cons 6->tri *viable_functions*)))
	      (if 6->hex_flag (setq *viable_functions* (cons 6->hex *viable_functions*)))
	      );_end progn
	  );_end if
	);_end progn
    );_end if
  );_end of get_dialog_input

(defun min_slider_action (value)
  (if (> (atof value) (atof (get_tile "max_slider_value")))
      (progn
	(set_tile "min_editbox_value" (rtos (* (atof value) 0.01) 2 2))
	(set_tile "max_editbox_value" (rtos (* (atof value) 0.01) 2 2))
	(set_tile "max_slider_value" value)
	)
    (progn
	(set_tile "min_editbox_value" (rtos (* (atof value) 0.01) 2 2))
      )
    )
  )

(defun max_slider_action (value)
  (if (< (atof value) (atof (get_tile "min_slider_value")))
      (progn
	(set_tile "min_editbox_value" (rtos (* (atof value) 0.01) 2 2))
	(set_tile "max_editbox_value" (rtos (* (atof value) 0.01) 2 2))
	(set_tile "min_slider_value" value)
	)
    (progn
	(set_tile "max_editbox_value" (rtos (* (atof value) 0.01) 2 2))
      )
    )
  )

(defun min_ebox_action (value)
  (if (< (atof value) 0)
      (progn
	(set_tile "min_slider_value" "0")
	(set_tile "min_editbox_value" "0")
	)
    (if (> (* (atof value) 100) (atof (get_tile "max_slider_value")))
	(progn
	  (set_tile "min_slider_value" (rtos (* (atof value) 100) 2 2))
	  (set_tile "max_slider_value" (rtos (* (atof value) 100) 2 2))
	  (set_tile "max_editbox_value" value)
	  )
      (progn
	(set_tile "min_slider_value" (rtos (* (atof value) 100) 2 2))
	)
      )
    )
  )

(defun max_ebox_action (value)
  (if (> (atof value) 1)
      (progn
	(set_tile "max_slider_value" "100")
	(set_tile "max_editbox_value" "1")
	)
    (if (< (* (atof value) 100) (atof (get_tile "min_slider_value")))
	(progn
	  (set_tile "min_slider_value" (rtos (* (atof value) 100) 2 2))
	  (set_tile "max_slider_value" (rtos (* (atof value) 100) 2 2))
	  (set_tile "min_editbox_value" value)
	  )
      (progn
	(set_tile "max_slider_value" (rtos (* (atof value) 100) 2 2))
	)
      )
    )
  )

(defun color_popup_list_action (value)
  (cond
   ((= value "0") (setq *color_number* 1))
   ((= value "1") (setq *color_number* 2))
   ((= value "2") (setq *color_number* 3))
   ((= value "3") (setq *color_number* 4))
   ((= value "4") (setq *color_number* 5))
   ((= value "5") (setq *color_number* 6))
   ((= value "6") (setq *color_number* 7))
   ((= value "7") (setq *color_number* 8))
   ((= value "8") (setq *color_number* 9))
   )
  )

(defun size_popup_list_action (value)
  (cond
   ((= value "0") (setq *min_area_percent* 0.20))
   ((= value "1") (setq *min_area_percent* 0.10))
   ((= value "2") (setq *min_area_percent* 0.06))
   ((= value "3") (setq *min_area_percent* 0.03))
   ((= value "4") (setq *min_area_percent* 0.01))
   )
  )

(defun make_3d_action (value)
  (if (= (atof $value) 1) 
      (progn
	(setq *make3d* T)
	(mode_tile "colorlist" 0)
	)
    (progn
      (setq *make3d* nil)
      (mode_tile "colorlist" 1)
      )
    )
  )

