;;
;; iceray_main.lsp
;; c:iceray
;; iceray
;; make-iceray
;;
;; haldane liew
;; june 12, 2000
;;

(defun c:iceray ()
  (iceray)
  )

(defun iceray ()
  (setq obj_snap_mode (getvar "osmode"))
  (setvar "osmode" 0)
  (setq initobject (car (entsel "Pick an object to iceray:")))
  (setq *total_boundary_list* (entity_to_points initobject))
  (make-iceray *total_boundary_list*)
  (setvar "osmode" obj_snap_mode)
  (princ)
  );_ end of iceray

(defun make-iceray (*total_boundary_list* / copy_viable_functions)
  (setq total (ssget "CP" *total_boundary_list* '((0 . "LWPOLYLINE"))))
  (setq *total_area* (area_of_poly *total_boundary_list*))
  (setq minarea (* (area_of_poly *total_boundary_list*) 0.10))
  (setq num_entities (sslength total))
  (setq failtimes 0)

  (get_dialog_input)
  (if (= (length *viable_functions*) 0)
      (progn
;;;	(print "start diagnostics...")
;;;	(print "*color_number*    =")(princ *color_number*)
;;;	(print "*total_area*      =")(princ *total_area*)
;;;	(print "*make3d*          =")(princ *make3d*)
;;;	(print "*min_area_percent*=")(princ *min_area_percent*)
;;;	(print "*min_line_percent*=")(princ *min_line_percent*)
;;;	(print "*max_line_percent*=")(princ *max_line_percent*)
;;;	(print "*viable_functions*=")(princ *viable_functions*)
	(princ)
	(exit)
      );_ end of progn
    );_ end of if

  (setq minarea (* (area_of_poly *total_boundary_list*) *min_area_percent*))

  (while (< failtimes num_entities)
    (setq i 0)
    (repeat num_entities
	    (setq cur_entity (ssname total i))
	    (setq cur_points (entity_to_points cur_entity))
	    (setq cur_points (rearrange_max_points cur_points))
	    (setq numsides (length cur_points))
	    (setq area (area_of_poly cur_points))

	    (setq cur_points (list cur_points))
	    (entdel cur_entity)

	    (if (> area minarea)
		(progn
		  (setq copy_viable_functions *viable_functions*)
		  (setq ok T)
		  (while ok
		    (print copy_viable_functions)
		    (setq rand_nth_function (rand 0 (- (length copy_viable_functions) 1)))
		    (setq current_function (nth rand_nth_function copy_viable_functions))
		    (if (not (apply '(eval current_function) cur_points))
			(progn
			  ;(print "NO MATCH")(print current_function)(print cur_points)
			  (setq copy_viable_functions 
				(nth-remove rand_nth_function copy_viable_functions))
			  );_ end of progn
		      (progn
			;(print "MATCH")(print current_function)(print cur_points)
			(setq ok nil)
			);_ end of progn
		      );_ end of if
		    (if (null copy_viable_functions)
			(progn
			  (setq ok nil)
			  (setq failtimes (+ failtimes 1))
			  (setq cur_points (car cur_points))
			  (drawpolygon cur_points)
			  );_ end of progn
		      );_ end of if
		    );_ end of while
		  );_ end of progn
	      (progn
		(setq failtimes (+ failtimes 1))
		(setq cur_points (car cur_points))
		(drawpolygon cur_points)
		);_ end of progn
	      );_ end of if
	    (setq i (+ i 1))
	    );_ end of repeat
    (setq total (ssget "CP" *total_boundary_list* '((0 . "LWPOLYLINE"))))
    (setq num_entities (sslength total))
    );_ end of while
  
  (if *make3d*
      (progn
	(setq *offset_thickness* 
	      (* (max_distance *total_boundary_list*) 0.005))
	(frames *total_boundary_list* *offset_thickness*)
	(firstframe  *total_boundary_list* *offset_thickness*)
	(setq total (ssget "CP" *total_boundary_list* '((0 . "3DSOLID"))))
	(command "union" total "")
	(command "chprop" (entlast) "" "Color" *color_number* "")
	);_ end of progn
    );_ end of if

;;;  (print "what should have happened...")
;;;  (print "*color_number*    =")(princ *color_number*)
;;;  (print "*total_area*      =")(princ *total_area*)
;;;  (print "*make3d*          =")(princ *make3d*)
;;;  (print "*min_area_percent*=")(princ *min_area_percent*)
;;;  (print "*min_line_percent*=")(princ *min_line_percent*)
;;;  (print "*max_line_percent*=")(princ *max_line_percent*)
;;;  (print "*viable_functions*=")(princ *viable_functions*)
  (princ)

  );_ end of make-iceray
