;;
;; iceray_make3d.lsp
;; frames
;; firstframes
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; given a polygon entity, creates a solid with a given offset_thickness
;;
(defun frames (*total_boundary_list* *offset_thickness* / total num_objects i 
				     cur_entity cur_points a b innerpoint
				     innerframe outerframe)
  (setq total (ssget "CP" *total_boundary_list* '((0 . "LWPOLYLINE"))))
  (setq num_objects (sslength total))
  (setq i 0)
  (repeat num_objects
	  (setq cur_entity (ssname total i))
	  (setq cur_points (entity_to_points cur_entity))
	  (setq numsides (length cur_points))
	  (setq a (pointBetween (nth 0 cur_points) (nth 1 cur_points) 45 55))
	  (setq b (pointBetween (nth 1 cur_points) (nth 2 cur_points) 45 55))
	  (setq innerpoint (pointBetween a b 45 55))
	  (print *offset_thickness*)
	  (command "offset" *offset_thickness* cur_entity innerpoint "")
	  (setq innerframe (entlast))
	  (command "extrude" innerframe "" *offset_thickness* 0)
	  (setq innerframe (entlast))
	  (command "extrude" cur_entity "" *offset_thickness* 0)
	  (setq outerframe (entlast))
	  (command "subtract" outerframe "" innerframe "")
	  (setq i (+ i 1))
	  );_ end of repeat
  );_ end of frames

;;
;; create a frame around the first object which is also the boundary
;;
(defun firstframe (*total_boundary_list* *offset_thickness* / numsides item
					 point originalframe firsttime 
					 outerframe innerframe outerpoint)
  (setq numsides (length *total_boundary_list*))
  (setq item 0)

  (command "pline")
  (repeat numsides
	  (setq point (nth item *total_boundary_list*))
	  (command point)
	  (setq item (+ item 1))
	  )
  (command "c")

  (setq originalframe (entlast))

  (setq firsttime true)
  (setq item 0)
  (repeat numsides
	  (setq point (nth item *total_boundary_list*))
	  (setq additive (+ (car point) (cadr point)))
	  (if (= firsttime true)
	      (setq minpoint point)
	      (if (< additive (+ (car minpoint) (cadr minpoint)))
		  (setq minpoint point)
		);_ end of if
	      );_ end of if
	  (setq item (+ item 1))
	  (setq firsttime false)
	  );_ end of repeat
  (setq outerpoint (list (- (car minpoint) 1) (- (cadr minpoint) 1)))

  (command "offset" *offset_thickness* originalframe outerpoint "")
  (setq outerframe (entlast))
  (command "extrude" originalframe "" *offset_thickness* 0)
  (setq innerframe (entlast))
  (command "extrude" outerframe "" *offset_thickness* 0)
  (setq outerframe (entlast))
  (command "subtract" outerframe "" innerframe "")
  );_ end of firstframe
