;;
;; iceray_random.lsp
;; random functions taken from takehiko nagakura
;;
;; haldane liew
;; june 12, 2000
;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; random functions                                                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq *SeedRand* nil) ; initialize the global

;;
;; (rand16) : generates a random number between 1 and 32767,
;;            that is, a positive 16 bit integer(defun rand16 ( / s )
;;
(defun rand16 ( / s )
  ; when this is used for the first time, initialize the seed
  ; from the system clock.
  (if (null *SeedRand*)
        (progn
          (setq s (getvar "date"))
	  (setq *SeedRand* (fix (* 86400 (- s (fix s)))))
	  ) ; progn
    ) ; if

  (setq *SeedRand* (+ (* *SeedRand* 1103515245) 12345))

  ; trim off the bits left of the 16th bits
  (logand (/ *SeedRand* 65536) 32767)
  );_ end of rand16

;;
;; generates a random number between min and max.
;; min and max must be a non-negative integer smaller than 32678.
;;
(defun rand (min max / r16 range quotient remainder result)
  (setq r16         (rand16))          ; random number smaller than 32678
  (setq range       (+ 1 (- max min))) ; number of integers to be produced
  (setq quotient    (/ r16 range))     ; result in non-neg. integer
  (setq remainder   (- r16 (* quotient range)))
  (setq result      (+ min remainder))
  result
  );_ end of rand
