;;
;; iceray_util1.lsp
;; drawpolygon
;; pointbetween
;; bisect_polyshape
;;
;; june 12, 2000
;;

;;
;; draws the polygon given a list of points of the polygon.
;;
(defun drawpolygon (pointslist / numsides index)
  (setq numsides (length pointslist))
  (setq index 0)
  (command "pline")
  (repeat numsides
	  (command (nth index pointslist))
	  (setq index (+ index 1))
	  )
  (command "c")
  );_ end of drawpolygon

;;
;; finds a random point such that it lies on a line between
;; two points and is between low and high percentages.
;; low and high need to be expressed as whole numbers. eg. 35% = 35.
;;
(defun pointbetween (first second low high / 
			   x1 y1 x2 y2 range rangenum 
			   x3 y3 delta_x delta_y
			   ydiff xdiff m bhere)
  (setq x1 (float (car first))
	y1 (float (cadr first))
	x2 (float (car second))
	y2 (float (cadr second))
	range (rand low high))
  (setq rangenum (float (* range 0.01)))

  (setq delta_x (* (abs (- x2 x1)) rangenum))
  (if (> x2 x1) 
      (setq x3 (+ x1 delta_x))
    (setq x3 (- x1 delta_x))
    )
  (setq ydiff (- y2 y1))
  (setq xdiff (- x2 x1))
  (if (= xdiff 0)
      (progn
	(setq delta_y (* (abs (- y2 y1)) rangenum))
	(if (> y2 y1)
	    (setq y3 (+ y1 delta_y))
	  (setq y3 (- y1 delta_y))
	  )
	)
      (progn
	(setq m (/ ydiff xdiff))
	(setq bhere (- y2 (* m x2)))
	(setq y3 (+ (* m x3) bhere))
	)
      )
  (list x3 y3)
  );_ end of pointbetween

;;
;; assumes longest side is between the first two vertices
;; assumes that the highest number in viable_sides is <= the number
;;   of vertices
;;
;; example:
;;   (bisect_polyshape '((0 0) (1 0) (0 1)) '(2) 40 60)
;;
(defun bisect_polyshape (vertices viable_sides min_cut max_cut /
				  num_sides side index pba pbb a_polygon b_polygon)

  ;; the number of sides of the polygon is the length of the vertices list
  (setq num_sides (length vertices))

  ;; pick a point on the first side which is always the longest side
  (setq pba (pointBetween (nth 0 vertices) (nth 1 vertices) min_cut max_cut))

  ;; randomly pick one of the number of viable sides
  (setq side (nth (- (rand 1 (length viable_sides)) 1) viable_sides))

  ;; pick the second point of the cut.  if the cut is on the last side,
  ;; make sure to connect it to the zero point.
  (if (= side (- num_sides 1))
      (setq pbb (pointBetween (nth side vertices) (nth 0 vertices) 
			      min_cut max_cut))
    (setq pbb (pointBetween (nth side vertices) (nth (+ side 1) vertices)
			    min_cut max_cut))
    );_ end of if

  ;; draw the two new polylines
  (setq a_polygon (list pbb pba (nth 0 vertices)))
  (setq index (+ side 1))
  (repeat (- num_sides side 1)
	  (setq a_polygon (cons (nth index vertices) a_polygon))
	  (setq index (+ index 1))
	  )
  (drawpolygon (reverse a_polygon))

  (setq b_polygon (list pbb pba (nth 1 vertices)))
  (setq index side)
  (repeat (- side 1)
	  (setq b_polygon (cons (nth index vertices) b_polygon))
	  (setq index (- index 1))
	  )
  (drawpolygon (reverse b_polygon))
  );_ end of bisect_polyshape

;; tests
;;(bisect_polyshape (list (list 0 0) (list 4 0) (list 6 4) (list 2 6) (list -2 4)) 
;;		  (list 1 4) 40 60)
;;(bisect_polyshape (list (list 0 0) (list 4 0) (list 6 4) (list 2 6) (list -2 4)) 
;;		  (list 2 3) 40 60)
;;(bisect_polyshape (list (list 10 10) (list 14 10) (list 14 12) (list 10 12)) 
;;		  (list 2) 40 60)

