;;
;; iceray_util2.lsp
;; entity_to_points
;; area_of_poly
;; max_distance
;; rearrange_max_points
;; nth-remove
;;
;; haldane liew
;; june 12, 2000
;;

;;
;; take an polyline entity and returns a list of the points.
;; eg ((0 1) (1 1) (1 0))
;;
(defun entity_to_points (entity / index entity_info numsides)
  (setq index 14)
  (setq entity_info (entget entity))
  (setq numsides (cdr (assoc 90 entity_info)))
  (repeat numsides
	  (setq point (cdr (nth index entity_info)))
	  (if (= index 14) 
	      (setq pointslist (cons point ()))
	    (setq pointslist (cons point pointslist))
	    )
	  (setq index (+ index 4))
	  )
  (reverse pointslist)
  );_ end of entity_to_points

;;
;; given a list of points of polylines, returns the area of the polyline
;;
(defun area_of_poly (pointslist / pointa pointb x1 y1 x2 y2 term)
  (setq answer 0)
  (setq pointa (last pointslist))
  (setq pointb (car pointslist))
  (setq x1 (car pointa))
  (setq y1 (cadr pointa))
  (setq x2 (car pointb))
  (setq y2 (cadr pointb))
  (setq term (* 0.5 (- (* x1 y2) (* x2 y1))))
  (setq answer (+ answer term))
  (repeat (- (length pointslist) 1)
	  (setq pointa (car pointslist))
	  (setq pointb (cadr pointslist))
	  (setq x1 (car pointa))
	  (setq y1 (cadr pointa))
	  (setq x2 (car pointb))
	  (setq y2 (cadr pointb))
	  (setq term (* 0.5 (- (* x1 y2) (* x2 y1))))
	  (setq answer (+ answer term))
	  (setq pointslist (cdr pointslist))
	  )
  (abs answer)
  );_ end of area_of_poly

;;
;; given a list of points of a polyline, returns the maximum
;; distance in the polyline.
;;
(defun max_distance (pointslist / dist currentdist maxdist)
  (setq dist (distance (car pointslist) (last pointslist)))
  (repeat (- (length pointslist) 1)
	  (setq currentdist (distance (car pointslist) (cadr pointslist)))
	  (if (> currentdist dist) 
	      (setq maxdist currentdist)
	    (setq maxdist dist)
	    )
	  (setq pointslist (cdr pointslist))
	  )
  maxdist
  );_ end of max_distance

;;
;; given a list of points, returns a list of points where the first
;; two points will make up the max distance.
;;
(defun rearrange_max_points (pointslist 
   / index next maxdist numpoints startpoint currentdist)
  (setq index 0)
  (setq next (+ index 1))
  (setq maxdist (max_distance pointslist))
  (setq numpoints (length pointslist))
  (repeat numpoints
	  (setq a (nth index pointslist))
	  (setq b (nth next pointslist))
	  (setq currentdist (distance a b))
	  (if (= currentdist maxdist)
	      (setq startpoint index))
	  (setq index (+ index 1))
	  (if (= next (- numpoints 1))
	      (setq next 0)
	    (setq next (+ next 1))
	    )
	  )
  (setq index startpoint)
  (repeat numpoints
	  (setq a (nth index pointslist))
	  (if (= index startpoint)
	      (setq maxlist (cons a ()))
	    (setq maxlist (cons a maxlist))
	    )
	  (setq index (+ index 1))
	  (if (= index numpoints)
	      (setq index 0))
	  )
  (reverse maxlist)
  );_ end of rearrange_max_points

;;
;; removes the nth element of a list
;; 
(defun nth-remove (position elements / index return)
  (if (or (> position (- (length elements) 1))
	  (< position 0))
      (setq return nil)
    (progn
      (setq index 0)
      (setq return nil)
      (repeat position
	      (setq return (cons (nth index elements) return))
	      (setq index (+ index 1))
	      )
      (setq index (+ index 1))
      (repeat (- (length elements) position 1)
	      (setq return (cons (nth index elements) return))
	      (setq index (+ index 1))
	      )
      );_ end of progn
    );_ end of if 
  (reverse return)
  );_ end of nth-remove

