/*
       File:           DILArchive.h
       Contains:       Definitions for the Archive application using CDILs for NP:Communications 2.0 class
       Written by:     Bill Worzel, Arroyo Software
       Copyright:       1996 by Apple Computer, Inc.  All rights reserved.
       Change History (most recent first):
 */

/*
 *
 *
 *
 *                Definitions
 *
 */

/*
 *
 *        Local Definitions
 */
 
#define IDM_EXIT                    11

#define IDM_CONNECT                 21
#define IDM_DISCONNECT              22
#define IDM_ARCHIVE                 23

#define IDM_ABOUT                   31

#define IDM_COM_1                   32
#define IDM_COM_2                   33
#define IDM_COM_3                   34
#define IDM_COM_4                   35
#define IDM_COM_5                   36
#define IDM_COM_6                   37
#define IDM_COM_7                   38
#define IDM_COM_8                   39
#define IDM_COM_9                   40

#define IDD_DIALOG1                 101
#define IDC_EDIT1                   1000
#define IDC_STATUS                  1001

#define kMBarID                     128
#define kAppleMenu                  128
#define kFileMenu                   129
#define kEditMenu                   130
#define kTestMenu                   131
#define kConnectMenuItem            1
#define kDisconnectMenuItem         2
#define kArchiveItem                4       // separator line is item 3
#define kPortMenu                  132

// the Config (Port) menu
#define kSerialTool                 1
#define kModemTool                  2
#define kADSPTool                   3
#define kIRTool                     4
#define kFirstPortItem              6
#define kSplashDialog               128
#define kAboutDialog                201
#define kInfoDialog                 203
#define     kStatusDialog           129   

/*      Comm Status dialog resource ID  */
#define     kConnectState           2

/*      Text item's in status dialog    */
#define kArchiveState               3
#define kOurUserCancelled           -1
#define kOurTimeoutError            -2
#define kDeskAbortError             -3
#define kNewtAbortError             -4
#define kUnknownError               -5
#define kStatusStr                  128
#define kConnected                  1
#define kArchiving                  2
#define kDearchiving                3
#define kConfirming                 4
#define kResending                  5
#define kEndArchive                 6
#define kAborting                   7

/******      Function prototypes  *******/
void        EventLoop(void) ;
CommErr     InitializePipe ();
void        PostAlertMessage(char*a, char*b, char*c, char*d);
CommErr     DoConnectPipe (void);
long        CurrentTimeInSeconds(void);
void        CreateStatusDlog ( void );
void        UpdateStatus ( void );
void        SetArchiveStatus ( short archiveState );
void        SetupPortMenu( HMENU hMenu );
char*       StateStrings(int theState, char *theString);
CommErr     CreateFileName ( char *name );
CommErr     GetFileName ( char *name );
