/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.grouping;

import java.awt.Color;

public class PdfAlgorithm {
    protected static final int COLUMNS = 9;
    protected static final int SPLIT_TITLES = 7;
    protected static final int VERTICALS = 8;
    protected static final int OVERLAPS = 1;
    protected static final int PARAGRAPHS = 6;
    protected static final int STANDARD_STRUCT = 21;
    public static final int TABLE_CSV = 23;
    public static final int TABLE_HTML = 24;
    protected static final int TABLOID = 12;
    protected static final int LINES = 3;
    protected static final int OBJECTS = 10;
    protected static final int DROPCAPS = 4;
    protected static final int STANDARD_PARA = 20;
    protected static final int BLOCKS = 5;
    protected static final int NEWSPAGE = 11;
    protected static final int NOTHING = 0;
    protected static final int MULTICOLUMN = 24;
    private static final String[] algorithms_available = new String[]{"Nothing", "0", "Overlaps/Shadows", "1", "Lines", "3", "Drop caps", "4", "Blocks", "5", "Paragraphs", "6", "Titles", "7", "Verticals", "8", "Columns", "9", "Objects", "10", "single_newspage", "11", "single_tabloid_page", "12", "Standard pages (as paragraphs)", "20", "Standard pages (with line structure)", "21", "Page as CSVtable", "22", "Page as HTMLtable", "23", "Multi-column text", "24"};
    private static final Color[] algorithm_col = new Color[]{null, Color.white, Color.green, Color.darkGray, Color.cyan, Color.pink, Color.blue, Color.red, Color.magenta, Color.gray, Color.gray, Color.gray, Color.gray, Color.gray};
    private static final int algorithm_count = algorithms_available.length;

    public static Color[] getAlgorithmColors() {
        return algorithm_col;
    }

    public static final String[] getAlgorithmsAvailable() {
        return algorithms_available;
    }

    public static final boolean validateAlgorithmName(String string) {
        boolean bl = false;
        int n = 0;
        while (n < algorithm_count) {
            if (string.equals(algorithms_available[n])) {
                bl = true;
                n = algorithm_count;
            }
            n += 2;
        }
        return bl;
    }

    protected static final int getAlgorithmNumber(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < algorithm_count) {
            if (algorithms_available[n2].equals(string)) {
                n = Integer.parseInt(algorithms_available[n2 + 1]);
            }
            n2 += 2;
        }
        return n;
    }
}

