/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.grouping;

import com.idrsolutions.grouping.PdfTableGrouping;
import com.idrsolutions.utils.StripTags;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SortRectangles;

public class PdfComplexObjectGrouping
extends PdfTableGrouping {
    protected String[] shapes;
    protected boolean[] canBeStrap;
    protected boolean[] isRectangleOrphan;
    protected boolean[] hasContent;
    protected boolean[] isMaster;
    protected boolean[] hasText;
    protected boolean[] isSingleLine;
    protected int initial_item_count;

    protected final int[] getStoriesAvailable() {
        int n = 0;
        int[] nArray = new int[]{};
        int n2 = this.isUsed.length;
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (!(this.isUsed[n3] || this.isRectangleOrphan[n3] || this.hasContent[n3])) {
                nArray2[n] = n3;
                ++n;
            }
            ++n3;
        }
        if (n > 0) {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        return nArray;
    }

    private final void mergeAllStories(int[] nArray, int n) {
        boolean bl = false;
        int n2 = 1;
        while (n2 < n) {
            if (!bl) {
                bl = true;
                if (this.debug_level) {
                    LogWriter.writeLog("Merging " + this.names[nArray[0]]);
                }
            }
            if (this.debug_level) {
                LogWriter.writeLog("* with " + this.names[nArray[n2]]);
            }
            if (this.hasText[nArray[0]] & this.hasText[nArray[n2]]) {
                if (this.debug_level) {
                    LogWriter.writeLog("Left as text item: " + this.names[nArray[0]]);
                }
            } else {
                this.mergeStories(nArray[0], nArray[n2]);
                if (this.hasText[nArray[0]] | this.hasText[nArray[n2]]) {
                    this.hasText[nArray[0]] = true;
                }
            }
            ++n2;
        }
    }

    private final void preScanPage(int[] nArray) {
        if (nArray.length > 1) {
            this.mergeAdjacentMasterObjects(nArray);
            this.processDrownedMasters(nArray);
            this.processDrownedItems(nArray);
            this.mergeCaptionsAboveMasterObjects(nArray);
            this.mergeSingleLinesTogether(nArray);
        }
    }

    private final void processDrownedMasters(int[] nArray) {
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("===Looking for Drowned master objects");
        }
        int n2 = n - 1;
        while (n2 > -1) {
            int n3 = nArray[n2];
            if (this.isSingleLine[n3] && !this.isUsed[n3] && this.isMaster[n3]) {
                int n4 = n - 1;
                while (n4 > -1) {
                    int n5 = nArray[n4];
                    if (!this.isUsed[n5] && !this.hasText[n5] && !this.isMaster[n5] && this.f_x1[n5] <= this.f_x1[n3] && this.f_x2[n5] >= this.f_x2[n3] && this.f_y1[n3] <= this.f_y1[n5] && this.f_y2[n3] >= this.f_y2[n5]) {
                        if (this.debug_level) {
                            LogWriter.writeLog("Master object=" + this.names[n3] + " merged into " + this.names[n5]);
                        }
                        this.mergeStories(n3, n5);
                    }
                    --n4;
                }
            }
            --n2;
        }
    }

    protected final void single_newspage(int[] nArray) {
        this.current_level = 11;
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Single tabloid Merging algorithm being applied " + n + " items");
        }
        int n2 = 0;
        int n3 = 0;
        if (this.debug_level) {
            LogWriter.writeLog("===List of objects");
            this.showStories(nArray);
            LogWriter.writeLog("===Working through all objects");
        }
        int n4 = n - 1;
        while (n4 > -1) {
            n3 = nArray[n4];
            if (!this.isUsed[n3] & this.isMaster[n3]) {
                if (this.debug_level) {
                    LogWriter.writeLogWithoutCR("===Master object=" + this.names[n3] + " (" + this.f_x1[n3] + "," + this.f_x2[n3] + ")");
                }
                if (n4 != n) {
                    n2 = this.findNextMaster(n4, nArray, n);
                    this.mergeAnyChildItems(n4, n2, nArray, n);
                }
            }
            --n4;
        }
        StatusBar.updateStatus("Merging completed", 0);
        if (this.debug_level) {
            LogWriter.writeLog("===Merging any submerged objects");
        }
        this.mergeSubmergedObjects(nArray);
        int n5 = n - 1;
        while (n5 > -1) {
            n3 = nArray[n5];
            if (!this.isUsed[n3] & !this.isMaster[n3] & !this.hasText[n3]) {
                this.isRectangleOrphan[n3] = true;
            }
            --n5;
        }
    }

    private final void mergeSingleLinesTogether(int[] nArray) {
        int n;
        if (this.debug_level) {
            LogWriter.writeLog("===Looking for isolated single lines together");
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < this.isSingleLine.length) {
            this.isSingleLine[n3] = false;
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            float f;
            n = nArray[n4];
            if (!this.isRectangleOrphan[n] & (double)(f = this.f_y1[n] - this.f_y2[n]) < (double)this.heights[n] * 1.5 && !this.isUsed[n]) {
                this.isSingleLine[n] = true;
                if (this.debug_level) {
                    LogWriter.writeLog("Possible single line=" + this.names[n] + " (" + this.f_x1[n] + "," + this.f_x2[n] + ")");
                }
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            int n5 = nArray[n];
            if (this.isSingleLine[n5]) {
                int n6 = n + 1;
                while (n6 < n2) {
                    int n7 = nArray[n6];
                    if (this.isSingleLine[n7]) {
                        boolean bl;
                        boolean bl2 = this.page_data.testHorizontalBetween(-1.0f, this.f_x1[n5], this.f_x2[n5], this.f_y1[n5], this.f_y2[n5], this.f_x1[n7], this.f_x2[n7], this.f_y1[n7], this.f_y2[n7]);
                        boolean bl3 = this.f_x1[n5] >= this.f_x1[n7] - 2.0f && this.f_x1[n5] <= this.f_x2[n7] + 2.0f && this.f_x2[n5] >= this.f_x1[n7] - 2.0f && this.f_x2[n5] <= this.f_x2[n7] + 2.0f;
                        boolean bl4 = bl = this.f_x1[n7] >= this.f_x1[n5] - 2.0f && this.f_x1[n7] <= this.f_x2[n5] + 2.0f && this.f_x2[n7] >= this.f_x1[n5] - 2.0f && this.f_x2[n7] <= this.f_x2[n5] + 2.0f;
                        if (!this.isUsed[n5] && !bl2 && bl3 | bl) {
                            if (Math.abs(this.f_y1[n7] - this.f_y2[n5]) < this.heights[n5]) {
                                this.mergeStories(n5, n7);
                                this.isMaster[n7] = this.isMaster[n7] & this.isMaster[n5];
                                if (this.debug_level) {
                                    LogWriter.writeLog(" Line " + this.names[n7] + " (" + n7 + ") merged into " + this.names[n5] + " (" + n5 + ")");
                                }
                            }
                            n6 = n2;
                        }
                    }
                    ++n6;
                }
            }
            ++n;
        }
    }

    private final void mergeCaptionsAboveMasterObjects(int[] nArray) {
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("===Looking for isolated captions above Master objects");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            float f = this.f_y1[n3] - this.f_y2[n3];
            if (!this.isRectangleOrphan[n3] & !this.isUsed[n3] && !this.isMaster[n3] && f < this.heights[n3] * 2.0f) {
                if (this.debug_level) {
                    LogWriter.writeLog("Possible caption=" + this.names[n3] + " (" + this.f_x1[n3] + "," + this.f_x2[n3] + ")");
                }
                int n4 = n2 + 1;
                while (n4 < n) {
                    int n5 = nArray[n4];
                    if (this.bothStoriesInSameRectangle(n3, n5, n)) {
                        float f2 = this.f_x2[n5] - this.f_x1[n5];
                        boolean bl = this.page_data.testHorizontalBetween(-1.0f, this.f_x1[n3], this.f_x2[n3], this.f_y1[n3], this.f_y2[n3], this.f_x1[n5], this.f_x2[n5], this.f_y1[n5], this.f_y2[n5]);
                        if (!this.hasText[n3] && !bl && this.bothStoriesInSameRectangle(n3, n5, n) && this.mid_x[n3] >= this.f_x1[n5] && this.mid_x[n3] <= this.f_x2[n5] && (this.f_x1[n3] >= this.f_x1[n5] - 2.0f && this.f_x1[n3] <= this.f_x2[n5] + 2.0f) | (this.f_x2[n3] >= this.f_x1[n5] - 2.0f && this.f_x2[n3] <= this.f_x2[n5] + 2.0f)) {
                            if (this.isMaster[n5] & Math.abs(this.f_y1[n5] - this.f_y2[n3]) < this.heights[n3] * 2.0f) {
                                this.mergeStories(n5, n3);
                                if (this.debug_level) {
                                    LogWriter.writeLog("Caption " + this.names[n3] + " merged into " + this.names[n5]);
                                }
                            }
                            n4 = n;
                        }
                    } else if (this.debug_level) {
                        LogWriter.writeLog("Caption " + this.names[n3] + " not in same rectangle as" + this.names[n5]);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private final void mergeStories(int n, int n2) {
        boolean bl = this.isOrderCorrect(n, n2);
        this.mergeStory(n, n2, bl, true);
        if (this.isMaster[n] | this.isMaster[n2]) {
            this.isMaster[n] = true;
        }
        this.updateMasterMetrics(n, n2);
        if (this.hasText[n] | this.hasText[n2]) {
            this.hasText[n] = true;
        }
        this.isUsed[n2] = true;
    }

    private final void updateMasterMetrics(int n, int n2) {
        boolean bl = false;
        if (this.f_x1[n] > this.f_x1[n2]) {
            this.f_x1[n] = this.f_x1[n2];
            bl = true;
        }
        if (this.f_x2[n] < this.f_x2[n2]) {
            this.f_x2[n] = this.f_x2[n2];
            bl = true;
        }
        if (this.f_y2[n] > this.f_y2[n2]) {
            this.f_y2[n] = this.f_y2[n2];
            bl = true;
        }
        if (this.debug_level && bl) {
            LogWriter.writeLog("Object metrics updated to (" + this.f_x1[n] + "," + this.f_y1[n] + " " + this.f_x2[n] + "," + this.f_y2[n] + ")");
        }
    }

    private final int findNextMaster(int n, int[] nArray, int n2) {
        boolean bl = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = nArray[n];
        int n6 = nArray[n2 - 1];
        int n7 = n5 + 1;
        while (n7 < n6) {
            if (this.isMaster[n7] & !this.isUsed[n7] && this.f_y1[n7] < this.f_y1[n5] & (this.f_x1[n7] >= this.f_x1[n5] & this.f_x1[n7] <= this.f_x2[n5] | this.f_x2[n7] >= this.f_x1[n5] & this.f_x2[n7] <= this.f_x2[n5] | this.mid_x[n7] >= this.f_x1[n5] & this.mid_x[n7] <= this.f_x2[n5])) {
                if (!this.isUsed[n7]) {
                    n4 = n7;
                    bl = true;
                } else {
                    n4 = -1;
                }
                n7 = n6 + 1;
            }
            ++n7;
        }
        if (bl) {
            int n8 = 0;
            while (n8 < nArray.length) {
                if (n4 == nArray[n8]) {
                    n3 = n8;
                }
                ++n8;
            }
            if (n3 == -1) {
                bl = false;
            }
        }
        if (this.debug_level) {
            if (bl) {
                LogWriter.writeLog("Next Master object=" + this.names[n4] + " (" + this.f_x1[n4] + "," + this.f_x2[n4] + ")");
            } else if (this.debug_level) {
                LogWriter.writeLog("Bottom of page");
            }
        }
        return n3;
    }

    private final void showStories(int[] nArray) {
        boolean bl = true;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!this.isRectangleOrphan[n3] & (!this.hasContent[n3] | bl)) {
                String string = n3 + " " + this.names[n3] + " (" + this.f_x1[n3] + "," + this.f_y1[n3] + " " + this.f_x2[n3] + "," + this.f_y2[n3] + ") ";
                if (this.isMaster[n3]) {
                    string = "**" + string;
                }
                if (bl) {
                    if (this.hasContent[n3]) {
                        string = string + " COMPLETE ";
                    }
                    if (this.isMaster[n3]) {
                        string = string + " MASTER ";
                    }
                    if (this.hasText[n3]) {
                        string = string + " TEXT ";
                    }
                }
                if (this.debug_level) {
                    LogWriter.writeLog(string);
                }
            }
            ++n2;
        }
    }

    private final void recursivelyScanRectangles(int n) {
        int n2 = this.page_data.getRectangleCount();
        int[] nArray = SortRectangles.quicksort_rectangles(n2, this.page_data.r_size.get());
        if (this.debug_level) {
            LogWriter.writeLog("====================================");
            LogWriter.writeLog("===Merging any objects in rectangles");
        }
        int n3 = 0;
        while (n3 < n2) {
            float f;
            float f2;
            float f3;
            int n4 = nArray[n2 - n3 - 1];
            float f4 = this.page_data.r_x1.elementAt(n4);
            float f5 = this.page_data.r_x2.elementAt(n4);
            float f6 = f5 - f4;
            if (f6 > 5.0f & (f3 = (f2 = this.page_data.r_y1.elementAt(n4)) - (f = this.page_data.r_y2.elementAt(n4))) > 5.0f) {
                if (this.debug_level) {
                    LogWriter.writeLog("====================================");
                    LogWriter.writeLog("===Scanning rectangle " + f4 + "," + f2 + " " + f5 + "," + f);
                    LogWriter.writeLog("====================================");
                }
                int[] nArray2 = this.getStoriesInRectangle(n, f4, f2, f5, f, false, true);
                int n5 = nArray2.length;
                this.preScanPage(nArray2);
                nArray2 = this.getStoriesInRectangle(n, f4, f2, f5, f, false, false);
                n5 = nArray2.length;
                int[] nArray3 = this.getStoriesInRectangle(n, f4, f2, f5, f, true, false);
                int n6 = nArray3.length;
                int n7 = 0;
                if (n5 > 0) {
                    int n8;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n5) {
                        if (this.isMaster[nArray2[n10]] && !this.isUsed[nArray2[n10]]) {
                            ++n9;
                        }
                        ++n10;
                    }
                    if (n9 == 0) {
                        this.showStories(nArray2);
                        if (this.debug_level) {
                            LogWriter.writeLog("No master objects");
                        }
                        if (n5 > 1) {
                            this.mergeAllStories(nArray2, n5);
                        }
                    } else if (n9 == 1) {
                        this.showStories(nArray2);
                        if (this.debug_level) {
                            LogWriter.writeLog("One master object");
                        }
                        n8 = 0;
                        while (n8 < n6) {
                            if (this.hasText[nArray3[n8]] && !this.isUsed[nArray3[n8]]) {
                                ++n7;
                            }
                            ++n8;
                        }
                        if (n5 > 1) {
                            this.mergeAllStories(nArray2, n5);
                            if (n7 > 0) {
                                this.hasContent[nArray2[0]] = true;
                            }
                            if (n5 == 2 & this.isMaster[nArray2[1]]) {
                                this.hasContent[nArray2[0]] = false;
                            }
                        } else if (n7 < 2) {
                            if (this.debug_level) {
                                LogWriter.writeLog("One Master object found - checking for existing object within rectangle");
                            }
                            nArray2 = this.getStoriesInRectangle(n, f4, f2, f5, f, true, false);
                            if (this.debug_level) {
                                this.showStories(nArray2);
                            }
                            this.mergeAllStories(nArray2, nArray2.length);
                        }
                    } else {
                        LogWriter.writeLog("Multiple master objects");
                        n7 = 0;
                        n8 = 0;
                        while (n8 < nArray2.length) {
                            if (this.hasText[nArray2[n8]] && !this.isUsed[nArray2[n8]]) {
                                ++n7;
                            }
                            ++n8;
                        }
                        if (n7 == 1) {
                            this.mergeAllStories(nArray2, nArray2.length);
                        } else if (n7 > 1) {
                            this.single_newspage(nArray2);
                        }
                    }
                    if (this.debug_level) {
                        LogWriter.writeLog("===Items left");
                        nArray2 = this.getStoriesInRectangle(n, f4, f2, f5, f, false, false);
                        this.showStories(nArray2);
                    }
                }
            }
            ++n3;
        }
        if (this.debug_level) {
            LogWriter.writeLog("===Scanning rectangles completed");
        }
    }

    private final void mergeSubmergedObjects(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Checking for any submerged items");
        }
        int n4 = 0;
        while (n4 < n3) {
            n = nArray[n4];
            if (!this.isUsed[n]) {
                if (this.debug_level) {
                    LogWriter.writeLog("Testing for objects in " + this.names[n]);
                }
                int n5 = 0;
                while (n5 < n3) {
                    n2 = nArray[n5];
                    if (!this.hasContent[n2] && !this.isUsed[n2] & (!this.hasText[n2] | !this.hasText[n]) & n5 != n4 && this.mid_x[n2] >= this.f_x1[n] & this.mid_x[n2] <= this.f_x2[n] & this.mid_y[n2] <= this.f_y1[n] & this.mid_y[n2] >= this.f_y2[n] & (this.f_x1[n2] >= this.f_x1[n] & this.f_x1[n2] <= this.f_x2[n] & this.f_y1[n2] <= this.f_y1[n] & this.f_y1[n2] >= this.f_y2[n] | this.f_x2[n2] >= this.f_x1[n] & this.f_x2[n2] <= this.f_x2[n] & this.f_y2[n2] <= this.f_y1[n] & this.f_y2[n2] >= this.f_y2[n])) {
                        if (this.debug_level) {
                            LogWriter.writeLog(this.names[n] + "  encloses part of " + this.names[n2] + " (" + this.f_x1[n2] + "," + this.f_x2[n2] + ")");
                        }
                        boolean bl = this.isOrderCorrect(n, n2);
                        this.mergeStory(n, n2, bl, true);
                        this.isUsed[n2] = true;
                        if (this.isMaster[n2] & !this.isMaster[n]) {
                            this.hasContent[n] = true;
                            this.isMaster[n] = true;
                        }
                        if (this.hasText[n] | this.hasText[n2]) {
                            this.hasText[n] = true;
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
    }

    private final int[] getStoriesInRectangle(int n, float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n = this.initial_item_count;
        }
        int[] nArray = new int[n + 1];
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n + 1) {
            if (!this.isUsed[n3] && bl | !this.hasContent[n3] | !this.hasText[n3]) {
                boolean bl4 = this.mid_x[n3] >= f & this.mid_x[n3] <= f3 && this.mid_y[n3] <= f2 & this.mid_y[n3] >= f4;
                boolean bl5 = this.mid_x[n3] >= f & this.mid_x[n3] <= f3 && this.mid_y[n3] <= f2 & this.mid_y[n3] >= f4;
                boolean bl6 = this.f_x1[n3] >= f & this.f_x2[n3] <= f3;
                float f5 = (f3 - f) * (f2 - f4);
                float f6 = (this.f_x2[n3] - this.f_x1[n3]) * (this.f_y1[n3] - this.f_y2[n3]);
                if (f5 > f6 && bl6 && bl5 | bl4) {
                    nArray[n2] = n3;
                    ++n2;
                    stringBuffer.append(this.names[n3] + " , ");
                    bl3 = true;
                }
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        if (bl3 && bl2 && this.debug_level) {
            LogWriter.writeLog("[ " + stringBuffer + " ]");
        }
        return nArray2;
    }

    private final void mergeAnyChildItems(int n, int n2, int[] nArray, int n3) {
        boolean bl;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = nArray[n];
        int n6 = -1;
        if (n2 != -1) {
            n6 = nArray[n2];
        }
        boolean bl3 = false;
        if (n2 == -1) {
            bl3 = true;
            n2 = n3;
        }
        int n7 = n + 1;
        while (n7 < n2) {
            n4 = nArray[n7];
            if (!this.isRectangleOrphan[n4] & !this.isUsed[n4] & (!this.hasContent[n4] | !this.hasText[n4])) {
                if (this.debug_level) {
                    LogWriter.writeLogWithoutCR("Testing : " + this.names[n4] + " (" + this.f_x1[n4] + "," + this.f_x2[n4] + ")");
                }
                if (this.f_x1[n4] >= this.f_x1[n5] & this.f_x1[n4] <= this.f_x2[n5] | this.f_x1[n5] >= this.f_x1[n4] & this.f_x1[n5] <= this.f_x2[n4]) {
                    if (!this.isMaster[n4]) {
                        if (this.hasText[n5] & this.hasText[n4]) {
                            if (this.debug_level) {
                                LogWriter.writeLog(this.names[n5] + " already has text story. Kept separate");
                            }
                            this.hasContent[n4] = true;
                        } else {
                            if (this.debug_level) {
                                LogWriter.writeLog(this.names[n4] + " being merged. (" + this.f_x1[n4] + "," + this.f_x2[n4]);
                            }
                            bl = this.isOrderCorrect(n5, n4);
                            this.mergeStory(n5, n4, bl, true);
                            bl2 = true;
                            this.hasContent[n5] = true;
                            this.updateMasterMetrics(n5, n4);
                            this.isUsed[n4] = true;
                            if (this.hasText[n5] | this.hasText[n4]) {
                                this.hasText[n5] = true;
                            }
                        }
                    }
                } else if (this.debug_level) {
                    LogWriter.writeLog("No overlap on " + this.names[n4] + "(" + this.f_x1[n4] + "," + this.f_x2[n4] + ")");
                }
            }
            ++n7;
        }
        if (!bl3 & !this.hasText[n5] & !this.isMasterPartlyDrowned(n5, nArray)) {
            LogWriter.writeLog("Master " + this.names[n5] + " contains no text object - merged into " + this.names[n6] + " ");
            try {
                bl = this.isOrderCorrect(n5, n6);
                this.mergeStory(n5, n6, bl, true);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in merging routines");
            }
            this.hasContent[n5] = true;
            this.updateMasterMetrics(n5, n6);
            this.isUsed[n6] = true;
            if (this.hasText[n5] | this.hasText[n6]) {
                this.hasText[n5] = true;
            }
        } else if (!bl2 && this.debug_level) {
            LogWriter.writeLog("Left as isolated item");
        }
    }

    protected final void multicolumn() {
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n = 0;
        while (n < nArray.length - 1) {
            int n2 = nArray[n];
            if (!this.isUsed[n2]) {
                int n3;
                for (int i = n + 1; i != nArray.length && !(this.f_x1[n3 = nArray[i]] > this.f_x2[n2] + this.col_width[n2] / 4.0f); ++i) {
                    float f;
                    if (this.isUsed[n3] || !((double)(f = this.col_width[n3] < this.col_width[n2] ? this.col_width[n3] / this.col_width[n2] : this.col_width[n2] / this.col_width[n3]) > 0.9) || !this.bothStoriesInSameRectangle(n2, n3, nArray.length)) continue;
                    this.mergeStory(n2, n3, false, false);
                    this.updateMasterMetrics(n2, n3);
                }
            }
            ++n;
        }
    }

    protected final void standard_pages(int n, int n2) {
        boolean bl = false;
        if (this.algorithm_merging_level == 20) {
            bl = true;
            this.current_level = 20;
        } else if (this.algorithm_merging_level == 21) {
            this.current_level = 21;
        }
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n3 = (n + n2) / 2;
        int n4 = n3 / 2;
        int n5 = nArray.length;
        String string = "";
        String string2 = "Standard Merging algorithm being applied " + n5 + " items";
        if (this.debug_level) {
            LogWriter.writeLog(string2);
        }
        StatusBar.updateStatus(string2, 1);
        if (n5 > 1) {
            int n6;
            int n7 = 0;
            while (n7 < n5) {
                int n8 = -1;
                float f = -1.0f;
                if (!this.isUsed[n7]) {
                    while (true) {
                        n6 = n7 + 1;
                        while (n6 < n5) {
                            if (!this.isUsed[n6]) {
                                float f2;
                                float f3 = this.f_x1[n6] - this.f_x2[n7];
                                if (f3 < 0.0f & f3 > -2.0f) {
                                    f3 = 0.0f;
                                }
                                if (this.f_x1[n6] > this.f_x1[n7] && (f2 = (this.f_y1[n6] + this.f_y2[n6]) / 2.0f) < this.f_y1[n7] & f2 > this.f_y2[n7] && f < 0.0f | f3 < f) {
                                    f = f3;
                                    n8 = n6;
                                }
                            }
                            ++n6;
                        }
                        if (n8 == -1) break;
                        if (n8 == -1) continue;
                        float f4 = this.current_thresholds.get_threshold(this.font_data[n7]);
                        string = this.isGapASpace(n7, n8, this.f_x1[n8] - this.f_x2[n7], f4);
                        this.merge_fragment(n7, n8, string, "", true, true, true);
                        n8 = -1;
                        f = 1000000.0f;
                    }
                }
                ++n7;
            }
            int[] nArray2 = this.getsortedUnusedFragments(false, true);
            n6 = nArray2.length;
            int n9 = nArray2[n6 - 1];
            int n10 = 2;
            if (this.contents[n9].length() > 5) {
                int n11 = this.contents[n9].indexOf(">");
                int n12 = this.contents[n9].lastIndexOf("</");
                this.contents[n9] = this.contents[n9].substring(0, n11 + 1) + "<~L1><TOP>" + this.contents[n9].substring(n11 + 1, n12) + "</TOP><~/L1>" + this.contents[n9].substring(n12);
                n11 = this.contents[nArray2[0]].indexOf(">");
                n12 = this.contents[nArray2[0]].lastIndexOf("</");
                this.contents[nArray2[0]] = this.contents[nArray2[0]].substring(0, n11 + 1) + "<BOTTOM>" + this.contents[nArray2[0]].substring(n11 + 1, n12) + "</BOTTOM>" + this.contents[nArray2[0]].substring(n12);
            }
            int n13 = n6 - 2;
            while (n13 > -1) {
                float f;
                float f5;
                int n14 = nArray2[n13];
                string = "";
                String string3 = StripTags.strip(this.contents[n14], false).trim();
                String string4 = StripTags.strip(this.contents[n9], false).trim();
                if (string3.length() > 1) {
                    int n15 = this.contents[n14].indexOf(">");
                    int n16 = this.contents[n14].lastIndexOf("</");
                    this.contents[n14] = this.contents[n14].substring(0, n15 + 1) + "<~L" + n10 + ">" + this.contents[n14].substring(n15 + 1, n16) + "<~/L" + n10 + ">" + this.contents[n14].substring(n16);
                    ++n10;
                    f5 = (float)n3 - this.f_x1[n14];
                    if (f5 > 0.0f & (f = this.f_x2[n14] - (float)n3) > 0.0f & this.f_x1[n14] > (float)n4 & this.f_x1[n14] < (float)(n3 + n4)) {
                        float f6 = f5 / f;
                        if (f6 > 1.0f) {
                            f6 = 1.0f / f6;
                        }
                        if ((double)f6 > 0.95) {
                            this.contents[n14] = "<CENTER>" + this.contents[n14] + "</CENTER>\n";
                        } else if (f < 10.0f & f5 > 30.0f) {
                            this.contents[n14] = "<RIGHT>" + this.contents[n14] + "</RIGHT>\n";
                        }
                    }
                }
                if ((f5 = this.f_y2[n9] - this.f_y1[n14]) > (f = this.f_y1[n14] - this.f_y2[n14])) {
                    while (f5 > f) {
                        string = string + "<P></P>\n";
                        f5 -= f;
                    }
                } else if (this.f_start_font_size[n9] != this.f_start_font_size[n14]) {
                    string = "<P></P>\n";
                } else if (bl) {
                    if ((string4.endsWith(".") | string4.endsWith(".\"")) & string3.length() > 0 && Character.isUpperCase(string3.charAt(0))) {
                        string = "<P></P>\n";
                    }
                } else {
                    this.contents[n14] = "<P>" + this.contents[n14] + "</P>\n";
                }
                this.merge_fragment(n9, n14, string, "", false, false, true);
                --n13;
            }
        } else {
            LogWriter.writeLog("Less than 1 text item on page");
        }
    }

    private final void mergeAdjacentMasterObjects(int[] nArray) {
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("===Looking for isolated straps/standfirsts");
        }
        int n2 = n - 1;
        while (n2 > -1) {
            int n3 = nArray[n2];
            if (!this.isUsed[n3]) {
                int n4 = n - 1;
                while (n4 > n2) {
                    int n5 = nArray[n4];
                    if (!this.isUsed[n5]) {
                        float f = this.heights[n3];
                        if (f > this.heights[n5]) {
                            f = this.heights[n5];
                        }
                        if (this.isMaster[n3] && !this.isUsed[n5] && this.canBeStrap[n3] && !this.hasText[n3] && !this.hasText[n5] && this.isMaster[n5]) {
                            boolean bl;
                            boolean bl2 = Math.abs(this.f_x1[n3] - this.f_x1[n5]) < 5.0f | Math.abs(this.f_x2[n3] - this.f_x2[n5]) < 5.0f;
                            boolean bl3 = this.f_x1[n5] >= this.f_x1[n3] && this.f_x2[n5] <= this.f_x2[n3];
                            boolean bl4 = this.f_x1[n3] >= this.f_x1[n5] && this.f_x2[n3] <= this.f_x2[n5];
                            boolean bl5 = bl = (double)(this.f_y2[n3] - this.f_y1[n5]) < (double)f * 1.5;
                            if (bl2 | bl3 | bl4 && bl && this.f_y1[n3] > this.f_y1[n5]) {
                                if (this.debug_level) {
                                    LogWriter.writeLog("Merging Master objects=" + this.names[n3] + " " + this.names[n5]);
                                }
                                this.mergeStories(n3, n5);
                            }
                        }
                    }
                    --n4;
                }
            }
            --n2;
        }
    }

    private final void mergeStory(int n, int n2, boolean bl, boolean bl2) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = "";
        this.line_count[n] = this.line_count[n] + this.line_count[n2];
        String string6 = "";
        if (this.isMaster[n] & !this.isMaster[n2] | this.isMaster[n2] & !this.isMaster[n]) {
            string6 = "<BR></BR>";
        }
        if (!bl) {
            string5 = bl2 ? this.contents[n] + string6 + "\n" + this.contents[n2] : this.contents[n] + string6 + this.contents[n2];
            string4 = this.shapes[n] + "\n" + this.shapes[n2];
            string3 = this.plotting[n] + "\n" + this.plotting[n2];
            string2 = this.raw_data[n] + "\n" + this.raw_data[n2];
            string = this.font_data[n] + this.font_data[n2];
        } else {
            string5 = bl2 ? this.contents[n2] + string6 + "\n" + this.contents[n] : this.contents[n2] + string6 + this.contents[n];
            string4 = this.shapes[n2] + "\n" + this.shapes[n];
            string3 = this.plotting[n2] + "\n" + this.plotting[n];
            string2 = this.raw_data[n2] + "\n" + this.raw_data[n];
            string = this.font_data[n2] + this.font_data[n];
        }
        this.contents[n] = string5;
        this.plotting[n] = string3;
        this.raw_data[n] = string2;
        this.font_data[n] = string;
        this.shapes[n] = string4;
        this.isUsed[n2] = true;
        this.contents[n2] = "";
    }

    protected final void flushFragments() {
        this.names = new String[0];
        this.contents = new String[0];
        this.shapes = new String[0];
        this.plotting = new String[0];
        this.raw_data = new String[0];
        this.font_data = new String[0];
        this.f_x1 = new float[0];
        this.mid_x = new float[0];
        this.f_x2 = new float[0];
        this.f_y1 = new float[0];
        this.mid_y = new float[0];
        this.f_y2 = new float[0];
        this.heights = new float[0];
        this.isMaster = new boolean[0];
        this.isSingleLine = new boolean[0];
        this.hasText = new boolean[0];
        this.isUsed = new boolean[0];
        this.isRectangleOrphan = new boolean[0];
        this.hasContent = new boolean[0];
        this.canBeStrap = new boolean[0];
        this.line_count = new int[0];
    }

    protected final void single_tabloid_newspage(int[] nArray) {
        this.current_level = 11;
        this.recursivelyScanRectangles(nArray.length);
        nArray = this.getStoriesAvailable();
        this.preScanPage(nArray);
        nArray = this.getStoriesAvailable();
        if (this.debug_level) {
            LogWriter.writeLog("======Final page scan");
        }
        this.single_newspage(nArray);
    }

    private final boolean bothStoriesInSameRectangle(int n, int n2, int n3) {
        boolean bl = true;
        int n4 = this.page_data.getRectangleCount();
        int n5 = 0;
        while (n5 < n4) {
            boolean bl2;
            boolean bl3;
            float f;
            float f2;
            float f3 = this.page_data.r_x1.elementAt(n5);
            float f4 = this.page_data.r_x2.elementAt(n5);
            if (f4 - f3 > 5.0f & (f2 = this.page_data.r_y1.elementAt(n5)) - (f = this.page_data.r_y2.elementAt(n5)) > 5.0f && (bl3 = this.mid_x[n2] >= f3 && this.mid_x[n2] <= f4 && this.mid_y[n2] <= f2 && this.mid_y[n2] >= f) & !(bl2 = this.mid_x[n] >= f3 && this.mid_x[n] <= f4 && this.mid_y[n] <= f2 && this.mid_y[n] >= f) | !bl3 & bl2) {
                bl = false;
                n5 = n4;
            }
            ++n5;
        }
        return bl;
    }

    private final void processDrownedItems(int[] nArray) {
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("===Looking for objects inside text objects");
        }
        int n2 = n - 1;
        while (n2 > -1) {
            int n3 = nArray[n2];
            if (!(this.isUsed[n3] || this.isMaster[n3] || this.hasText[n3])) {
                int n4 = n - 1;
                while (n4 > -1) {
                    int n5 = nArray[n4];
                    if (n4 != n2 && !this.isUsed[n5] && this.hasText[n5] && this.mid_y[n3] < this.f_y1[n5] & this.mid_y[n3] > this.f_y2[n5] & this.mid_x[n3] > this.f_x1[n5] & this.mid_x[n3] < this.f_x2[n5] && this.f_y1[n3] < this.f_y1[n5] & this.f_x1[n3] > this.f_x1[n5] | this.f_y2[n3] > this.f_y2[n5] & this.f_x2[n3] < this.f_x2[n5]) {
                        if (this.debug_level) {
                            LogWriter.writeLog("Object=" + this.names[n3] + " merged into " + this.names[n5]);
                        }
                        this.mergeStories(n5, n3);
                        this.isUsed[n3] = true;
                        n4 = -1;
                    }
                    --n4;
                }
            }
            --n2;
        }
    }
}

