/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.grouping;

import com.idrsolutions.grouping.PdfGrouping;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfFragmentGrouping
extends PdfGrouping {
    protected final void cleanupFragments() {
        if (this.algorithm_merging_level >= 1) {
            this.current_level = 1;
            this.removeEncoding();
            this.cleanupShadowsAndDrownedObjects();
        } else {
            this.removeEncoding();
        }
    }

    protected final void mergeTextFragments(int n) {
        StatusBar.updateStatus("Merging text Fragments", 0);
        if (this.debug_level) {
            LogWriter.writeLog("============================================");
        }
        this.flagCaptions();
        int n2 = this.getFragmentCount();
        if (this.debug_level) {
            LogWriter.writeLog("============================================");
            LogWriter.writeLog("Merging items");
            LogWriter.writeLog("============================================");
            LogWriter.writeLog("Raw Items = " + n2);
        }
        if (n >= 3) {
            StatusBar.updateStatus("Merging LINES", 0);
            this.current_level = 3;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("Cleanup and join lines which run together");
            }
            this.mergePartLines();
        }
        if (n >= 4) {
            StatusBar.updateStatus("Merging Drop Caps", 0);
            this.current_level = 4;
            LogWriter.writeLog("============================================");
            LogWriter.writeLog("Handle any drop caps");
            this.mergeDropCaps();
        }
        if (n >= 5) {
            StatusBar.updateStatus("Merging BLOCKS", 0);
            this.current_level = 5;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("Cleanup and join blocks which run together");
            }
            this.mergeTStars();
        }
        this.setMasterAndTextFlags();
        if (n >= 6) {
            StatusBar.updateStatus("Merging PARAGRAPHS", 0);
            this.current_level = 6;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("merge Vertical blocks");
            }
            this.mergeParagraphs();
            this.mergeVerticalColumns();
        }
        if (n >= 7) {
            StatusBar.updateStatus("Merging TITLES", 0);
            this.current_level = 7;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("Split titles");
            }
            this.mergeSplitLines();
        }
        if (n >= 8) {
            StatusBar.updateStatus("Merging VERTICALS", 0);
            this.current_level = 8;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("merge objects across page");
            }
            this.mergeAdjoiningItems();
        }
        if (n >= 9) {
            StatusBar.updateStatus("Merging COLUMNS", 0);
            this.current_level = 9;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("merge objects");
            }
            this.mergeAdjoiningColumns();
        }
        if (n >= 10) {
            StatusBar.updateStatus("Merging OBJECTS", 0);
            this.current_level = 10;
            if (this.debug_level) {
                LogWriter.writeLog("============================================");
                LogWriter.writeLog("Update information on objects");
            }
            this.updateFragmentSize();
        }
        if (this.debug_level) {
            LogWriter.writeLog("============================================");
        }
        StatusBar.updateStatus("Merging fragments completed", 0);
    }

    private final void mergeTStars() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        String string = "";
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling T* joins");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            int n4 = nArray[n2 - 1];
            if (!this.isUsed[n3] && !this.isUsed[n4] && this.move_command[n3] == 0) {
                string = this.getLineDownSeparator(n4, n3, this.contents[n4], this.contents[n3], true);
                this.merge_fragment(n4, n3, string, "{T*}", false, false, true);
            }
            --n2;
        }
    }

    private final void processTables() {
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n = nArray.length;
        int[] nArray2 = new int[n];
        boolean[] blArray = new boolean[n];
        Vector_Float vector_Float = new Vector_Float(200);
        Vector_Float vector_Float2 = new Vector_Float(200);
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n + "\nProcessing tables");
        }
        int n2 = 0;
        if (n > 1) {
            int n3;
            int n4;
            int n5 = 0;
            while (n5 < n) {
                n4 = nArray[n5];
                if (!this.isUsed[n4]) {
                    boolean bl = false;
                    float f = (this.f_y1[n4] + this.f_y2[n4]) / 2.0f;
                    n3 = 0;
                    while (n3 < n2) {
                        if (f < vector_Float.elementAt(n3) & f > vector_Float2.elementAt(n3)) {
                            bl = true;
                            nArray2[n5] = n3;
                            if (vector_Float.elementAt(n3) < this.f_y1[n4]) {
                                vector_Float.setElementAt(this.f_y1[n4], n3);
                            }
                            if (vector_Float2.elementAt(n3) > this.f_y2[n4]) {
                                vector_Float2.setElementAt(this.f_y2[n4], n3);
                            }
                            n3 = n2;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        vector_Float.addElement(this.f_y1[n4]);
                        vector_Float2.addElement(this.f_y2[n4]);
                        nArray2[n5] = n2++;
                    }
                }
                ++n5;
            }
            Vector_Int[] vector_IntArray = new Vector_Int[n2 + 1];
            int n6 = 0;
            while (n6 < n) {
                n4 = nArray[n6];
                if (!this.isUsed[n4]) {
                    n3 = nArray2[n6];
                    if (vector_IntArray[n3] == null) {
                        vector_IntArray[n3] = new Vector_Int(200);
                    }
                    vector_IntArray[n3].addElement(n4);
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < n2 - 1) {
                boolean bl = false;
                int n7 = 0;
                while (n7 < vector_IntArray[n3].size() - 2) {
                    int n8 = vector_IntArray[n3].elementAt(n7);
                    int n9 = -1;
                    if (!blArray[n8]) {
                        int n10;
                        boolean bl2 = false;
                        int n11 = vector_IntArray[n3 + 1].elementAt(0);
                        if ((this.f_x1[n11] >= this.f_x1[n8] & this.f_x1[n11] <= this.f_x2[n8] | this.f_x1[n8] > this.f_x1[n11] & this.f_x1[n8] < this.f_x2[n11]) & this.f_x2[n8] < this.f_x1[n10 = vector_IntArray[n3 + 1].elementAt(1)] & this.f_x2[n11] < this.f_x1[n10]) {
                            bl2 = true;
                            n9 = n11;
                            blArray[n11] = true;
                        }
                        if (!bl2) {
                            int n12 = vector_IntArray[n3 + 1].size();
                            int n13 = 1;
                            while (n13 < n12 - 2) {
                                int n14 = vector_IntArray[n3 + 1].elementAt(n13 - 1);
                                n11 = vector_IntArray[n3 + 1].elementAt(n13);
                                if ((this.f_x1[n11] >= this.f_x1[n8] & this.f_x1[n11] <= this.f_x2[n8] | this.f_x1[n8] > this.f_x1[n11] & this.f_x1[n8] < this.f_x2[n11]) & this.f_x2[n8] < this.f_x1[n10 = vector_IntArray[n3 + 1].elementAt(n13 + 1)] & this.f_x2[n11] < this.f_x1[n10]) {
                                    bl2 = true;
                                    n9 = n11;
                                    blArray[n11] = true;
                                    this.merge_fragment(n8, n11, ";", "{TABLE}", false, false, true);
                                }
                                ++n13;
                            }
                        }
                    }
                    ++n7;
                }
                ++n3;
            }
        }
    }

    private final void mergePartLines() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Merging part lines");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            int n4 = nArray[n2 - 1];
            if (!(this.isUsed[n4] || this.isUsed[n3] || this.handleMasterandBreakFont(n4, n3))) {
                boolean bl;
                int n5 = this.getSmallestFontSize(n4, n3) / 2;
                boolean bl2 = Math.abs(this.f_end_font_size[n4] - this.f_end_font_size[n3]) < n5;
                if (bl2 & (bl = this.f_x2[n3] >= this.f_x2[n4] & Math.abs(this.f_y2[n4] - this.f_y2[n3]) < (float)n5) & !this.overlapsAnotherObject(n4, n3, nArray)) {
                    float f = n5 / 4;
                    boolean bl3 = this.page_data.testVerticalBetween(this.f_x1[n4] - f, this.f_x2[n4] + f, this.f_y1[n4] - f, this.f_y2[n4] + f, this.f_x1[n3] - f, this.f_x2[n3] + f, this.f_y1[n3] - f, this.f_y2[n3] + f);
                    boolean bl4 = this.has_other_item_inbetween(n3, n4, nArray);
                    float f2 = this.f_x1[n3] - this.f_x2[n4];
                    float f3 = this.current_thresholds.get_threshold(this.font_data[n3]);
                    if (bl3) {
                        if (this.debug_level) {
                            this.contents[n3] = "{VS1}" + this.contents[n3];
                        }
                    } else if (bl4) {
                        if (this.debug_level) {
                            this.contents[n3] = "{ITEMBETWEEN}" + this.contents[n3];
                        }
                    } else {
                        String string = this.isGapASpace(n3, n4, f2, f3);
                        this.merge_fragment(n4, n3, string, "{PARTLINE}", true, false, true);
                    }
                }
            }
            --n2;
        }
    }

    private final boolean mergeLinesIntoParagraphs(int n, int n2, int n3, int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = Math.abs(this.f_end_font_size[n2] - this.f_end_font_size[n]);
        float f = this.getSmallestFontSize(n2, n);
        boolean bl3 = false;
        float f2 = this.f_x2[n2] - this.f_x1[n2];
        float f3 = this.f_x2[n] - this.f_x1[n];
        if (f2 > f3 & this.f_end_font_size[n2] > this.f_end_font_size[n] + 2 & f2 / f3 > 2.0f) {
            bl3 = true;
        }
        if (!bl3) {
            int n5 = (int)(f / 4.0f);
            if (this.f_end_font_size[n2] < this.f_end_font_size[n] | this.f_end_font_size[n2] > this.f_end_font_size[n] & this.f_x2[n2] - this.f_x1[n2] > this.f_x2[n] - this.f_x1[n]) {
                n5 = 0;
            }
            if (bl2 = this.page_data.testHorizontalBetween(-1.0f, this.f_x1[n2] - (float)n5, this.f_x2[n2] + (float)n5, this.f_y1[n2], this.f_y2[n2], this.f_x1[n] - (float)n5, this.f_x2[n] + (float)n5, this.f_y1[n], this.f_y2[n])) {
                if (this.debug_level) {
                    this.contents[n] = "{HS1}" + this.contents[n];
                }
            } else {
                boolean bl4 = (double)(this.f_y2[n2] - this.f_y1[n]) < (double)this.f_end_font_size[n] * 1.5 && this.f_y2[n2] >= this.f_y2[n];
                boolean bl5 = (this.mid_x[n] >= this.f_x1[n2] && this.mid_x[n] <= this.f_x2[n2]) | this.mid_x[n2] >= this.f_x1[n] & this.mid_x[n2] <= this.f_x2[n];
                if (bl5 && bl4) {
                    String string = this.f_is_master[n2] > -1 && this.f_is_master[n] > -1 && Math.abs(this.f_start_font_size[n2] - this.f_start_font_size[n]) > 3 ? "<P></P>\n" : this.getLineDownSeparator(n2, n, this.contents[n2], this.contents[n], true);
                    this.merge_fragment(n2, n, string, "{PARA}", false, false, true);
                    bl = true;
                }
            }
        }
        return bl;
    }

    private final boolean includeDrownedColumns(int n, int n2, float f) {
        int n3;
        int n4;
        float f2;
        boolean bl = true;
        float f3 = this.f_x1[n2] - this.f_x2[n];
        f = this.f_x2[n2] - this.f_x1[n2];
        float f4 = this.f_x1[n2];
        if (f4 > this.f_x1[n]) {
            f4 = this.f_x1[n];
        }
        if ((f2 = this.f_x2[n2]) < this.f_x2[n]) {
            f2 = this.f_x2[n];
        }
        float f5 = this.f_y1[n];
        float f6 = this.f_y2[n2];
        int[] nArray = this.getsortedUnusedFragments(false, true);
        int n5 = nArray.length;
        int n6 = 0;
        if (this.f_is_master[n2] > -1 & this.f_is_master[n] > -1) {
            n4 = 0;
            while (n4 < n5) {
                n3 = nArray[n4];
                if (!this.isUsed[n3] && n3 != n && n3 != n2 && this.f_is_master[n2] < 0 && f4 < this.mid_x[n3] && f2 > this.mid_x[n3] && this.mid_y[n3] <= f5 && this.mid_y[n3] >= f6) {
                    ++n6;
                }
                ++n4;
            }
        }
        if (n6 == 0) {
            n4 = 0;
            while (n4 < n5) {
                n3 = nArray[n4];
                if (!this.isUsed[n3] && n3 != n && n3 != n2) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.f_y1[n3] - this.f_y2[n3] > (float)(this.f_end_font_size[n3] * 2);
                    if (f4 < this.mid_x[n3] && f2 > this.mid_x[n3] && this.f_end_font_size[n] == this.f_end_font_size[n3] && bl2 && (double)f3 > (double)f * 0.9 && (double)f3 < (double)f * 1.25 && this.mid_y[n3] <= f5 && this.mid_y[n3] >= f6) {
                        String string = this.getLineDownSeparator(n, n3, this.contents[n], this.contents[n3], true);
                        this.merge_fragment(n, n3, string, "{DROWNED1}", false, false, true);
                    }
                }
                ++n4;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void mergeDrownedObjectsX() {
        int[] nArray = this.getSortedUnusedFragmentsbySize();
        int n = nArray.length;
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling drowned Text");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!this.isUsed[n3]) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = nArray[n4];
                    if (!this.isUsed[n5] && n5 != n3) {
                        boolean bl3;
                        double d = this.f_end_font_size[n3] > this.f_end_font_size[n5] ? (double)this.f_end_font_size[n5] * 0.5 : (double)this.f_end_font_size[n3] * 0.5;
                        boolean bl4 = (double)this.f_x2[n5] + d >= (double)this.f_x1[n3] & (double)this.f_x2[n5] - d <= (double)this.f_x2[n3] | this.mid_x[n5] >= this.f_x1[n3] & this.mid_x[n5] <= this.f_x2[n3] | (double)this.f_x1[n5] + d >= (double)this.f_x1[n3] & (double)this.f_x1[n5] - d <= (double)this.f_x2[n3] && this.f_y1[n5] <= this.f_y1[n3] & this.f_y1[n5] >= this.f_y2[n3] | this.mid_y[n5] <= this.f_y1[n3] & this.mid_y[n5] >= this.f_y2[n3] | this.f_y2[n5] <= this.f_y1[n3] & this.f_y2[n5] >= this.f_y2[n3];
                        boolean bl5 = this.f_x1[n5] > this.f_x1[n3] && this.f_x2[n5] < this.f_x2[n3] && this.f_y1[n5] < this.f_y1[n3] && this.f_y2[n5] > this.f_y2[n3];
                        boolean bl6 = this.f_x1[n3] > this.f_x1[n5] && this.f_x2[n3] < this.f_x2[n5] && this.f_y1[n3] < this.f_y1[n5] && this.f_y2[n3] > this.f_y2[n5];
                        boolean bl7 = bl3 = this.mid_x[n3] > this.f_x1[n5] && this.mid_x[n3] < this.f_x2[n5] && this.mid_y[n3] < this.f_y1[n5] && this.mid_y[n3] > this.f_y2[n5];
                        if (bl3) {
                            String string2 = this.removeHiddenMarkers(n3).toString().trim();
                            String string3 = this.removeHiddenMarkers(n5).toString().trim();
                            if (string2.length() == string3.length() && string2.equals(string3)) {
                                this.isUsed[n5] = true;
                                bl5 = false;
                                bl6 = false;
                                bl4 = false;
                            }
                        }
                        if (bl5 | bl6 | bl4) {
                            bl = true;
                            if (!bl2) {
                                if (bl5 | bl6) {
                                    if (this.f_y2[n3] > this.f_y2[n5]) {
                                        string = this.getLineDownSeparator(n5, n3, this.contents[n3], this.contents[n5], true);
                                        this.merge_fragment(n3, n5, string, "{DROWNEDITEM1}", false, false, true);
                                    } else {
                                        string = this.getLineDownSeparator(n5, n3, this.contents[n5], this.contents[n3], true);
                                        this.merge_fragment(n5, n3, string, "{DROWNEDITEM2}", false, false, true);
                                    }
                                } else if (this.f_x1[n5] > this.f_x1[n3]) {
                                    bl = false;
                                } else {
                                    string = this.getLineDownSeparator(n5, n3, this.contents[n5], this.contents[n3], true);
                                    this.merge_fragment(n5, n3, string, "{Overlap2}" + d, false, false, true);
                                }
                            }
                            if (bl) {
                                n4 = n;
                                n2 = 0;
                                bl = false;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private final void mergeSplitLines() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Merging split part lines");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            int n4 = nArray[n2 - 1];
            boolean bl = this.f_end_font_size[n3] > this.f_end_font_size[n4] * 2 | this.f_end_font_size[n4] > this.f_end_font_size[n3] * 2;
            float f = this.current_thresholds.get_threshold(this.font_data[n3]);
            if (!this.isUsed[n3] && bl) {
                boolean bl2;
                boolean bl3 = bl2 = this.f_x1[n3] >= this.f_x1[n4] && Math.abs(this.f_y1[n4] - this.f_y1[n3]) < 2.0f && Math.abs(this.f_y2[n4] - this.f_y2[n3]) < 2.0f;
                if (bl2) {
                    boolean bl4 = this.page_data.testVerticalBetween(this.f_x1[n4], this.f_x2[n4], this.f_y1[n4], this.f_y2[n4], this.f_x1[n3], this.f_x2[n3], this.f_y1[n3], this.f_y2[n3]);
                    float f2 = this.f_x1[n3] - this.f_x2[n4];
                    if (bl4) {
                        if (this.debug_level) {
                            this.contents[n3] = "{VS2}" + this.contents[n3];
                        }
                        n2 = 0;
                    } else if (f2 < this.scaled_space[n3] * 4.0f) {
                        String string = this.isGapASpace(n3, n4, f2, f);
                        this.merge_fragment(n4, n3, string, "{SPLITLINE}", true, false, true);
                        if (this.f_is_master[n3] > -1) {
                            this.f_is_master[n4] = this.f_is_master[n3];
                        }
                    }
                }
            }
            --n2;
        }
    }

    private final void mergeColumnsTogether(int n, int n2) {
        String string = "";
        if (!this.isUsed[n2] & !this.isUsed[n]) {
            boolean bl;
            int n3 = (int)(this.f_x2[n2] - this.f_x1[n2]) / 2;
            int n4 = (int)(this.f_x2[n] - this.f_x1[n]) / 2;
            if (n3 > n4) {
                n3 = n4;
            }
            boolean bl2 = this.f_y1[n2] - this.f_y2[n2] > (float)(this.f_end_font_size[n2] * 2);
            boolean bl3 = this.f_y1[n] - this.f_y2[n] > (float)(this.f_end_font_size[n] * 2);
            boolean bl4 = this.f_x1[n] < this.f_x1[n2];
            float f = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            float f2 = (this.f_y1[n] + this.f_y2[n]) / 2.0f;
            boolean bl5 = this.f_y1[n2] <= this.f_y1[n] + 2.0f & this.f_y1[n2] >= this.f_y2[n] - 2.0f | this.f_y1[n] <= this.f_y1[n2] + 2.0f & this.f_y1[n] >= this.f_y2[n2] - 2.0f | this.f_y2[n] <= this.f_y1[n2] + 2.0f & this.f_y2[n] >= this.f_y2[n2] - 2.0f | this.f_y2[n2] <= this.f_y1[n] + 2.0f & this.f_y2[n2] >= this.f_y2[n] - 2.0f | f < this.f_y1[n] & f > this.f_y2[n] | f2 < this.f_y1[n2] & f2 > this.f_y2[n2];
            boolean bl6 = this.page_data.testVerticalBetween(this.f_x1[n], this.f_x2[n], this.f_y1[n], this.f_y2[n], this.f_x1[n2], this.f_x2[n2], this.f_y1[n2], this.f_y2[n2]);
            int n5 = this.sharesMaster(n, n2, bl6);
            if (n5 == 2) {
                bl6 = false;
            }
            boolean bl7 = this.f_is_master[n] < 0 && this.f_is_master[n2] < 0;
            boolean bl8 = bl = this.f_x2[n] <= this.f_x2[n2] | Math.abs(this.f_x2[n] - this.f_x2[n2]) < 2.0f && this.f_x2[n] + (float)n3 > this.f_x1[n2];
            if (bl7 && bl2 && bl3 && n5 > 0 & bl5 & !bl | (bl5 && bl)) {
                float f3 = this.f_y1[n] - this.f_y2[n];
                float f4 = this.f_y1[n2] - this.f_y2[n2];
                if (bl4 & !bl6) {
                    this.includeDrownedColumns(n, n2, n3);
                    string = this.getLineDownSeparator(n, n2, this.contents[n], this.contents[n2], true);
                    this.merge_fragment(n, n2, string, "{ADJOINING_COLUMN1}", false, false, true);
                }
            }
        }
    }

    private final void testVerticalFragments(int n, int n2, int[] nArray) {
        String string = "";
        if (!this.isUsed[n2]) {
            boolean bl = Math.abs(this.f_x1[n2] - this.f_x1[n]) < 2.0f | Math.abs(this.f_x2[n2] - this.f_x2[n]) < 2.0f;
            boolean bl2 = this.f_x1[n] > this.f_x1[n2] & this.f_x2[n] < this.f_x2[n2];
            float f = this.f_x2[n] - this.f_x1[n];
            float f2 = this.f_x2[n2] - this.f_x1[n2];
            float f3 = f / f2;
            boolean bl3 = (double)f3 < 0.33 | f3 > 3.0f;
            if (this.f_y2[n] >= this.f_y2[n2] && bl | bl2 && !this.handleMasterandBreakFont(n, n2)) {
                boolean bl4 = this.page_data.testHorizontalBetween(this.getMinWidth(n, n2), this.f_x1[n], this.f_x2[n], this.f_y1[n], this.f_y2[n], this.f_x1[n2], this.f_x2[n2], this.f_y1[n2], this.f_y2[n2]);
                if (bl3) {
                    if (this.debug_level) {
                        this.contents[n2] = "{SIZEMISMATCH}" + this.contents[n2];
                    }
                } else if (bl4) {
                    if (this.debug_level) {
                        this.contents[n2] = "{HS2}" + this.contents[n2];
                    }
                } else if (this.f_is_master[n] > -1 & this.f_is_master[n2] > -1) {
                    if (this.debug_level) {
                        this.contents[n2] = "{NO VERTICAL ALLOWED}" + this.contents[n2];
                    }
                } else if (this.willNotEncloseMaster(n, n2, nArray)) {
                    boolean bl5 = this.includeDrownedItems(n, n2);
                    if (bl5) {
                        string = this.getLineDownSeparator(n, n2, this.contents[n], this.contents[n2], true);
                        this.merge_fragment(n, n2, string, "{VERTICAL " + n + " " + n2 + "}", false, false, true);
                    } else if (this.debug_level) {
                        this.contents[n2] = "{NO VERTICAL ALLOWED2}" + this.contents[n2];
                    }
                }
            }
        }
    }

    private final void mergeDropCaps() {
        int[] nArray = this.getsortedUnusedFragments(true, true);
        int n = nArray.length;
        String string = "";
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n + "\nHandling Drop Caps");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            float f = this.f_x2[n3] - this.f_x1[n3];
            if (!this.isUsed[n3] & this.text_length[n3] == 1) {
                int n4;
                Vector_Int vector_Int = new Vector_Int(5);
                int n5 = 0;
                float f2 = -9999.0f;
                float f3 = 9999.0f;
                boolean bl = false;
                boolean bl2 = false;
                int n6 = 0;
                while (n6 < n) {
                    int n7 = nArray[n6];
                    if (this.f_start_font_size[n3] > this.f_start_font_size[n7] & !this.isUsed[n7]) {
                        if (this.f_y1[n3] > this.f_y1[n7] & this.f_y2[n3] < this.f_y1[n7] | this.f_y1[n3] > this.f_y2[n7] & this.f_y2[n3] < this.f_y2[n7]) {
                            if (n6 > n2 && this.f_x1[n3] < this.f_x1[n7]) {
                                vector_Int.addElement(n7);
                                ++n5;
                            } else if (n6 < n2 && this.f_x1[n3] > this.f_x1[n7]) {
                                vector_Int.addElement(n7);
                                ++n5;
                            }
                        }
                        if (this.f_y1[n3] + f > this.f_y2[n7] & this.f_y1[n3] < this.f_y1[n7] | this.f_y2[n3] - f < this.f_y1[n7] & this.f_y2[n3] > this.f_y2[n7]) {
                            if (this.f_x1[n3] >= this.f_x1[n7] & this.f_x1[n3] <= this.f_x2[n7] & this.f_x2[n3] >= this.f_x2[n7]) {
                                bl = true;
                                if (this.f_x2[n7] > f2) {
                                    f2 = this.f_x2[n7];
                                }
                                if (this.f_x1[n7] < f3) {
                                    f3 = this.f_x1[n7];
                                }
                            }
                            if (this.f_x2[n3] >= this.f_x1[n7] & this.f_x2[n3] <= this.f_x2[n7] & (this.f_x1[n3] < this.f_x1[n7] | Math.abs(this.f_x1[n3] - this.f_x1[n7]) < 1.0f)) {
                                bl2 = true;
                                if (this.f_x2[n7] > f2) {
                                    f2 = this.f_x2[n7];
                                }
                                if (this.f_x1[n7] < f3) {
                                    f3 = this.f_x1[n7];
                                }
                            }
                        }
                    }
                    ++n6;
                }
                int n8 = n5 - 1;
                while (n8 > -1) {
                    n4 = vector_Int.elementAt(n8);
                    if (!(bl2 & this.f_x1[n3] + f / 2.0f < this.f_x1[n4] & this.f_x2[n3] + f > this.f_x1[n4] & (this.f_x2[n3] + f / 2.0f > this.f_x1[n4] | this.f_x1[n4] < f2)) && !(bl & this.f_x2[n4] < this.f_x2[n3] & (f / 2.0f + this.f_x2[n4] > this.f_x1[n3] | this.f_x2[n4] > f3))) {
                        --n5;
                        vector_Int.removeElementAt(n8);
                    }
                    --n8;
                }
                if (n5 > 0 & (bl2 | bl)) {
                    n4 = vector_Int.elementAt(n5 - 1);
                    this.font_data[n3] = this.font_data[n4];
                    this.f_end_font_size[n3] = this.f_end_font_size[n4];
                    this.f_start_font_size[n3] = this.f_start_font_size[n4];
                    this.f_font_used[n3] = this.f_font_used[n4];
                    float f4 = this.current_thresholds.get_threshold(this.font_data[n3]);
                    String string2 = "";
                    if (this.test_drop_gap) {
                        this.isGapASpace(n3, n4, this.f_x1[n4] - this.f_x2[n3], f4);
                    }
                    int n9 = n5 - 2;
                    while (n9 > -1) {
                        int n10 = vector_Int.elementAt(n9);
                        string = this.getLineDownSeparator(n4, n10, this.contents[n4], this.contents[n10], true);
                        this.merge_fragment(n4, n10, string, "{DROP_CAPS}", false, false, true);
                        --n9;
                    }
                    if (bl2) {
                        this.merge_fragment(n3, n4, string2, "{DROP_CAPS}", false, false, true);
                    } else if (bl) {
                        this.merge_fragment(n4, n3, "", "{DROP_CAPS}", false, false, true);
                    }
                }
            }
            --n2;
        }
    }

    private final void mergeAdjoiningColumns() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling Adjoining Columns");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            int n4 = nArray[n2 - 1];
            this.mergeColumnsTogether(n4, n3);
            --n2;
        }
    }

    private final void cleanupShadowsAndDrownedObjects() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        String string = "";
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling shadows and drowned Text");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!this.isUsed[n3]) {
                int n4 = n2 + 1;
                while (n4 < n) {
                    int n5 = nArray[n4];
                    if (!this.isUsed[n5] & !this.isUsed[n3]) {
                        if (this.mid_x[n3] > this.f_x1[n5] && this.mid_x[n3] < this.f_x2[n5] && Math.abs(this.f_x2[n5] - this.f_x1[n5] - (this.f_x2[n3] - this.f_x1[n3])) < 10.0f && this.mid_y[n3] < this.f_y1[n5] && this.mid_y[n3] > this.f_y2[n5]) {
                            this.isUsed[n5] = true;
                        } else {
                            boolean bl;
                            boolean bl2 = this.f_x1[n5] > this.f_x1[n3] & this.f_x2[n5] < this.f_x2[n3] & this.f_y1[n5] < this.f_y1[n3] & this.f_y2[n5] > this.f_y2[n3];
                            if (bl2 | (bl = this.f_x1[n3] > this.f_x1[n5] & this.f_x2[n3] < this.f_x2[n5] & this.f_y1[n3] < this.f_y1[n5] & this.f_y2[n3] > this.f_y2[n5])) {
                                if (this.f_y2[n3] > this.f_y2[n5]) {
                                    string = this.getLineDownSeparator(n5, n3, this.contents[n3], this.contents[n5], true);
                                    this.merge_fragment(n3, n5, string, "{DROWNEDITEM1}", false, false, true);
                                } else {
                                    string = this.getLineDownSeparator(n5, n3, this.contents[n5], this.contents[n3], true);
                                    this.merge_fragment(n5, n3, string, "{DROWNEDITEM2}" + bl2 + " " + bl, false, false, true);
                                }
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private final void mergeAdjoiningItems() {
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n = nArray.length;
        String string = "";
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling Adjoining Items");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            if (!this.isUsed[n3]) {
                int n4 = n2 - 1;
                while (n4 > 0) {
                    int n5 = nArray[n4];
                    if (!this.isUsed[n5] & !this.isUsed[n3] & this.f_is_master[n3] > -1 & this.f_is_master[n5] > -1) {
                        boolean bl;
                        int n6;
                        boolean bl2 = (double)(this.f_y1[n5] - this.f_y2[n5]) < (double)this.f_end_font_size[n5] * 1.5 & (double)(this.f_y1[n3] - this.f_y2[n3]) < (double)this.f_end_font_size[n3] * 1.5;
                        boolean bl3 = Math.abs(this.f_y1[n5] - this.f_y1[n3]) < 3.0f | Math.abs(this.f_y2[n5] - this.f_y2[n3]) < 3.0f;
                        boolean bl4 = false;
                        if (this.contents[n3].length() > 2 & this.contents[n5].length() > 2 && (n6 = this.nextTextIsCaps(this.contents[n3])) == 0 & (bl = this.nextTextIsCaps(this.contents[n5])) | n6 == 1 & !bl) {
                            bl4 = true;
                        }
                        if (bl4) {
                            if (this.debug_level) {
                                this.contents[n3] = "{CASE_CHANGES}" + this.contents[n3];
                            }
                        } else if (this.f_x1[n5] <= this.f_x1[n3] && bl2 && bl3) {
                            n6 = this.getSmallestFontSize(n5, n3) / 4;
                            bl = this.page_data.testVerticalBetween(this.f_x1[n5], this.f_x2[n5], this.f_y1[n5] - (float)n6, this.f_y2[n5] + (float)n6, this.f_x1[n3], this.f_x2[n3], this.f_y1[n3] - (float)n6, this.f_y2[n3] + (float)n6);
                            boolean bl5 = this.page_data.isBrokenByBox(this.mid_x[n5], this.f_y1[n5], this.f_y2[n5], this.mid_x[n3], this.f_y1[n3], this.f_y2[n3]);
                            boolean bl6 = this.isBrokenByText(n5, n3, nArray);
                            if (!this.overlapsAnotherObject(n5, n3, nArray)) {
                                float f = this.f_y1[n5] - this.f_y2[n5];
                                float f2 = this.f_y1[n3] - this.f_y2[n3];
                                if (f > f2 * 2.0f | f2 > f * 2.0f) {
                                    if (this.debug_level) {
                                        this.contents[n3] = "{DIFF_SIZES}" + this.contents[n3];
                                    }
                                } else if (bl) {
                                    if (this.debug_level) {
                                        this.contents[n3] = "{VB4}" + this.contents[n3];
                                    }
                                } else if (bl5) {
                                    if (this.debug_level) {
                                        this.contents[n3] = "{BOX}" + this.contents[n3];
                                    }
                                } else if (bl6) {
                                    if (this.debug_level) {
                                        this.contents[n3] = "{TEXT}" + this.contents[n3];
                                    }
                                } else {
                                    string = this.getLineDownSeparator(n5, n3, this.contents[n5], this.contents[n3], true);
                                    this.merge_fragment(n5, n3, string, "{ADJOINING_ITEM}", false, false, true);
                                }
                            }
                        }
                    }
                    --n4;
                }
            }
            --n2;
        }
    }

    private final void mergeParagraphs() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray = this.getUnusedFragments();
        int n5 = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n5);
            LogWriter.writeLog("Merging Paragraphs");
        }
        int n6 = n5 - 1;
        while (n6 > 0) {
            n4 = nArray[n6];
            n3 = nArray[n6 - 1];
            if (!(this.isUsed[n4] || this.isUsed[n3] || this.handleMasterandBreakFont(n3, n4))) {
                this.mergeLinesIntoParagraphs(n4, n3, n6, nArray);
            }
            --n6;
        }
        nArray = this.getUnusedFragments();
        n5 = nArray.length;
        int n7 = n5 - 1;
        while (n7 > 0) {
            n2 = n5 - 1;
            while (n2 > 0) {
                if (n7 != n2 & !this.isUsed[n4 = nArray[n7]] & !this.isUsed[n3 = nArray[n2]] && this.f_y2[n4] < this.f_y2[n3] & this.f_y1[n4] < this.f_y1[n3] & this.f_x2[n4] - this.f_x1[n4] < this.f_x2[n3] - this.f_x1[n3]) {
                    n = this.isTwoLinesHigh(n4) ? 1 : 0;
                    bl3 = this.isTwoLinesHigh(n3);
                    bl2 = true;
                    if (this.f_end_font_size[n3] > this.f_end_font_size[n4] & this.getFragmentWidth(n3) > this.getFragmentWidth(n4)) {
                        bl2 = false;
                    }
                    if (bl2 && bl3 && n != 0 && !this.handleMasterandBreakFont(n3, n4) && (bl = this.mergeLinesIntoParagraphs(n4, n3, n7, nArray))) {
                        n2 = -1;
                    }
                }
                --n2;
            }
            --n7;
        }
        n2 = n5 - 1;
        while (n2 > 0) {
            n = n5 - 1;
            while (n > 0) {
                if (n2 != n & !this.isUsed[n4 = nArray[n]] & !this.isUsed[n3 = nArray[n2]] & this.f_end_font_size[n4] == this.f_end_font_size[n3] & this.f_is_master[n4] == this.f_is_master[n3] & this.f_y1[n4] > this.f_y1[n3] & this.f_x2[n4] - this.f_x1[n4] > this.f_x2[n3] - this.f_x1[n3]) {
                    bl3 = this.isTwoLinesHigh(n4);
                    bl2 = this.isTwoLinesHigh(n3);
                    if (bl3 && !bl2 && !this.handleMasterandBreakFont(n4, n3) && (bl = this.mergeLinesIntoParagraphs(n3, n4, n2, nArray))) {
                        n = -1;
                    }
                }
                --n;
            }
            --n2;
        }
    }

    private final boolean includeDrownedItems(int n, int n2) {
        int n3;
        int n4;
        float f;
        boolean bl = true;
        float f2 = this.f_x1[n2];
        if (f2 > this.f_x1[n]) {
            f2 = this.f_x1[n];
        }
        if ((f = this.f_x2[n2]) < this.f_x2[n]) {
            f = this.f_x2[n];
        }
        float f3 = this.f_y1[n];
        float f4 = this.f_y2[n2];
        int[] nArray = this.getsortedUnusedFragments(false, true);
        int n5 = nArray.length;
        int n6 = 0;
        if (this.f_is_master[n2] > -1 & this.f_is_master[n] > -1) {
            n4 = 0;
            while (n4 < n5) {
                n3 = nArray[n4];
                if (!this.isUsed[n3] && n3 != n && n3 != n2 && this.f_is_master[n2] < 0 && f2 < this.mid_x[n3] && f > this.mid_x[n3] && this.mid_y[n3] <= f3 && this.mid_y[n3] >= f4) {
                    ++n6;
                }
                ++n4;
            }
        }
        if (n6 == 0) {
            n4 = 0;
            while (n4 < n5) {
                n3 = nArray[n4];
                if (!this.isUsed[n3] && n3 != n && n3 != n2 && f2 < this.mid_x[n3] && f > this.mid_x[n3] && this.mid_y[n3] <= f3 && this.mid_y[n3] >= f4) {
                    String string = this.getLineDownSeparator(n, n3, this.contents[n], this.contents[n3], true);
                    this.merge_fragment(n, n3, string, "{DROWNED1}", false, false, true);
                }
                ++n4;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void mergeVerticalColumns() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        if (this.debug_level) {
            LogWriter.writeLog("Items left= " + n);
            LogWriter.writeLog("Handling Vertical Columns");
        }
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = nArray[n2];
            int n4 = nArray[n2 - 1];
            boolean bl = true;
            if (this.f_is_master[n4] > -1 | this.f_is_master[n3] > -1) {
                bl = this.f_y2[n4] - this.f_y1[n3] < (float)this.f_end_font_size[n3] && this.f_y2[n4] >= this.f_y2[n3];
            }
            boolean bl2 = (double)(this.f_y1[n4] - this.f_y2[n4]) < (double)this.f_end_font_size[n4] * 1.5 & (double)(this.f_y1[n3] - this.f_y2[n3]) < (double)this.f_end_font_size[n3] * 1.5;
            if (this.f_end_font_size[n4] > this.f_end_font_size[n3] & this.f_x2[n4] - this.f_x1[n4] > this.f_x2[n3] - this.f_x1[n3]) {
                bl2 = true;
            }
            if (bl && !bl2 && !this.isUsed[n3] & !this.isUsed[n4]) {
                this.testVerticalFragments(n4, n3, nArray);
            }
            --n2;
        }
        if (this.debug_level) {
            LogWriter.writeLog("Columns merged. Items left: " + n);
            LogWriter.writeLog("============================================");
        }
    }
}

