/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.grouping;

import com.idrsolutions.grouping.PdfComplexObjectGrouping;
import com.idrsolutions.storypad.utils.sleep;
import com.idrsolutions.utils.StripTags;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jpedal.fonts.Fonts;
import org.jpedal.gui.PdfToolTips;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;

public class PdfStoryGrouping
extends PdfComplexObjectGrouping {
    public final void applyGrouping(PdfToolTips pdfToolTips, List list, int n, boolean bl, String string, int n2, int n3, int n4) {
        this.generic_minumum_size = n2;
        this.removeHiddenTextandShapes();
        this.page_data.workoutPageFurniture();
        this.copyDataToFragmentArrays();
        this.cleanupFragments();
        StatusBar.updateStatus("Composing text objects", 1);
        if (this.algorithm_merging_level == 20 | this.algorithm_merging_level == 21) {
            try {
                this.setMasterAndTextFlags();
                this.standard_pages(n3, n4);
                StatusBar.updateStatus("Page merging algoritm completed", 0);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in merging algorithm");
                sleep sleep2 = new sleep(5);
            }
        } else if (this.algorithm_merging_level == 24) {
            this.mergeTextFragments(8);
        } else {
            this.mergeTextFragments(this.algorithm_merging_level);
        }
        if (bl) {
            this.eliminateFurniture(list);
        }
        if (this.debug_level) {
            LogWriter.writeLog("====================================");
            LogWriter.writeLog("===Calculating key objects ");
        }
        this.createStoriesFromData(n, pdfToolTips);
        int[] nArray = this.getStoriesAvailable();
        if (this.debug_level) {
            LogWriter.writeLog("====================================");
        }
        if (string.length() > 1) {
            if (this.debug_level) {
                LogWriter.writeLog("===Executing " + string);
            }
            try {
                if (string.equals("single_newspage")) {
                    this.single_newspage(nArray);
                } else if (string.equals("single_tabloid_page")) {
                    this.single_tabloid_newspage(nArray);
                } else if (string.equals("Multi-column text")) {
                    this.multicolumn();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Algorithm " + string + " failed in execution with exception " + exception);
            }
            this.writeStoriesToData();
            int n5 = nArray.length - 1;
            while (n5 > -1) {
                if (this.isUsed[n5]) {
                    this.contents[n5] = null;
                }
                --n5;
            }
        } else {
            LogWriter.writeLog("No algorithm used");
        }
        this.flushFragments();
    }

    private final void createStoriesFromData(int n, PdfToolTips pdfToolTips) {
        this.garbageCollectFragments();
        this.initial_item_count = this.contents.length;
        int[] nArray = this.sortedOrder();
        String[] stringArray = this.contents;
        float[] fArray = this.f_x1;
        float[] fArray2 = this.f_x2;
        float[] fArray3 = this.f_y1;
        float[] fArray4 = this.f_y2;
        String[] stringArray2 = this.raw_data;
        int[] nArray2 = this.line_count;
        int[] nArray3 = this.f_is_master;
        float[] fArray5 = this.heights;
        String[] stringArray3 = this.plotting;
        this.col_width = new float[this.initial_item_count + 1];
        this.names = new String[this.initial_item_count + 1];
        this.contents = new String[this.initial_item_count + 1];
        this.shapes = new String[this.initial_item_count + 1];
        this.plotting = new String[this.initial_item_count + 1];
        this.raw_data = new String[this.initial_item_count + 1];
        this.font_data = new String[this.initial_item_count + 1];
        this.f_x1 = new float[this.initial_item_count + 1];
        this.mid_x = new float[this.initial_item_count + 1];
        this.f_x2 = new float[this.initial_item_count + 1];
        this.f_y1 = new float[this.initial_item_count + 1];
        this.mid_y = new float[this.initial_item_count + 1];
        this.f_y2 = new float[this.initial_item_count + 1];
        this.heights = new float[this.initial_item_count + 1];
        this.isMaster = new boolean[this.initial_item_count + 1];
        this.isSingleLine = new boolean[this.initial_item_count + 1];
        this.hasText = new boolean[this.initial_item_count + 1];
        this.isUsed = new boolean[this.initial_item_count + 1];
        this.isRectangleOrphan = new boolean[this.initial_item_count + 1];
        this.hasContent = new boolean[this.initial_item_count + 1];
        this.canBeStrap = new boolean[this.initial_item_count + 1];
        this.line_count = new int[this.initial_item_count + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.initial_item_count) {
            n2 = nArray[n3];
            stringArray[n2] = "<~START>" + Fonts.cleanupTokens(stringArray[n2]) + "<~END>";
            String string = StripTags.strip(stringArray[n2], true);
            if (string.length() > 10) {
                string = string.substring(0, 10);
            }
            this.names[n3] = string;
            this.contents[n3] = stringArray[n2];
            this.plotting[n3] = stringArray3[n2];
            this.raw_data[n3] = stringArray2[n2];
            this.line_count[n3] = nArray2[n2];
            this.heights[n3] = fArray5[n2];
            int n4 = nArray3[n2];
            this.font_data[n3] = "[" + Fonts.extractFontsList(this.contents[n3]) + "]";
            this.f_x1[n3] = fArray[n2];
            this.f_x2[n3] = fArray2[n2];
            this.f_y1[n3] = fArray3[n2];
            this.f_y2[n3] = fArray4[n2];
            this.col_width[n3] = this.f_x2[n3] - this.f_x1[n3];
            this.mid_x[n3] = (this.f_x1[n3] + this.f_x2[n3]) / 2.0f;
            this.mid_y[n3] = (this.f_y1[n3] + this.f_y2[n3]) / 2.0f;
            this.shapes[n3] = this.f_y1[n3] < this.f_y2[n3] ? n + " " + (int)this.f_x1[n3] + " " + (int)this.f_y2[n3] + " " + (int)this.f_x2[n3] + " " + (int)this.f_y1[n3] : n + " " + (int)this.f_x1[n3] + " " + (int)this.f_y1[n3] + " " + (int)this.f_x2[n3] + " " + (int)this.f_y2[n3];
            this.isMaster[n3] = false;
            this.hasText[n3] = false;
            this.isUsed[n3] = false;
            this.hasContent[n3] = false;
            this.canBeStrap[n3] = true;
            String string2 = this.font_data[n3];
            int n5 = string2.indexOf("[");
            int n6 = string2.indexOf("]");
            int n7 = -1;
            if (n5 != -1 & n6 != -1) {
                if (this.debug_level) {
                    pdfToolTips.master_message(n4, string);
                }
                if (n4 > -1) {
                    this.isMaster[n3] = true;
                    if (!this.current_MT_data.getStrapFlag(n4)) {
                        this.canBeStrap[n3] = false;
                    }
                    pdfToolTips.addMasterToolTip(this.plotting[n3], this.shapes[n3], "Master object Rule " + n4);
                }
                string2 = string2.substring(n5 + 1, n6);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    int n8 = stringTokenizer.countTokens() - 1;
                    String string3 = stringTokenizer.nextToken().trim();
                    if (n4 >= 0) continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ">");
                    int n9 = stringTokenizer2.countTokens() + n8;
                    while (stringTokenizer2.hasMoreTokens()) {
                        n7 = this.current_MT_data.isTextFont(this.values_deliminator, this.line_count[n3], this.generic_minumum_size, n9, false, stringTokenizer2.nextToken() + ">", this.contents[n3]);
                        if (n7 != -1) break;
                    }
                    if (this.debug_level) {
                        pdfToolTips.text_message(n7, string);
                    }
                    if (n7 <= -1) continue;
                    this.hasText[n3] = true;
                    pdfToolTips.addTextToolTip(this.plotting[n3], this.shapes[n3], "Text object Rule " + n7);
                }
            }
            ++n3;
        }
    }

    private final void writeStoriesToData() {
        int n = this.initial_item_count;
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                if (this.contents[n2].length() > 0) {
                    Element element = new Element("Value");
                    element.setAttribute("content", "" + this.contents[n2]);
                    element.setAttribute("is_master", "" + this.isMaster[n2]);
                    element.setAttribute("plot_string", "" + this.plotting[n2]);
                    element.setAttribute("raw_data", "" + this.raw_data[n2]);
                    element.setAttribute("scaled_space_width", "" + this.scaled_space[n2]);
                    element.setAttribute("shape_data", "" + this.shapes[n2]);
                    element.setAttribute("line_count", "" + this.line_count[n2]);
                    element.setAttribute("line_height", "" + this.heights[n2]);
                    element.setAttribute("x1", "" + this.f_x1[n2]);
                    element.setAttribute("x2", "" + this.f_x2[n2]);
                    element.setAttribute("y1", "" + this.f_y1[n2]);
                    element.setAttribute("y2", "" + this.f_y2[n2]);
                    element.setAttribute("fonts_used", "" + this.font_data[n2]);
                    arrayList.add(element);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in writing data >" + this.contents[n2] + "<");
            }
            ++n2;
        }
        this.pdf_data.resetTextList(arrayList);
    }
}

