/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.storypad.ClientStandard;
import com.idrsolutions.storypad.ColorListener;
import com.idrsolutions.storypad.ColorRenderer;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.utils.functions.IsWriteable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jpedal.utils.LogWriter;

public class ClientData {
    public static HashMap color_values = new HashMap();
    private static UIManager.LookAndFeelInfo[] inst = UIManager.getInstalledLookAndFeels();
    private static int feel_counter = 0;
    private static Object[] initial_color_values = new Object[]{"admin_background", new Color(224, 224, 224), "main", "button_disabled", Color.lightGray, "main", "client_background", Color.lightGray, "main", "client_background_config_changed", new Color(253, 255, 153), "main", "header_column", new Color(192, 192, 192), "main", "highlight_reparse_icon", Color.white, "main", "list_changed_story_foreground", Color.blue, "main", "list_jump_story_foreground", Color.darkGray, "main", "list_story_background", Color.white, "main", "list_unchanged_story_foreground", Color.red, "main", "menu_foreground", Color.gray, "main", "background", Color.white, "pdf", "cursor", Color.blue, "pdf", "highlight", Color.pink, "pdf", "highlight_outline", Color.red, "pdf", "master_objects", Color.magenta, "pdf", "text_objects", Color.blue, "pdf", "panel", Color.gray, "pdf", "rectangle", Color.black, "pdf", "selected", Color.yellow, "pdf", "sql_background", Color.lightGray, "main", "tab_main", Color.lightGray, "main", "table_boolean_text_foreground", Color.red, "main", "table_comment_text_foreground", Color.green, "main", "table_help_text_foreground", Color.black, "main", "table_standard_text_foreground", Color.black, "main", "table_text_background", Color.white, "main", "text_foreground", Color.black, "main", "text_background", Color.white, "main", "toolbar_filter_foreground", Color.blue, "main", "toolbar_filter_background", Color.lightGray, "main", "toolbar_pdf_foreground", Color.blue, "main", "toolbar_pdf_background", Color.lightGray, "main"};
    private static JButton feel_button = new JButton();
    private static HashMap shortcuts = null;

    public static final void setClientColor(String string, Color color) {
        color_values.put(string, color);
    }

    public static final void saveShortcuts(HashMap hashMap) {
        shortcuts = hashMap;
    }

    public static final void loadValues() {
        block2: {
            File file;
            if (!IsWriteable.writeable(DecoderPaths.config_dir) || !(file = new File(DecoderPaths.config_dir + "colors.bin")).exists()) break block2;
            LogWriter.writeLog("User colours reloaded");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                Object object = objectInputStream.readObject();
                Vector vector = (Vector)object;
                objectInputStream.close();
                color_values = (HashMap)vector.elementAt(0);
                feel_counter = 0;
                feel_counter = Integer.parseInt((String)vector.elementAt(1));
                shortcuts = (HashMap)vector.elementAt(2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " accessing client data");
            }
        }
    }

    public static final HashMap getSavedShortcuts() {
        return shortcuts;
    }

    public static final JPanel getColorPanel(boolean bl) {
        JComponent jComponent;
        String string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < initial_color_values.length) {
            string = (String)initial_color_values[n2];
            String string2 = (String)initial_color_values[n2 + 2];
            if (!bl && string2.indexOf("pdf") == -1) {
                ++n;
                arrayList.add(string);
            }
            if (bl && string2.indexOf("pdf") != -1) {
                ++n;
                arrayList.add(string);
            }
            n2 += 3;
        }
        JTable jTable = new JTable(n, 2);
        int n3 = 0;
        while (n3 < n) {
            string = (String)arrayList.get(n3);
            jTable.setValueAt(string, n3, 0);
            jTable.setValueAt("", n3, 1);
            ++n3;
        }
        jTable.addMouseListener(new ColorListener(jTable, initial_color_values));
        jTable.setCellSelectionEnabled(false);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n4 = 0;
        while (n4 < 2) {
            jComponent = new ColorRenderer(initial_color_values);
            TableColumn tableColumn = tableColumnModel.getColumn(n4);
            tableColumn.setCellRenderer((TableCellRenderer)((Object)jComponent));
            if (n4 == 0) {
                jComponent.setToolTipText("Value");
                tableColumn.setHeaderValue("Name");
            } else {
                jComponent.setToolTipText("Color used - click with mouse to edit");
                tableColumn.setHeaderValue("Colour value");
            }
            ++n4;
        }
        jComponent = new JScrollPane();
        ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(31);
        ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
        ((JScrollPane)jComponent).getViewport().add(jTable);
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public static final JPanel getFeelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 20, 10, 20);
        BevelBorder bevelBorder = new BevelBorder(1);
        jPanel.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        feel_button.setText("Look and Feel : " + inst[feel_counter].getName());
        jPanel.add((Component)feel_button, "Center");
        return jPanel;
    }

    public static final void init() {
        int n = 0;
        while (n < initial_color_values.length) {
            color_values.put(initial_color_values[n], initial_color_values[n + 1]);
            n += 3;
        }
        ClientData.loadValues();
        try {
            int n2 = 0;
            while (n2 < inst.length) {
                String string = inst[n2].toString().toLowerCase();
                if (string.indexOf("windows") != -1 | string.indexOf("mac") != -1) {
                    feel_counter = n2;
                }
                ++n2;
            }
            UIManager.setLookAndFeel(inst[feel_counter].getClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to set look and feel");
        }
        feel_button.setToolTipText("Click to toggle Look and Feel of display");
        feel_button.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                feel_counter++;
                if (feel_counter == inst.length) {
                    feel_counter = 0;
                }
                feel_button.setText("Look and Feel : " + inst[feel_counter].getName());
                try {
                    UIManager.setLookAndFeel(inst[feel_counter].getClassName());
                    ClientData.saveValues();
                    ClientStandard.setUI();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Unable to set look and feel");
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public static final void saveValues() {
        if (IsWriteable.writeable(DecoderPaths.config_dir)) {
            File file = new File(DecoderPaths.config_dir + "colors.bin");
            try {
                Vector<Object> vector = new Vector<Object>(4);
                vector.add(0, color_values);
                vector.add(1, "" + feel_counter);
                vector.add(2, shortcuts);
                Vector<Object> vector2 = vector;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(vector2);
                objectOutputStream.close();
                LogWriter.writeLog("Client data saved");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " writing client data");
            }
        } else {
            LogWriter.writeLog("Serialised object on an http connection - not updated");
        }
    }

    public static final Color getClientColor(String string) {
        Color color = Color.blue;
        Object v = color_values.get(string);
        if (v != null) {
            color = (Color)color_values.get(string);
        }
        return color;
    }
}

