/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.storypad.ClientData;
import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderIO;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.gui.CommandList;
import com.idrsolutions.storypad.gui.ConfigDialog;
import com.idrsolutions.storypad.gui.FileFilterer;
import com.idrsolutions.storypad.gui.GridBagHelper;
import com.idrsolutions.storypad.gui.StoryList;
import com.idrsolutions.storypad.objects.ConfigurationData;
import com.idrsolutions.storypad.objects.License;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.FileInfo;
import com.idrsolutions.utils.ToUnicode;
import com.idrsolutions.utils.functions.GetComment;
import com.idrsolutions.utils.functions.IsWriteable;
import com.idrsolutions.utils.gui.HttpFiler;
import com.idrsolutions.utils.gui.IconiseImage;
import com.idrsolutions.utils.gui.MemoryMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ClientStandard
extends Decoder
implements ActionListener {
    private final int max_tabs = 20;
    public static JFrame main_frame;
    protected JPanel[] tab_panel = new JPanel[20];
    protected String[] tab_sql = new String[20];
    protected String[] tab_sql_name = new String[20];
    protected JTabbedPane tabbed_pane = new JTabbedPane();
    protected int story_number = 0;
    protected boolean is_reparse = false;
    protected StoryList available_stories = new StoryList();
    protected String[] headers = new String[10];
    protected int next_free_tab = 0;
    protected String section = "";
    protected DefaultListModel jump_model = new DefaultListModel();
    protected String command = "";
    protected StoryList unchanged_stories = new StoryList();
    protected int total_tabs = 1;
    protected boolean new_story_selected = false;
    protected JList jump_stories = new JList(this.jump_model);
    protected JPanel text_data = new JPanel();
    protected final CommandList current_command_list = new CommandList();
    protected static boolean focus_processing;
    protected static JScrollPane pdf_bar_scroll;
    protected static boolean is_pdf;
    protected static boolean options_altered;
    protected static boolean options_unsaved;
    protected static JPanel upper;
    protected static boolean processing_data;
    protected static HashMap shortcuts;
    ConfigDialog current_menu_dialog;
    private JPanel story_list;
    private String prefix = "";
    private static int max_furniture_items;
    private ImageIcon[] icons = new ImageIcon[max_furniture_items];
    private JPanel story_list_panel = new JPanel();
    private boolean file_opened = false;
    private HelpBroker hb;
    private ClassLoader loader = this.getClass().getClassLoader();
    private boolean helpLoaded = false;
    private JFileChooser chooser = new JFileChooser(this.user_file);
    private static int mfields;
    private JScrollPane[] holder = new JScrollPane[mfields];
    private String[] icon_name = new String[max_furniture_items];
    private boolean[] display_mode = new boolean[mfields];
    private boolean admin_mode = false;
    private String[] filter_operand = new String[max_furniture_items];
    private String[] filter_value = new String[max_furniture_items];
    private String[] filter_field = new String[max_furniture_items];
    private JScrollPane jump_stories_scrollpane = new JScrollPane();
    private boolean display_toolbars = true;
    private String[] default_menu_list = new String[]{"File=open O **Open a file", "File=-", "File=saveTextFromPages **Save text from range of pages using current settings", "File=saveImagesFromPages **Save Images from range of pages", "File=savePagesAsThumbnails **Save Images from range of pages", "File=-", "File=reload_configuration **Reload configuration file from hard copy", "File=save_configuration\t**Backup the configuration file and update with copy from memory", "File=-", "File=save_profile **Backup the configuration file as a profile whch can be loaded in preference to default", "File=-", "File=hide_toolbars", "File=-", "File=file_information", "File=-", "File=exit **Exit program", "Edit=merge M **Merge any highlighted stories together", "Edit=structured_merge **Merge any highlighted stories together", "Edit=table_merge(CSV) **Merge highlighted content together preserving table layout. Output as comma separate values.", "Edit=table_merge(HTML) **Merge highlighted content together preserving table layout. Output as tagged HTML.", "Format=reparse R **Reprocess the data using the configuration in memory", "Tools=geometry **General values used to associate items using metrics", "Tools=geometry_data **Defines fonts which constitute headers in algorithms", "Tools=-", "Tools=font_space_thresholds **defines minimum spacinf required for a hard space", "Configuration=client_parameters **Configuration of the client", "Configuration=-", "Configuration=pdf **Pdf specific settings", "Configuration=-", "Configuration=table_extraction **Table specific settings for extraction", "Configuration=database **Setup connections for MYSQL and PostgreSQL", "Help=help **Online help", "Help=info **Information on the program", "null"};
    private TabListener tab_listener = null;
    private JPanel main_panel = new JPanel();
    private HelpSet hs;
    private final Font menu_font = new Font("SansSerif", 0, 8);
    private final Font button_font = new Font("SansSerif", 0, 14);
    private final Font default_font = new Font("Serif", 0, 12);
    private final Border button_border_unpressed = new BevelBorder(0, Color.lightGray, Color.black);
    private final String menu_values_allowed = "open#saveTextPages#reload_configuration#save_configuration#admin#hide_toolbars#file_information#exit#delete#structured_merge#merge#table_merge(CSV)#table_merge(HTML)#submit#submitAll#reparse#showtokens#maptokens#Filters#table_extraction#display_fields#keywords#incremental#sorting#geometry#geometry_data#font_space_thresholds#orphan_objects#Link_items#remove_furniture#maximum_font_size#email_reports#initial_fields#substitution#rules#iteration#mandatory#TextOnlyFields#markup#encapsulation#Default_field_value#aliases#overwrite#tokens#decomposition#mapping#editing#general#token_definition#client_parameters#pdf#info#help#saveTextFromPages#saveImagesFromPages#savePagesAsThumbnails#save_profile#database";
    private final String initial_commands = "helpexitopen";
    private final Border button_border_pressed = new BevelBorder(1, Color.lightGray, Color.black);
    private final String prefixer = "";
    private static ClientStandard client_applet;
    private static JToolBar icon_bar;
    private static int reparse_icon_number;
    private static final int max_menus = 20;
    private static JMenu[] main_menu;
    private static JCheckBox[] filters;
    private static JTextArea[] text_holder;
    private static boolean[] main_menu_admin_flag;
    private static JToolBar shortcut_bar;
    private static JButton[] controls;
    private static final int max_menu_items = 200;
    private static JMenuItem[] menu_item;
    private static boolean[] menu_item_admin_flag;
    private static JMenuBar menu;
    private static JPanel top;
    private static JPanel[] data_panel;
    private static JToolBar filter_bar;
    private static int number_of_filters;
    private static final int TEXT = 1;
    private static final Font tab_font;
    private static final JPanel blank_panel;
    private static final int IMAGE = 3;

    public void actionPerformed(ActionEvent actionEvent) {
        main_frame.requestFocus();
        this.command = this.getCommand(actionEvent);
        this.executeCommand();
        main_frame.validate();
    }

    public ClientStandard() {
    }

    public ClientStandard(String[] stringArray) throws IOException {
        this.initClient(stringArray);
    }

    public static void setUI() {
        icon_bar.updateUI();
        menu.updateUI();
        upper.updateUI();
        filter_bar.updateUI();
        int n = 0;
        while (n < max_furniture_items) {
            if (filters[n] != null) {
                filters[n].updateUI();
            }
            if (main_menu[n] != null) {
                main_menu[n].updateUI();
            }
            if (controls[n] != null) {
                controls[n].updateUI();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 200) {
            if (menu_item[n2] != null) {
                menu_item[n2].updateUI();
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        try {
            client_applet = new ClientStandard(stringArray);
            main_frame.setBackground(ClientData.getClientColor("client_background"));
            main_frame.setVisible(false);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in program");
        }
        ClientStandard.showDisplay();
        main_frame.addWindowListener(new FrameCloser(client_applet));
        client_applet.run();
    }

    protected boolean open() {
        LogWriter.writeMethod("{standard_open}", 0);
        this.is_reparse = false;
        boolean bl = false;
        String[] stringArray = this.user_files;
        String string = null;
        this.resetTextDisplay();
        this.resetTabDisplay();
        do {
            string = this.selectFile(this.user_file);
        } while (this.isBinaryFile);
        if (string != null) {
            if (stringArray != null & (is_pdf = string.toLowerCase().endsWith(".pdf"))) {
                ObjectStore.flush();
            }
            ClientStandard clientStandard = this;
            if (clientStandard.current_license.getLevel() == 2) {
                LogWriter.resetLogFile();
            }
            if (!this.first_time) {
                this.archiveDataFile(false);
            }
            this.user_file = string;
            try {
                this.setup();
            }
            catch (Exception exception) {
                ExitDecoder.exitWithMessage("Exception " + exception + " in initialisation");
            }
            this.setColors();
            this.set_shortcut_bar();
            this.flushStoryDisplayPanel();
            this.resetStoryPanel(this.use_incremental);
            options_altered = false;
            options_unsaved = false;
            String string2 = "Storypad";
            ClientStandard clientStandard2 = this;
            if (clientStandard2.current_license.getLevel() == 1) {
                string2 = string2 + " DEMO";
            }
            ClientStandard clientStandard3 = this;
            if (clientStandard3.current_license.getLevel() == 2) {
                string2 = string2 + " PERSONAL";
            }
            main_frame.setTitle(string2 + " ( " + "3.1.0b14" + " )" + "  Decoding " + this.user_file + " Config File: " + this.config_file);
            if (this.first_time) {
                this.first_time = false;
                int n = 0;
                while (n < 200) {
                    if (menu_item[n] != null) {
                        menu_item[n].setForeground(Color.black);
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < 20) {
                    if (main_menu[n2] != null) {
                        main_menu[n2].setForeground(Color.black);
                    }
                    ++n2;
                }
                this.file_opened = true;
            }
            this.createPanels();
            this.resetTextDisplay();
            main_frame.validate();
            bl = true;
            StatusBar.resetStatus("File selected - decoding");
            this.decodeData();
            this.alignDisplay();
            this.first_time = false;
            this.updateStoriesNumber(false);
            main_frame.validate();
        }
        this.updateStoriesNumber(false);
        main_frame.validate();
        return bl;
    }

    protected void merge() {
        int n;
        LogWriter.writeMethod("{merge}", 0);
        int n2 = this.available_stories.getSelected();
        int n3 = this.unchanged_stories.getSelected();
        boolean bl = true;
        Object[] objectArray = this.available_stories.getSelectedStories();
        int n4 = 0;
        while (n4 < objectArray.length) {
            n = this.current_data.returnID((String)objectArray[n4]);
            String string = this.current_data.getField("TYPE", n);
            if (string.equals("IMAGE")) {
                bl = false;
            }
            ++n4;
        }
        objectArray = this.unchanged_stories.getSelectedStories();
        n = 0;
        while (n < objectArray.length) {
            int n5 = this.current_data.returnID((String)objectArray[n]);
            String string = this.current_data.getField("TYPE", n5);
            if (string.equals("IMAGE")) {
                bl = false;
            }
            ++n;
        }
        if (!bl) {
            ShowGUIMessage.showGUIMessage("Images cannot be merged - only text items", "Image in selection");
        } else {
            if (this.use_link) {
                this.moveSelectedJumpStories();
                this.saveLinkedItems();
            }
            this.story_list.validate();
            this.mergeClientStoriesTogether(this.available_stories.getSelectedStories(), this.unchanged_stories.getSelectedStories());
            this.alignDisplay();
            if (n2 > -1) {
                this.available_stories.selectStory(n2);
            } else if (n3 > -1) {
                this.unchanged_stories.selectStory(n3);
            }
            ClientStandard clientStandard = this;
            if (clientStandard.current_license.getLevel() != 2 & n2 * n3 != 1) {
                this.setValues(false);
            }
            main_frame.validate();
        }
    }

    protected void reparse() {
        LogWriter.writeMethod("{reparse}", 0);
        this.is_reparse = true;
        processing_data = true;
        options_altered = false;
        this.setColors();
        this.setConfigValues();
        StatusBar.resetStatus("Reparsing data");
        this.flushStoryDisplayPanel();
        this.resetTextDisplay();
        int n = 0;
        while (n < number_of_filters) {
            filters[n].setSelected(false);
            ++n;
        }
        ObjectStore.flush();
        this.decodeData();
        this.resetStoryPanel(this.use_incremental);
        this.alignDisplay();
        main_frame.validate();
    }

    protected void setColors() {
        Color color = ClientData.getClientColor("client_background");
        Color color2 = ClientData.getClientColor("admin_background");
        if (options_altered) {
            color = ClientData.getClientColor("client_background_config_changed");
            StatusBar.updateStatus("Changes take effect when reparse button (highlighted) is pressed", 4);
        }
        icon_bar.setBackground(color);
        menu.setBackground(color);
        upper.setBackground(color);
        this.resetColors(color);
        main_frame.setBackground(color);
        Color color3 = ClientData.getClientColor("toolbar_filter_background");
        Color color4 = ClientData.getClientColor("toolbar_filter_foreground");
        filter_bar.setForeground(color4);
        filter_bar.setBackground(color3);
        int n = 0;
        while (n < max_furniture_items) {
            if (filters[n] != null) {
                filters[n].setBackground(color3);
                filters[n].setForeground(color4);
            }
            if (main_menu[n] != null) {
                if (main_menu_admin_flag[n]) {
                    main_menu[n].setBackground(color2);
                } else {
                    main_menu[n].setBackground(color);
                }
            }
            if (controls[n] != null) {
                controls[n].setBackground(color);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 200) {
            if (menu_item[n2] != null) {
                if (menu_item_admin_flag[n2]) {
                    menu_item[n2].setBackground(color2);
                } else {
                    menu_item[n2].setBackground(color);
                }
            }
            ++n2;
        }
        if (options_altered) {
            controls[reparse_icon_number].setBackground(ClientData.getClientColor("highlight_reparse_icon"));
        }
    }

    protected final void updateStoriesNumber(boolean bl) {
        LogWriter.writeMethod("{updateStoriesNumber}", 1);
        int n = this.available_stories.getStorySize();
        int n2 = this.unchanged_stories.getStorySize();
        String string = "Stories: " + n;
        if (n2 > 0) {
            string = string + "/" + n2;
        }
        this.updateDisplayedNumber(string);
    }

    protected final int translateID(String string) {
        int n = -1;
        String string2 = "";
        try {
            if (string == null || string.equals("")) {
                string = this.getSelectedStory();
            }
            if (string != null) {
                string2 = this.current_data.getStoryID(string);
            }
            if (string2 != null && !string2.equals("")) {
                n = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception getting ID " + exception);
        }
        return n;
    }

    protected final String getCommand(ActionEvent actionEvent) {
        block6: {
            this.command = "";
            int n = controls.length;
            try {
                int n2 = 0;
                while (n2 < n) {
                    if (actionEvent.getSource() == controls[n2]) {
                        this.command = this.icon_name[n2];
                        controls[n2].setSelected(false);
                        int n3 = (int)controls[n2].getSize().getWidth();
                        int n4 = (int)controls[n2].getSize().getHeight();
                        controls[n2].paintImmediately(0, 0, n3, n4);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Error with icon settings");
            }
            if (!this.command.equals("")) break block6;
            try {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                this.command = jMenuItem.getText();
                top.paintImmediately(0, 0, (int)top.getSize().getWidth(), (int)top.getSize().getHeight());
                this.story_list.paintImmediately(0, 0, (int)this.story_list.getSize().getWidth(), (int)this.story_list.getSize().getHeight());
            }
            catch (Exception exception) {
                LogWriter.writeLog("Error " + exception + " identifying menu");
            }
        }
        return this.command;
    }

    protected final void resetStoryPanel(boolean bl) {
        LogWriter.writeMethod("{setStoryPanel}", 1);
        this.story_list_panel.removeAll();
        this.story_list_panel.add((Component)this.available_stories, GridBagHelper.getGridBag(1 + this.available_stories.getCount(), 1));
        if (bl) {
            this.story_list_panel.add((Component)this.unchanged_stories, GridBagHelper.getGridBag(this.unchanged_stories.getCount() + 1, 2));
        }
        if (this.use_link) {
            this.jump_stories_scrollpane.getViewport().add(this.jump_stories);
            this.story_list_panel.add((Component)this.jump_stories_scrollpane, GridBagHelper.getGridBag(this.jump_model.getSize() + 1, 3));
        }
    }

    protected final int createSQLDisplays(Color color) {
        LogWriter.writeMethod("{createSQLdisplays}", 1);
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = true;
        BufferedReader bufferedReader = null;
        while (bl) {
            if (++n > 20) break;
            String string4 = DecoderPaths.config_dir + "/tabs/" + FileInfo.getExtension(this.user_file, this.command_line_values) + "-" + DecoderPaths.group_id + n + ".cfg";
            File file = new File(string4);
            if (file.exists()) {
                try {
                    bufferedReader = this.getInputStream(string4, true);
                    string = bufferedReader.readLine();
                    string2 = Strip.stripComment(string);
                    string = bufferedReader.readLine();
                    this.tab_sql[n] = string3 = Strip.stripComment(string);
                    this.tab_sql_name[n] = string2;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Unable to read tab name/sql " + exception);
                    ShowGUIMessage.showGUIMessage(exception.toString(), "Unable to read tab name/sql ");
                }
                this.tab_panel[n] = new JPanel();
                this.tab_panel[n].setLayout(new BorderLayout());
                this.tabbed_pane.addTab(string2, this.tab_panel[n]);
                this.tabbed_pane.setBackgroundAt(n, color);
                ++this.total_tabs;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Failed to close tab config file");
                }
                continue;
            }
            bl = false;
        }
        return n;
    }

    protected final void executeCommand() {
        if (this.command.indexOf("exit") != -1) {
            this.exit();
        } else if (this.command.indexOf("open") != -1) {
            if (this.checkConfigSaved()) {
                this.open();
            }
            this.updateSQLDisplay();
        } else if (this.command.indexOf("info") != -1) {
            this.info();
        } else if (this.command.indexOf("help") != -1) {
            this.help();
        } else if (this.current_configuration != null) {
            StatusBar.updateStatus("Executing Command - " + this.command, 3);
            try {
                Object object = this.current_command_list.get(this.command);
                if (object != null) {
                    this.createConfigMenu((Object[])object);
                } else if (this.command.indexOf("save_configuration") != -1) {
                    this.saveConfiguration();
                } else if (this.command.indexOf("save_profile") != -1) {
                    this.saveProfle();
                } else if (this.command.indexOf("reload_configuration") != -1) {
                    this.reloadConfiguration();
                } else if (this.command.indexOf("delete") != -1) {
                    this.delete();
                } else if (this.command.indexOf("merge") != -1) {
                    this.merge();
                } else if (this.command.indexOf("submitAll") != -1) {
                    this.SubmitAll();
                } else if (this.command.indexOf("submit") != -1) {
                    this.submit();
                } else if (this.command.indexOf("reparse") != -1) {
                    this.reparse();
                } else if (this.command.indexOf("file_information") != -1) {
                    this.fileInformation();
                } else if (this.command.indexOf("showtokens") != -1) {
                    this.showtokens();
                } else if (this.command.indexOf("maptokens") != -1) {
                    this.maptokens();
                } else if (this.command.indexOf("admin") != -1) {
                    this.admin();
                } else if (this.command.indexOf("user") != -1) {
                    this.user();
                } else if (this.command.indexOf("hide_toolbars") != -1) {
                    this.hide_toolbars();
                } else if (this.command.indexOf("show_toolbars") != -1) {
                    this.show_toolbars();
                } else if (this.command.indexOf("cleanup") != -1) {
                    this.cleanup();
                }
                StatusBar.updateStatus("", 4);
            }
            catch (Exception exception) {
                LogWriter.writeLog(this.command + " not available" + exception);
                StatusBar.updateStatus(this.command + "failed with exception " + exception, 3);
            }
            this.updateStoriesNumber(false);
        }
    }

    protected final void applyChanges(boolean bl, String string, List list, boolean bl2) {
        boolean bl3;
        LogWriter.writeMethod("{applyChanges}", 0);
        processing_data = true;
        boolean bl4 = bl3 = string.indexOf("client_parameters") != -1;
        if (bl2) {
            this.current_tokens.updateSection(list);
            this.current_tokens.loadTokens(null, true, this.token_deliminators);
        } else {
            this.current_configuration.updateSection(bl, string, list);
        }
        if (bl3) {
            ClientData.saveValues();
        } else {
            this.saveConfiguration();
        }
        if (string.indexOf("filters") == -1) {
            this.createFilters();
        }
        processing_data = false;
        this.set_shortcut_bar();
    }

    protected final void initClient(String[] stringArray) {
        this.use_client = true;
        ExitDecoder.setClientDisplay();
        ShowGUIMessage.setClientDisplay();
        StatusBar.setClientDisplay();
        this.readArgs(stringArray);
        ClientData.init();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        main_frame = new JFrame();
        main_frame.setBackground(ClientData.getClientColor("client_background"));
        RepaintManager repaintManager = RepaintManager.currentManager(main_frame);
        repaintManager.setDoubleBufferingEnabled(true);
        ShowGUIMessage.setParentFrame(main_frame);
        int n = 600;
        int n2 = 300;
        main_frame.setSize(n, n2);
        main_frame.setTitle("Loading program info");
        main_frame.getContentPane().setLayout(new BorderLayout());
        main_frame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        main_frame.toFront();
        main_frame.setVisible(true);
        try {
            String string = this.getPath("log_file", false);
            LogWriter.log_name = string.indexOf("/") == -1 && string.indexOf("\\") == -1 ? DecoderPaths.user_dir + string : this.getPath("log_file", true);
            boolean bl = LogWriter.testLogFileWriteable(string, this.use_client);
            if (bl) {
                ExitDecoder.exitWithMessage("Unable to access logfile");
            }
            if (this.echo_to_screen) {
                main_frame.getContentPane().add((Component)LogWriter.showLog(), "East");
                main_frame.validate();
                main_frame.setTitle("Log values");
            }
            LogWriter.setupLogFile(this.echo_to_screen, Decoder.debug_level, "3.1.0b14", this.command_line_values, this.use_client);
        }
        catch (Exception exception) {
            ExitDecoder.exitWithMessage("Exception " + exception.getMessage() + " in setting log");
        }
        try {
            this.initStandardDecoder(true, this.user_file, null, null);
            LogWriter.writeLog("Decoder running");
        }
        catch (Exception exception) {
            ExitDecoder.exitWithMessage("Exception " + exception + " in setting up decoder object");
        }
        this.checkTempDirNotOverFull();
    }

    protected final void createClientDisplay() {
        LogWriter.writeMethod("{init_client}", 0);
        this.story_list = new JPanel();
        this.story_list.setLayout(new BorderLayout());
        ClientStandard clientStandard = this;
        if (clientStandard.current_license.getLevel() != 2) {
            this.text_data.setLayout(new GridBagLayout());
        } else {
            this.text_data.setLayout(new BorderLayout());
        }
        this.story_list_panel.setLayout(new GridBagLayout());
        this.story_list_panel.setPreferredSize(new Dimension(100, this.story_list.getHeight()));
        this.unchanged_stories.setPrototypeCellValue("xxxxxxxxxxxxxxxx");
        this.jump_stories.setPrototypeCellValue("xxxxxxxxxxxxxxxx");
        this.resetStoryPanel(false);
        this.updateStoriesNumber(true);
        this.text_data.setBackground(ClientData.getClientColor("client_background"));
        this.text_data.setBorder(BorderFactory.createTitledBorder(new EtchedBorder()));
        this.tabbed_pane.setBackground(ClientData.getClientColor("client_background"));
        this.tabbed_pane.setFont(tab_font);
        ClientStandard clientStandard2 = this;
        if (clientStandard2.current_license.getLevel() != 2) {
            this.tabbed_pane.addTab("Data", this.text_data);
        } else {
            this.tabbed_pane.addTab("Information", this.text_data);
            this.setPdfCover();
        }
        ClientStandard clientStandard3 = this;
        if (clientStandard3.current_license.getLevel() != 2) {
            this.story_list.add((Component)this.story_list_panel, "West");
        }
        this.story_list.add((Component)this.tabbed_pane, "Center");
        StatusBar.initialiseStatus("Storypad software", Decoder.debug_level);
        this.admin_mode = false;
        upper.setLayout(new BorderLayout());
        top.setLayout(new BorderLayout());
        main_frame.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        menu.setFont(this.menu_font);
        top.add((Component)shortcut_bar, "Center");
        icon_bar.setFloatable(false);
        icon_bar.setBorder(BorderFactory.createEmptyBorder());
        filter_bar.setFloatable(false);
        upper.add((Component)menu, "North");
        upper.add((Component)icon_bar, "West");
        upper.add((Component)filter_bar, "Center");
        top.add((Component)upper, "North");
        main_frame.getContentPane().add((Component)this.story_list, "Center");
        main_frame.getContentPane().add(StatusBar.getStatusObject(), "South");
        main_frame.getContentPane().add((Component)top, "North");
        if (this.command_line_values.indexOf("F") != -1) {
            MemoryMonitor memoryMonitor = new MemoryMonitor();
            memoryMonitor.surf.start();
            main_frame.getContentPane().add((Component)memoryMonitor, "East");
        }
        try {
            this.createTop();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " creating toolbar");
        }
        this.setColors();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ClientStandard.this.loadHelp();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("No help loaded");
                }
                ClientStandard.this.helpLoaded = true;
            }
        });
        main_frame.validate();
        StatusBar.updateStatus("waiting for user to select a file", 4);
    }

    protected final void initShortcuts() {
        shortcuts = ClientData.getSavedShortcuts();
        if (shortcuts == null) {
            shortcuts = this.current_configuration == null ? new HashMap() : this.current_configuration.getDefaultShortcutList();
        } else {
            LogWriter.writeLog("Shortcuts restored");
        }
    }

    public void repaintImmediately() {
        top.paintImmediately(0, 0, (int)top.getSize().getWidth(), (int)top.getSize().getHeight());
        this.story_list.paintImmediately(0, 0, (int)this.story_list.getSize().getWidth(), (int)this.story_list.getSize().getHeight());
    }

    protected final void setValues(boolean bl) {
        LogWriter.writeMethod("{setValues}", 1);
        int n = 0;
        boolean bl2 = false;
        int n2 = 1;
        int n3 = this.current_configuration.getIntValue("max_text_size");
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        List list = this.current_configuration.getSection(20);
        this.story_number = this.translateID("");
        if (bl) {
            string3 = (String)this.jump_stories.getSelectedValue();
        }
        this.buildDisplayElements();
        int n4 = list.size();
        int n5 = 0;
        while (n5 < n4) {
            Element element = (Element)list.get(n5);
            string = element.getAttributeValue("Field");
            n2 = this.getFieldType(string);
            bl2 = false;
            if (n2 == 1) {
                if (!bl) {
                    string2 = this.current_data.getField(string, this.story_number);
                } else if (string3 != null) {
                    string2 = this.current_linked_items.getField(string, string3);
                }
                n = string2.length();
                if (n > n3 & n3 > 0) {
                    LogWriter.writeLog("Over allowable size.Truncating entry for " + string);
                    string2 = string2.substring(0, n3);
                    bl3 = true;
                }
                try {
                    text_holder[n5].setText(ToUnicode.insertUnicodeEscapes(string2));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in value " + string2.length());
                    LogWriter.writeLog("Error id=" + n5);
                }
            } else if (n2 == 3) {
                JPanel jPanel = this.getImageFieldDisplay(string, this.story_number);
                this.holder[n5].getViewport().add(jPanel);
            }
            ++n5;
        }
        StatusBar.updateStatus("", 4);
        this.setPanesizes(false, bl);
        this.text_data.validate();
    }

    protected final int alignDisplay() {
        String string;
        this.available_stories.removeAllStories();
        this.unchanged_stories.removeAllStories();
        this.jump_stories.removeAll();
        int n = this.current_data.getStoryCount();
        String string2 = "sample_data";
        int n2 = 0;
        while (n2 < n) {
            string = this.current_data.getField("STORYNAME", n2);
            if (string.length() > 0) {
                if (this.current_data.isStoryChanged(n2)) {
                    this.unchanged_stories.addStory(string);
                } else {
                    this.available_stories.addStory(string);
                }
            }
            if (string.length() > string2.length()) {
                string2 = string;
            }
            ++n2;
        }
        this.available_stories.setPrototypeCellValue(string2);
        this.unchanged_stories.setPrototypeCellValue(string2);
        this.jump_stories.setPrototypeCellValue(string2);
        if (this.use_link) {
            int n3 = 0;
            while (n3 < this.current_linked_items.getJumpStoryKeyCount()) {
                string = this.current_linked_items.getJumpStoryAt(n3);
                this.jump_model.addElement(string);
                ++n3;
            }
        }
        this.updateStoriesNumber(false);
        this.resetStoryPanel(this.use_incremental);
        return this.story_number;
    }

    protected final boolean checkConfigSaved() {
        Object[] objectArray;
        int n;
        boolean bl = true;
        if (options_unsaved && (n = JOptionPane.showOptionDialog(main_frame, "Config changes will be lost - Are you sure?", "Confirm", 0, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[1])) == 1) {
            bl = false;
        }
        return bl;
    }

    protected final void help() {
        LogWriter.writeMethod("{help}", 0);
        if (!this.helpLoaded) {
            LogWriter.writeLog("Help is still loading");
            ShowGUIMessage.showGUIMessage("Help is still being loaded", "Help initialising");
        } else {
            try {
                JHelp jHelp = new JHelp(this.hs);
                jHelp.setVisible(true);
                JFrame jFrame = new JFrame();
                jFrame.getContentPane().add((Component)jHelp);
                int n = 600;
                int n2 = 400;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                jFrame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
                jFrame.setSize(n, n2);
                jFrame.setVisible(true);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with help");
            }
        }
    }

    protected final void resetTextDisplay() {
        LogWriter.writeMethod("{resetTextDisplay}", 1);
        if (this.current_configuration != null) {
            List list = this.current_configuration.getSection(20);
            String string = "";
            int n = list.size();
            Color color = ClientData.getClientColor("client_background");
            ClientStandard clientStandard = this;
            if (clientStandard.current_license.getLevel() != 2) {
                this.text_data.removeAll();
                int n2 = 0;
                while (n2 < n) {
                    Element element = (Element)list.get(n2);
                    string = element.getAttributeValue("Field");
                    text_holder[n2].setText("");
                    this.text_data.add((Component)data_panel[n2], GridBagHelper.getGridBag(10, n2));
                    data_panel[n2].setBackground(color);
                    ++n2;
                }
            } else {
                this.setPdfCover();
            }
        }
        this.tabbed_pane.validate();
    }

    protected final void info() {
        LogWriter.writeMethod("{info}", 0);
        ClientStandard clientStandard = this;
        JTextArea jTextArea = new JTextArea("StoryPad 3.1.0b14\n\n\u00a9IDRsolutions 2002\nwww.idrsolutions.com \nLicensed to: " + this.current_license.getLicenseValue("licensee") + " \nVersion:   " + this.current_license.version_text[clientStandard.current_license.getLevel()] + " \nSerial number: " + this.current_license.getLicenseValue("serial") + " \n");
        jTextArea.setEditable(false);
        jTextArea.setAutoscrolls(false);
        Object[] objectArray = new Object[]{"OK"};
        int n = JOptionPane.showOptionDialog(main_frame, jTextArea, "Storypad", 0, 1, null, objectArray, objectArray[0]);
    }

    protected final void exitWithConfigUnsaved() {
        if (options_unsaved) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(main_frame, "Changes made to configuration - do you wish to save", "Exiting client", 0, 3, null, objectArray, objectArray[1]);
            if (n == 1) {
                ExitDecoder.exitWithMessage("Exiting client without saving configuration");
            }
            this.saveConfiguration();
        }
        ExitDecoder.exitWithMessage("Exiting client and saving configuration");
    }

    protected final void exit() {
        Object[] objectArray;
        int n;
        if (this.checkConfigSaved() && (n = JOptionPane.showOptionDialog(null, "Are you sure?", "Confirm", 0, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[1])) == 0) {
            ExitDecoder.exitWithMessage("User requested program exit");
        }
    }

    protected final void run() {
        this.createClientDisplay();
        this.available_stories.story_list.addMouseListener(new story_mouse_listener(false, 0, this.available_stories.story_list));
        this.unchanged_stories.story_list.addMouseListener(new story_mouse_listener(false, 1, this.unchanged_stories.story_list));
        this.jump_stories.addMouseListener(new story_mouse_listener(true, 2, this.jump_stories));
        if (this.command_line_values.indexOf("o") != -1) {
            this.open();
            this.updateSQLDisplay();
        }
        this.initShortcuts();
    }

    protected static final void showDisplay() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 600;
        int n2 = 300;
        n = dimension.width - 60;
        n2 = dimension.height - 60;
        main_frame.setSize(n, n2);
        main_frame.setTitle("Storypad ( version  3.1.0b14 )");
        main_frame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        main_frame.validate();
        main_frame.setVisible(true);
        main_frame.addComponentListener(new ComponentListener(){

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                main_frame.validate();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    private final void set_shortcut_bar() {
        shortcut_bar.setLayout(new FlowLayout());
        shortcut_bar.setFloatable(false);
        shortcut_bar.removeAll();
        String string = "";
        Iterator iterator = shortcuts.keySet().iterator();
        while (iterator.hasNext()) {
            JComponent jComponent;
            string = (String)iterator.next();
            String string2 = shortcuts.get(string).toString().toLowerCase();
            if (string2.indexOf("true") == -1) continue;
            String string3 = this.current_configuration.getSystemValue(string);
            String string4 = string3.toLowerCase();
            String string5 = "truefalse";
            shortcut_bar.add(new JLabel(string));
            if (string5.indexOf(string4) == -1) {
                jComponent = new JTextField("  " + string3 + "  ");
                shortcut_bar.add(jComponent);
                jComponent.addFocusListener(new Shortcut_Text_Listener(this.section, (JTextField)jComponent, string));
                continue;
            }
            jComponent = new JCheckBox();
            boolean bl = this.current_configuration.getBooleanValue(string);
            ((AbstractButton)jComponent).setSelected(bl);
            ((AbstractButton)jComponent).addChangeListener(new Shortcut_Check_Listener(this.section, string, (JCheckBox)jComponent, bl));
            shortcut_bar.add(jComponent);
        }
    }

    private final void resetTabDisplay() {
        LogWriter.writeMethod("{resetTabDisplay}", 1);
        int n = this.tabbed_pane.getTabCount();
        while (n > 1) {
            this.tabbed_pane.remove(n - 1);
            n = this.tabbed_pane.getTabCount();
        }
        this.total_tabs = 1;
        this.next_free_tab = 0;
        this.tabbed_pane.setSelectedIndex(0);
        this.updateStoriesNumber(true);
    }

    private final void createPanels() {
        LogWriter.writeMethod("{createPanels}", 1);
        this.text_data.removeAll();
        ClientStandard clientStandard = this;
        if (clientStandard.current_license.getLevel() != 2) {
            this.buildDisplayElements();
            this.setPanesizes(true, false);
        }
        this.text_data.setBackground(ClientData.getClientColor("client_background"));
    }

    private final void resetColors(Color color) {
        this.story_list.setBackground(color);
        this.story_list_panel.setBackground(color);
        this.tabbed_pane.setBackground(color);
        this.text_data.setBackground(color);
        this.available_stories.setColor(ClientData.getClientColor("list_unchanged_story_foreground"));
        this.unchanged_stories.setForeground(ClientData.getClientColor("list_changed_story_foreground"));
        this.jump_stories.setForeground(ClientData.getClientColor("list_jump_story_foreground"));
        int n = 0;
        while (n < mfields) {
            if (data_panel[n] != null) {
                data_panel[n].setBackground(color);
            }
            if (text_holder[n] != null) {
                text_holder[n].setForeground(ClientData.getClientColor("text_foreground"));
                text_holder[n].setBackground(ClientData.getClientColor("text_background"));
            }
            ++n;
        }
    }

    private final void fileInformation() {
        LogWriter.writeMethod("{info}", 0);
        if (this.decode_pdf != null) {
            String string = "Current file : " + FileInfo.extractFileNameWithExtension(this.user_file) + "   \n\n";
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setEditable(false);
            jTextArea.setAutoscrolls(false);
            Object[] objectArray = new Object[]{"OK"};
            int n = JOptionPane.showOptionDialog(main_frame, jTextArea, "File Information", 0, 1, null, objectArray, objectArray[0]);
        }
    }

    private final void flushStoryDisplayPanel() {
        LogWriter.writeMethod("{flushStoryPanel}", 1);
        this.available_stories.removeAllStories();
        this.unchanged_stories.removeAllStories();
        this.jump_model.removeAllElements();
        this.updateStoriesNumber(processing_data);
        this.story_list_panel.validate();
    }

    private final void moveSelectedJumpStories() {
        Object[] objectArray = this.jump_stories.getSelectedValues();
        int[] nArray = this.jump_stories.getSelectedIndices();
        int n = objectArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            try {
                string = (String)objectArray[n2];
                Element element = this.current_linked_items.getStory(string);
                int n3 = this.available_stories.getStorySize();
                this.available_stories.addStory(string);
                int[] nArray2 = this.available_stories.getSelection();
                int n4 = nArray2.length;
                int[] nArray3 = new int[n4 + 1];
                int n5 = 0;
                while (n5 < n4) {
                    nArray3[n5] = nArray2[n5];
                    ++n5;
                }
                nArray3[n4] = n3;
                this.available_stories.setSelectedIndices(nArray3);
                this.current_data.createStory(string, element);
                this.current_linked_items.removeStory(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " moving story from jumplist");
            }
            ++n2;
        }
        int n6 = n - 1;
        while (n6 >= 0) {
            this.jump_model.remove(nArray[n6]);
            --n6;
        }
    }

    private final void resetHighlightedItem(int n) {
        LogWriter.writeMethod("{resetHighlightedItem}", 1);
        int n2 = 0;
        if (n == 0) {
            n2 = this.available_stories.getSelected();
        }
        if (n == 1) {
            n2 = this.unchanged_stories.getSelected();
        }
        int n3 = n2;
        while (n3 > -1) {
            try {
                if (n == 0) {
                    this.available_stories.removeStoryAt(n3);
                } else {
                    this.unchanged_stories.removeStoryAt(n3);
                }
                n2 = n3;
                if (n == 0) {
                    n3 = this.available_stories.getSelected();
                }
                if (n == 1) {
                    n3 = this.unchanged_stories.getSelected();
                }
                if (n3 != 0) continue;
                break;
            }
            catch (Exception exception) {
                n3 = -1;
            }
        }
        if (n == 0) {
            n3 = this.available_stories.getCount() - 1;
        }
        if (n == 1) {
            n3 = this.unchanged_stories.getCount() - 1;
        }
        if (n2 >= n3) {
            n2 = n3;
        }
        if (n == 0) {
            this.available_stories.selectStory(n2);
        } else {
            this.unchanged_stories.selectStory(n2);
        }
        if (n2 == 0) {
            this.resetTextDisplay();
        } else {
            this.setValues(false);
        }
    }

    private final void checkTempDirNotOverFull() {
        File file = new File(DecoderPaths.temp_dir);
        int n = file.list().length;
        if (n > 30) {
            LogWriter.writeLog("Files in temp directory may need purging " + n + " files");
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n2 = JOptionPane.showOptionDialog(main_frame, "There are " + n + " files in the temp directory.\nDo you wish to delete\nWARNING!!\nThis may effect any other copies of the software running", "Files in Storypad temp directory warning", 0, 3, null, objectArray, objectArray[1]);
            if (n2 == 0) {
                String[] stringArray = file.list();
                int n3 = 0;
                while (n3 < n) {
                    File file2 = new File(DecoderPaths.temp_dir + stringArray[n3]);
                    file2.delete();
                    ++n3;
                }
            }
        }
    }

    private final void showtokens() {
        LogWriter.writeMethod("{showtokens}", 0);
        this.current_configuration.setSystemValue("Editing", "keep_tags", "true");
        options_altered = true;
        options_unsaved = true;
        this.setColors();
        this.allowImmediateReparse();
    }

    private final int getFieldType(String string) {
        int n = 1;
        Element element = null;
        List list = this.current_configuration.getSection(27);
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Element element2 = (Element)list.get(n3);
            String string2 = element2.getAttributeValue("Field");
            if (string2.equals(string)) {
                String string3 = element2.getAttributeValue("Type").toLowerCase();
                if (string3.indexOf("image") != -1) {
                    n = 3;
                }
                n3 = n2;
                element = element2;
            }
            ++n3;
        }
        return n;
    }

    private final void createFilters() {
        LogWriter.writeMethod("{createFilters}", 1);
        String string = "";
        Color color = ClientData.getClientColor("toolbar_filter_foreground");
        Color color2 = ClientData.getClientColor("toolbar_filter_background");
        number_of_filters = 0;
        filter_bar.removeAll();
        filter_bar.setForeground(color);
        filter_bar.setFloatable(false);
        filter_bar.setBackground(color2);
        filter_bar.setFont(new Font("SansSerif", 0, 8));
        filter_bar.setToolTipText("Filters allow only a subset of data to be displayed");
        List list = this.current_configuration.getSection(21);
        Check_Listener check_Listener = new Check_Listener();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)list.get(n2);
            String string2 = element.getAttributeValue("Name");
            this.filter_field[ClientStandard.number_of_filters] = element.getAttributeValue("Field");
            this.filter_operand[ClientStandard.number_of_filters] = element.getAttributeValue("Operator");
            this.filter_value[ClientStandard.number_of_filters] = element.getAttributeValue("Value");
            string = element.getAttributeValue("Comment");
            ClientStandard.filters[ClientStandard.number_of_filters] = new JCheckBox(string2);
            filters[number_of_filters].setForeground(color);
            filters[number_of_filters].setBackground(color2);
            filter_bar.add(filters[number_of_filters]);
            filters[number_of_filters].addItemListener(check_Listener);
            filters[number_of_filters].setToolTipText(string);
            ++number_of_filters;
            ++n2;
        }
        main_frame.validate();
    }

    private final void removeAllStories() {
        this.unchanged_stories.removeAllStories();
        this.available_stories.removeAllStories();
        this.jump_model.removeAllElements();
    }

    private final void submit() {
        LogWriter.writeMethod("{submit}", 0);
        boolean bl = true;
        if (!focus_processing) {
            try {
                bl = this.writeStory(this.translateID(""), this.getSelectedStory());
            }
            catch (Exception exception) {
                LogWriter.writeLog("Error writing story");
            }
            if (!bl) {
                this.delete();
            }
        }
    }

    private final void delete() {
        LogWriter.writeMethod("{delete}", 0);
        int n = this.unchanged_stories.getCount();
        boolean bl = false;
        if (this.available_stories.getSelected() != -1) {
            bl = true;
            this.resetHighlightedItem(0);
        }
        if (this.unchanged_stories.getSelected() != -1) {
            if (n > 1) {
                bl = true;
            }
            this.resetHighlightedItem(1);
        }
        if (bl) {
            ClientStandard clientStandard = this;
            if (clientStandard.current_license.getLevel() != 2) {
                this.setValues(false);
            }
        } else {
            this.resetTextDisplay();
        }
    }

    private final String selectFile(String string) {
        LogWriter.writeMethod("{selectFile}", 0);
        String string2 = null;
        if (IsWriteable.writeable(string)) {
            string2 = this.selectFlatFile(string);
        } else {
            try {
                HttpFiler httpFiler = new HttpFiler();
                string2 = httpFiler.getHttpFile(string);
                if (License.getLevel() == 1) {
                    string2 = this.current_license.checkFile(string2);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Error in selecting from http menu " + exception);
            }
        }
        return string2;
    }

    private final void allowImmediateReparse() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(main_frame, "Do you wish to reprocess the data now?", "Reparse now", 0, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.reparse();
        }
    }

    private final void user() {
        LogWriter.writeMethod("{user}", 0);
        this.admin_mode = false;
        try {
            this.createTop();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " recreating menus");
        }
    }

    private final void mergeClientStoriesTogether(Object[] objectArray, Object[] objectArray2) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = objectArray2.length - 1;
        int n5 = objectArray.length - 1;
        int n6 = 0;
        if (n5 >= 0) {
            string = (String)objectArray[0];
            n3 = this.current_data.returnID(string);
        }
        if (n3 == -1 && n4 > 0) {
            n3 = this.current_data.returnID((String)objectArray2[0]);
            n6 = 1;
        }
        if (n3 != -1) {
            if (n5 > 0) {
                n = 0;
                while (n < n5) {
                    string2 = (String)objectArray[n + 1];
                    n2 = this.current_data.returnID(string2);
                    boolean bl = this.isOrderCorrect(string, string2, n3);
                    this.merge(this.use_first_field, n3, n2, "", bl, true, false, true);
                    ++n;
                }
            }
            if (n4 >= 0) {
                n = n6;
                while (n < n4 + 1) {
                    n2 = this.current_data.returnID((String)objectArray2[n]);
                    this.merge(this.use_first_field, n3, n2, "", true, true, false, true);
                    ++n;
                }
            }
        } else {
            LogWriter.writeLog("No items selected");
        }
    }

    private final void saveConfiguration() {
        LogWriter.writeMethod("{saveConfiguration}", 0);
        this.rewriteConfigurationFiles();
        options_altered = false;
        options_unsaved = false;
    }

    private final void maptokens() {
        LogWriter.writeMethod("{maptokens}", 0);
        options_altered = true;
        options_unsaved = true;
        this.setColors();
        this.current_configuration.setSystemValue("Editing", "keep_tags", "false");
        this.allowImmediateReparse();
    }

    private final void saveProfle() {
        block4: {
            LogWriter.writeMethod("{saveProfile}", 0);
            File file = new File(config_dir + "profiles");
            if (!file.exists()) {
                file.mkdir();
            }
            this.chooser = new JFileChooser(file);
            this.chooser.setFileSelectionMode(0);
            this.chooser.showSaveDialog(main_frame);
            File file2 = this.chooser.getSelectedFile();
            if (file2 == null) break block4;
            try {
                String string = file2.getCanonicalPath();
                if (!string.endsWith(".xml")) {
                    string = string + ".xml";
                }
                this.rewriteConfigFile(string, false);
                options_altered = false;
                options_unsaved = false;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " saving profile");
            }
        }
    }

    private final void decodeData() {
        processing_data = true;
        try {
            this.createFilters();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in creating display");
        }
        try {
            this.processFile(this.user_file, true, this.is_reparse);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ExitDecoder.exitWithMessage("Insufficient free memory to process file");
        }
        processing_data = false;
        if (this.fields_have_been_rejected) {
            ShowGUIMessage.showGUIMessage("This data contains fields with data over specified lengths", "Oversized data present");
        }
    }

    private final void SubmitAll() {
        LogWriter.writeMethod("{SubmitAll}", 0);
        this.flushStoryDisplayPanel();
        StatusBar.updateStatus("Writing out all stories to disk", 1);
        try {
            this.writeAllStories();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Error writing stories");
        }
    }

    private final void backupConfigurationFile(String string, boolean bl) {
        LogWriter.writeMethod("{backupConfigurationFile}", 0);
        String string2 = FileInfo.extractFileNameWithExtension(string);
        if (IsWriteable.writeable(string)) {
            LogWriter.writeLog("Attempting to backup configuration file " + string2);
            int n = this.current_configuration.getIntValue("current_backup");
            if (bl) {
                n = n >= this.current_configuration.getIntValue("max_backup") ? 0 : ++n;
                this.current_configuration.setSystemValue("General", "current_backup", n + "");
            }
            File file = new File(string);
            File file2 = new File(DecoderPaths.config_dir + "backup/" + string2 + ".backup" + n);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
    }

    private final void rewriteConfigFile(String string, boolean bl) {
        LogWriter.writeMethod("{writeVector}", 0);
        if (bl) {
            this.backupConfigurationFile(string, true);
        }
        String string2 = "";
        try {
            this.current_configuration.saveConfigAsXML(string);
            LogWriter.writeLog(string + " saved with updated configuration");
        }
        catch (Exception exception) {
            LogWriter.writeLog("Error writing to config file " + string);
        }
    }

    private final void rewriteConfigurationFiles() {
        String string;
        LogWriter.writeMethod("{rewriteConfigurationFile}", 0);
        File file = new File(DecoderPaths.config_dir + "backup");
        if (!file.exists()) {
            file.mkdir();
        }
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Attempting to rewrite configuration");
        }
        if (IsWriteable.writeable(string = DecoderPaths.config_dir + this.config_file)) {
            this.rewriteConfigFile(string, true);
        } else {
            LogWriter.writeLog("Http connection - no config file written");
        }
        if (IsWriteable.writeable(this.token_file_name)) {
            this.backupConfigurationFile(this.token_file_name, false);
            this.current_tokens.saveTokensAsXML(this.token_file_name);
        } else {
            LogWriter.writeLog("Http connection - no token file written");
        }
    }

    private final void buildDisplayElements() {
        LogWriter.writeMethod("{buildDisplayElements}", 1);
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        List list = this.current_configuration.getSection(20);
        int n2 = list.size();
        n = 0;
        while (n < n2) {
            Serializable serializable;
            boolean bl;
            Element element = (Element)list.get(n);
            this.holder[n] = new JScrollPane();
            ClientStandard.data_panel[n] = new JPanel();
            data_panel[n].setLayout(new BorderLayout());
            data_panel[n].add((Component)this.holder[n], "Center");
            this.holder[n].setBackground(ClientData.getClientColor("client_background"));
            ClientStandard.text_holder[n] = new JTextArea();
            text_holder[n].setLineWrap(true);
            text_holder[n].setFont(this.default_font);
            text_holder[n].setForeground(ClientData.getClientColor("text_foreground"));
            string2 = element.getAttributeValue("Field");
            String string4 = element.getAttributeValue("Font_Name");
            String string5 = element.getAttributeValue("Font_Size");
            this.display_mode[n] = bl = Boolean.valueOf(element.getAttributeValue("Always_Show").toUpperCase()).booleanValue();
            boolean bl2 = Boolean.valueOf(element.getAttributeValue("Editable").toUpperCase());
            if (!bl2) {
                text_holder[n].setEditable(false);
                text_holder[n].setBackground(ClientData.getClientColor("tab_main"));
            } else {
                text_holder[n].setEditable(true);
                text_holder[n].setBackground(ClientData.getClientColor("text_background"));
            }
            string3 = element.getAttributeValue("Comment");
            try {
                if (string4.length() > 4) {
                    serializable = new Font(string4, 0, Integer.parseInt(string5));
                    text_holder[n].setFont((Font)serializable);
                } else if (string5.length() > 0) {
                    serializable = new Font("Lucida", 0, Integer.parseInt(string5));
                    text_holder[n].setFont((Font)serializable);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("No user font settings - defaults used");
            }
            text_holder[n].setForeground(ClientData.getClientColor("text_foreground"));
            text_holder[n].addFocusListener(new handle_focus(n));
            text_holder[n].setToolTipText(string3);
            text_holder[n].setWrapStyleWord(true);
            if (this.getFieldType(string2) == 1) {
                this.holder[n].getViewport().add(text_holder[n]);
                this.holder[n].setBackground(ClientData.getClientColor("client_background"));
            }
            this.holder[n].setBorder(BorderFactory.createTitledBorder(new TitledBorder(BorderFactory.createTitledBorder(new EtchedBorder()))));
            this.holder[n].setForeground(Color.black);
            serializable = new JLabel(string2);
            data_panel[n].add((Component)serializable, "North");
            ((JComponent)serializable).setToolTipText("Click to toggle screen display");
            ((Component)serializable).addMouseListener(new toggle_display_listener(n));
            this.holder[n + 1] = new JScrollPane();
            ++n;
        }
    }

    private final void createTop() throws IOException {
        LogWriter.writeMethod("{createTop}", 1);
        menu.removeAll();
        icon_bar.removeAll();
        BufferedReader bufferedReader = null;
        ClientStandard clientStandard = this;
        if (clientStandard.current_license.getLevel() != 2) {
            bufferedReader = this.getInputStream(DecoderPaths.config_dir + "menu.cfg", true);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        changeListener changeListener2 = new changeListener();
        Color color = ClientData.getClientColor("client_background");
        Color color2 = ClientData.getClientColor("admin_background");
        int n6 = 97;
        int n7 = 0;
        while (true) {
            boolean bl;
            n3 = 0;
            ClientStandard clientStandard2 = this;
            if (clientStandard2.current_license.getLevel() == 2) {
                string4 = this.default_menu_list[n7];
                ++n7;
            } else {
                string4 = bufferedReader.readLine();
            }
            string5 = GetComment.get(string4);
            string3 = Strip.stripComment(string4);
            if (string3 == null || string3.indexOf("=") == -1) break;
            if (!(this.admin_mode | !(bl = string3.startsWith("Admin_")))) continue;
            if (bl) {
                string3 = string3.substring(6);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3.trim(), "=");
            string = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            while (true) {
                if (string.length() > 0) {
                    n2 = string2.indexOf(" ");
                    if (n2 != -1) {
                        n6 = string2.charAt(n2 + 1);
                        string2 = string2.substring(0, n2).trim();
                    }
                    if (hashtable.get(string) == null) {
                        ClientStandard.main_menu[n] = new JMenu(string);
                        main_menu[n].setBackground(color);
                        char c = string.toLowerCase().charAt(0);
                        main_menu[n].setMnemonic(c);
                        hashtable.put(string, n + "");
                        if (n3 == 0) {
                            menu.add(main_menu[n]);
                        } else {
                            main_menu[n3].add(main_menu[n]);
                        }
                        ++n;
                    }
                    ++n5;
                }
                n3 = Integer.parseInt((String)hashtable.get(string));
                if (!stringTokenizer.hasMoreTokens()) break;
                string = string2;
                string2 = stringTokenizer.nextToken();
            }
            if (string2.length() <= 0) continue;
            if (string2.indexOf("-") != -1) {
                main_menu[n3].addSeparator();
                continue;
            }
            if ("open#saveTextPages#reload_configuration#save_configuration#admin#hide_toolbars#file_information#exit#delete#structured_merge#merge#table_merge(CSV)#table_merge(HTML)#submit#submitAll#reparse#showtokens#maptokens#Filters#table_extraction#display_fields#keywords#incremental#sorting#geometry#geometry_data#font_space_thresholds#orphan_objects#Link_items#remove_furniture#maximum_font_size#email_reports#initial_fields#substitution#rules#iteration#mandatory#TextOnlyFields#markup#encapsulation#Default_field_value#aliases#overwrite#tokens#decomposition#mapping#editing#general#token_definition#client_parameters#pdf#info#help#saveTextFromPages#saveImagesFromPages#savePagesAsThumbnails#save_profile#database".indexOf(string2) == -1) continue;
            if (string2.indexOf("admin") != -1 & this.admin_mode) {
                string2 = "user";
            }
            if (string2.indexOf("hide_toolbars") != -1 & !this.display_toolbars) {
                string2 = "show_toolbars";
            }
            ClientStandard.menu_item[n5] = new JMenuItem(string2);
            main_menu[n3].add(menu_item[n5]);
            menu_item[n5].addActionListener(this);
            menu_item[n5].addChangeListener(changeListener2);
            menu_item[n5].setActionCommand(string5);
            menu_item[n5].setBackground(color);
            if (!this.file_opened & "helpexitopen".indexOf(string2) == -1) {
                menu_item[n5].setForeground(ClientData.getClientColor("menu_foreground"));
            }
            if (bl) {
                ClientStandard.menu_item_admin_flag[n5] = true;
                ClientStandard.main_menu_admin_flag[n3] = true;
                menu_item[n5].setBackground(color2);
                main_menu[n3].setBackground(color2);
            }
            if (!bl | this.admin_mode) {
                URL uRL = ClassLoader.getSystemResource("com/res/icons/" + string2 + ".gif");
                if (uRL != null) {
                    if (string2.indexOf("reparse") != -1) {
                        reparse_icon_number = n4;
                    }
                    this.icons[n4] = new ImageIcon(uRL);
                    ClientStandard.controls[n4] = new JButton(this.icons[n4]);
                    this.icon_name[n4] = string2;
                    controls[n4].setToolTipText(string5);
                    icon_bar.add(controls[n4]);
                    controls[n4].addActionListener(this);
                    ++n4;
                }
            }
            if (n2 <= 0) continue;
            menu_item[n5].setAccelerator(KeyStroke.getKeyStroke(n6, 2));
        }
        ClientStandard clientStandard3 = this;
        if (clientStandard3.current_license.getLevel() != 2) {
            bufferedReader.close();
        }
        icon_bar.add(Box.createHorizontalGlue());
        if (options_altered) {
            controls[reparse_icon_number].setBackground(ClientData.getClientColor("highlight_reparse_icon"));
        }
    }

    private final void createConfigMenu(Object[] objectArray) {
        List list;
        LogWriter.writeMethod("{createConfigMenu}", 0);
        boolean bl = false;
        String string = (String)objectArray[0];
        this.headers = (String[])objectArray[1];
        this.section = (String)objectArray[2];
        this.prefix = (String)objectArray[3];
        String string2 = (String)objectArray[4];
        boolean bl2 = ConfigurationData.isDefaultUserSection(this.section);
        if (this.section.indexOf("Tag_map") == -1) {
            list = this.current_configuration.getSection(this.section);
        } else {
            list = this.current_tokens.getTokenList();
            bl = true;
        }
        if (this.headers == null) {
            this.headers = !bl2 ? ConfigurationData.default_system_headers : ConfigurationData.default_user_headers;
        }
        this.current_menu_dialog = new ConfigDialog(DecoderPaths.temp_dir, this.MySQL_output, this.Postgre_output);
        this.current_menu_dialog.init(this.current_configuration.getFields(), string2, this.current_data, this.translateID(""), this.section, this.headers, this.current_configuration);
        ClientStandard clientStandard = this;
        this.current_menu_dialog.initDisplay(clientStandard.current_license.getLevel(), shortcuts, string, list);
        this.current_menu_dialog.showDialog();
        List list2 = this.current_menu_dialog.returnValues();
        HashMap hashMap = this.current_menu_dialog.returnShortcuts();
        this.current_menu_dialog.cleanupDialog();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            shortcuts.put(k, hashMap.get(k));
        }
        this.setColors();
        this.current_menu_dialog = null;
        if (list2 != null) {
            ClientData.saveShortcuts(shortcuts);
            this.applyChanges(bl2, this.section, list2, bl);
            options_altered = true;
            options_unsaved = true;
            this.setColors();
        }
        main_frame.validate();
    }

    private final void loadHelp() {
        try {
            this.hs = new HelpSet(this.loader, ClassLoader.getSystemResource("com/res/javahelp/storypad.hs"));
            this.hs.setTitle("Storypad online help");
            this.hb = this.hs.createHelpBroker();
            LogWriter.writeLog("Interactive help setup ");
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " initialising helpset");
        }
    }

    private final void setPanesizes(boolean bl, boolean bl2) {
        LogWriter.writeMethod("{setPanesizes}", 1);
        String string = "";
        List list = this.current_configuration.getSection(20);
        if (bl2) {
            string = (String)this.jump_stories.getSelectedValue();
        }
        int n = list.size();
        Color color = ClientData.getClientColor("client_background");
        this.story_number = this.translateID("");
        int n2 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        String string2 = "";
        String string3 = "";
        int n3 = 1;
        int n4 = 0;
        int n5 = 1;
        if (this.story_number == -1 & !bl2) {
            this.resetTextDisplay();
        } else {
            this.text_data.removeAll();
            this.text_data.setBackground(color);
            int n6 = 0;
            while (n6 < n) {
                Element element = (Element)list.get(n6);
                string2 = element.getAttributeValue("Field");
                int n7 = this.getFieldType(string2);
                if (!bl) {
                    if (n7 == 1) {
                        string3 = !bl2 ? this.current_data.getField(string2, this.story_number) : this.current_linked_items.getField(string2, string);
                        nArray2[n6] = n3 = Strip.stripSpaces(string3).trim().length();
                    } else {
                        nArray2[n6] = n7 == 3 ? (this.current_data.hasImage(string2, this.story_number) ? 20 : 0) : 20;
                    }
                }
                if (n3 > 50) {
                    ++n5;
                }
                if (n3 > 100) {
                    n5 += 2;
                }
                if (n3 > 150) {
                    n5 += 2;
                }
                nArray[n6] = n5;
                n2 += n5;
                ++n6;
            }
            n6 = 0;
            while (n6 < n) {
                n5 = nArray[n6];
                n4 += n5;
                if (nArray2[n6] > 0 | bl | this.display_mode[n6]) {
                    this.text_data.add((Component)data_panel[n6], GridBagHelper.getGridBag(100 * n5, n6));
                    data_panel[n6].setBackground(color);
                }
                ++n6;
            }
        }
        main_frame.validate();
    }

    private final void cleanup() {
        LogWriter.writeMethod("{cleanup}", 0);
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "Please use Open command", "Confirm", 0, 3, null, objectArray, objectArray[1]);
    }

    private final void admin() {
        LogWriter.writeMethod("{admin}", 0);
        this.admin_mode = true;
        try {
            this.createTop();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " recreating menus");
        }
        main_frame.validate();
    }

    private final void updateSQLDisplay() {
        if (this.output_use_sql) {
            try {
                this.next_free_tab = this.createSQLDisplays(ClientData.getClientColor("sql_background"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Error building SQL tabs " + exception);
                ShowGUIMessage.showGUIMessage(exception.toString(), "Error building SQL tabs for " + DecoderPaths.group_id);
            }
        }
        this.tabbed_pane.removeChangeListener(this.tab_listener);
        this.tab_listener = new TabListener();
        this.tabbed_pane.addChangeListener(this.tab_listener);
    }

    private final void updateDisplayedNumber(String string) {
        this.story_list_panel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), string));
        this.story_list.validate();
    }

    private final void show_toolbars() {
        LogWriter.writeMethod("{show_toolbars}", 0);
        this.display_toolbars = true;
        try {
            this.createTop();
            icon_bar.setVisible(true);
            filter_bar.setVisible(true);
            pdf_bar_scroll.setVisible(true);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " recreating menus");
        }
        main_frame.validate();
    }

    private final JPanel getImageFieldDisplay(String string, int n) {
        String string2 = this.current_data.getField("IMAGE_" + string, n);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (string2.length() > 0) {
            BufferedImage bufferedImage = ObjectStore.loadStoredImage(string2);
            IconiseImage iconiseImage = new IconiseImage(bufferedImage);
            if (bufferedImage != null) {
                jPanel.add((Component)new JLabel(iconiseImage), "Center");
            }
        }
        return jPanel;
    }

    private final void hide_toolbars() {
        LogWriter.writeMethod("{hide_toolbars}", 0);
        this.display_toolbars = false;
        try {
            this.createTop();
            icon_bar.setVisible(false);
            filter_bar.setVisible(false);
            pdf_bar_scroll.setVisible(false);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " recreating menus");
        }
        main_frame.validate();
    }

    private final String getSelectedStory() {
        String string = (String)this.available_stories.getSelectedStory();
        if (string == null) {
            string = (String)this.unchanged_stories.getSelectedStory();
        }
        if (string == null && this.use_link) {
            string = (String)this.jump_stories.getSelectedValue();
        }
        return string;
    }

    private final String selectFlatFile(String string) {
        Object object;
        LogWriter.writeMethod("{selectFlatFile}", 0);
        this.chooser = new JFileChooser(string);
        this.chooser.setFileSelectionMode(0);
        ClientStandard clientStandard = this;
        if (clientStandard.current_license.getLevel() == 2) {
            object = new String[]{"pdf"};
            this.chooser.addChoosableFileFilter(new FileFilterer((String[])object, "Pdf (*.pdf)"));
        }
        object = null;
        while (true) {
            int n = this.chooser.showOpenDialog(main_frame);
            File file = this.chooser.getSelectedFile();
            if (file != null && n == 0) {
                try {
                    object = file.getCanonicalPath();
                    this.current_input_directory = this.chooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Excpetion " + exception + " getting paths");
                }
                File file2 = new File(this.current_input_directory);
                this.user_files = file2.list();
            } else if (n == 1) {
                JOptionPane.showMessageDialog(main_frame, "Nothing selected");
                file = null;
            } else if (n == -1) {
                JOptionPane.showMessageDialog(main_frame, "Error!");
            }
            if (file == null || file.isFile()) break;
            this.chooser.grabFocus();
        }
        if (License.getLevel() == 1) {
            object = this.current_license.checkFile((String)object);
        }
        return object;
    }

    private final void setPdfCover() {
        this.text_data.setLayout(new BorderLayout());
        try {
            JEditorPane jEditorPane = new JEditorPane(ClassLoader.getSystemResource("com/res/help/shortcuts.htm"));
            jEditorPane.setEditable(false);
            jEditorPane.setAutoscrolls(true);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jEditorPane);
            this.text_data.add((Component)jScrollPane, "Center");
        }
        catch (Exception exception) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/res/javahelp/logo.gif"));
            JLabel jLabel = new JLabel(" Pdf Extraction software", imageIcon, 0);
            Font font = new Font("Lucida", 1, 18);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            this.text_data.add((Component)jLabel, "North");
        }
    }

    private final void reloadConfiguration() throws IOException {
        BufferedReader bufferedReader;
        String string;
        LogWriter.writeMethod("{reloadConfiguration}", 0);
        try {
            string = FileInfo.getExtension(this.user_file, this.command_line_values) + ".xml";
            bufferedReader = this.getInputStream(DecoderPaths.config_dir + string, true);
            this.readConfigurationFile(bufferedReader, this.user_file, this.command_line_values, DecoderIO.use_default);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " regenerating config");
        }
        string = DecoderPaths.config_dir + this.current_configuration.getSystemValue("token_file");
        bufferedReader = this.getInputStream(string, false);
        this.current_tokens.loadTokens(bufferedReader, false, this.token_deliminators);
        this.resetTextDisplay();
    }

    private final void highlightTokens(int n, String string) {
        LogWriter.writeMethod("{highlightTokens}", 1);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Error loading L&F: " + exception);
        }
        main_frame = new JFrame();
        focus_processing = false;
        pdf_bar_scroll = new JScrollPane();
        is_pdf = false;
        options_altered = false;
        options_unsaved = false;
        upper = new JPanel();
        processing_data = false;
        shortcuts = new HashMap();
        max_furniture_items = 20;
        mfields = 36;
        client_applet = null;
        icon_bar = new JToolBar();
        reparse_icon_number = 0;
        main_menu = new JMenu[20];
        filters = new JCheckBox[max_furniture_items];
        text_holder = new JTextArea[mfields];
        main_menu_admin_flag = new boolean[20];
        shortcut_bar = new JToolBar();
        controls = new JButton[max_furniture_items];
        menu_item = new JMenuItem[200];
        menu_item_admin_flag = new boolean[200];
        menu = new JMenuBar();
        top = new JPanel();
        data_panel = new JPanel[mfields];
        filter_bar = new JToolBar();
        number_of_filters = 0;
        tab_font = new Font("SansSerif", 1, 12);
        blank_panel = new JPanel();
    }

    private static class FrameCloser
    extends WindowAdapter {
        private ClientStandard client_applet;

        public void windowClosing(WindowEvent windowEvent) {
            if (!options_unsaved) {
                ExitDecoder.exitWithMessage("Exiting client");
            } else {
                this.client_applet.exitWithConfigUnsaved();
            }
        }

        public FrameCloser(ClientStandard clientStandard) {
            this.client_applet = clientStandard;
        }
    }

    private class handle_focus
    extends FocusAdapter {
        private boolean data_may_be_changed = false;
        private boolean focus_gained = false;
        private int pane_id;

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() & ClientStandard.this.story_number != -1 & !processing_data & !focus_processing) {
                focus_processing = true;
                String string = "" + focusEvent;
                String string2 = "";
                String string3 = "";
                String string4 = ClientStandard.this.current_configuration.getSystemValue("forbidden_chars");
                boolean bl = false;
                int n = this.pane_id;
                List list = ClientStandard.this.current_configuration.getSection(20);
                Element element = (Element)list.get(n);
                string3 = element.getAttributeValue("Field");
                String string5 = "#RAWDATA#OBJECT_FONTS#";
                if (!ClientStandard.this.current_configuration.getBooleanValue("keep_tags") & string5.indexOf("#" + string3 + "#") == -1 & string.indexOf("Text") != -1) {
                    string2 = ToUnicode.remapUnicodeEscapes(text_holder[n].getText()).trim();
                    int n2 = string4.length();
                    if (n2 > 0) {
                        Object[] objectArray;
                        int n3;
                        int n4 = 0;
                        while (n4 < n2) {
                            if (string2.indexOf(string4.charAt(n4)) != -1) {
                                bl = true;
                            }
                            ++n4;
                        }
                        if (bl && (n3 = JOptionPane.showOptionDialog(null, "This data contains characters defined as forbidden characters in Client parameters.\nDo you wish to revert to previous version?\n\n WARNING: Selecting NO may impact on your system", "Forbidden Characters", 0, 2, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0])) == 1) {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        ClientStandard.this.current_configuration.addField(string3);
                        ClientStandard.this.current_data.setTextFieldValue(string3, ClientStandard.this.story_number, string2);
                        ClientStandard.this.validateStory(ClientStandard.this.story_number);
                        ClientStandard.this.testFieldForOverSize(true, "Current story", ClientStandard.this.story_number, true, true);
                    } else {
                        text_holder[n].setText(ClientStandard.this.current_data.getField(string3, ClientStandard.this.story_number));
                        bl = false;
                    }
                }
                focus_processing = false;
            }
        }

        public handle_focus(int n) {
            this.pane_id = n;
        }
    }

    private class Shortcut_Check_Listener
    implements ChangeListener {
        private JCheckBox boolean_shortcut;
        private boolean current_state;
        private String command = "";
        private String section = "";

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = this.boolean_shortcut.isSelected();
            if (this.current_state != bl) {
                if (bl) {
                    ClientStandard.this.current_configuration.setSystemValue(this.section, this.command, "true");
                    this.current_state = true;
                } else {
                    ClientStandard.this.current_configuration.setSystemValue(this.section, this.command, "false");
                    this.current_state = false;
                }
                options_altered = true;
                options_unsaved = true;
                ClientStandard.this.setColors();
            }
        }

        public Shortcut_Check_Listener(String string, String string2, JCheckBox jCheckBox, boolean bl) {
            this.command = string2;
            this.section = string;
            this.boolean_shortcut = jCheckBox;
            this.current_state = bl;
        }
    }

    private class toggle_display_listener
    extends MouseAdapter {
        private boolean flag = false;
        private int choosen_list = 0;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ClientStandard.this.translateID("") != -1 && !processing_data) {
                if (!this.flag) {
                    ClientStandard.this.text_data.removeAll();
                    ClientStandard.this.text_data.add((Component)data_panel[this.choosen_list], GridBagHelper.getGridBag(1, 0));
                    this.flag = true;
                } else {
                    this.flag = false;
                    ClientStandard clientStandard = ClientStandard.this;
                    if (clientStandard.current_license.getLevel() != 2) {
                        ClientStandard.this.setPanesizes(false, false);
                    }
                }
                ClientStandard.this.text_data.validate();
            }
        }

        public toggle_display_listener(int n) {
            this.choosen_list = n;
        }
    }

    private class Check_Listener
    implements ItemListener {
        private Check_Listener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!processing_data) {
                ClientStandard.this.flushStoryDisplayPanel();
                ClientStandard.this.resetTextDisplay();
                int n = ClientStandard.this.current_data.getStoryCount();
                int n2 = 0;
                while (n2 < n) {
                    String string = ClientStandard.this.current_data.getField("STORYNAME", n2);
                    if (string.length() > 0 && this.display_item(string)) {
                        if (ClientStandard.this.current_data.isStoryChanged(n2)) {
                            ClientStandard.this.unchanged_stories.addStory(string);
                        } else {
                            ClientStandard.this.available_stories.addStory(string);
                        }
                    }
                    ++n2;
                }
                ClientStandard.this.updateStoriesNumber(false);
            }
        }

        private boolean display_item(String string) {
            boolean bl = false;
            boolean bl2 = true;
            String string2 = "";
            int n = 0;
            while (n < number_of_filters) {
                if (filters[n].isSelected()) {
                    bl2 = false;
                    bl = false;
                    String string3 = ClientStandard.this.filter_operand[n].toLowerCase();
                    if (bl) break;
                    string2 = ClientStandard.this.current_data.getField(ClientStandard.this.filter_field[n], ClientStandard.this.translateID(string));
                    if (string3.equals("=") & string2.equals(ClientStandard.this.filter_value[n])) {
                        bl = true;
                    } else if ((string3.equals("!=") | string3.equals("not")) & !string2.equals(ClientStandard.this.filter_value[n])) {
                        bl = true;
                    } else if ((string3.equals("not contains") | string3.equals("!contains")) & string2.indexOf(ClientStandard.this.filter_value[n]) == -1) {
                        bl = true;
                    } else if (string3.equals("contains") & string2.indexOf(ClientStandard.this.filter_value[n]) != -1) {
                        bl = true;
                    }
                    if (!bl) {
                        n = number_of_filters + 1;
                    }
                }
                ++n;
            }
            if (bl2) {
                bl = true;
            }
            return bl;
        }
    }

    private class story_mouse_listener
    extends MouseAdapter {
        private int choosen_list = 0;
        private JList list_used = null;
        private int[] last_selection;
        private boolean isJumpStory = false;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!focus_processing & processing_data) {
                StatusBar.updateStatus("Still parsing data - system lock", 4);
                this.list_used.setSelectedIndices(this.last_selection);
            } else {
                ClientStandard clientStandard = ClientStandard.this;
                if (clientStandard.current_license.getLevel() != 2) {
                    ClientStandard.this.setValues(this.isJumpStory);
                }
            }
            ClientStandard.this.new_story_selected = false;
        }

        public story_mouse_listener(boolean bl, int n, JList jList) {
            this.isJumpStory = bl;
            this.choosen_list = n;
            this.list_used = jList;
        }
    }

    private class TabListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            block3: {
                int n = ClientStandard.this.tabbed_pane.getSelectedIndex();
                try {
                    if (n > 0) {
                        JPanel jPanel = new JPanel();
                        jPanel = ClientStandard.this.sql_output.createSQLDisplay("current_table", ClientStandard.this.tab_sql[n], ClientStandard.this.user_message);
                        ClientStandard.this.tab_panel[n].removeAll();
                        ClientStandard.this.tab_panel[n].add((Component)jPanel, "Center");
                        ClientStandard.this.tab_panel[n].updateUI();
                        break block3;
                    }
                    ClientStandard.this.setValues(false);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception changing tab " + exception);
                    ShowGUIMessage.showGUIMessage(exception.toString(), "Exception changing tab");
                }
            }
        }
    }

    private class SQLbuttonListener
    implements ActionListener {
        String SQL;
        int pane_number;

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel();
            jPanel = ClientStandard.this.sql_output.createSQLDisplay(ClientStandard.this.user_message, "current_table", this.SQL);
            ClientStandard.this.tab_panel[this.pane_number].add((Component)jPanel, "Center");
            ClientStandard.this.tab_panel[this.pane_number].validate();
        }

        public SQLbuttonListener(int n, String string) {
            this.pane_number = n;
            this.SQL = string;
        }
    }

    private class Shortcut_Text_Listener
    extends FocusAdapter {
        private String command;
        private String section;
        private JTextField text_field;

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                String string = this.text_field.getText();
                ClientStandard.this.current_configuration.setSystemValue(this.section, this.command, string);
            }
        }

        public Shortcut_Text_Listener(String string, JTextField jTextField, String string2) {
            this.text_field = jTextField;
            this.command = string2;
            this.section = string;
        }
    }

    private class changeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
            if (jMenuItem.isArmed()) {
                StatusBar.updateStatus(jMenuItem.getActionCommand(), 4);
            } else {
                StatusBar.updateStatus("", 4);
            }
        }
    }
}

