/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.storypad.DecoderIO;
import com.idrsolutions.storypad.DecoderParserPdf;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.data.Content;
import com.idrsolutions.storypad.objects.ConfigurationData;
import com.idrsolutions.storypad.objects.KeyWords;
import com.idrsolutions.storypad.objects.OutputTemplate;
import com.idrsolutions.storypad.objects.Tokens;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.FileInfo;
import com.idrsolutions.utils.functions.SendEmail;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;

public class Decoder
extends DecoderParserPdf {
    protected final void readArgs(String[] stringArray) {
        int n = stringArray.length;
        if (n > 2) {
            LogWriter.writeLog("Incorrect values used");
            LogWriter.writeLog("=====================\n");
            LogWriter.writeLog("no values");
            LogWriter.writeLog("group_id");
            LogWriter.writeLog("group_id config_directory_location");
            LogWriter.writeLog("\n\nValues just used");
            LogWriter.writeLog("================\n");
            int n2 = 0;
            while (n2 < n) {
                LogWriter.writeLog(n2 + " " + stringArray[n2]);
                ++n2;
            }
            System.exit(1);
        }
        if (n > 0) {
            DecoderPaths.group_id = stringArray[0];
        }
        if (n > 1) {
            DecoderPaths.config_dir = stringArray[1];
        }
        if (DecoderPaths.config_dir == null) {
            DecoderPaths.config_dir = DecoderPaths.user_dir + "config" + DecoderPaths.separator;
        }
        String string = config_dir + "paths.cfg";
        File file = new File(string);
        try {
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(DecoderPaths.config_dir + "paths.cfg"));
                ConfigurationData.convertToXML(bufferedReader, string, "configuration", 2);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " translating paths.cfg");
        }
        try {
            this.getConfigurationDataFromFile();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading configuration file");
        }
        if (this.command_line_values != null) {
            if (this.command_line_values.indexOf("1") != -1) {
                debug_level = 1;
            }
            if (this.command_line_values.indexOf("2") != -1) {
                debug_level = 2;
            }
            if (this.command_line_values.indexOf("3") != -1) {
                debug_level = 3;
            }
            DecoderIO.use_default = this.command_line_values.indexOf("d") != -1;
            if (debug_level > 0) {
                LogWriter.writeLog("Debug level set to " + debug_level);
            }
            if (this.use_client & this.command_line_values.indexOf("s") != -1) {
                this.echo_to_screen = true;
            }
        }
    }

    protected final void setup() throws IOException {
        String string = null;
        LogWriter.writeLog("********************************");
        LogWriter.writeLog("System initialised");
        LogWriter.writeLog("Java details: " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor"));
        LogWriter.writeLog("File being processed : " + this.user_file);
        this.is_pdf = this.user_file.toLowerCase().endsWith(".pdf");
        this.isBinaryFile = FileInfo.isBinaryFile(this.user_file);
        if (!this.isBinaryFile) {
            String string2;
            if (!FileInfo.fileExists(DecoderPaths.config_dir)) {
                ExitDecoder.exitWithMessage("Temp directory " + DecoderPaths.config_dir + " does not exist and cannot be created");
            }
            this.current_configuration = new ConfigurationData();
            this.file_template = new OutputTemplate();
            try {
                BufferedReader bufferedReader;
                this.config_file = FileInfo.getExtension(this.user_file, this.command_line_values) + ".xml";
                if (this.use_client) {
                    string = this.checkProfile();
                }
                if (string == null) {
                    bufferedReader = this.getInputStream(config_dir + this.config_file, false);
                    this.config_file = this.readConfigurationFile(bufferedReader, this.user_file, this.command_line_values, false);
                } else {
                    if (!string.endsWith(".xml")) {
                        string = string + ".xml";
                    }
                    bufferedReader = this.getInputStream(string, true);
                    this.current_configuration.loadXMLConfiguration(bufferedReader);
                }
            }
            catch (Exception exception) {
                ExitDecoder.exitWithMessage("Exception " + exception + " in creating configuration for " + this.user_file);
            }
            LogWriter.writeLog(this.config_file + " loaded");
            this.initLocking();
            String string3 = "Storypad has started decoding file " + this.user_file + " at " + TimeNow.getTimeNow();
            SendEmail.post(this.user_file, string3, null, "Decoding file" + this.user_file, 3);
            LogWriter.writeLog(string3);
            if (debug_level > 1) {
                LogWriter.writeLog("Setting config values");
            }
            this.hasCustomCode = false;
            this.custom_module = this.current_configuration.getSystemValue("custom_classes");
            this.setConfigValues();
            if (this.current_configuration.getBooleanValue("keep_tags")) {
                this.current_configuration.setSystemValue("Editing", "keep_tags", "false");
                LogWriter.writeLog("Program always defaults mapping tokens to values");
                if (this.use_client) {
                    ShowGUIMessage.showGUIMessage("Program always defaults mapping tokens to values", "Default configuration");
                }
            }
            this.end_marker = this.current_configuration.getSystemValue("file_token_deliminators");
            String string4 = this.getPath("mandatory_db_fields", false);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.mandatory_db_fields.put(string2, "x");
            }
            this.setupSQLconnections();
            string2 = null;
            try {
                string2 = !this.output_use_sql ? DecoderPaths.config_dir + "template" + separator + this.current_configuration.getSystemValue("story_file_template") : DecoderPaths.config_dir + "template" + separator + this.current_configuration.getSystemValue("story_sql_template");
                if (!FileInfo.fileExists(string2)) {
                    ExitDecoder.exitWithMessage("Template file " + string2 + " does not exist");
                }
                this.file_template.cacheTemplate(this.getInputStream(string2, false));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Failure to cache template " + string2 + "Error reported " + exception);
            }
        } else if (this.use_client) {
            ShowGUIMessage.showGUIMessage("Binary object identified", "Program attempting to place in temp directory");
        }
    }

    protected final String readConfigurationFile(BufferedReader bufferedReader, String string, String string2, boolean bl) throws IOException {
        File file;
        File file2;
        this.user_file = string;
        String string3 = FileInfo.getExtension(string, string2);
        this.config_file = string3 + ".xml";
        this.config_file = this.config_file.toLowerCase();
        String string4 = DecoderPaths.config_dir + FileInfo.getExtension(string, string2) + ".cfg";
        File file3 = new File(string4);
        File file4 = new File(DecoderPaths.config_dir + this.config_file);
        if (file3.exists() & !file4.exists() && (file2 = new File(string4)).exists()) {
            LogWriter.writeLog("Converting " + string4 + " to " + string3 + ".xml");
            try {
                ConfigurationData.convertToXML(this.getInputStream(string4, false), string4, string3, 1);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception);
            }
        }
        if (!(file2 = new File(config_dir + this.config_file)).exists()) {
            if (bl) {
                LogWriter.writeLog("d option set - Using default.xml for files with no cfg file");
                this.config_file = string.toLowerCase().endsWith(".pdf") ? "pdf.xml" : "default.xml";
            } else if (string2.indexOf("e") != -1) {
                ExitDecoder.exitWithMessage("e option set - No existing cfg file found in config directory.");
            }
        }
        if (!(file = new File(DecoderPaths.config_dir + this.config_file)).exists()) {
            ConfigurationData.convertToXML(null, this.config_file, this.config_file, 1);
        }
        bufferedReader = this.getInputStream(config_dir + this.config_file, false);
        this.current_configuration.loadXMLConfiguration(bufferedReader);
        return this.config_file;
    }

    protected final void processFile(String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        StatusBar.updateStatus("Data being decoded", 1);
        StatusBar.setProgress(5);
        long l = System.currentTimeMillis();
        StatusBar.updateStatus("Preparing to load data file", 1);
        long l2 = System.currentTimeMillis();
        boolean bl3 = false;
        if (this.is_pdf) {
            bl3 = this.cachePdfData(string);
            if (!bl3) {
                this.decode_pdf.closePdfFile();
            }
        } else if (this.hasCustomCode && !this.current_custom.reloadData() && !this.current_custom.cacheDataFile(this.current_data, string, this.current_configuration)) {
            try {
                bl3 = this.genericCacheDataFile(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Failure to cache file with exception " + exception);
            }
        }
        StatusBar.setProgress(30);
        if (!bl3) {
            if (this.use_client) {
                ShowGUIMessage.showGUIMessage("File generated an error", "Problem handling file");
                LogWriter.writeLog("File " + string + " generated an error");
            } else {
                SendEmail.post(string, "Failure to cache file " + string, null, "Failure to cache file", 2);
                LogWriter.writeLog("File " + string + " removed from queue");
                this.archiveDataFile(true);
            }
        }
        this.cachedDataFileMaxLines = this.current_cached_data.getSize();
        StatusBar.setProgress(40);
        long l3 = System.currentTimeMillis();
        if (this.use_keywords) {
            PrintWriter printWriter = null;
            object3 = this.getInputStream(config_dir + "words.cfg", false);
            object2 = this.getInputStream(DecoderPaths.config_dir + "newwords.cfg", false);
            object = this.getInputStream(DecoderPaths.config_dir + "iwords.cfg", false);
            Decoder decoder = this;
            if (decoder.current_license.getLevel() != 2) {
                printWriter = this.setOutputStream(DecoderPaths.config_dir + "nwords.txt", true);
            }
            this.current_keywords.loadKeywords(printWriter, (BufferedReader)object3, (BufferedReader)object2, (BufferedReader)object);
            LogWriter.writeLog("Keyword files read");
        }
        this.loadObjects();
        this.createDataObject();
        if (!bl2) {
            try {
                object3 = this.current_configuration.getSystemValue("token_file");
                object2 = config_dir + (String)object3;
                if (!((String)object2).endsWith(".xml")) {
                    object = object3;
                    int n = ((String)object).lastIndexOf(".");
                    if (n != -1) {
                        object = ((String)object).substring(0, n);
                    }
                    ConfigurationData.convertToXML(this.getInputStream((String)object2, false), (String)object2, (String)object, 0);
                    this.token_file_name = (String)object + ".xml";
                    this.current_configuration.setSystemValue("Token_definition", "token_file", this.token_file_name);
                    this.current_configuration.saveConfigAsXML(config_dir + this.config_file);
                    this.token_file_name = config_dir + this.token_file_name;
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " converting token file");
            }
            this.current_tokens = new Tokens();
            try {
                object3 = new File(this.token_file_name);
                if (((File)object3).exists()) {
                    object2 = this.getInputStream(this.token_file_name, false);
                    this.current_tokens.loadTokens((BufferedReader)object2, false, this.token_deliminators);
                    LogWriter.writeLog("Token File read");
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading token file");
            }
        }
        StatusBar.setProgress(45);
        this.parseData(string);
        StatusBar.setProgress(72);
        long l4 = System.currentTimeMillis();
        LogWriter.writeLog("Cache time: " + (l3 - l2) / 100L + " deci-seconds");
        LogWriter.writeLog("Parse time: " + (l4 - l3) / 100L + " deci-seconds");
        LogWriter.writeLog("Total time: " + (l4 - l) / 100L + " deci-seconds");
        StatusBar.setProgress(100);
    }

    protected final void initStandardDecoder(boolean bl, String string, String[] stringArray, String string2) throws Exception {
        block7: {
            this.isProcessing = true;
            this.user_file = string;
            this.user_files = stringArray;
            this.current_input_directory = string2;
            this.root_file = string;
            this.first_time = bl;
            ObjectStore.init(group_id + TimeNow.getShortTimeNow());
            DecoderPaths.temp_dir = System.getProperty("java.io.tmpdir") + separator + "storypad" + separator + group_id + separator;
            LogWriter.writeLog("Temp storage:" + DecoderPaths.temp_dir + " will be deleted on exit");
            File file = new File(DecoderPaths.temp_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!FileInfo.fileExists(DecoderPaths.temp_dir)) {
                ExitDecoder.exitWithMessage("Temp directory " + DecoderPaths.temp_dir + " does not exist and cannot be created");
            }
            file.deleteOnExit();
            if (!FileInfo.fileExists(string)) {
                ExitDecoder.exitWithMessage(string + " does not exist");
            }
            this.current_keywords = new KeyWords();
            try {
                this.current_license.init(DecoderPaths.config_dir);
                if (debug_level > 1) {
                    LogWriter.writeLog("License File read");
                }
                if (this.use_client) break block7;
                Decoder decoder = this;
                if (decoder.current_license.getLevel() != 3) {
                    ExitDecoder.exitWithMessage("Storypad not licensed to run as a batch task");
                }
            }
            catch (Exception exception) {
                ExitDecoder.exitWithMessage("Exception " + exception + " reading license file");
            }
        }
    }

    private final boolean parseData(String string) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{parseData}");
        }
        Content content = null;
        if (this.is_pdf) {
            if (!this.use_client) {
                try {
                    int n = this.decode_pdf.getPageCount();
                    int n2 = 1;
                    while (n2 < n + 1) {
                        this.decode_pdf.flushObjectValues(false);
                        this.decode_pdf.decodePage(this.use_client, n2);
                        this.extractDataAsContent();
                        StatusBar.setProgress(74);
                        this.addPdfText();
                        Decoder decoder = this;
                        if (decoder.current_license.canAccessImages()) {
                            this.addPdfImages(n2);
                        }
                        this.processExtractedData();
                        ++n2;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.gc();
                    if (this.use_client) {
                        ShowGUIMessage.showGUIMessage("File generated a memory error", "Insufficient memory");
                    }
                }
                catch (Exception exception) {
                    this.decode_pdf.closePdfFile();
                    this.archiveDataFile(true);
                    String string2 = "Failure to process pdf file with exception " + exception.getMessage() + "\nFile removed from queue";
                    ExitDecoder.exitWithMessage(string2);
                }
            }
        } else {
            if (this.hasCustomCode) {
                try {
                    content = this.current_custom.parseDataFile(string, this.current_configuration, this.current_data);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Failure to process file with custom code - error " + exception);
                }
            }
            if (content == null) {
                try {
                    this.parseASCIIData();
                    if (this.cachedDataFileMaxLines > 0) {
                        this.processExtractedData();
                    }
                }
                catch (Exception exception) {
                    this.archiveDataFile(true);
                    String string3 = "Failure to process file with exception " + exception.getMessage() + "\nFile removed from queue";
                    ExitDecoder.exitWithMessage(string3);
                }
            } else {
                if (debug_level > 1) {
                    LogWriter.writeLog("Custom data parsing routine used");
                }
                this.current_data = content;
            }
        }
        return true;
    }
}

