/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.storypad.ClientStandard;
import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.data.Checksums;
import com.idrsolutions.storypad.data.Content;
import com.idrsolutions.storypad.data.Jump_Stories;
import com.idrsolutions.storypad.objects.ConfigurationData;
import com.idrsolutions.storypad.objects.License;
import com.idrsolutions.storypad.objects.OutputTemplate;
import com.idrsolutions.storypad.objects.SpellChecker;
import com.idrsolutions.storypad.objects.Tokens;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.FileInfo;
import com.idrsolutions.storypad.utils.SQL;
import com.idrsolutions.utils.StripTags;
import com.idrsolutions.utils.functions.DayOfCentury;
import com.idrsolutions.utils.functions.IsWriteable;
import com.idrsolutions.utils.functions.SendEmail;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.jdom.Element;
import org.jpedal.PdfDecoder;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class DecoderIO
extends DecoderPaths {
    public static int debug_level = -1;
    protected boolean output_use_sql = false;
    protected Vector_Int max_sizes;
    protected boolean fields_have_been_rejected = false;
    protected Vector_String fields;
    protected Vector_String values;
    protected int checks;
    public static String start_token_deliminator = "<";
    public static String end_token_deliminator = ">";
    public static String deliminator = "|";
    protected PdfDecoder decode_pdf;
    protected String enc = System.getProperty("file.encoding");
    protected String root_file = "";
    protected Jump_Stories current_linked_items = null;
    protected SpellChecker current_spelling = new SpellChecker();
    protected OutputTemplate file_template = null;
    protected Checksums current_checksum;
    protected boolean use_incremental = false;
    protected boolean use_link = false;
    protected boolean use_client = false;
    protected ConfigurationData current_configuration = null;
    protected Tokens current_tokens;
    protected boolean is_pdf = false;
    protected Content current_data;
    private String lock_dir;
    private String lock_file;
    private boolean use_lock = false;
    protected boolean recursive_value_found = false;
    protected License current_license = new License();
    protected boolean line_is_recursive = true;
    protected HashMap mandatory_db_fields = new HashMap();
    protected String output_SQLprefix;
    protected SQL sql_output = null;
    protected SQL MySQL_output = null;
    protected SQL Postgre_output = null;
    protected String end_marker = "";
    protected boolean echo_to_screen = false;
    protected boolean mandatory_value_missing = false;
    protected static boolean use_default = false;
    private Vector SQL_bind_values;
    private Vector SQL_bind_variables;
    private Vector SQL_bind_field_name;

    protected final void loadObjects() {
        block6: {
            try {
                if (this.use_link) {
                    this.loadLinkedItems();
                    LogWriter.writeLog("Reloaded serialised object");
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " unable to setup link functionality");
            }
            try {
                this.use_incremental = this.current_configuration.getBooleanValue("use_incremental");
                if (!this.use_incremental) break block6;
                LogWriter.writeLog("Loading checksum");
                this.loadChecksum();
                if (this.current_checksum.hasBeenClocked() && this.use_client) {
                    ShowGUIMessage.showGUIMessage("Program defaulting to Standard Mode", "Clock has been delierately reset to an earlier date");
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("No checksum loaded");
            }
        }
    }

    protected final void saveChecksum() {
        String string = DecoderPaths.temp_dir + "objects" + Decoder.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (IsWriteable.writeable(string)) {
            File file2 = new File(string + FileInfo.getExtension(this.user_file, this.command_line_values) + ".chk");
            try {
                Checksums checksums = this.current_checksum;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
                objectOutputStream.writeObject(checksums);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " writing serialised object");
            }
        } else {
            LogWriter.writeLog("Serialised object on an http connection - not updated");
        }
    }

    protected final int getChecksum(int n) {
        int n2;
        block2: {
            n2 = 0;
            String string = this.getKey(n);
            int n3 = this.current_checksum.returnKey(string);
            if (n3 == -1) break block2;
            try {
                n2 = this.current_checksum.getChecksum(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " getting checksum");
            }
        }
        return n2;
    }

    protected final BufferedReader getInputStream(String string, boolean bl) {
        BufferedReader bufferedReader = null;
        if (string.startsWith("file:") | string.startsWith("http:")) {
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                uRLConnection.setAllowUserInteraction(false);
                bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), this.enc));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem reading stream  :" + string);
            }
        } else {
            boolean bl2;
            if (bl & !(bl2 = FileInfo.fileExists(string))) {
                ExitDecoder.exitWithMessage("Missing mandatory file " + string);
            }
            try {
                if (bl2) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), this.enc));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in reading  file - " + string);
            }
        }
        return bufferedReader;
    }

    protected final void saveLinkedItems() {
        String string = DecoderPaths.temp_dir + "objects" + Decoder.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (IsWriteable.writeable(string)) {
            File file2 = new File(string + FileInfo.getExtension(this.user_file, this.command_line_values) + ".lik");
            try {
                Jump_Stories jump_Stories = this.current_linked_items;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
                objectOutputStream.writeObject(jump_Stories);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " writing serialised object");
            }
        } else {
            LogWriter.writeLog("Serialised object on an http connection - not updated");
        }
    }

    private final void renameTo(File file, File file2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            Object object;
            if (file2.exists()) {
                object = new RandomAccessFile(file2, "rw");
                ((RandomAccessFile)object).close();
                LogWriter.writeLog("Destination file over-written");
                file2.delete();
            }
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            object = new byte[4096];
            while ((n = fileInputStream.read((byte[])object)) != -1) {
                fileOutputStream.write((byte[])object, 0, n);
            }
            fileOutputStream.close();
            fileInputStream.close();
            if (this.is_pdf) {
                this.decode_pdf.closePdfFile();
            }
            file.delete();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
        if (file.exists()) {
            ExitDecoder.exitWithMessage("Unable to delete file " + file);
        }
    }

    protected final void archiveDataFile(boolean bl) {
        boolean bl2;
        boolean bl3 = this.current_configuration.getBooleanValue("user_delete");
        if (bl | (bl2 = this.current_configuration.getBooleanValue("archive_file")) | !this.use_client | bl3) {
            String string = FileInfo.getFileType(this.user_file);
            String string2 = FileInfo.extractFileNameWithoutExtension(this.user_file);
            string2 = string2 + TimeNow.getShortTimeNow();
            if (string.length() > 0) {
                string2 = string2 + "." + string;
            }
            String string3 = DecoderPaths.processed_dir + "error" + Decoder.separator;
            String string4 = string3 + string2;
            String string5 = DecoderPaths.processed_dir + string2;
            File file = new File(this.user_file);
            if (!file.exists()) {
                LogWriter.writeLog("File already archived");
            } else if (IsWriteable.writeable(this.user_file)) {
                if (bl | !this.use_client | bl3) {
                    block29: {
                        File file2;
                        File file3 = new File(this.user_file);
                        if (bl) {
                            file = new File(string3);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            LogWriter.writeLog("Attempting to move data file " + this.user_file + " to error queue " + string4 + " due to application error");
                            try {
                                file2 = new File(string4);
                                this.renameTo(file3, file2);
                                LogWriter.writeLog("File moved to error queue");
                            }
                            catch (Exception exception) {
                                LogWriter.writeLog("Error deleting data file " + this.user_file + " in queue");
                            }
                        } else {
                            file = new File(DecoderPaths.processed_dir);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            LogWriter.writeLog("Processed datafile: " + this.user_file);
                            if (bl2) {
                                LogWriter.writeLog("File archived to " + string5);
                                try {
                                    file2 = new File(string5);
                                    if (file2.exists()) {
                                        File file4 = new File(DecoderPaths.processed_dir);
                                        if (!file4.canWrite()) {
                                            ExitDecoder.exitWithMessage("No write permissions on " + DecoderPaths.processed_dir + "\nProgram terminating");
                                        }
                                        file2.delete();
                                        if (file2.exists()) {
                                            ExitDecoder.exitWithMessage("File cannot be removed\nProgram terminating");
                                        }
                                        file2 = new File(string5);
                                    }
                                    this.renameTo(file3, file2);
                                    if (file3.exists()) {
                                        ExitDecoder.exitWithMessage("File " + this.user_file + " cannot be renamed to " + string5 + " check permissions");
                                        break block29;
                                    }
                                    LogWriter.writeLog("File " + this.user_file + " moved to processed queue");
                                }
                                catch (Exception exception) {
                                    LogWriter.writeLog("Error " + exception + " archiving data file " + this.user_file + " in queue");
                                }
                            } else {
                                try {
                                    file3.delete();
                                }
                                catch (Exception exception) {
                                    LogWriter.writeLog("Error " + exception + "deleting data file " + this.user_file + " in queue");
                                }
                                if (!this.use_client & file3.exists()) {
                                    ExitDecoder.exitWithMessage("Program cannot delete files in queue - check permissions");
                                }
                            }
                        }
                    }
                    try {
                        FileInfo.validateUserFile(this.root_file, this.root_file);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Error " + exception + " validating file -" + this.root_file);
                    }
                } else if (!bl3) {
                    LogWriter.writeLog("User delete disabled");
                } else {
                    LogWriter.writeLog(this.root_file + " being read across http connection. Not archived");
                }
            }
        }
        if (this.use_lock) {
            this.releaseLock(this.user_file);
        }
    }

    protected final void initLocking() {
        this.lock_dir = DecoderPaths.temp_dir + "locks" + Decoder.separator;
        File file = new File(this.lock_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.lock_file = this.lock_dir + FileInfo.getExtension(this.user_file, this.command_line_values) + ".lck";
        try {
            String string = this.current_configuration.getSystemValue("lock_file");
            if (string.toLowerCase().indexOf("true") != -1) {
                this.use_lock = true;
                this.testLock(this.user_file);
                this.takeLock(this.user_file);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in setting lock");
        }
    }

    protected final String alias(String string, String string2, String string3) {
        String string4 = StripTags.strip(string, false).trim();
        List list = this.current_configuration.getSection(28);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string5;
            Element element = (Element)list.get(n2);
            String string6 = element.getAttributeValue("Source_Field");
            if (string6.equals(string2) && (string5 = element.getAttributeValue("Source_Value")).equals(string4)) {
                string = element.getAttributeValue("Maps_to");
                n2 = n;
            }
            ++n2;
        }
        return string;
    }

    protected final String checkProfile() {
        String string;
        block3: {
            string = null;
            File file = new File(config_dir + "profiles");
            if (!file.exists() || file.listFiles().length <= 0) break block3;
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.showOpenDialog(ClientStandard.main_frame);
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null) {
                try {
                    string = file2.getCanonicalPath();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " loading profile");
                }
            }
        }
        return string;
    }

    protected final int generateChecksum(int n, String string) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 32;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = new StringBuffer(this.current_data.getField(stringTokenizer.nextToken(), n));
            int n6 = 0;
            while (n6 < stringBuffer.length()) {
                n5 = stringBuffer.charAt(n6);
                n4 = (n6 & 1) + 1;
                n3 = n5;
                n2 += n3 * n4;
                ++n6;
            }
        }
        return n2;
    }

    protected final int resetChecksum(int n, boolean bl) {
        String string = this.getKey(n);
        int n2 = 0;
        try {
            String string2 = this.current_configuration.getSystemValue("checksum_fields");
            n2 = this.generateChecksum(n, string2);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " creating checksum for incremental extraction");
        }
        if (this.use_incremental) {
            int n3 = this.current_checksum.returnKey(string);
            if (bl) {
                if (n3 != -1) {
                    this.current_checksum.resetChecksum(n3, n2);
                } else {
                    this.current_checksum.addChecksum(n3, n2, string);
                }
            }
        }
        return n2;
    }

    protected final PrintWriter setOutputStream(String string, boolean bl) {
        PrintWriter printWriter = null;
        String string2 = this.current_configuration.getSystemValue("character_encoding");
        if (!IsWriteable.writeable(string)) {
            ExitDecoder.exitWithMessage("Unable to write to http");
        } else {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, bl), string2)));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem writing to file :" + string);
            }
        }
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Output stream genereated:" + string);
        }
        return printWriter;
    }

    private final void loadLinkedItems() {
        File file;
        String string = DecoderPaths.temp_dir + "objects" + Decoder.separator;
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(string + FileInfo.getExtension(this.user_file, this.command_line_values) + ".lik")).exists()) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                Object object = objectInputStream.readObject();
                this.current_linked_items = (Jump_Stories)object;
                objectInputStream.close();
                LogWriter.writeLog("Serialized link item read from disk");
                int n = DayOfCentury.getDayOfCentury();
                this.current_linked_items.resetDate(n);
                int n2 = this.current_configuration.getIntValue("significant_characters");
                int n3 = Integer.parseInt(this.current_configuration.getSystemValue("link_expiration"));
                this.current_linked_items.expireValues(n2, n, n3);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + "generating linked list.Unable to read linked items serialised object.\nNew linked items list created");
                this.createNewLinkedItem();
                this.saveLinkedItems();
            }
        } else {
            this.createNewLinkedItem();
            if (Decoder.debug_level > 1) {
                LogWriter.writeLog("New link item created");
            }
        }
    }

    private final void loadChecksum() {
        File file;
        String string = DecoderPaths.temp_dir + "objects" + Decoder.separator;
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(string + FileInfo.getExtension(this.user_file, this.command_line_values) + ".chk")).exists()) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                Object object = objectInputStream.readObject();
                this.current_checksum = (Checksums)object;
                objectInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " trying to read checksum object. Unable to read serialised object.\nNew checksum list created");
                this.current_checksum = new Checksums();
                this.saveChecksum();
            }
        } else {
            this.current_checksum = new Checksums();
        }
        this.current_checksum.resetToday();
        if (this.use_incremental) {
            if (Decoder.debug_level > 1) {
                LogWriter.writeLog("Expiring values");
            }
            this.current_checksum.expireValues(Integer.parseInt(this.current_configuration.getSystemValue("expiration")));
        }
    }

    private final void createNewLinkedItem() {
        int n = this.current_configuration.getIntValue("significant_characters");
        this.current_linked_items = new Jump_Stories(n, start_token_deliminator, end_token_deliminator);
    }

    private final void releaseLock(String string) {
        if (IsWriteable.writeable(this.lock_file)) {
            File file = new File(this.lock_file);
            file.delete();
            if (file.exists()) {
                LogWriter.writeLog("Error deleting " + this.lock_file);
            } else {
                LogWriter.writeLog("Lock removed");
            }
            file = null;
        } else {
            LogWriter.writeLog("Http connection. Lock not removed");
        }
    }

    private final String getKey(int n) {
        String string = "";
        String string2 = "";
        String string3 = this.current_configuration.getSystemValue("key_fields");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string = string + this.current_data.getField(string2, n);
        }
        return string;
    }

    private final void takeLock(String string) {
        if (IsWriteable.writeable(this.lock_file)) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.lock_file));
                printWriter.println(string);
                printWriter.close();
                LogWriter.writeLog("Lock established");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " trying to establish lock");
            }
        } else {
            LogWriter.writeLog("Http connection. Lock not taken");
        }
    }

    private final void testLock(String string) {
        File file = new File(this.lock_file);
        if (file.exists()) {
            String string2 = "Lock file " + this.lock_file + " detected.\n" + "Program already running or abnormal program termination last time.";
            ExitDecoder.exitWithMessage(string2);
        }
    }

    protected final void writeAllStories() {
        int n = 0;
        int n2 = this.current_data.getStoryCount();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.current_data.getField("STORYNAME", n3);
            if (string.length() > 0 && !this.current_data.isStoryChanged(n3)) {
                try {
                    this.writeStory(n3, string);
                    ++n;
                    if (Decoder.debug_level > 1) {
                        LogWriter.writeLog(string + " written out");
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " - unable to write story " + string);
                }
            }
            ++n3;
        }
        LogWriter.writeLog("Total stories written out : " + n);
        try {
            int n4 = this.current_configuration.getIntValue("minimum_number_of_stories");
            if (n4 > 0 && n < n4) {
                String string = "Storypad has generated " + n + "\n Minimum number =" + n4;
                LogWriter.writeLog(string);
                SendEmail.post(this.user_file, string, this.user_file, "Minimum number of stories missing", 2);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " trying to send email");
        }
    }

    protected final void setupSQLconnections() {
        String string = this.current_configuration.getSystemValue("PostgreSQL_user");
        String string2 = this.current_configuration.getSystemValue("PostgreSQL_password");
        String string3 = this.current_configuration.getSystemValue("PostgreSQL_connection");
        String string4 = this.current_configuration.getSystemValue("PostgreSQL_text_table");
        String string5 = this.current_configuration.getSystemValue("PostgreSQL_image_table");
        String string6 = this.current_configuration.getSystemValue("PostgreSQL_driver");
        if (string3.length() > 2) {
            this.Postgre_output = new SQL(string3, string, string2, string6, true, string4, string5);
        }
        String string7 = this.current_configuration.getSystemValue("MYSQL_user");
        String string8 = this.current_configuration.getSystemValue("MYSQL_password");
        String string9 = this.current_configuration.getSystemValue("MYSQL_connection");
        String string10 = this.current_configuration.getSystemValue("MYSQL_text_table");
        String string11 = this.current_configuration.getSystemValue("MYSQL_image_table");
        String string12 = this.current_configuration.getSystemValue("MYSQL_driver");
        if (string9.length() > 2) {
            this.MySQL_output = new SQL(string9, string7, string8, string12, true, string10, string11);
        }
        String string13 = this.getPath("dbUrl", false);
        String string14 = this.getPath("alternate_dbUrl", false);
        int n = Integer.parseInt(this.getPath("escalator", false));
        String string15 = this.getPath("non_escalator_flags", false);
        this.output_SQLprefix = this.getPath("sql_prefix", false);
        String string16 = this.getPath("user", false);
        String string17 = this.getPath("password", false);
        String string18 = this.getPath("driver_name", false);
        String string19 = this.getPath("sql_prefix", false);
        boolean bl = this.current_configuration.getBooleanValue("database_is_unicode");
        if (!string13.equals("")) {
            DecoderIO decoderIO = this;
            if (decoderIO.current_license.getLevel() == 3) {
                boolean bl2;
                StatusBar.updateStatus("Trying SQL setup - please wait", 0);
                this.output_use_sql = true;
                this.sql_output = new SQL(bl, this.command_line_values, string13, string14, n, string15, string16, string17, string18, string19, this.use_client);
                String string20 = this.getPath("table_name", false);
                if (string20.length() > 2 && !(bl2 = this.sql_output.trackUsers(string20, "3.1.0b14"))) {
                    ExitDecoder.exitWithMessage("Program unable to write to tracking table in database");
                }
            }
        }
    }

    private final int getTokenEnd(String string, int n) {
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = stringBuffer.length();
        int n4 = n + 1;
        while (n4 < n3) {
            if (this.end_marker.indexOf(stringBuffer.charAt(n4)) != -1) {
                n2 = n4;
                n4 = n3 + 1;
            }
            ++n4;
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        return n2;
    }

    private final boolean writeStoryToSQL(String string, boolean bl, int n) {
        String string2 = "";
        boolean bl2 = true;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.parseInt(this.getPath("max_tries", false));
        int n3 = Integer.parseInt(this.getPath("dbdelay", false));
        this.SQL_bind_values = new Vector(200);
        this.SQL_bind_variables = new Vector(200);
        this.SQL_bind_field_name = new Vector();
        this.mandatory_value_missing = false;
        int n4 = this.file_template.getTemplateSize();
        int n5 = 0;
        while (n5 < n4) {
            string2 = this.file_template.getTemplateLineAt(n5);
            stringBuffer.append(this.generateOutputSQL(string2, string, bl, n));
            ++n5;
        }
        if (!this.mandatory_value_missing) {
            LogWriter.writeLog("Attempting to execute SQL insert");
            try {
                bl3 = this.sql_output.insertSQL(this.SQL_bind_field_name, this.SQL_bind_values, this.SQL_bind_variables, stringBuffer.toString(), n2, n3);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " executing SQL command");
            }
            if (bl3) {
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("SQL executed");
                }
                if (this.use_incremental) {
                    this.resetChecksum(n, true);
                    this.saveChecksum();
                }
                bl2 = false;
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("Story written to output");
                }
            } else if (Decoder.debug_level > 1) {
                LogWriter.writeLog("SQL command failed");
            }
        } else {
            LogWriter.writeLog("Mandatory value missing - no SQL insert attempted");
        }
        return bl2;
    }

    protected final String validateName(String string, String string2) {
        if (string2 == null) {
            string2 = this.current_configuration.getSystemValue("forbidden_characters");
        }
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        int n = 0;
        while (n < stringBuffer.length()) {
            c = stringBuffer.charAt(n);
            if (string2.indexOf(c) != -1 | !Character.isLetterOrDigit(c)) {
                stringBuffer.setCharAt(n, '_');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    protected final boolean writeStory(int n, String string) throws IOException {
        boolean bl = true;
        boolean bl2 = this.testFieldForOverSize(this.use_client, string, n, true, true);
        int n2 = this.file_template.getTemplateSize();
        if (n2 < 1) {
            LogWriter.writeLog("No template defined - Data cannot be written out. Set either story_file_template or story_file_template in general section AND check file exists in template directory.");
            if (this.use_client) {
                ShowGUIMessage.showGUIMessage("No template has been defined - \nSet either story_file_template or story_file_template in general section \nAND check file exists in template directory.", "No output template");
            }
        } else if (bl2) {
            LogWriter.writeLog("Not written out. Fields too long in " + string);
        } else {
            String string2 = "";
            boolean bl3 = false;
            if (this.use_link) {
                bl3 = this.current_linked_items.isAJumpStory(string);
            }
            if (string.equals("")) {
                LogWriter.writeLog("no story selected");
                System.exit(1);
            }
            bl = !this.output_use_sql ? this.writeStoryToFile(string, bl3, n) : this.writeStoryToSQL(string, bl3, n);
        }
        return bl;
    }

    protected final boolean testFieldForOverSize(boolean bl, String string, int n, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        while (n2 < this.checks) {
            string3 = this.fields.elementAt(n2);
            String string4 = StripTags.strip(this.current_data.getField(string3, n), false);
            int n3 = string4.length();
            if (n3 < 1 & !bl2) {
                this.current_data.setTextFieldValue(string3, n, this.values.elementAt(n2));
            }
            if (this.max_sizes.elementAt(n2) != 0 && n3 > Math.abs(this.max_sizes.elementAt(n2))) {
                if (bl2) {
                    string2 = string2 + string3 + " is " + n3 + " and should be no more than " + Math.abs(this.max_sizes.elementAt(n2)) + " characters\n";
                    bl4 = true;
                    this.fields_have_been_rejected = true;
                } else if (!bl3) {
                    if (this.max_sizes.elementAt(n2) > 0) {
                        this.current_data.setTextFieldValue(string3, n, "(TRUNCATED) " + string4.substring(0, this.max_sizes.elementAt(n2)));
                    } else {
                        this.current_data.setTextFieldValue(string3, n, this.values.elementAt(n2));
                    }
                }
                String string5 = "Story:" + string + "\nField : " + string3 + "\nMaximum size=" + this.max_sizes.elementAt(n2) + "\nValue before removal:" + string4;
                if (bl && this.use_client) {
                    ShowGUIMessage.showGUIMessage(string5, "Field value too large");
                }
                LogWriter.writeLog("Oversized value for field " + string3);
            }
            ++n2;
        }
        return bl4;
    }

    private final boolean writeStoryToFile(String string, boolean bl, int n) {
        File file;
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = "";
        String string3 = this.current_configuration.getSystemValue("file_suffix");
        StringBuffer stringBuffer = new StringBuffer();
        PrintWriter printWriter = null;
        String string4 = this.current_configuration.getSystemValue("composite_file");
        if (!string4.equals("")) {
            LogWriter.writeLog("Composite output mode being used");
            string = string4.startsWith("%") ? string4.substring(1) : this.current_data.getField(string4, n);
            if (string.equals("")) {
                string = "Composite_file";
            }
            bl2 = true;
        }
        String string5 = this.getFilePath(n);
        String string6 = string5 + string + string3;
        printWriter = this.setOutputStream(string6, bl2);
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Output to " + string6);
        }
        if ((file = new File(string6)).exists() && !file.canWrite()) {
            ExitDecoder.exitWithMessage("Cannot write " + string6);
        }
        int n2 = this.file_template.getTemplateSize();
        int n3 = 0;
        while (n3 < n2) {
            string2 = this.file_template.getTemplateLineAt(n3);
            stringBuffer.append(this.generateOutputLine(string2, printWriter, string, bl, n));
            ++n3;
        }
        printWriter.close();
        if (this.use_incremental) {
            this.resetChecksum(n, true);
            this.saveChecksum();
        }
        bl3 = false;
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Story written to output");
        }
        return bl3;
    }

    protected final String getTextFieldValue(int n, String string, String string2, boolean bl, int n2) {
        Object object;
        String string3 = "";
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Looking up field :" + string);
        }
        if (string.startsWith("CHECKSUM_")) {
            object = string.substring(9);
            string3 = "" + this.generateChecksum(n2, (String)object);
        } else if (string.startsWith("LENGTH_")) {
            object = string.substring(7);
            string3 = this.current_data.getField((String)object, n2);
            string3 = "" + string3.length();
        } else {
            string3 = !bl ? this.current_data.getField(string, n2) : this.current_linked_items.getField(string, string2);
        }
        if (this.mandatory_db_fields.get(string) != null & string3.length() == 0) {
            this.mandatory_value_missing = true;
            LogWriter.writeLog(string2 + " Field " + string + " defined as mandatory but no value");
        }
        if (n != -1 & !string3.equals("")) {
            this.recursive_value_found = true;
            this.line_is_recursive = true;
        }
        if ((string3 = this.alias(string3, string, "false")) != "" & string3 != null) {
            object = this.current_configuration.getSection(29);
            int n3 = object.size();
            int n4 = 0;
            while (n4 < n3) {
                Element element = (Element)object.get(n4);
                String string4 = element.getAttributeValue("Source_Field");
                if (string4.equals(string)) {
                    String string5 = element.getAttributeValue("Prefix");
                    String string6 = element.getAttributeValue("Suffix");
                    string3 = string5 + string3 + string6;
                    n4 = n3;
                }
                ++n4;
            }
        }
        return string3;
    }

    private final String getFilePath(int n) {
        String string = DecoderPaths.output_dir;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            file = new File(string);
            if (!file.exists()) {
                LogWriter.writeLog("Problem with root dir - check access/existence");
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.current_configuration.getSystemValue("output_path"));
        while (stringTokenizer.hasMoreTokens()) {
            File file2;
            String string2;
            String string3 = StripTags.strip(this.current_data.getField(stringTokenizer.nextToken(), n), true).toLowerCase().trim();
            if (string3.length() <= 0 || (string2 = this.validateName(string3, "./\\")).length() <= 0 || (file2 = new File(string = string + string2 + File.separator)).exists()) continue;
            file2.mkdirs();
        }
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("File path generated:" + string);
        }
        return string;
    }

    private final StringBuffer generateOutputSQL(String string, String string2, boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = string;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        this.line_is_recursive = true;
        n2 = string.indexOf(Decoder.deliminator, 0);
        if (n2 != -1) {
            while (this.line_is_recursive) {
                int n5;
                ++n4;
                this.line_is_recursive = false;
                boolean bl2 = false;
                string = string3;
                this.recursive_value_found = false;
                string5 = string.substring(0, n2);
                while (n2 != -1) {
                    n3 = this.getTokenEnd(string, n2);
                    String string7 = string.substring(n2 + 1, n3);
                    n5 = string7.indexOf(".iterate");
                    if (n5 != -1) {
                        string7 = string7.substring(0, n5) + n4;
                        bl2 = true;
                    }
                    string = string.substring(n3);
                    n2 = string.indexOf(Decoder.deliminator, 0);
                    string6 = this.getTextFieldValue(n5, string7, string2, bl, n);
                    if (string6.length() > 0) {
                        string5 = string5 + "?";
                        this.SQL_bind_variables.addElement(string7);
                        this.SQL_bind_field_name.addElement(string7);
                        this.SQL_bind_values.addElement(string6);
                    } else {
                        string5 = string5 + "''";
                        if (Decoder.debug_level > 2) {
                            LogWriter.writeLog("No value found for >>" + string7 + "<<");
                        }
                    }
                    if (n2 <= 0) continue;
                    string5 = string5 + string.substring(0, n2);
                }
                if (!this.line_is_recursive & !bl2 | this.recursive_value_found & bl2) {
                    stringBuffer.append(string4);
                    stringBuffer.append(string5);
                    stringBuffer.append(string);
                    if (string5.startsWith(this.output_SQLprefix)) {
                        n5 = this.output_SQLprefix.length();
                        string5 = string5.substring(n5);
                    }
                }
                n2 = string3.indexOf(Decoder.deliminator, 0);
            }
        } else {
            stringBuffer.append(string);
            if (string.startsWith(this.output_SQLprefix)) {
                int n6 = this.output_SQLprefix.length();
                string = string.substring(n6);
            }
        }
        return stringBuffer;
    }

    private final StringBuffer generateOutputLine(String string, PrintWriter printWriter, String string2, boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = string;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        this.line_is_recursive = true;
        n2 = string.indexOf(Decoder.deliminator, 0);
        if (n2 != -1) {
            while (this.line_is_recursive) {
                ++n4;
                this.line_is_recursive = false;
                boolean bl2 = false;
                string = string3;
                this.recursive_value_found = false;
                string5 = string.substring(0, n2);
                while (n2 != -1) {
                    n3 = this.getTokenEnd(string, n2);
                    String string7 = string.substring(n2 + 1, n3);
                    int n5 = string7.indexOf(".iterate");
                    if (n5 != -1) {
                        string7 = string7.substring(0, n5) + n4;
                        bl2 = true;
                    }
                    string = string.substring(n3);
                    n2 = string.indexOf(Decoder.deliminator, 0);
                    if (string7.startsWith("BINARY_")) {
                        LogWriter.writeLog("BINARY object cannot be written to file output");
                    } else {
                        string6 = this.getTextFieldValue(n5, string7, string2, bl, n);
                        string5 = string5 + string6;
                    }
                    if (n2 <= 0) continue;
                    string5 = string5 + string.substring(0, n2);
                }
                if (!this.line_is_recursive & !bl2 | this.recursive_value_found & bl2) {
                    printWriter.println(string4 + string5 + string);
                    printWriter.flush();
                }
                n2 = string3.indexOf(Decoder.deliminator, 0);
            }
        } else {
            printWriter.println(string);
        }
        return stringBuffer;
    }
}

