/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderFormatter;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.data.Content;
import com.idrsolutions.storypad.expansion.Custom;
import com.idrsolutions.storypad.objects.CachedData;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.FileInfo;
import com.idrsolutions.utils.StripTags;
import com.idrsolutions.utils.ToUnicode;
import com.idrsolutions.utils.functions.GetSignificantCharacters;
import com.idrsolutions.utils.functions.NumberConversion;
import com.idrsolutions.utils.functions.SendEmail;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import org.jpedal.fonts.Fonts;
import org.jpedal.gui.PdfToolTips;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class DecoderParser
extends DecoderFormatter {
    protected String keyword_deliminator = "";
    protected int page_count;
    protected String[] user_files;
    protected String[] information_values;
    protected boolean isBinaryFile = false;
    protected boolean merge_orphans = false;
    protected CachedData current_cached_data = new CachedData();
    protected String current_input_directory;
    protected boolean isProcessing = false;
    protected String use_first_field = "";
    protected String token_file_name = "";
    protected String orphan_field_name = "";
    protected String[] files_to_use;
    protected PdfToolTips current_tooltips = new PdfToolTips();
    protected int minimum_matches_required = 1;
    protected boolean show_matches = false;
    protected String config_file = "";
    protected int cachedDataFileMaxLines = 0;
    protected String values_deliminator = "-";
    protected String orphan_masterfield_name = "";
    private StringBuffer raw_data = new StringBuffer();
    private StringBuffer processed_data = new StringBuffer();
    private int cachedDataFileLine = 0;
    private boolean check_fields = false;
    private boolean use_subtoken = false;
    private String first_field = "";
    private int absolute_merge = 0;
    private String new_keyword_fields;
    private String key_fields;
    private String default_field = "";
    private BufferedReader data_file = null;
    private int auto_merge = 0;
    private NumberConversion numbersToWords = new NumberConversion();
    private String field_to_check = "";
    private String differing_field = "";
    private boolean parsing_data = false;
    private int count = 0;
    private String default_pdf_field = "";
    private final String unchanged_format = "><font size=1 face=\"Arial,Helvetica\"><I>";
    private final String changed_format = "><font size=4 face=\"Arial,Helvetica\" color=\"red\">";
    private final String end_rule = ">";
    private final String start_rule = "<~";
    private final String missing_format = " bgcolor=\"#000000\"><font size=1 color=\"white\" face=\"Arial,Helvetica\">";

    protected final boolean isOrderCorrect(String string, String string2, int n) {
        int n2;
        int n3;
        boolean bl = true;
        boolean bl2 = false;
        if (this.extractName(string).equals(this.extractName(string2)) && (n3 = this.extractNumber(string)) != (n2 = this.extractNumber(string2))) {
            if (n3 < n2) {
                bl = false;
            }
            bl2 = true;
        }
        if (!bl2) {
            String string3 = this.current_configuration.getSystemValue("child_string_identifier");
            String string4 = this.current_data.getField(this.field_to_check, n);
            if (string4.indexOf(string3) == -1) {
                bl = false;
            }
        }
        return bl;
    }

    protected final void merge(String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{merge}");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashMap.put(stringTokenizer.nextToken(), "*");
        }
        HashMap hashMap2 = (HashMap)this.current_configuration.getFields().clone();
        hashMap2.put(this.default_field, "x");
        hashMap2.put(this.default_pdf_field, "x");
        hashMap2.put("KEYWORDS", "x");
        if (this.is_pdf) {
            hashMap2.put("DEFAULT_DATA", "x");
            hashMap2.put("OBJECT_FONTS", "x");
            hashMap2.put("PLOT", "x");
            hashMap2.put("SHAPE", "x");
        }
        Iterator iterator = hashMap2.keySet().iterator();
        String string3 = this.current_configuration.getSystemValue("key_fields");
        String string4 = this.current_configuration.getSystemValue("output_path");
        boolean bl5 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        while (iterator.hasNext()) {
            CharSequence charSequence;
            string5 = (String)iterator.next();
            bl5 = true;
            string6 = string5;
            string8 = this.current_data.getField(string5, n);
            string7 = this.current_data.getField(string5, n2);
            if (this.is_pdf && "#OBJECT_FONTS#PAGE#LINE_COUNT#OBJECT_X1#OBJECT_Y1#OBJECT_X2#OBJECT_Y2#OBJECT_WIDTH#OBJECT_HEIGHT#COLUMNS#".indexOf("#" + string5 + "#") != -1) {
                bl5 = false;
                if (string5.equals("PAGE")) {
                    string7 = "";
                } else if (!string5.equals("OBJECT_FONTS")) {
                    n3 = ToInteger.getInteger(StripTags.strip(string8, true));
                    n4 = ToInteger.getInteger(StripTags.strip(string7, true));
                    string7 = "";
                    if (string5.equals("LINE_COUNT")) {
                        string8 = "" + (n3 + n4);
                    } else {
                        string8 = "" + n3;
                        string7 = "";
                        int n6 = 1;
                        if (string5.indexOf("OBJECT_X2") != -1 | string5.indexOf("OBJECT_Y1") != -1) {
                            n6 = -1;
                        }
                        if (n6 * n3 > n6 * n4) {
                            string8 = "" + n4;
                        }
                    }
                }
            } else {
                n5 = -1;
                int n7 = string5.length();
                charSequence = new StringBuffer();
                try {
                    int n8;
                    int n9 = n7 - 1;
                    while (n9 > -1) {
                        n8 = string5.charAt(n9);
                        if (Character.isDigit((char)n8)) {
                            charSequence.insert(0, (char)n8);
                        } else {
                            n9 = -5;
                        }
                        --n9;
                    }
                    n8 = charSequence.length();
                    if (n8 > 0) {
                        string5 = string5.substring(0, n7 - n8);
                        n5 = Integer.parseInt(charSequence.toString());
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in calculating iterative field " + exception);
                }
                if (string8.length() == 0) {
                    string8 = string7;
                    string7 = "";
                }
            }
            if (n5 != -1) {
                if (string7.length() == 0 | string8.length() == 0) {
                    this.current_configuration.addField(string6);
                    this.current_data.setTextFieldValue(string6, n, string8 + string7);
                    continue;
                }
                string5 = this.current_data.scanIterativeHeader(string5, n);
                this.current_configuration.addField(string5);
                this.current_data.setTextFieldValue(string6, n, string7);
                this.current_data.setTextFieldValue(string5, n, string8);
                continue;
            }
            if (string8.equals(string7)) continue;
            if (string5.equals("KEYWORDS")) {
                bl5 = false;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string7, this.keyword_deliminator);
                while (stringTokenizer2.hasMoreTokens()) {
                    charSequence = stringTokenizer2.nextToken();
                    if (string8.indexOf((String)charSequence) != -1) continue;
                    string8 = string8 + this.keyword_deliminator + (String)charSequence;
                }
                if (string8.startsWith(this.keyword_deliminator)) {
                    string8 = string8.substring(this.keyword_deliminator.length(), string8.length());
                }
            } else {
                if (string5.equals("SHAPE") | string5.equals("PLOT")) {
                    string7 = string7 + '\n';
                    string8 = string8 + '\n';
                    bl5 = false;
                }
                if (!bl) {
                    String string9 = string7;
                    string7 = string8;
                    string8 = string9;
                }
                if (hashMap.containsKey(string5)) {
                    string8 = string7;
                } else {
                    if (bl2 & string7.length() > 1 & string4.indexOf(string5) == -1 & string3.indexOf(string5) == -1) {
                        string7 = string7 + "\n";
                    }
                    if (bl5 && StripTags.strip(string7, false).trim().length() > 0 & StripTags.strip(string8, false).trim().length() > 0) {
                        string7 = string7 + string2;
                    }
                    string8 = string7 + string8;
                }
            }
            if (bl3 && string5.equals("DEFAULT_DATA")) {
                string8 = Fonts.cleanupTokens(string8);
            }
            this.current_data.setTextFieldValue(string5, n, string8);
        }
        if (bl4) {
            this.current_data.deleteStory(n2);
        }
        this.validateStory(n);
    }

    protected final boolean genericCacheDataFile(String string) throws IOException {
        LogWriter.writeLog("Loading datafile");
        StatusBar.updateStatus("Standard caching routine being used", 3);
        boolean bl = false;
        this.current_cached_data.resetCachedLines();
        String string2 = "";
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Reading datafile");
        }
        this.data_file = this.getInputStream(string, true);
        StatusBar.setProgress(10);
        if (this.data_file != null) {
            while (true) {
                try {
                    string2 = this.data_file.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error accessing datafile");
                }
                if (string2 == null) break;
                if (string2.equals("")) continue;
                this.current_cached_data.setCachedLine(string2);
            }
            bl = true;
        } else {
            ExitDecoder.exitWithMessage("Cannot access datafile!! Program terminating");
        }
        StatusBar.setProgress(20);
        this.data_file.close();
        return bl;
    }

    protected final void processStory(String string) {
        block12: {
            String string2;
            int n = this.current_data.getNextStoryID();
            this.current_data.setTextFieldValue("SOURCEFILE", n, FileInfo.extractFileNameWithExtension(this.user_file));
            this.current_data.setTextFieldValue("NAME", n, "<~START>" + FileInfo.extractFileNameWithoutExtension(this.user_file) + "<~END>");
            String string3 = "" + new Date();
            this.current_data.setTextFieldValue("PROCESSED_TIME", n, string3);
            String string4 = this.current_data.getField("OBJECT_FONTS", n);
            this.current_data.setTextFieldValue("raw_object_font", n, string4);
            if (Decoder.debug_level > 1) {
                LogWriter.writeLog("Processing story");
            }
            if ((string2 = this.current_configuration.getSystemValue("merge_exception_string").toLowerCase()) == "") {
                string2 = "This WILL NEVER to occur";
            }
            string = string == null ? this.getFileName(-1) : this.validateName(string, null);
            String string5 = null;
            String string6 = "";
            String string7 = "";
            if (!this.is_pdf) {
                int n2 = string.indexOf("-");
                string6 = string;
                if (n2 > 1) {
                    string7 = string6.substring(n2 + 1).trim();
                    string = string.substring(0, n2).trim();
                }
            }
            try {
                LogWriter.writeLog("Processing: " + n + "  " + string);
                String string8 = GetSignificantCharacters.get(string, this.absolute_merge);
                if (string.indexOf(string2) == -1) {
                    string8 = "";
                }
                if (this.auto_merge <= 0) {
                    string5 = this.current_data.getMergeTest(string);
                }
                if (string5 == null) {
                    string5 = this.current_data.getMergeTest(string8);
                }
                if (string5 == null | this.auto_merge == 0) {
                    string = this.ensureUnique(string, n);
                    this.current_data.setMergeTest(string, n);
                    if (!string8.equals("")) {
                        this.current_data.setMergeTest(string8, n);
                    }
                    if (this.current_data.isUnique(string)) {
                        LogWriter.writeLog("Problem generating unique name for story " + string);
                    }
                    this.current_data.setTextFieldValue("STORY_ID", n, string);
                    this.current_data.setTextFieldValue("REF", n, string);
                    this.current_data.createStory(string);
                    break block12;
                }
                int n3 = Integer.parseInt(string5);
                this.merge(this.use_first_field, n3, n, "", true, true, false, false);
                LogWriter.writeLog("@@Story " + string6 + " merged into " + string);
                this.current_data.initialiseStory(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Time:" + new Date());
                LogWriter.writeLog("Exception " + exception + " in generating story " + string + " - story flushed");
                this.current_data.initialiseStory(n);
            }
        }
    }

    protected final void validateStory(int n) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(this.post_validation_fields);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            String string2 = StripTags.strip(this.current_data.getField(string, n), true);
            if (!(string2.equals("") | string2.equals(" "))) continue;
            bl = false;
        }
        this.current_data.setTextFieldValue("VALIDATED", n, bl + "");
    }

    protected final boolean processExtractedData() {
        String string;
        int n;
        Object object;
        int n2;
        boolean bl = this.current_configuration.getBooleanValue("validate_record");
        boolean bl2 = this.current_configuration.getBooleanValue("use_sort");
        int n3 = n2 = this.current_data.getStoryCheckPoint();
        StatusBar.setProgress(77);
        DecoderParser decoderParser = this;
        if (decoderParser.current_license.getLevel() != 2) {
            if (bl2) {
                StatusBar.updateStatus("Merging & sorting data", 1);
                try {
                    this.sortItems(n2);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " executing sort");
                }
            }
            StatusBar.updateStatus("Overwrite command", 1);
            this.overwriteField(n2);
            StatusBar.updateStatus("Applying rules", 1);
        }
        StatusBar.setProgress(79);
        if (!this.current_configuration.getBooleanValue("disable_rules")) {
            object = this.current_configuration.getSection(31);
            List list = this.current_configuration.getSection(23);
            n = this.current_data.getStoryCount();
            int n4 = n2;
            while (n4 < n) {
                string = this.current_data.getField("STORYNAME", n4);
                if (string.length() > 0 && !this.current_data.isStoryChanged(n4)) {
                    if (Decoder.debug_level > 1) {
                        LogWriter.writeLog("Applying iterative substitutions");
                    }
                    this.processRules(list, true, n4);
                    if (Decoder.debug_level > 1) {
                        LogWriter.writeLog("Applying non-iterative rules");
                    }
                    this.processRules((List)object, false, n4);
                }
                ++n4;
            }
        }
        StatusBar.updateStatus("Formatting data", 1);
        StatusBar.setProgress(82);
        object = (HashMap)this.current_configuration.getFields().clone();
        ((HashMap)object).put(this.default_field, "x");
        ((HashMap)object).put(this.default_pdf_field, "x");
        int n5 = this.current_data.getStoryCount();
        if (this.command_line_values.toLowerCase().indexOf("w") != -1) {
            this.current_spelling.loadDictionary();
            this.remove_hyphenation = true;
        }
        n = n2;
        while (n < n5) {
            String string2 = this.current_data.getField("STORYNAME", n);
            if (string2.length() > 0 && !this.current_data.isStoryChanged(n)) {
                this.formatAllFields(n, ((HashMap)object).keySet().iterator());
            }
            ++n;
        }
        StatusBar.setProgress(84);
        if (this.merge_orphans) {
            LogWriter.writeLog("Merging orphan objects");
            try {
                this.mergeOrphans(n2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("No merging");
            }
        }
        StatusBar.updateStatus("Identifying linked items", 1);
        StatusBar.setProgress(86);
        if (this.use_link) {
            n5 = this.current_data.getStoryCount();
            int n6 = n2;
            while (n6 < n5) {
                string = this.current_data.getField("STORYNAME", n6);
                if (string.length() > 0 && !this.current_data.isStoryChanged(n6)) {
                    boolean bl3 = false;
                    try {
                        String string3 = StripTags.strip(this.current_data.getField(this.field_to_check, n6), false);
                        if (string3.length() > 0) {
                            bl3 = this.processJumpStory(string, n6);
                            if (bl3) {
                                LogWriter.writeLog(string + " identified as a linked item and placed in datastore");
                            } else {
                                LogWriter.writeLog(string + " has linked data inserted");
                            }
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " linking items");
                        bl3 = false;
                    }
                    if (bl3) {
                        this.current_data.deleteStory(n6);
                        --n6;
                        --n5;
                    } else {
                        ++n3;
                    }
                }
                ++n6;
            }
        }
        StatusBar.updateStatus("Validating data", 1);
        StatusBar.setProgress(88);
        if (bl) {
            if (this.current_data.getNextStoryID() == 0) {
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("No records written - no checks on mandatory fields");
                }
            } else {
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("Eliminating items with non-mandatory fields");
                }
                this.checkMandatoryFields(n2);
            }
        }
        StatusBar.updateStatus("Post validating data", 1);
        StatusBar.setProgress(90);
        try {
            this.postValidation(n2);
        }
        catch (Exception exception) {
            LogWriter.writeLog("No data to validate");
        }
        StatusBar.setProgress(92);
        if (this.check_fields) {
            this.useDefaultsForEmptyFields(false, n2);
        }
        this.setIncrementalDisplay(n2);
        StatusBar.updateStatus("File processed", 1);
        StatusBar.setProgress(95);
        this.current_tokens.saveTokensAsXML(this.token_file_name);
        DecoderParser decoderParser2 = this;
        if (decoderParser2.current_license.getLevel() == 3) {
            try {
                this.generateReport(n2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " generating report");
            }
        }
        StatusBar.setProgress(97);
        this.current_data.setStoryCheckPoint();
        return true;
    }

    protected final void createDataObject() {
        this.current_data = new Content();
    }

    protected final void parseASCIIData() {
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("About to decode data file");
        }
        boolean bl = this.current_configuration.getBooleanValue("add_spaces");
        String string = "";
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        String string4 = this.current_configuration.getSystemValue("default");
        boolean bl2 = true;
        boolean bl3 = this.current_configuration.getBooleanValue("force_tags");
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = 1;
        int n2 = 0;
        int n3 = 1;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        boolean bl8 = true;
        List list = this.current_configuration.getSection(27);
        int n4 = list.size();
        int n5 = 0;
        boolean bl9 = false;
        StatusBar.updateStatus("Parsing data", 1);
        if (this.cachedDataFileMaxLines == 0) {
            LogWriter.writeLog("Empty file");
            if (this.use_client) {
                ShowGUIMessage.showGUIMessage("This file contains no data", "Empty file");
            }
        } else {
            this.cachedDataFileLine = 0;
            while (this.cachedDataFileLine < this.cachedDataFileMaxLines + 1) {
                Element element;
                int n6;
                StatusBar.setProgress(45 + this.cachedDataFileLine * 25 / this.cachedDataFileMaxLines);
                if (this.cachedDataFileLine < this.cachedDataFileMaxLines) {
                    if (!string13.equals("")) {
                        string3 = string13;
                    }
                    string13 = this.current_cached_data.getCachedLine(this.cachedDataFileLine);
                    stringBuffer = new StringBuffer(string13);
                    bl4 = bl5;
                    bl5 = this.incompleteTagCheck(stringBuffer);
                } else {
                    bl9 = true;
                }
                ++n2;
                string15 = string12;
                string2 = null;
                if (stringBuffer.length() > 1) {
                    n6 = 0;
                    while (n6 < n4) {
                        element = (Element)list.get(n6);
                        string12 = element.getAttributeValue("Line_value");
                        int n7 = string13.indexOf(string12);
                        if (n7 != -1) {
                            string2 = element.getAttributeValue("Field");
                            this.raw_data.append(string13.substring(0, n7));
                            stringBuffer = new StringBuffer(stringBuffer.toString().substring(n7));
                            n6 = n4;
                            n5 = string12.length();
                            this.current_configuration.addField(string2);
                        }
                        ++n6;
                    }
                }
                if (bl9) {
                    string2 = string4;
                    if (string == "") {
                        string = string4;
                    }
                }
                if (string2 != null && string2.equals("")) {
                    string2 = null;
                }
                if (string2 != null) {
                    string16 = this.raw_data.toString();
                    n6 = this.current_data.getNextStoryID();
                    if (!string16.equals(string15) & !string16.equals("") & !string16.equals(" ")) {
                        string16 = string8 + string16 + string9;
                        if (bl6) {
                            string16 = this.internal_start_char + "~START" + this.internal_end_char + string16 + this.internal_start_char + "~END" + this.internal_end_char;
                        }
                        if (this.use_subtoken) {
                            string14 = this.getSubToken(n6);
                        }
                        if ((element = this.current_configuration.getUserValue("Source_Field", string, 30)) == null) {
                            string7 = null;
                        } else {
                            string7 = element.getAttributeValue("DestField");
                            boolean bl10 = Boolean.valueOf(element.getAttributeValue("TreatAsArray").toUpperCase());
                            if (bl10) {
                                string7 = this.current_data.scanIterativeHeader(string7, n6);
                            }
                        }
                        if (string7 != null) {
                            string = string7;
                        }
                        if (this.use_subtoken & !string14.equals("") & !string16.equals("")) {
                            string16 = this.internal_start_char + "-" + string14 + this.internal_end_char + string16 + this.internal_start_char + "-/" + string14 + this.internal_end_char;
                        }
                        try {
                            if (string16.length() < 100) {
                                string16 = this.alias(string16, string, "true");
                            }
                            this.current_configuration.addField(string);
                            string16 = Strip.removeMultipleSpacesAndReturns(string16).toString();
                            this.current_data.setTextFieldValue(string, n6, string16);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Error " + exception + " reported in generic parsing routine");
                        }
                    }
                    bl6 = this.isNotPdfField(string = string2);
                    element = this.current_configuration.getUserValue("Source_Field", string, 26);
                    if (element != null) {
                        string8 = element.getAttributeValue("Field_Prefix");
                        string10 = element.getAttributeValue("Line_Prefix");
                        string11 = element.getAttributeValue("Line_Suffix");
                        string9 = element.getAttributeValue("Field_Suffix");
                    } else {
                        string8 = "";
                        string10 = "";
                        string11 = "";
                        string9 = "";
                    }
                    string2 = null;
                    n = 1;
                    n3 = 1;
                    string5 = "";
                    bl5 = false;
                    this.raw_data.setLength(0);
                    this.raw_data.append(stringBuffer);
                    if (string.equals(this.first_field) | string.equals(string4)) {
                        if (bl8 && !string.equals(string4)) {
                            bl8 = false;
                        } else {
                            this.processStory(null);
                        }
                    }
                } else {
                    if (n != 1 & bl2 & bl3 | !bl4) {
                        if (string5.length() > 0) {
                            string6 = string5;
                        }
                        string5 = Strip.stripSpaces(stringBuffer.toString()).trim();
                        string5 = StripTags.strip(stringBuffer.toString(), false).trim();
                        n6 = 0;
                        boolean bl11 = false;
                        if (string5.toUpperCase().indexOf(string5) != -1 & string6.toUpperCase().indexOf(string6) != -1) {
                            bl11 = true;
                        }
                        if (!bl11 & string6.length() > 0) {
                            if (string5.length() > 0) {
                                String string17 = string5.substring(0, 1);
                                if (string6.endsWith(":") | string6.endsWith(".")) {
                                    if (string17.toUpperCase().equals(string17)) {
                                        n6 = 1;
                                    }
                                } else {
                                    String string18;
                                    int n8 = string5.indexOf(" ");
                                    if (n8 > 1 && (string18 = string5.substring(0, n8)).toUpperCase().equals(string18)) {
                                        n6 = 1;
                                    }
                                }
                            } else {
                                n6 = 1;
                            }
                        }
                        if (this.raw_data.length() <= n5) {
                            n6 = 0;
                        }
                        if (n6 == 1) {
                            stringBuffer.insert(0, "\n");
                            if (bl6) {
                                stringBuffer.insert(0, this.internal_start_char + "~/PARA" + n3 + this.internal_end_char);
                            }
                            ++n3;
                        }
                    }
                    String string19 = StripTags.strip(stringBuffer.toString(), false);
                    if (bl6 & (bl3 | !bl4)) {
                        bl7 = StripTags.strip(stringBuffer.toString(), false).toUpperCase().equals(StripTags.strip(stringBuffer.toString(), false)) & string19.length() > 3;
                        if (stringBuffer.length() > 3) {
                            if (this.hasCustomCode && !this.current_custom.addMarkup(stringBuffer.toString())) {
                                bl2 = false;
                            }
                            if (bl2) {
                                stringBuffer.insert(0, string10);
                                stringBuffer.insert(0, this.internal_start_char + "~L" + n + this.internal_end_char);
                            }
                        }
                        if (bl7) {
                            stringBuffer.insert(0, this.internal_start_char + "~ALL_CAPS" + this.internal_end_char);
                        }
                    }
                    if (bl6 & (bl3 | !bl5)) {
                        if (stringBuffer.length() > 3 && bl2) {
                            stringBuffer.append(string11);
                            stringBuffer.append(this.internal_start_char + "~/L" + n + this.internal_end_char);
                        }
                        if (bl7) {
                            stringBuffer.append(this.internal_start_char + "~/ALL_CAPS" + this.internal_end_char);
                        }
                        if (string19 != "" & bl) {
                            stringBuffer.insert(0, " ");
                        }
                    }
                    this.raw_data.append(stringBuffer.toString());
                    ++n;
                }
                if (bl9) break;
                ++this.cachedDataFileLine;
            }
        }
        this.raw_data.setLength(0);
    }

    protected final void setConfigValues() {
        Object object;
        if (!this.custom_module.equals("")) {
            try {
                object = Class.forName(this.custom_module);
                this.current_custom = (Custom)((Class)object).newInstance();
                this.current_custom.initialise(this.current_configuration);
                this.hasCustomCode = true;
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("Custom class object setup");
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Unable to startup custom code " + this.custom_module);
                LogWriter.writeLog("Custom Exception " + exception);
                System.exit(1);
            }
        }
        this.token_file_name = DecoderPaths.config_dir + this.current_configuration.getSystemValue("token_file");
        this.enc = this.current_configuration.getSystemValue("character_encoding");
        object = this.current_configuration.getSection(27);
        this.first_field = ((Element)object.get(0)).getAttributeValue("Field");
        this.default_field = this.current_configuration.getSystemValue("default");
        this.default_pdf_field = this.current_configuration.getSystemValue("default_data_field");
        this.valid_keyword_fields = this.current_configuration.getSystemValue("valid_keyword_fields");
        this.new_keyword_fields = this.current_configuration.getSystemValue("new_keyword_fields");
        this.use_link = this.current_configuration.getBooleanValue("use_link");
        this.field_to_check = this.current_configuration.getSystemValue("field_to_check");
        this.differing_field = this.current_configuration.getSystemValue("differing_field");
        this.use_first_field = this.current_configuration.getSystemValue("use_first_field");
        this.wild_cards = this.current_configuration.getSystemValue("wild_cards");
        this.auto_merge = this.current_configuration.getIntValue("auto_merge");
        if (this.auto_merge != 0 && this.is_pdf && this.use_client) {
            ShowGUIMessage.showGUIMessage("Auto-merge is set. Use not recommended with pdf data", "Pdf warning");
        }
        this.absolute_merge = this.auto_merge;
        if (this.auto_merge < 0) {
            this.absolute_merge = this.auto_merge * -1;
        }
        if (!this.is_pdf) {
            Decoder.start_token_deliminator = "<[{";
            Decoder.end_token_deliminator = ">]}";
            Decoder.escape_character = "\\";
            this.use_subtoken = true;
        }
        this.transient_tokens = this.current_configuration.getSystemValue("transient_token_characters");
        this.post_validation_fields = this.current_configuration.getSystemValue("post_validation_fields");
        StripTags.punctuation = this.current_configuration.getSystemValue("punctuation");
        this.token_deliminators = Decoder.start_token_deliminator + Decoder.end_token_deliminator;
        this.format_token_deliminators = Decoder.start_token_deliminator + Decoder.end_token_deliminator + DecoderFormatter.escape_character + " " + this.current_configuration.getSystemValue("other_characters");
        if (!this.use_whole_field) {
            this.keyword_deliminators = " " + this.keyword_deliminators;
        }
        this.last_selection = "";
        this.use_whole_field = this.current_configuration.getBooleanValue("use_whole_field");
        this.use_keywords = this.current_configuration.getBooleanValue("use_keywords");
        this.values_deliminator = this.current_configuration.getSystemValue("values_deliminator");
        this.values_deliminator = this.values_deliminator.indexOf("\" \"") == -1 ? this.values_deliminator.trim() : " ";
        this.orphan_field_name = this.current_configuration.getSystemValue("orphan_field_name");
        this.orphan_masterfield_name = this.current_configuration.getSystemValue("orphan_masterfield_name");
        this.merge_orphans = this.current_configuration.getBooleanValue("merge_orphans");
        this.show_matches = this.current_configuration.getBooleanValue("show_matches");
        this.minimum_matches_required = this.current_configuration.getIntValue("minimum_matches_required");
        this.check_fields = this.current_configuration.getBooleanValue("check_fields");
        this.keyword_deliminator = ToUnicode.toUnicode(this.current_configuration.getSystemValue("keyword_deliminator"));
        Decoder.deliminator = this.current_configuration.getSystemValue("token_deliminator");
    }

    private final void setIncrementalDisplay(int n) {
        block2: {
            if (!(this.use_incremental & this.current_data.getStoryCount() > 0)) break block2;
            LogWriter.writeLog("Stories unchanged being identified");
            try {
                this.postIncrementalCheck(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in incremental scan: ");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean getValidated(int var1_1) {
        block4: {
            var2_2 = "";
            var5_3 = this.current_configuration.getSection(24);
            var6_4 = var5_3.listIterator();
            var7_5 = this.current_configuration.getBooleanValue("mandatory_as_AND_function");
            var8_6 = false;
            var9_7 = false;
            if (var5_3.size() != 0) ** GOTO lbl22
            var8_6 = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                var10_10 = (Element)var6_4.next();
                var2_2 = var10_10.getAttributeValue("Field");
                var3_8 = Integer.parseInt(var10_10.getAttributeValue("Minimum_size"));
                var4_9 = StripTags.strip(this.current_data.getField(var2_2, var1_1), false).trim().length();
                if (var4_9 > var3_8) {
                    var8_6 = true;
                    var9_7 = true;
                } else if (var7_5) {
                    var8_6 = false;
                    var9_7 = true;
                }
                if (var9_7) break;
lbl22:
                // 2 sources

                ** while (var6_4.hasNext())
            }
        }
        return var8_6;
    }

    private final void sortItems(int n) {
        String string = this.current_configuration.getSystemValue("primary_sort_field");
        boolean bl = this.current_configuration.getBooleanValue("primary_reverse_order");
        String string2 = this.current_configuration.getSystemValue("secondary_sort_field");
        boolean bl2 = this.current_configuration.getBooleanValue("secondary_reverse_order");
        String string3 = this.current_configuration.getSystemValue("tertiary_sort_field");
        boolean bl3 = this.current_configuration.getBooleanValue("tertiary_reverse_order");
        String string4 = this.current_configuration.getSystemValue("comparison_type");
        boolean bl4 = this.current_configuration.getBooleanValue("ignore_tags");
        try {
            this.current_data.sort(n, string, bl, string2, bl2, string3, bl3, string4, bl4);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in sort ");
        }
    }

    private final int extractNumber(String string) {
        int n = 1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length() - 1;
        while (n2 > -1) {
            char c = string.charAt(n2);
            if (Character.isDigit(c)) {
                stringBuffer.insert(0, c);
                bl = true;
            } else {
                n2 = -1;
            }
            --n2;
        }
        if (bl) {
            n = Integer.parseInt(stringBuffer.toString());
        }
        return n;
    }

    private final void processRules(List list, boolean bl, int n) {
        int n2 = list.size();
        String string = "";
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            Element element = (Element)list.get(n3);
            string = element.getAttributeValue("Source_Field");
            string2 = this.current_data.getField(string, n);
            if (string2.length() > 0) {
                this.substituteFromTags(element, n3, string2, string, bl, n);
            }
            ++n3;
        }
    }

    private final String extractName(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        while (n > -1) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                stringBuffer.insert(0, c);
                bl = true;
            } else {
                string = string.substring(0, n + 1);
                n = -1;
            }
            --n;
        }
        return string;
    }

    private final boolean processJumpStory(String string, int n) {
        String string2;
        String string3;
        boolean bl = false;
        String string4 = "";
        Vector vector = new Vector();
        int n2 = 0;
        string4 = string3 = this.current_configuration.getSystemValue("common_value");
        String string5 = this.addInDataValues(string4, n, true).toLowerCase();
        string4 = this.addInDataValues(string4, n, false).toLowerCase();
        int n3 = 0;
        try {
            string2 = this.current_configuration.getSystemValue("linked_checksum_fields");
            n3 = this.generateChecksum(n, string2);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " creating checksum for linked items");
        }
        string2 = StripTags.strip(this.current_data.getField(this.differing_field, n), false);
        String string6 = StripTags.strip(this.current_data.getField(this.field_to_check, n), false).trim().toLowerCase();
        vector = this.current_linked_items.matches(string3, string, this.field_to_check, this.differing_field, string4, string6, string5, n3, string2);
        n2 = vector.size();
        if (n2 == 1) {
            LogWriter.writeLog(string + " has match in stored data");
            this.mergeBackJumpStory(string, vector);
        } else {
            if (n2 > 0) {
                LogWriter.writeLog("Multiple matches found - unable to merge");
            }
            if (n2 == 0) {
                LogWriter.writeLog("No matches found - writing out");
            }
            this.current_linked_items.setStory(string, this.current_data.getStory(n), n3);
            bl = true;
        }
        this.saveLinkedItems();
        return bl;
    }

    private final void generateReport(int n) {
        Object object;
        boolean bl = this.current_configuration.getBooleanValue("archive_emails");
        int n2 = 0;
        int n3 = 0;
        String string = Decoder.temp_dir + Decoder.group_id + "_" + FileInfo.extractFileNameWithoutExtension(this.user_file) + "_temp.html";
        PrintWriter printWriter = this.setOutputStream(string, false);
        StringTokenizer stringTokenizer = new StringTokenizer(this.current_configuration.getSystemValue("append_fields"));
        int n4 = stringTokenizer.countTokens();
        String string2 = "<font size=4 face=\"Arial,Helvetica\" >";
        String string3 = "";
        String string4 = "";
        int n5 = -1;
        printWriter.println("<HTML><BODY><H1>REPORT</H1>");
        printWriter.println("<B>Stories generated</B>");
        printWriter.println("<TABLE border=\"1\" width=\"100%\" colspan=\"" + n4 / 2 + "\"><TR><TD>" + string2 + "StoryName</FONT></TD><TD>");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (string3.length() <= 1) continue;
            printWriter.println(string2 + string3 + "</FONT></TD><TD>");
        }
        printWriter.println("</TD></TR>");
        int n6 = this.current_data.getStoryCount();
        int n7 = 0;
        while (n7 < n6) {
            object = this.current_data.getField("STORYNAME", n7);
            if (((String)object).length() > 0) {
                if (this.current_data.isStoryChanged(n7)) {
                    this.addFieldValuesToReport(n7, (String)object, n7, "><font size=4 face=\"Arial,Helvetica\" color=\"red\">", printWriter);
                    ++n2;
                } else {
                    this.addFieldValuesToReport(n7, (String)object, n7, "><font size=1 face=\"Arial,Helvetica\"><I>", printWriter);
                    ++n3;
                }
                printWriter.println("</TR>\n");
            }
            ++n7;
        }
        printWriter.println("</TABLE></BODY></HTML>");
        printWriter.println("<h2>" + new Date() + "</h2><hr><br>");
        printWriter.println("<TABLE border=\"1\" width=\"30%\" colspan=\"2\">");
        printWriter.println("<TR><TD><font size=4 face=\"Arial,Helvetica\" color=\"red\">New stories extracted out</FONT></TD><TD><font size=4 face=\"Arial,Helvetica\" color=\"red\">" + n2 + "</FONT></TD></TR>");
        printWriter.println("<TR><TD><font size=1 face=\"Arial,Helvetica\"><I>Stories unchanged</FONT></TD><TD><font size=1 face=\"Arial,Helvetica\"><I>" + n3 + "</FONT></TD></TR>");
        printWriter.println("</TABLE>\n<BR>");
        printWriter.close();
        SendEmail.post(this.user_file, "File " + string + " report", string, "Decoding report", 0);
        object = new File(string);
        if (bl) {
            LogWriter.writeLog("Hardcopy of report being generated");
            String string5 = Decoder.temp_dir + "email" + Decoder.separator + "General" + "." + FileInfo.extractFileNameWithoutExtension(this.user_file) + ".html";
            try {
                File file = new File(string5);
                if (file.exists()) {
                    file.delete();
                }
                ((File)object).renameTo(file);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " attempting to place email report on disk");
            }
        }
        ((File)object).delete();
    }

    private final void ruleDecode(Element element, String string, int n, String string2, boolean bl, String string3, String string4, boolean bl2, int n2, int n3) {
        boolean bl3 = Boolean.valueOf(element.getAttributeValue("IfEmpty").toUpperCase());
        boolean bl4 = Boolean.valueOf(element.getAttributeValue("TreatAsArray").toUpperCase());
        boolean bl5 = Boolean.valueOf(element.getAttributeValue("GlobalWrite").toUpperCase());
        String string5 = element.getAttributeValue("Capitalisation");
        String string6 = "";
        try {
            if (bl4) {
                string = this.current_data.scanIterativeHeader(string2, n2);
            } else {
                string6 = this.current_data.getField(string, n2);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in decoding rule");
        }
        if (Strip.stripSpaces(StripTags.strip(string3, false)).length() > 0 && bl & n3 > 0) {
            string3 = string4 + "===" + string + ">" + string3;
            string3 = bl2 ? "<~REPEATER " + n + ":" + string3 : "<~RULE " + n + ":" + string3;
        }
        if (!(bl3 & string6.length() > 0)) {
            if (string6.length() > 0) {
                string3 = string3.indexOf("ALL_CAPS" + this.internal_end_char) == -1 ? string6 + string3 : string3 + string6;
            }
            if (string3.length() < 100) {
                string3 = this.alias(string3, string, "true");
            }
            if (!string5.equals("")) {
                if (string5.equals("uppercase")) {
                    string3 = string3.toUpperCase();
                }
                if (string5.equals("lowercase")) {
                    string3 = string3.toLowerCase();
                }
                if (string5.equals("capitalise")) {
                    string3 = this.capitalise(string3);
                }
            }
            this.current_configuration.addField(string);
            if (!bl5) {
                this.current_data.setTextFieldValue(string, n2, string3);
            } else {
                int n4 = 0;
                while (n4 < this.current_data.getStoryCount()) {
                    String string7 = this.current_data.getField("STORYNAME", n4);
                    if (string7.length() > 0) {
                        this.current_data.setTextFieldValue(string, n4, string3);
                    }
                    ++n4;
                }
            }
        }
    }

    private final String addInDataValues(String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "% ", true);
            String string2 = "";
            String string3 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string3.equals("%")) {
                    String string4;
                    String string5 = StripTags.strip(this.current_data.getField(string2, n), false).trim();
                    if (bl && (string4 = this.numbersToWords.get(string5)) != null) {
                        string5 = string4;
                    }
                    stringBuffer.append(string5);
                } else if (!string2.equals("%")) {
                    stringBuffer.append(string2);
                }
                string3 = string2;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in getting variable from " + string);
        }
        return stringBuffer.toString();
    }

    private final String capitalise(String string) {
        char[] cArray = string.toCharArray();
        int n = 1;
        while (n < cArray.length) {
            if (Character.isLetter(cArray[n]) && Character.isWhitespace(cArray[n - 1])) {
                cArray[n] = Character.toUpperCase(cArray[n]);
            }
            ++n;
        }
        return new String(cArray);
    }

    private final void initDefaultEmptyFieldCheck() {
        List list = this.current_configuration.getSection(25);
        if (list != null) {
            this.checks = list.size();
            this.fields = new Vector_String(this.checks);
            this.values = new Vector_String(this.checks);
            this.max_sizes = new Vector_Int(this.checks);
            int n = 0;
            while (n < this.checks) {
                Element element = (Element)list.get(n);
                this.fields.addElement(element.getAttributeValue("Source_Field"));
                this.values.addElement(element.getAttributeValue("Default_value"));
                String string = element.getAttributeValue("Maximum_size");
                if (string.length() > 0) {
                    this.max_sizes.addElement(Integer.parseInt(string));
                } else {
                    this.max_sizes.addElement(0);
                }
                ++n;
            }
        }
    }

    private final void overwriteStoryField(int n, String string, String string2, String string3, String string4, boolean bl) {
        block6: {
            boolean bl2 = false;
            String string5 = "";
            try {
                if (bl) {
                    int n2 = this.current_data.getStoryCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        String string6 = this.current_data.getField("STORYNAME", n3);
                        if (string6.length() > 0 && !this.current_data.isStoryChanged(n3)) {
                            string5 = this.current_data.getField(string, n3);
                            if (string3.equals("*") | string5.indexOf(string3) != -1) {
                                this.current_data.setTextFieldValue(string, n3, string4);
                            }
                        }
                        ++n3;
                    }
                    break block6;
                }
                string5 = this.current_data.getField(string, n);
                if (!(string3.equals("*") | string5.indexOf(string3) != -1)) break block6;
                this.current_data.setTextFieldValue(string, n, string4);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " overwriting field");
            }
        }
    }

    private final boolean testForValue(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken().trim();
            if (string.indexOf(string4) != -1) {
                bl = true;
            }
            if (bl) break;
        }
        return bl;
    }

    private final void mergeOrphans(int n) {
        LogWriter.writeLog("Merging any orphan objects");
        int n2 = -1;
        String string = "";
        String string2 = "";
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        int n3 = this.current_data.getStoryCount();
        int n4 = n;
        while (n4 < n3) {
            String string3 = this.current_data.getField("STORYNAME", n4);
            if (string3.length() > 0 && !this.current_data.isStoryChanged(n4)) {
                if (this.current_data.getField(this.orphan_masterfield_name, n4).length() > 1) {
                    hashMap.put(new Integer(n4), this.current_data.getObjectField("WORDS", n4));
                    if (this.show_matches) {
                        LogWriter.writeLog(string3 + " has masterfield" + hashMap.get(new Integer(n4)));
                    }
                } else {
                    hashMap.put(new Integer(n4), "");
                }
            }
            ++n4;
        }
        int n5 = n;
        while (n5 < n3) {
            String string4 = this.current_data.getField("STORYNAME", n5);
            if (string4.length() > 0 && !this.current_data.isStoryChanged(n5)) {
                int n6 = n;
                while (n6 < n3) {
                    hashMap2.put(new Integer(n6), new Integer(0));
                    ++n6;
                }
                if (this.show_matches) {
                    LogWriter.writeLog("Testing " + string4);
                }
                string2 = this.current_data.getField(this.orphan_field_name, n5);
                string = this.current_data.getField(this.orphan_masterfield_name, n5);
                if (string2.length() > 1 & string.length() < 1) {
                    int n7;
                    String string5;
                    LogWriter.writeLog(string4 + " has " + this.orphan_field_name + " but no " + this.orphan_masterfield_name);
                    StringTokenizer stringTokenizer = new StringTokenizer(StripTags.strip(string2, false));
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken().toLowerCase();
                        n7 = n;
                        while (n7 < n3) {
                            String string6 = this.current_data.getField("STORYNAME", n7);
                            if (string6.length() > 0 && !this.current_data.isStoryChanged(n7) && n5 != n7) {
                                try {
                                    if (((String)hashMap.get(new Integer(n7))).indexOf("#" + StripTags.stripPunctuation(string5) + "#") != -1) {
                                        Integer n8 = (Integer)hashMap2.get(new Integer(n7));
                                        hashMap2.put(new Integer(n7), new Integer(n8 + 1));
                                        if (this.show_matches) {
                                            LogWriter.writeLog(string4 + " matched with " + string6 + " on >>" + string5 + "<<");
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    LogWriter.writeLog("Exception " + exception + " merging orphans");
                                }
                            }
                            ++n7;
                        }
                    }
                    string5 = "";
                    n7 = -1;
                    int n9 = -1;
                    int n10 = this.minimum_matches_required - 1;
                    if (n10 < 1) {
                        n10 = 1;
                    }
                    int n11 = n + 1;
                    while (n11 < n3) {
                        int n12;
                        String string7 = this.current_data.getField("STORYNAME", n11);
                        if (string7.length() > 0 && !this.current_data.isStoryChanged(n11) && (n12 = ((Integer)hashMap2.get(new Integer(n11))).intValue()) > n10) {
                            n7 = n11;
                            n10 = n12;
                            n9 = n11;
                            string5 = string7;
                        }
                        ++n11;
                    }
                    if (n7 == -1) {
                        LogWriter.writeLog("No word matches");
                    } else {
                        LogWriter.writeLog(string5 + " is best match for " + string4 + " with " + n10 + " matches");
                        if (this.show_matches) {
                            LogWriter.writeLog(string5 + " : " + ((HashMap)hashMap.get(new Integer(n9))).keySet());
                        }
                        this.merge(this.use_first_field, n5, n7, "", true, true, false, true);
                    }
                }
            }
            ++n5;
        }
    }

    private final void checkMandatoryFields(int n) {
        boolean bl = false;
        int n2 = n;
        int n3 = this.current_data.getStoryCount();
        int n4 = n;
        while (n4 < n3) {
            String string = this.current_data.getField("STORYNAME", n4);
            if (string.length() > 0 && !this.current_data.isStoryChanged(n4) && !this.getValidated(n4)) {
                LogWriter.writeLog("Story " + string + " does not contain mandatory fields");
                this.current_data.deleteStory(n4);
                --n4;
                --n3;
            }
            ++n4;
        }
    }

    private final void postValidation(int n) {
        int n2 = this.current_data.getStoryCount();
        int n3 = n;
        while (n3 < n2) {
            String string = this.current_data.getField("STORYNAME", n3);
            if (string.length() > 0 && !this.current_data.isStoryChanged(n3)) {
                this.validateStory(n3);
            }
            ++n3;
        }
    }

    private final void overwriteField(int n) {
        String string = "";
        String string2 = "";
        List list = this.current_configuration.getSection(22);
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        String[] stringArray4 = new String[n2];
        String[] stringArray5 = new String[n2];
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            Element element = (Element)list.get(n3);
            stringArray4[n3] = element.getAttributeValue("Source_Field");
            stringArray5[n3] = element.getAttributeValue("Source_Value");
            stringArray[n3] = element.getAttributeValue("Target_Field");
            stringArray2[n3] = element.getAttributeValue("Current_Value");
            stringArray3[n3] = element.getAttributeValue("New_Value");
            string2 = element.getAttributeValue("Global_overwite");
            blArray[n3] = string2.toLowerCase().indexOf("true") != -1;
            ++n3;
        }
        boolean bl = false;
        int n4 = 1;
        while (n4 < n2) {
            int n5 = this.current_data.getStoryCount();
            int n6 = n;
            while (n6 < n5) {
                String string3 = this.current_data.getField("STORYNAME", n6);
                if (string3.length() > 0 && !this.current_data.isStoryChanged(n6) && (string = this.current_data.getField(stringArray4[n4], n6)).indexOf(stringArray5[n4]) != -1) {
                    this.overwriteStoryField(n6, stringArray[n4], stringArray4[n4], stringArray2[n4], stringArray3[n4], blArray[n4]);
                }
                ++n6;
            }
            ++n4;
        }
    }

    private final void substituteFromTags(Element element, int n, String string, String string2, boolean bl, int n2) {
        String string3;
        String string4 = "";
        String string5 = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = true;
        String string6 = element.getAttributeValue("DestField");
        String string7 = ToUnicode.toUnicode(element.getAttributeValue("Start_Tag"));
        int n6 = string7.length();
        String string8 = ToUnicode.toUnicode(element.getAttributeValue("End_Tag"));
        int n7 = string8.length();
        boolean bl3 = Boolean.valueOf(element.getAttributeValue("IfEmpty").toUpperCase());
        boolean bl4 = Boolean.valueOf(element.getAttributeValue("DataMustBeCaps").toUpperCase());
        String string9 = element.getAttributeValue("Mandatory");
        if (string9.length() == 0) {
            string9 = null;
        }
        if ((string3 = element.getAttributeValue("Exclusion")).length() == 0) {
            string3 = "This will never occurXXX";
        }
        boolean bl5 = Boolean.valueOf(element.getAttributeValue("Remove_tokens").toUpperCase());
        String string10 = element.getAttributeValue("DestField");
        boolean bl6 = Boolean.valueOf(element.getAttributeValue("Move").toUpperCase());
        String string11 = element.getAttributeValue("Replacement");
        string11 = ToUnicode.toUnicode(string11);
        int n8 = string11.length();
        boolean bl7 = this.current_configuration.getBooleanValue("show_rule");
        StringTokenizer stringTokenizer = null;
        if (!this.current_configuration.getBooleanValue("keep_tags")) {
            bl7 = false;
        }
        n5 = string7.length() + 1;
        string5 = string6;
        if (string7 != null && string8 != null) {
            if (string7.indexOf("%") != -1 & !bl) {
                try {
                    n3 = Integer.parseInt(string7.substring(1, n5 - 1));
                    n4 = Integer.parseInt(string8.substring(1)) + 1;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error " + exception + " in setting absolute values for " + string7 + " & " + string8);
                }
                string = StripTags.strip(string, false).trim();
                int n9 = string.length();
                if (n3 < n9 && n4 < n9 + 1) {
                    string4 = ToUnicode.toUnicode(element.getAttributeValue("Prefix")) + this.alias(string.substring(n3, n4), string6, "true") + ToUnicode.toUnicode(element.getAttributeValue("Suffix"));
                }
                this.ruleDecode(element, string6, n, string5, bl7, string4, string2, bl, n2, n6);
            } else {
                n3 = -n5;
                while (true) {
                    String string12;
                    n3 = string.indexOf(string7, n3 + n5);
                    if (!bl) {
                        n4 = string.indexOf(string8, n3 + n5 - 1);
                    } else {
                        n4 = string.indexOf(string7, n3 + n5 - 1);
                        if (n4 == -1 & !bl2) {
                            n4 = string.length();
                        }
                        bl2 = false;
                    }
                    if (n4 != -1 && bl3 && (string12 = this.current_data.getField(string6, n2)).length() > 0) {
                        n4 = -1;
                    }
                    if (n4 != -1 && n3 != -1 && bl4 && (string12 = StripTags.strip(string.substring(n3 + n6, n4 - n7), true)).toUpperCase().indexOf(string12) == -1) {
                        n4 = -1;
                    }
                    if (n3 == -1 | n4 == -1) break;
                    if (!bl) {
                        n4 += n7;
                    }
                    string12 = "";
                    string12 = bl5 ? string.substring(n3 + n6, n4 - n7) : string.substring(n3, n4);
                    string4 = ToUnicode.toUnicode(element.getAttributeValue("Prefix")) + string12.trim() + ToUnicode.toUnicode(element.getAttributeValue("Suffix"));
                    boolean bl8 = false;
                    boolean bl9 = this.testForValue(string4, string3, this.values_deliminator);
                    if (!bl9) {
                        bl8 = string9 == null ? true : this.testForValue(string4, string9, this.values_deliminator);
                    }
                    if (!(bl8 & !bl9)) continue;
                    if (bl) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            stringTokenizer = new StringTokenizer(string10);
                        }
                        string6 = stringTokenizer.nextToken();
                    }
                    this.ruleDecode(element, string6, n, string5, bl7, string4, string2, bl, n2, n6);
                    if (bl6) {
                        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n3));
                        stringBuffer.append(string11);
                        if (n4 < string.length()) {
                            stringBuffer.append(string.substring(n4));
                        }
                        string = stringBuffer.toString();
                        this.current_data.setTextFieldValue(string2, n2, string);
                    }
                    if (n4 <= 0) continue;
                    if (bl6) {
                        n3 = n8 - n5;
                        continue;
                    }
                    n4 = n3 - n5 + 1 + n8;
                }
            }
        }
    }

    private final void mergeBackJumpStory(String string, Vector vector) {
        String string2 = (String)vector.firstElement();
        int n = this.current_data.returnID(string);
        if (this.current_data.isImage(n)) {
            ShowGUIMessage.showGUIMessage("Unable to merge back jump story", "Ignore images");
        } else {
            LogWriter.writeLog("Extracting data for :" + string2 + " " + string);
            Element element = this.current_linked_items.getStory(string2);
            element.setAttribute("SHAPE", "");
            element.setAttribute("PLOT", "");
            this.current_data.createStory(string2, element);
            int n2 = this.current_data.returnID(string2);
            boolean bl = this.isOrderCorrect(string, string2, n);
            this.merge(this.use_first_field, n, n2, " ", bl, true, false, true);
            LogWriter.writeLog("Story " + string2 + " merged back into data");
            this.current_data.deleteStory(string2);
            if (Decoder.debug_level > 0) {
                LogWriter.writeLog("Deleting " + string2 + " from store");
            }
            if (!this.use_client) {
                this.current_linked_items.removeStory(string2);
            }
        }
    }

    private final void addFieldValuesToReport(int n, String string, int n2, String string2, PrintWriter printWriter) {
        printWriter.println("<TR><TD" + string2);
        printWriter.println(n + 1 + " " + string);
        printWriter.println("</I></B></TD>\n");
        StringTokenizer stringTokenizer = new StringTokenizer(this.current_configuration.getSystemValue("append_fields"));
        String string3 = "";
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = "";
            String string5 = stringTokenizer.nextToken().trim();
            string3 = this.use_link && this.current_linked_items.isAJumpStory(string) ? this.current_linked_items.getField(string5, string) : this.current_data.getField(string5, n2);
            string4 = StripTags.strip(string3, false);
            if (string4.length() < 1) {
                string4 = "&nbsp;";
            }
            printWriter.println("<TD" + string2 + string4 + "</I></B></FONT></TD>");
        }
    }

    private final void postIncrementalCheck(int n) {
        int n2 = n;
        int n3 = -1;
        int n4 = this.current_data.getStoryCount();
        int n5 = 0;
        while (n5 < n4) {
            String string = this.current_data.getField("STORYNAME", n5);
            if (string.length() > 0) {
                n3 = this.getChecksum(n5);
                int n6 = this.resetChecksum(n5, false);
                if (n6 == n3) {
                    this.current_data.setStoryAsChanged(n5);
                    LogWriter.writeLog(string + " unchanged. Not written out.");
                } else {
                    ++n2;
                }
            }
            ++n5;
        }
    }

    private final String ensureUnique(String string, int n) {
        if (this.current_data.isUnique(string)) {
            String string2 = "x" + n;
            string = string2 + string;
            if (this.absolute_merge > 0 & string2.length() > this.absolute_merge) {
                LogWriter.writeLog("Unable to generate unique key for " + string);
                string = string.substring(0, this.absolute_merge);
            } else {
                LogWriter.writeLog("Generated unique key for " + string);
            }
        }
        return string;
    }

    private final String getFileName(int n) {
        if (n == -1) {
            n = this.current_data.getNextStoryID();
        }
        String string = "";
        String string2 = "";
        int n2 = this.current_configuration.getIntValue("max_name_length");
        StringTokenizer stringTokenizer = new StringTokenizer(this.current_configuration.getSystemValue("default_name"));
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string3 = stringTokenizer.nextToken();
            string2 = StripTags.strip(this.current_data.getField(string3, n), true).toLowerCase().trim();
            string2 = StripTags.stripUserTags(string2);
            if (this.use_subtoken && (n3 = string2.indexOf("-")) != -1) {
                string2 = string2.substring(0, n3);
            }
            string = string + string2;
        }
        if ((string = this.validateName(string, null)).length() > n2) {
            string = string.substring(0, n2);
        }
        if (Decoder.debug_level > 1) {
            LogWriter.writeLog("Generating filename:" + string);
        }
        if (string.equals("")) {
            string = "" + n;
        }
        return string;
    }

    private final String getSubToken(int n) {
        String string = "";
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.current_configuration.getSystemValue("default_name"));
        while (stringTokenizer.hasMoreTokens()) {
            string = StripTags.strip(this.current_data.getField(stringTokenizer.nextToken(), n), true).toLowerCase().trim();
            int n2 = string.indexOf("-");
            if (n2 == -1) continue;
            string2 = string.substring(n2 + 1);
        }
        if (Decoder.debug_level > 2) {
            LogWriter.writeLog("Generating subtag:" + string2);
        }
        return string2;
    }

    private final void useDefaultsForEmptyFields(boolean bl, int n) {
        LogWriter.writeLog("Filling Empty fields with default values");
        this.initDefaultEmptyFieldCheck();
        boolean bl2 = this.current_configuration.getBooleanValue("reject_oversize_stories");
        this.fields_have_been_rejected = false;
        int n2 = this.current_data.getStoryCount();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.current_data.getField("STORYNAME", n3);
            if (string.length() > 0 && !this.current_data.isStoryChanged(n3)) {
                this.testFieldForOverSize(bl, string, n3, bl2, false);
            }
            ++n3;
        }
    }

    private final boolean incompleteTagCheck(StringBuffer stringBuffer) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), Decoder.start_token_deliminator + Decoder.end_token_deliminator, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() <= 0) continue;
            if (Decoder.start_token_deliminator.indexOf(string) != -1) {
                bl = true;
                continue;
            }
            if (Decoder.end_token_deliminator.indexOf(string) == -1) continue;
            bl = false;
        }
        return bl;
    }

    private final String textBeforeTable(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, Decoder.start_token_deliminator + Decoder.end_token_deliminator, true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (Decoder.start_token_deliminator.indexOf(string2) != -1) {
                bl = false;
            }
            if (Decoder.end_token_deliminator.indexOf(string2) != -1) {
                bl = true;
                string2 = "";
            }
            if (!bl && "TBTCTR".indexOf(string2) != -1) break;
            if (!bl) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

