/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad;

import com.idrsolutions.grouping.PdfAlgorithm;
import com.idrsolutions.grouping.PdfStoryGrouping;
import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderIO;
import com.idrsolutions.storypad.DecoderParser;
import com.idrsolutions.storypad.objects.License;
import com.idrsolutions.storypad.pdf.PdfMasterTextFonts;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.utils.functions.SendEmail;
import java.awt.Color;
import java.util.List;
import org.jdom.Element;
import org.jpedal.PdfDecoder;
import org.jpedal.grouping.PdfGenericGrouping;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.text.PdfThreshold;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DecoderParserPdf
extends DecoderParser {
    protected String algorithm_name = "";
    protected String[] algorithms_available;
    protected Color[] algorithm_col;
    protected PdfMasterTextFonts current_MT_data;
    PdfThreshold current_thresholds;
    private PdfStoryGrouping grouping = new PdfStoryGrouping();
    private PdfGenericGrouping no_grouping = new PdfGenericGrouping();

    protected void extractTable(float f, float f2, float f3, float f4, int n, int n2) {
        boolean bl = this.current_configuration.getBooleanValue("keep_font_information");
        boolean bl2 = this.current_configuration.getBooleanValue("keep_width_information");
        boolean bl3 = this.current_configuration.getBooleanValue("keep_alignment_information");
        int n3 = this.current_configuration.getIntValue("border_width");
        Element element = this.grouping.extractTextAsTable(f, f2, f3, f4, n, n2, bl, bl2, bl3, n3);
        String string = null;
        if (n2 == 23) {
            string = "23";
        } else if (n2 == 24) {
            string = "24";
        }
        this.writeTextObject(element, n, string);
    }

    protected final boolean cachePdfData(String string) {
        boolean bl = false;
        DecoderParserPdf decoderParserPdf = this;
        if (decoderParserPdf.current_license.getLevel() == 1 | License.decode_pdf) {
            this.decode_pdf = null;
            DecoderParserPdf decoderParserPdf2 = this;
            boolean bl2 = decoderParserPdf2.current_license.canAccessImages();
            this.algorithm_name = this.current_configuration.getSystemValue("algorithm_name");
            this.current_thresholds = new PdfThreshold();
            int n = this.current_configuration.getIntValue("image_scale");
            boolean bl3 = this.current_configuration.getBooleanValue("draw_screen_interactively");
            boolean bl4 = this.current_configuration.getBooleanValue("process_text");
            boolean bl5 = this.current_configuration.getBooleanValue("process_images");
            boolean bl6 = this.current_configuration.getBooleanValue("process_shapes");
            try {
                this.decode_pdf = new PdfDecoder(this.use_client);
                this.decode_pdf.initValues(bl4, bl5, bl6, true, this.current_thresholds, n, bl3, this.values_deliminator, Decoder.debug_level, bl2);
                this.initGrouping();
                StatusBar.setProgress(10);
                this.files_to_use = new String[1];
                this.files_to_use[0] = string;
                if (this.files_to_use != null) {
                    this.decode_pdf.openPdfFile(string);
                }
                StatusBar.setProgress(20);
                if (DecoderIO.debug_level > 0) {
                    LogWriter.writeLog("Reading information");
                }
                this.information_values = this.decode_pdf.getInformation();
                if (DecoderIO.debug_level > 0) {
                    LogWriter.writeLog("Information read");
                }
                this.page_count = this.decode_pdf.getPageCount();
                LogWriter.writeLog("Pdf file translated into XML");
                bl = true;
            }
            catch (Exception exception) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog("Failure to cache pdf file " + string + " with exception " + exception);
            }
        } else {
            ExitDecoder.exitWithMessage("This version will not decode pdf");
        }
        return bl;
    }

    protected final void addPdfImages(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        PdfData pdfData = this.decode_pdf.getPdfData();
        PdfImageData pdfImageData = this.decode_pdf.getPdfImageData();
        int n7 = pdfImageData.getImageCount();
        int n8 = 0;
        while (n8 < n7) {
            n2 = (int)pdfImageData.getImageXCoord(n8);
            n3 = (int)pdfImageData.getImageYCoord(n8);
            n4 = (int)pdfImageData.getImageWidth(n8);
            n5 = (int)pdfImageData.getImageHeight(n8);
            n6 = pdfImageData.getImagePageID(n8);
            String string = pdfImageData.getImageName(n8);
            if (n6 == n) {
                if (Decoder.debug_level > 1) {
                    LogWriter.writeLog("Adding " + string);
                }
                int n9 = this.current_data.getNextStoryID();
                this.current_data.setTextFieldValue("IMAGE_IMAGE", n9, string);
                String string2 = n6 + " " + n2 + " " + (n3 + n5) + " " + (n2 + n4) + " " + n3;
                String string3 = n2 + " " + (n3 + n5) + " " + (n2 + n4) + " " + n3 + " " + n6;
                this.current_data.setTextFieldValue("SHAPE", n9, string2);
                this.current_data.setTextFieldValue("PLOT", n9, string3);
                this.current_data.setTextFieldValue("PAGE", n9, "" + n6);
                this.current_data.setTextFieldValue("OBJECT_X1", n9, n2 + "");
                this.current_data.setTextFieldValue("OBJECT_Y1", n9, n3 + n5 + "");
                this.current_data.setTextFieldValue("OBJECT_X2", n9, n2 + n4 + "");
                this.current_data.setTextFieldValue("OBJECT_Y2", n9, n3 + "");
                this.current_data.setTextFieldValue("TYPE", n9, "IMAGE");
                try {
                    this.processStory(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog(exception + " with image " + string);
                }
            }
            ++n8;
        }
    }

    protected final void resetAlgorithm(String string) {
        this.algorithm_name = string;
        if (this.grouping != null) {
            this.grouping.resetAlgorithm(string);
        }
    }

    protected final void extractDataAsContent() {
        block5: {
            boolean bl = this.current_configuration.getBooleanValue("remove_furniture");
            String string = this.current_configuration.getSystemValue("algorithm_name");
            int n = this.current_configuration.getIntValue("minimum_chars");
            boolean bl2 = this.current_configuration.getBooleanValue("drop_text_gap");
            StatusBar.updateStatus("Decoding page content", 1);
            try {
                PdfData pdfData = this.decode_pdf.getPdfData();
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                int n2 = this.decode_pdf.getPageNumber();
                float f = this.decode_pdf.getMinX(n2);
                float f2 = this.decode_pdf.getMaxX(n2);
                float f3 = this.decode_pdf.getMinY(n2);
                float f4 = this.decode_pdf.getMaxY(n2);
                if (this.grouping == null) {
                    this.no_grouping.decodePageFragments(pdfData, n2);
                    break block5;
                }
                if (string.endsWith("table")) {
                    int n3 = 23;
                    if (string.indexOf("HTML") != -1) {
                        n3 = 24;
                    }
                    this.grouping.setValues("-\u00ad-\u2020\u0097", this.values_deliminator, string, bl2, this.current_thresholds, pdfPageData, pdfData, this.current_MT_data);
                    this.extractTable(f, f3, f2, f4, n2, n3);
                    break block5;
                }
                this.grouping.setValues("-\u00ad-\u2020\u0097", this.values_deliminator, string, bl2, this.current_thresholds, pdfPageData, pdfData, this.current_MT_data);
                this.grouping.applyGrouping(this.current_tooltips, this.current_configuration.getSection(16), n2, bl, string, n, (int)f, (int)f2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in applying merge algorithms with " + string);
                SendEmail.post(this.user_file, "File failed merging", this.user_file, "File failed merging", 2);
                this.archiveDataFile(true);
            }
        }
    }

    protected final void addPdfText() {
        PdfData pdfData = this.decode_pdf.getPdfData();
        int n = pdfData.getTextElementCount();
        int n2 = this.decode_pdf.getPageNumber();
        int n3 = 0;
        while (n3 < n) {
            StatusBar.setProgress(45 + n3 * 25 / n);
            Element element = pdfData.getTextElementAt(n3);
            this.writeTextObject(element, n2, null);
            ++n3;
        }
    }

    private void writeTextObject(Element element, int n, String string) {
        block5: {
            String string2 = "";
            String string3 = "";
            String string4 = "<~START>" + n + "<~END>";
            String string5 = this.current_configuration.getSystemValue("default_data_field");
            string3 = element.getAttributeValue("content");
            string3 = Strip.removeMultipleSpacesAndReturns(string3).toString();
            int n2 = this.current_data.getNextStoryID();
            String string6 = "<~START>" + element.getAttributeValue("x1") + "<~END>";
            if (string3.length() <= 1) break block5;
            if (string != null) {
                this.current_data.setTextFieldValue("TABLE_TYPE", n2, string);
            }
            string2 = element.getAttributeValue("raw_data");
            this.current_data.setTextFieldValue("RAWDATA", n2, string2);
            this.current_data.setTextFieldValue("PAGE", n2, string4);
            this.current_data.setTextFieldValue("OBJECT_X1", n2, string6);
            string2 = "<~START>" + element.getAttributeValue("x2") + "<~END>";
            this.current_data.setTextFieldValue("OBJECT_X2", n2, string2);
            string2 = "<~START>" + element.getAttributeValue("y1") + "<~END>";
            this.current_data.setTextFieldValue("OBJECT_Y1", n2, string2);
            string2 = "<~START>" + element.getAttributeValue("y2") + "<~END>";
            this.current_data.setTextFieldValue("OBJECT_Y2", n2, string2);
            string2 = "<~START>" + element.getAttributeValue("scaled_space_width") + "<~END>";
            this.current_data.setTextFieldValue("SPACE", n2, string2);
            string2 = element.getAttributeValue("line_count");
            this.current_data.setTextFieldValue("LINE_COUNT", n2, string2);
            string2 = element.getAttributeValue("fonts_used");
            this.current_data.setTextFieldValue("OBJECT_FONTS", n2, string2);
            string2 = element.getAttributeValue("plot_string");
            this.current_data.setTextFieldValue("PLOT", n2, string2);
            string2 = "<~START>" + element.getAttributeValue("line_height") + "<~END>";
            this.current_data.setTextFieldValue("LINE_HEIGHT", n2, string2);
            string2 = element.getAttributeValue("shape_data");
            this.current_data.setTextFieldValue("SHAPE", n2, string2);
            string2 = element.getAttributeValue("is_master");
            this.current_data.setTextFieldValue("IS_MASTER", n2, string2);
            if (!string3.startsWith("<~START>")) {
                string2 = "<~START>" + string3;
            }
            if (!string3.endsWith("<~END>")) {
                string3 = string3 + "<~END>";
            }
            this.current_data.setTextFieldValue(string5, n2, string3);
            this.current_data.setTextFieldValue("DEFAULT_DATA", n2, string3);
            this.current_data.setTextFieldValue("TYPE", n2, "TEXT");
            try {
                this.processStory(null);
            }
            catch (Exception exception) {
                LogWriter.writeLog(exception + " with text ");
            }
        }
    }

    private final void initGrouping() {
        List list = this.current_configuration.getSection(17);
        this.current_MT_data = new PdfMasterTextFonts(list);
        List list2 = this.current_configuration.getSection(18);
        float f = Float.parseFloat(this.current_configuration.getSystemValue("space_thresh_hold"));
        this.current_thresholds.setThresholds(f, list2);
        if (this.grouping != null) {
            this.algorithms_available = PdfAlgorithm.getAlgorithmsAvailable();
            this.algorithm_col = PdfAlgorithm.getAlgorithmColors();
        }
    }
}

