/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.data;

import com.idrsolutions.utils.functions.DayOfCentury;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import org.jpedal.utils.LogWriter;

public class Checksums
implements Serializable {
    private Vector keys = new Vector();
    private Vector check_sum = new Vector();
    private Vector iteration = new Vector();
    private Vector expires = new Vector();
    private int today = 0;
    private Date[] times = new Date[5];

    public Checksums() {
        int n = 0;
        while (n < 5) {
            this.times[n] = new Date();
            ++n;
        }
    }

    public final void expireValues(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.expires.size();
        LogWriter.writeLog("Flushing items from checksum table");
        while (n3 != this.expires.size()) {
            n2 = Integer.parseInt((String)this.expires.elementAt(n3));
            if (this.today - n2 > n) {
                this.keys.removeElementAt(n3);
                this.check_sum.removeElementAt(n3);
                this.iteration.removeElementAt(n3);
                this.expires.removeElementAt(n3);
                continue;
            }
            ++n3;
        }
        LogWriter.writeLog("Original Items=" + n4);
        LogWriter.writeLog("Items left=" + this.expires.size());
        LogWriter.writeLog("Number of items removed from checksum table=" + (n4 - this.expires.size()));
    }

    public final boolean hasBeenClocked() {
        boolean bl = false;
        Date date = new Date();
        int n = 0;
        while (n < 5) {
            if (date != null && this.times[n] != null && this.times[n].after(date)) {
                bl = true;
                LogWriter.writeLog("Clock has been reset with on system.");
                LogWriter.writeLog("Program will run in standard mode");
            }
            ++n;
        }
        int n2 = 4;
        while (n2 > 1) {
            this.times[n2 - 1] = this.times[n2];
            --n2;
        }
        this.times[4] = new Date();
        return bl;
    }

    public final void resetChecksum(int n, int n2) {
        int n3 = this.getIncrementalCount(n);
        try {
            this.iteration.setElementAt("" + n3, n);
            this.expires.setElementAt("" + this.today, n);
            this.setChecksum("" + n2, n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception creating " + exception);
        }
    }

    public final int returnKey(String string) {
        return this.keys.indexOf(string);
    }

    public final void addChecksum(int n, int n2, String string) {
        int n3 = 1;
        try {
            this.setKey(string);
            this.setChecksum("" + n2);
            this.iteration.addElement("" + n3);
            this.expires.addElement("" + this.today);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " creating checksum ");
        }
    }

    public final int getChecksum(String string) {
        int n = -1;
        try {
            int n2 = this.keys.indexOf(string);
            n = Integer.parseInt((String)this.check_sum.elementAt(n2));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " generating checksum for " + string + " - default used");
        }
        return n;
    }

    public final void resetToday() {
        this.today = DayOfCentury.getDayOfCentury();
    }

    private final void setKey(String string) {
        this.keys.addElement(string);
    }

    private final int getIncrementalCount(int n) {
        int n2 = 1;
        try {
            n2 = Integer.parseInt((String)this.iteration.elementAt(n));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " - counter reset");
            n2 = 1;
        }
        n2 = n2 == 999 ? 1 : ++n2;
        return n2;
    }

    private final void setChecksum(String string, int n) {
        this.check_sum.setElementAt(string, n);
    }

    private final void setChecksum(String string) {
        this.check_sum.addElement(string);
    }
}

