/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.data;

import com.idrsolutions.utils.StripTags;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom.Element;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;

public class Content {
    private HashMap storyID = new HashMap();
    private HashMap merge_test = new HashMap();
    private int next_story_id;
    private int first_story_to_use = this.next_story_id = 0;
    private ArrayList stories = new ArrayList();
    private int max_count = 1000;
    private double ID = Math.random() * 1024.0;

    public Content() {
        this.stories.ensureCapacity(this.max_count);
        this.init();
    }

    public final int getStoryCheckPoint() {
        if (this.first_story_to_use == -1) {
            this.first_story_to_use = 0;
        }
        return this.first_story_to_use;
    }

    public final void createStory(String string) {
        this.storyID.put(string, "" + this.next_story_id);
        this.setTextFieldValue("STORYNAME", this.next_story_id, string);
        this.setTextFieldValue("CHANGED", this.next_story_id, "false");
        ++this.next_story_id;
        this.initialiseStory(this.next_story_id);
    }

    public final boolean isUnique(String string) {
        boolean bl = true;
        if (this.storyID.get(string) == null) {
            bl = false;
        }
        return bl;
    }

    public final void createStory(String string, Element element) {
        this.storyID.put(string, "" + this.next_story_id);
        this.stories.set(this.next_story_id, element);
        this.setTextFieldValue("STORYNAME", this.next_story_id, string);
        this.setTextFieldValue("CHANGED", this.next_story_id, "false");
        ++this.next_story_id;
        this.initialiseStory(this.next_story_id);
    }

    public final Object getObjectField(String string, int n) {
        String string2 = null;
        Element element = this.getStory(n);
        string2 = element.getAttributeValue(string);
        return string2;
    }

    public final void setMergeTest(String string, int n) {
        this.merge_test.put(string, "" + n);
    }

    public final String getMergeTest(String string) {
        String string2 = null;
        if (string.length() > 0) {
            string2 = (String)this.merge_test.get(string);
        }
        return string2;
    }

    public final void setTextFieldValue(String string, int n, String string2) {
        if (!string.equals("KEYWORDS")) {
            string2 = Strip.removeMultipleSpacesAndReturns(string2).toString();
        }
        Element element = this.getStory(n);
        element.setAttribute(string, string2 + " ");
    }

    public final boolean isStoryChanged(int n) {
        boolean bl = false;
        if (this.getField("CHANGED", n).equals("true")) {
            bl = true;
        }
        return bl;
    }

    public final void setStoryCheckPoint() {
        this.first_story_to_use = this.next_story_id - 1;
    }

    public final boolean isImage(int n) {
        Element element = this.getStory(n);
        String string = element.getAttributeValue("IMAGE_IMAGE");
        return string != null;
    }

    public final void setAsTable(int n, String string) {
        Element element = this.getStory(n);
        element.setAttribute("TABLE_TYPE", string);
    }

    public final boolean isTable(int n) {
        Element element = this.getStory(n);
        String string = element.getAttributeValue("TABLE_TYPE");
        return string != null;
    }

    public final String getStoryID(String string) {
        return (String)this.storyID.get(string);
    }

    public final void deleteStory(int n) {
        if (!this.isImage(n)) {
            --this.next_story_id;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < this.getStoryCount() + 1) {
            String string = this.getField("STORYNAME", n2);
            if (n2 > n) {
                hashMap.put(string, "" + (n2 - 1));
            } else if (n != n2) {
                hashMap.put(string, "" + n2);
            }
            ++n2;
        }
        this.stories.remove(n);
        this.storyID = hashMap;
    }

    public final void initialiseStory(int n) {
        if (n >= this.max_count) {
            this.max_count += 100;
            this.stories.ensureCapacity(this.max_count);
        }
        this.stories.add(n, new Element("story"));
    }

    public final boolean hasImage(String string, int n) {
        Element element = this.getStory(n);
        String string2 = element.getAttributeValue("IMAGE_" + string);
        return string2 != null;
    }

    public final int getStoryCount() {
        int n = this.stories.size() - 1;
        return n;
    }

    public final int getNextStoryID() {
        if (this.next_story_id < 0) {
            this.next_story_id = 0;
        }
        return this.next_story_id;
    }

    public final void sort(int n, String string, boolean bl, String string2, boolean bl2, String string3, boolean bl3, String string4, boolean bl4) {
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        if (bl) {
            n2 = -1;
        }
        if (bl2) {
            n3 = -1;
        }
        if (bl3) {
            n4 = -1;
        }
        boolean bl5 = false;
        if (string4.indexOf("length") != -1) {
            bl5 = true;
        }
        int n5 = this.getStoryCount();
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5 + 1];
        int[] nArray3 = new int[n5 + 1];
        String[] stringArray = new String[n5 + 1];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        while (n9 < n5) {
            String string5 = this.getField("STORYNAME", n9);
            if (string5.length() > 0 && !this.isStoryChanged(n9)) {
                String string6 = this.getField(string, n9);
                String string7 = this.getField(string2, n9);
                String string8 = this.getField(string3, n9);
                try {
                    if (bl4 | !bl5) {
                        string6 = StripTags.strip(string6, false);
                        string7 = StripTags.strip(string7, false);
                        string8 = StripTags.strip(string8, false);
                    }
                    if (!bl5) {
                        n6 = ToInteger.getInteger(string6);
                        n7 = ToInteger.getInteger(string7);
                        n8 = ToInteger.getInteger(string8);
                    }
                    if (bl5) {
                        n6 = string6.length();
                        n7 = string7.length();
                        n8 = string8.length();
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " in story " + string5);
                    n6 = 0;
                    n7 = 0;
                    n8 = 0;
                }
                nArray[n9] = n2 * n6;
                nArray2[n9] = n3 * n7;
                nArray3[n9] = n4 * n8;
                stringArray[n9] = string5;
            }
            ++n9;
        }
        stringArray = Sorts.quicksort(n, n5, nArray, nArray2, nArray3, stringArray);
    }

    public final String getField(String string, int n) {
        String string2 = "";
        Element element = this.getStory(n);
        if (element != null && (string2 = element.getAttributeValue(string)) == null) {
            string2 = "";
        }
        if (!string.equals("KEYWORDS")) {
            string2 = string2.trim();
        }
        return string2;
    }

    public final int returnID(String string) {
        int n = -1;
        String string2 = "";
        string2 = this.getStoryID(string);
        if (string2 != null && !string2.equals("")) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public final Element getStory(int n) {
        return (Element)this.stories.get(n);
    }

    public final void setStoryAsChanged(int n) {
        this.setTextFieldValue("CHANGED", n, "true");
    }

    public final String scanIterativeHeader(String string, int n) {
        int n2 = 1;
        String string2 = string + n2;
        while (this.getField(string2, n).length() > 0) {
            string2 = string + ++n2;
        }
        return string2;
    }

    public final void deleteStory(String string) {
        this.deleteStory(this.getStoryID(string));
    }

    private final void init() {
        this.merge_test = new HashMap();
        this.storyID = new HashMap();
        this.stories.add(this.next_story_id, new Element("story"));
    }
}

