/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.gui;

import com.idrsolutions.storypad.ClientData;
import com.idrsolutions.storypad.ClientStandard;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.data.Content;
import com.idrsolutions.storypad.gui.FileFilterer;
import com.idrsolutions.storypad.gui.PopulatedTable;
import com.idrsolutions.storypad.gui.StoryList;
import com.idrsolutions.storypad.objects.ConfigurationData;
import com.idrsolutions.storypad.utils.SQL;
import com.idrsolutions.utils.functions.OneItemSort;
import com.idrsolutions.utils.gui.IconiseImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jpedal.fonts.Fonts;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;

public class ConfigDialog {
    public BufferedImage raw_image;
    public BufferedImage clipped_image;
    protected JPanel table_contents = new JPanel();
    protected PopulatedTable display_table;
    protected JPanel source_panel = new JPanel();
    ConfigurationData current_configuration;
    Content current_data;
    int selected_story;
    private JButton remove = new JButton();
    private JPanel bottom_panel = new JPanel();
    private JTextPane format_pane;
    private JTextPane raw_pane;
    private JEditorPane source_field = new JEditorPane();
    private Border button_border_unpressed = new BevelBorder(0, Color.lightGray, Color.black);
    private JButton yes = new JButton();
    private JToolBar filter_panel = new JToolBar(0);
    private JCheckBox filter = new JCheckBox();
    private int dialog_width = 380;
    private HashMap common_descriptions = new HashMap();
    private JTextArea help_information = new JTextArea();
    private JButton apply = new JButton();
    private JScrollPane source_field_scroll = new JScrollPane();
    private boolean is_user_section = false;
    private JLabel tooltip_label = new JLabel();
    private int max_rows = 0;
    private JButton insert = new JButton();
    private String section;
    private boolean may_be_changed = false;
    private JButton duplicate = new JButton();
    private String temp_dir = "";
    private JButton cancel = new JButton();
    private JButton okay = new JButton();
    private String descriptor;
    private HashMap fields;
    private JTabbedPane client_values;
    private int dialog_height = 200;
    private JCheckBox further_help = new JCheckBox();
    private boolean is_yes_flag;
    private Border button_border_pressed = new BevelBorder(1, Color.lightGray, Color.black);
    private JButton no = new JButton();
    private JButton use_selected_button = new JButton();
    private JTabbedPane panes = new JTabbedPane();
    private JDialog dialog;
    private JToolBar buttons = new JToolBar();
    private SQL MySQL_output;
    private SQL Postgre_output;
    private final Font button_font = new Font("SansSerif", 0, 14);
    private static String[] headings;
    private static List returned_data;

    public ConfigDialog(String string) {
        this.temp_dir = string;
    }

    public ConfigDialog() {
    }

    public ConfigDialog(String string, SQL sQL, SQL sQL2) {
        this.MySQL_output = sQL;
        this.Postgre_output = sQL2;
        this.temp_dir = string;
    }

    public final void updateUI() {
        this.client_values.updateUI();
        this.apply.updateUI();
        this.cancel.updateUI();
    }

    public final boolean createDialog(Component component, String string, boolean bl) {
        this.is_yes_flag = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n = (int)component.getPreferredSize().getWidth() + 20;
        int n2 = (int)component.getPreferredSize().getHeight() * 2;
        n2 += 50;
        this.buttons.setLayout(new FlowLayout(1, 10, 1));
        this.buttons.setFloatable(false);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (bl) {
            this.buttons.add(this.yes);
            this.buttons.add(this.no);
        } else {
            this.buttons.add(this.okay);
        }
        jPanel.add((Component)this.buttons, "South");
        this.dialog = new JDialog(ClientStandard.main_frame, string, true);
        this.dialog.setSize(n, n2);
        this.dialog.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.dialog.addComponentListener(new ComponentListener(){

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                componentEvent.getComponent().transferFocus();
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.dialog.getContentPane().add(jPanel);
        this.dialog.show();
        return this.is_yes_flag;
    }

    public final List returnValues() {
        return returned_data;
    }

    public final boolean cleanupDialog() {
        this.dialog.dispose();
        return this.may_be_changed;
    }

    public final void init(HashMap hashMap, String string, Content content, int n, String string2, String[] stringArray, ConfigurationData configurationData) {
        this.section = string2;
        headings = stringArray;
        this.dialog_width = configurationData.getIntValue("dialog_width");
        this.dialog_height = configurationData.getIntValue("dialog_height");
        this.current_configuration = configurationData;
        this.selected_story = n;
        this.current_data = content;
        this.descriptor = string;
        this.fields = hashMap;
        this.is_user_section = ConfigurationData.isDefaultUserSection(string2);
        this.table_contents.setLayout(new BorderLayout());
        this.table_contents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.common_descriptions.put("source_field", "Field which the command looks for the raw data to process");
        this.common_descriptions.put("destination_field", "Field where any data extracted will be placed");
        this.common_descriptions.put("comment", "A user description of what this command does");
        this.common_descriptions.put("prefix", "Added to start of data if it is written to destination field");
        this.common_descriptions.put("suffix", "Added to end of data if it is written to destination field");
        this.common_descriptions.put("mandatory", "Value which must be in the extracted data");
        this.common_descriptions.put("exclusion", "Value which must NOT be in the extracted data");
        this.tooltip_label.setFont(new Font("SansSerif", 1, 12));
        this.help_information.setEditable(false);
        this.help_information.setWrapStyleWord(true);
        this.help_information.setLineWrap(true);
        this.help_information.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "General Information"));
        this.help_information.setForeground(Color.blue);
        this.setButtonValue(this.apply, " apply ", "Click to use changes in program");
        this.setButtonValue(this.cancel, " cancel ", "Click to remove window without using any changes");
        this.setButtonValue(this.duplicate, " duplicate ", "Click to copy selected line in display");
        this.setButtonValue(this.insert, " insert ", "Click to insert empty line in display");
        this.setButtonValue(this.remove, " remove ", "Click to remove line from display");
        this.setButtonValue(this.no, " no ", "Click to reject");
        this.setButtonValue(this.okay, " okay ", "Click to accept");
        this.setButtonValue(this.yes, " yes ", "Click to select");
        this.source_panel = new JPanel();
        this.source_panel.setLayout(new BorderLayout());
        this.source_field.setEditable(false);
        this.source_field_scroll.getViewport().add(this.source_field);
        this.source_field_scroll.setHorizontalScrollBarPolicy(31);
        this.source_field_scroll.setVerticalScrollBarPolicy(20);
        this.setButtonValue(this.use_selected_button, "Use highlighted text ", "Puts any text highlighted into the field as the value");
        this.use_selected_button.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ConfigDialog.this.display_table.getSelectedRow();
                int n2 = ConfigDialog.this.display_table.getSelectedColumn();
                String string = ConfigDialog.this.source_field.getSelectedText();
                if (string != null) {
                    ConfigDialog.this.display_table.setValueAt(string, n, n2);
                    ConfigDialog.this.display_table.updateValues();
                    ConfigDialog.this.display_table.redraw();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.yes.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.yes.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.dialog.dispose();
                ConfigDialog.this.yes.setBorder(ConfigDialog.this.button_border_unpressed);
                ConfigDialog.this.is_yes_flag = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.no.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.no.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.dialog.dispose();
                ConfigDialog.this.no.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.okay.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.okay.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.dialog.dispose();
                ConfigDialog.this.okay.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.remove.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.remove.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.display_table.remove();
                ConfigDialog.this.remove.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.insert.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.insert.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.display_table.insert(false);
                ConfigDialog.this.display_table.showAll();
                ConfigDialog.this.display_table.populateTable(null);
                if (ConfigDialog.this.filter.isSelected()) {
                    ConfigDialog.this.filter.setSelected(false);
                }
                ConfigDialog.this.insert.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.duplicate.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.duplicate.setBorder(ConfigDialog.this.button_border_pressed);
                int n = ConfigDialog.this.display_table.getSelectedColumn();
                int n2 = ConfigDialog.this.display_table.getSelectedRow();
                ConfigDialog.this.display_table.insert(true);
                ConfigDialog.this.display_table.updateValues();
                ConfigDialog.this.display_table.showAll();
                ConfigDialog.this.display_table.populateTable(null);
                if (ConfigDialog.this.filter.isSelected()) {
                    ConfigDialog.this.filter.setSelected(false);
                }
                ConfigDialog.this.duplicate.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.apply.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.apply.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.display_table.updateValues();
                returned_data = ConfigDialog.this.display_table.getValues();
                ConfigDialog.this.apply.setBorder(ConfigDialog.this.button_border_unpressed);
                ConfigDialog.this.dialog.dispose();
                ConfigDialog.this.may_be_changed = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.cancel.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.cancel.setBorder(ConfigDialog.this.button_border_pressed);
                ConfigDialog.this.dialog.dispose();
                ConfigDialog.this.cancel.setBorder(ConfigDialog.this.button_border_unpressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.filter_panel.setLayout(new FlowLayout(1, 10, 1));
        this.filter_panel.setFloatable(false);
        this.filter_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.is_user_section) {
            this.filter_panel.add((Component)this.filter, "Center");
        }
        this.filter_panel.add(this.further_help);
        this.filter.setText("Filter on selected cell");
        this.filter.setToolTipText("Displays only rows matching text in selected cell");
        this.filter.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.display_table.updateValues();
                if (!ConfigDialog.this.filter.isSelected()) {
                    ConfigDialog.this.display_table.showAll();
                    ConfigDialog.this.display_table.populateTable(null);
                } else {
                    boolean bl = ConfigDialog.this.display_table.filterOnSelectedCell();
                    if (!bl) {
                        ConfigDialog.this.filter.setSelected(false);
                    }
                    ConfigDialog.this.display_table.populateTable(null);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.further_help.setText("Display further help");
        this.further_help.setToolTipText("Displays further help on commands");
        this.further_help.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.displayFurtherInfoPanel();
                if (ConfigDialog.this.further_help.isSelected()) {
                    ConfigDialog.this.addFurtherHelp();
                } else {
                    ConfigDialog.this.removeFurtherHelp();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.bottom_panel.setLayout(new BorderLayout());
    }

    public final void initDisplay(int n, HashMap hashMap, String string, List list) {
        Serializable serializable;
        returned_data = null;
        this.display_table = new PopulatedTable(n, this.is_user_section, this.dialog_width, headings, this.section, hashMap, list);
        this.display_table.getTable().addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigDialog.this.displayFurtherInfoPanel();
                ConfigDialog.this.dialog.repaint();
                ConfigDialog.this.table_contents.validate();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.client_values = new JTabbedPane();
        this.buttons = this.getToolbar();
        if (this.section.indexOf("client_parameters") == -1) {
            this.table_contents.add((Component)this.filter_panel, "North");
            this.table_contents.add((Component)this.display_table, "Center");
            this.bottom_panel.add((Component)this.buttons, "North");
            this.table_contents.add((Component)this.bottom_panel, "South");
        } else {
            serializable = new JPanel();
            serializable.setLayout(new BorderLayout());
            this.display_table.setHorizontalScrollBarPolicy(30);
            serializable.setLayout(new BorderLayout());
            serializable.add(this.display_table, "Center");
            serializable.add(this.buttons, "South");
            this.client_values.addTab("Main", (Component)serializable);
            this.client_values.addTab("Color", ClientData.getColorPanel(false));
            this.client_values.addTab("Pdf Color", ClientData.getColorPanel(true));
            this.table_contents.add((Component)this.client_values, "Center");
            this.table_contents.add((Component)ClientData.getFeelPanel(), "North");
        }
        this.dialog = new JDialog(ClientStandard.main_frame, string, true);
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((((Dimension)serializable).width - this.dialog_width) / 2, (((Dimension)serializable).height - this.dialog_height) / 2);
        this.dialog.getContentPane().add(this.table_contents);
        this.dialog.setSize(this.dialog_width, this.dialog_height);
        this.dialog.addComponentListener(new ComponentListener(){

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                componentEvent.getComponent().transferFocus();
            }

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                int n = component.getHeight();
                int n2 = component.getWidth();
                if (n < ConfigDialog.this.dialog_height) {
                    n = ConfigDialog.this.dialog_height;
                }
                if (n2 < ConfigDialog.this.dialog_width) {
                    n2 = ConfigDialog.this.dialog_width;
                }
                component.setSize(n2, n);
                ConfigDialog.this.dialog.validate();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    public final void showGraphicArea(int n, int n2, boolean bl, BufferedImage bufferedImage) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.panes = new JTabbedPane();
        JButton jButton = new JButton("Save");
        jButton.setToolTipText("Save text/image as file");
        this.panes.addTab("Selected Area with Text", this.getImagePanel(bufferedImage));
        jPanel.add((Component)this.panes, "Center");
        jPanel.setToolTipText("Image can be saved to local drive/database");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.setLayout(new BorderLayout());
        this.buttons.setFloatable(false);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.add((Component)jButton, "East");
        jButton.addActionListener(new saveItem(bl, this.panes, bufferedImage));
        jPanel.add((Component)this.buttons, "South");
        this.dialog = new JDialog(ClientStandard.main_frame, "Graphics in selected area", true);
        this.dialog.setSize(n, n2);
        this.dialog.setResizable(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.dialog.addComponentListener(new ComponentListener(){

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                componentEvent.getComponent().transferFocus();
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.dialog.getContentPane().add(jPanel);
        this.dialog.show();
    }

    public final void showDialog() {
        this.dialog.show();
    }

    public final void showField(int n, String string, String string2, int n2, int n3, boolean bl, String[] stringArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Save");
        String string3 = "Field data";
        string3 = string3 + " - text data can be selected with mouse and Ctrl-C";
        String string4 = "";
        jButton.setToolTipText("Save text/image as file");
        string4 = "Text and images can be saved to local drive";
        this.format_pane = this.createPane(string4, string2, bl, true);
        this.raw_pane = this.createPane(string4, string, bl, false);
        JScrollPane jScrollPane = this.addScrollPane(this.format_pane);
        JScrollPane jScrollPane2 = this.addScrollPane(this.raw_pane);
        if (n != 24) {
            this.panes.addTab("Text", jScrollPane);
        }
        if (n != 23) {
            this.panes.addTab("XHTML", jScrollPane2);
        }
        if (stringArray[0].length() > 1) {
            this.raw_image = ObjectStore.loadStoredImage("R" + stringArray[0]);
            this.clipped_image = ObjectStore.loadStoredImage(stringArray[0]);
            this.panes.addTab(stringArray[0], this.getImagePanel(stringArray[0], this.clipped_image));
            this.panes.addTab("RAW image-" + stringArray[0], this.getImagePanel("R" + stringArray[0], this.raw_image));
        }
        jPanel.add((Component)this.panes, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.setLayout(new BorderLayout());
        this.buttons.setFloatable(false);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.add((Component)jButton, "East");
        jButton.addActionListener(new saveItem(n, bl, this.panes, string, string2, stringArray[0], "R" + stringArray[0]));
        jPanel.add((Component)this.buttons, "South");
        this.dialog = new JDialog(ClientStandard.main_frame, string3, true);
        this.dialog.setSize(n2, n3);
        this.dialog.setResizable(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension.width - n2) / 2, (dimension.height - n3) / 2);
        this.dialog.addComponentListener(new ComponentListener(){

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                componentEvent.getComponent().transferFocus();
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.dialog.getContentPane().add(jPanel);
        this.dialog.show();
    }

    public final HashMap returnShortcuts() {
        return this.display_table.returnShortcuts();
    }

    private final JScrollPane addScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(component);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        return jScrollPane;
    }

    private final void addFurtherHelp() {
        this.bottom_panel.add((Component)this.source_panel, "Center");
        this.table_contents.validate();
    }

    private final String replaceTokens(String string) {
        int n = string.indexOf("%%");
        if (n != -1) {
            String string2 = string.substring(n + 2, string.length());
            string = string.substring(0, n);
            string = (String)this.common_descriptions.get(string2);
        }
        return string;
    }

    private final BufferedImage doctorImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        String string = "DEMO";
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Font font = new Font("Lucida", 1, 12);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        Shape shape = glyphVector.getOutline();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, n2 / 2);
        affineTransform.scale((double)n / shape.getBounds().getWidth(), (double)n2 / (2.0 * shape.getBounds().getHeight()));
        Shape shape2 = affineTransform.createTransformedShape(shape);
        graphics2D.setColor(Color.red);
        graphics2D.fill(shape2);
        BufferedImage bufferedImage3 = bufferedImage2.getSubimage(0, 0, n, n2);
        return bufferedImage3;
    }

    private final void setSourcePanel(String string, String string2) {
        this.source_panel.removeAll();
        int n = -1;
        StoryList storyList = new StoryList();
        storyList.story_list.addMouseListener(new story_mouse_listener());
        storyList.story_list.setToolTipText("Click on  a value to make it the selected field");
        String string3 = "--POSSIBLE VALUES--";
        Iterator iterator = this.fields.keySet().iterator();
        int n2 = this.fields.keySet().size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (String)iterator.next();
            if (stringArray[n3].length() > string3.length()) {
                string3 = stringArray[n3];
            }
            ++n3;
        }
        stringArray = OneItemSort.sort(stringArray);
        storyList.story_list.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Possible Values"));
        storyList.setPrototypeCellValue(string3);
        int n4 = 0;
        while (n4 < n2) {
            if (stringArray[n4].compareTo(string2) == 0) {
                n = n4;
            }
            storyList.addStory(stringArray[n4]);
            ++n4;
        }
        if (n != -1) {
            storyList.selectStory(n);
        }
        this.help_information.setText("\n" + string + "\n\nClick on a field from the list on RIGHT >> \nto select a field " + " - or type the name of a field into the chosen field.\n");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.help_information);
        this.source_panel.add((Component)jScrollPane, "Center");
        this.source_panel.add((Component)storyList, "East");
        this.source_panel.validate();
    }

    private final JScrollPane getImagePanel(BufferedImage bufferedImage) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        IconiseImage iconiseImage = new IconiseImage(bufferedImage);
        if (bufferedImage != null) {
            jPanel.add((Component)new JLabel(iconiseImage), "Center");
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jPanel);
        return jScrollPane;
    }

    private final JScrollPane getImagePanel(String string, BufferedImage bufferedImage) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (string.length() > 0) {
            object = new IconiseImage(bufferedImage);
            if (bufferedImage != null) {
                jPanel.add((Component)new JLabel((Icon)object), "Center");
            }
        }
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jPanel);
        return object;
    }

    private final void saveImage(boolean bl, String string, boolean bl2, SQL sQL, String string2, String string3, BufferedImage bufferedImage) {
        boolean bl3 = false;
        String string4 = this.panes.getTitleAt(this.panes.getSelectedIndex());
        try {
            if (bufferedImage == null) {
                if (string4.equals(string3)) {
                    bufferedImage = this.clipped_image;
                } else if (string4.indexOf(string3) != -1) {
                    bufferedImage = this.raw_image;
                }
            }
            if (!bl) {
                bufferedImage = this.doctorImage(bufferedImage);
            }
            if (bl2) {
                String string5 = this.temp_dir + TimeNow.getShortTimeNow() + ".png";
                ObjectStore.saveStoredImage(string5, bufferedImage, ".png");
                FileInputStream fileInputStream = new FileInputStream(string5);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                boolean bl4 = sQL.writeImage(string2, byteArrayOutputStream.toByteArray());
                if (!bl4) {
                    ShowGUIMessage.showGUIMessage("Unable to save image to database as " + string2, "Image data NOT saved");
                }
                byteArrayOutputStream.close();
                fileInputStream.close();
                File file = new File(string5);
                file.delete();
            } else {
                bl3 = ObjectStore.saveStoredImage(string2, bufferedImage, string);
                if (bl3) {
                    ShowGUIMessage.showGUIMessage("Please use JPEG format to save this image", "Image NOT Saved");
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            ShowGUIMessage.showGUIMessage("Insufficient memory to process and save clip", "Memory warning");
        }
        catch (Exception exception) {
            ShowGUIMessage.showGUIMessage("Exception " + exception, "Exception warning");
        }
    }

    private final void setGenericPanel(String string) {
        this.source_panel.removeAll();
        this.help_information.setText("\n" + string + "\n");
        this.source_panel.add((Component)this.help_information, "South");
    }

    private final JToolBar getToolbar() {
        this.buttons.setLayout(new FlowLayout(1, 10, 1));
        this.buttons.setFloatable(false);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.add(this.apply);
        this.apply.setBorder(this.button_border_unpressed);
        this.buttons.add(this.cancel);
        this.cancel.setBorder(this.button_border_unpressed);
        if (ConfigurationData.isDefaultUserSection(this.section)) {
            this.buttons.add(this.remove);
            this.remove.setBorder(this.button_border_unpressed);
            this.buttons.add(this.insert);
            this.insert.setBorder(this.button_border_unpressed);
            this.buttons.add(this.duplicate);
            this.duplicate.setBorder(this.button_border_unpressed);
        }
        return this.buttons;
    }

    private final void setDataPanel(String string, String string2) {
        this.source_panel.removeAll();
        String string3 = "";
        int n = 0;
        int n2 = string2.length();
        int n3 = this.display_table.getSelectedRow();
        if (n2 > 0) {
            String string4 = this.display_table.getValueAt(n3, 1).trim();
            if (this.selected_story == -1) {
                this.source_field.setText("If a story is selected, raw data from the appropriate field appears here");
                this.source_field.setForeground(Color.blue);
            } else {
                string3 = this.current_data.getField("RAW_" + string4, this.selected_story);
                this.source_field.setText(string3);
                this.source_field.setForeground(Color.black);
                while ((n = string3.indexOf(string2, n)) != -1) {
                    this.source_field.setCaretPosition(n + 1);
                    this.source_field.moveCaretPosition(n += n2);
                }
            }
        }
        this.help_information.setText(string + " \nSelected data can be used as a value ");
        this.source_panel.add((Component)this.help_information, "South");
        this.source_panel.add((Component)this.source_field_scroll, "Center");
        if (this.selected_story != -1) {
            this.source_panel.add((Component)this.use_selected_button, "North");
        }
    }

    private final void saveText(int n, boolean bl, String string, boolean bl2, boolean bl3, SQL sQL, String string2, String string3) {
        block11: {
            block9: {
                block10: {
                    if (!bl3) break block9;
                    if (sQL != null) break block10;
                    ShowGUIMessage.showGUIMessage("Database not setup", "Database error");
                    break block11;
                }
                boolean bl4 = sQL.writeText(string2, string);
                if (bl4) break block11;
                ShowGUIMessage.showGUIMessage("Unable to save to database as " + string2, "Text data NOT saved");
                break block11;
            }
            try {
                if (!string2.toLowerCase().endsWith("." + string3)) {
                    string2 = string2 + "." + string3;
                }
                OutputStreamWriter outputStreamWriter = bl ? new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-16") : (bl2 ? new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8") : new OutputStreamWriter((OutputStream)new FileOutputStream(string2), System.getProperty("file.encoding")));
                if (n == 24) {
                    outputStreamWriter.write("<HTML>\n<BODY><!-- Table exported from Storypad -->\n");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("</HTML>\n");
                } else if (bl2) {
                    if (bl) {
                        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n\n");
                    } else {
                        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                    }
                    outputStreamWriter.write("<ARTICLE title=\"Exported content\">\n");
                    outputStreamWriter.write("\n<!-- Content exported from Storypad -->\n");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("\n\n</ARTICLE>\n");
                } else {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                ShowGUIMessage.showGUIMessage("Exception " + exception + " in writing file", "Output text data");
            }
        }
    }

    private final JLabel getTooltipLabel(int n) {
        int n2 = headings[n - 1].indexOf("|") + 1;
        int n3 = headings[n - 1].indexOf("|", n2);
        if (n3 < 1) {
            n3 = headings[n - 1].length();
        }
        String string = headings[n - 1].substring(n2, n3);
        this.tooltip_label.setText(string);
        return this.tooltip_label;
    }

    private final void removeFurtherHelp() {
        this.bottom_panel.removeAll();
        this.bottom_panel.add((Component)this.buttons, "North");
        this.table_contents.validate();
    }

    private final void displayFurtherInfoPanel() {
        String string = "";
        int n = this.display_table.getSelectedColumn();
        int n2 = this.display_table.getSelectedRow();
        if (n > 0) {
            int n3 = headings[n - 1].indexOf("|");
            string = this.display_table.getValueAt(n2, n);
            n3 = headings[n - 1].lastIndexOf("|") + 1;
            int n4 = headings[n - 1].indexOf("-", n3) + 1;
            if (n4 < 1) {
                n4 = headings[n - 1].length();
            }
            String string2 = headings[n - 1].substring(n3, headings[n - 1].length()).trim();
            String string3 = this.replaceTokens(headings[n - 1].substring(n4, headings[n - 1].length()).trim());
            if (string2.startsWith("FIELD")) {
                this.setSourcePanel(string3, string);
            } else if (string2.startsWith("DATA")) {
                this.setDataPanel(string3, string);
            } else {
                this.setGenericPanel(string3);
            }
        } else {
            this.setGenericPanel(this.descriptor + "\n\nClick in a cell for more information on specific value");
        }
    }

    private final void setButtonValue(JButton jButton, String string, String string2) {
        jButton.setText(string);
        jButton.setToolTipText(string2);
        jButton.setFont(this.button_font);
        jButton.setBorder(this.button_border_unpressed);
    }

    public final JTextPane createPane(String string, String string2, boolean bl, boolean bl2) {
        String string3 = "";
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(true);
        jTextPane.setFont(new Font("Lucida", 0, 14));
        jTextPane.setEnabled(bl);
        jTextPane.setToolTipText(string);
        Document document = jTextPane.getDocument();
        jTextPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Extracted Data"));
        jTextPane.setForeground(Color.black);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setForeground(simpleAttributeSet2, Color.black);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "<>", true);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("<") & stringTokenizer.hasMoreTokens()) {
                    String string5 = string4 + stringTokenizer.nextToken() + stringTokenizer.nextToken();
                    if (string5.startsWith("<FONT")) {
                        string3 = Fonts.extractFontName(string5);
                        int n2 = Fonts.extractFontSize(string5);
                    }
                    if (bl2 || string5.indexOf("FONT_SIZE") != -1) continue;
                    document.insertString(n, string5, simpleAttributeSet);
                    n += string5.length();
                    continue;
                }
                document.insertString(n, string4, simpleAttributeSet2);
                n += string4.length();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("exception in pane " + exception);
        }
        return jTextPane;
    }

    private class story_mouse_listener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = ConfigDialog.this.display_table.getSelectedRow();
            int n2 = ConfigDialog.this.display_table.getSelectedColumn();
            Object e = ((JList)mouseEvent.getSource()).getSelectedValue();
            ConfigDialog.this.display_table.setValueAt(e, n, n2);
            ConfigDialog.this.display_table.redraw();
        }
    }

    class saveItem
    implements ActionListener {
        private JTabbedPane panes;
        private int table_type = -1;
        private BufferedImage image2 = null;
        private String raw_text = null;
        private String formatted_text = null;
        private String image_name = "";
        private String raw_image_name = "";
        private boolean can_save = false;

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            JFileChooser jFileChooser = new JFileChooser(DecoderPaths.user_dir);
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            SQL sQL = null;
            String string = "png";
            String string2 = this.panes.getTitleAt(this.panes.getSelectedIndex());
            String[] stringArray = new String[]{"csv", "csv"};
            String[] stringArray2 = new String[]{"htm", "html"};
            String[] stringArray3 = new String[]{"txt", "html"};
            String[] stringArray4 = new String[]{"xml", "xml"};
            String[] stringArray5 = new String[]{"Database export"};
            String[] stringArray6 = new String[]{"jpeg", "jpg"};
            String[] stringArray7 = new String[]{"png", "png"};
            String[] stringArray8 = new String[]{"tiff", "tif"};
            if (!this.can_save) {
                ShowGUIMessage.showGUIMessage("Demo will save data with limitations:-\n1.Words will be removed from Text in output files\n2.Text cannot be copied from popup window\n3.Images will be overprinted with the word DEMO", "Demo limitations");
            }
            jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray5, "MySQL"));
            jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray5, "PostgreSQL"));
            if (string2.equals("Text") | string2.equals("XHTML")) {
                if (this.table_type == 23) {
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "CSV file/Unicode XML Text (*.csv)"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "CSV file/Plain Text (*.csv)"));
                } else if (this.table_type == 24) {
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "HTML file/Unicode Text (*.html)"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "HTML file/Plain Text (*.html)"));
                } else {
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray4, "Unicode XML Text (*.xml)"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Unicode Plain Text (*.txt)"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray4, "XML Text (*.xml)"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Plain Text (*.txt)"));
                }
                bl2 = false;
            } else {
                jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray6, "Images (*.jpg ,*.jpeg)"));
                jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray8, "Images (*.tif ,*.tif)"));
                jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray7, "Images (*.png ,*.png)"));
            }
            int n = jFileChooser.showSaveDialog(ClientStandard.main_frame);
            if (n == 0) {
                String string3 = jFileChooser.getFileFilter().getDescription();
                String string4 = jFileChooser.getSelectedFile().getPath();
                if (string3.indexOf("tif") != -1) {
                    string = "tif";
                } else if (this.table_type == 24) {
                    if (!string2.equals("Text")) {
                        string = "html";
                    } else {
                        string = "txt";
                        this.table_type = -1;
                        ShowGUIMessage.showGUIMessage("To save a table with formatting select the XHTML tab", "Table saved as text file");
                    }
                } else if (this.table_type == 23) {
                    string = "csv";
                } else if (string3.indexOf("jpg") != -1) {
                    string = "jpg";
                    if (ConfigDialog.this.clipped_image != null) {
                        ConfigDialog.this.clipped_image = ObjectStore.convertToRGB(ConfigDialog.this.clipped_image);
                    }
                } else if (string3.indexOf("png") != -1) {
                    string = "png";
                } else if (string3.indexOf("txt") != -1) {
                    string = "txt";
                } else if (string3.indexOf("xml") != -1) {
                    string = "xml";
                    bl4 = true;
                } else if (string3.indexOf("MySQL") != -1) {
                    string = "MySQL";
                    bl3 = true;
                    sQL = ConfigDialog.this.MySQL_output;
                    string4 = jFileChooser.getSelectedFile().getName();
                } else if (string3.indexOf("Postgre") != -1) {
                    string = "Postgre";
                    bl3 = true;
                    sQL = ConfigDialog.this.Postgre_output;
                    string4 = jFileChooser.getSelectedFile().getName();
                }
                if (string3.indexOf("Uni") != -1) {
                    bl = true;
                }
                if (bl2) {
                    ConfigDialog.this.saveImage(this.can_save, string, bl3, sQL, string4, this.image_name, this.image2);
                } else {
                    String string5 = string2.equals("Text") ? ConfigDialog.this.format_pane.getText() : ConfigDialog.this.raw_pane.getText();
                    ConfigDialog.this.saveText(this.table_type, bl, string5, bl4, bl3, sQL, string4, string);
                }
            }
        }

        public saveItem(int n, boolean bl, JTabbedPane jTabbedPane, String string, String string2, String string3, String string4) {
            this.can_save = bl;
            this.panes = jTabbedPane;
            this.raw_text = string;
            this.formatted_text = string2;
            this.image_name = string3;
            this.raw_image_name = string4;
            this.table_type = n;
        }

        public saveItem(boolean bl, JTabbedPane jTabbedPane, BufferedImage bufferedImage) {
            this.can_save = bl;
            this.panes = jTabbedPane;
            this.image2 = bufferedImage;
        }
    }
}

