/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.gui;

import com.idrsolutions.storypad.objects.ConfigurationDefault;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.repositories.Vector_boolean;

public class PopulatedTable
extends JScrollPane {
    public static int highlight_row = -1;
    public static int active_table = 0;
    protected List config_values;
    private Vector_boolean line_is_hidden;
    private int total_columns = 0;
    private int dialog_width;
    private int max_tables = 4;
    private JTable[] current_table = new JTable[this.max_tables];
    private int license_level = 3;
    private JTable title = new JTable();
    private String[] tooltips;
    private HashMap shortcuts;
    private int[] min_widths;
    private int data_lines;
    private boolean values_hidden = false;
    private int last_row = 0;
    private HashMap new_shortcuts = new HashMap();
    private final Font tablefont = new Font("SansSerif", 0, 10);
    private final Font headerfont = new Font("SansSerif", 1, 12);
    private static String[] headings;
    private static String[] header_tooltips;
    private static String prefix;
    private static boolean is_user_section;
    private static String section;

    public PopulatedTable(int n, boolean bl, int n2, String[] stringArray, String string, HashMap hashMap, List list) {
        this.license_level = n;
        section = string;
        this.config_values = list;
        this.dialog_width = n2;
        this.total_columns = 1 + stringArray.length;
        this.data_lines = list.size();
        this.shortcuts = hashMap;
        is_user_section = bl;
        headings = new String[this.total_columns];
        header_tooltips = new String[this.total_columns];
        String string2 = "";
        int n3 = 0;
        while (n3 < this.total_columns) {
            int n4;
            string2 = n3 == 0 ? "ID" : stringArray[n3 - 1];
            int n5 = string2.indexOf("|", (n4 = string2.indexOf("|")) + 1);
            if (n5 == -1) {
                n5 = string2.length();
            }
            if (n4 != -1) {
                PopulatedTable.header_tooltips[n3] = string2.substring(n4 + 1, n5);
                PopulatedTable.headings[n3] = string2.substring(0, n4);
            } else {
                PopulatedTable.header_tooltips[n3] = "";
                PopulatedTable.headings[n3] = string2;
            }
            ++n3;
        }
        this.line_is_hidden = new Vector_boolean(this.data_lines);
        this.populateTable(null);
    }

    public final void addValue(Element element) {
        this.config_values.add(element);
        ++this.data_lines;
    }

    public final int getRowCount() {
        return this.current_table[active_table].getRowCount();
    }

    public final int getSelectedRow() {
        return this.current_table[active_table].getSelectedRow();
    }

    public final HashMap returnShortcuts() {
        return this.new_shortcuts;
    }

    public final void redraw() {
        this.resizeColumns(this.dialog_width - 10);
    }

    public final int getSelectedColumn() {
        return this.current_table[active_table].getSelectedColumn();
    }

    protected final int getRowsNeeded() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.data_lines) {
            if (!this.line_is_hidden.elementAt(n2)) {
                ++n;
            }
            ++n2;
        }
        if (n == 0 & !is_user_section) {
            n = 6;
        }
        return n;
    }

    protected final void setValueAt(Object object, int n, int n2) {
        this.current_table[active_table].setValueAt(object, n, n2);
    }

    protected final void filterByRow(int[] nArray) {
        this.showAll();
        int n = 0;
        while (n < nArray.length) {
            this.line_is_hidden.setElementAt(false, nArray[n]);
            ++n;
        }
        this.values_hidden = true;
    }

    protected final void remove() {
        int n = this.current_table[active_table].getSelectedRow();
        if (n != -1) {
            int n2 = Integer.parseInt(this.getValueAt(n, 0));
            this.config_values.remove(n2);
            this.line_is_hidden.removeElementAt(n2);
            --this.data_lines;
            Rectangle rectangle = this.current_table[active_table].getVisibleRect();
            this.populateTable(rectangle);
        } else {
            ShowGUIMessage.showGUIMessage("Please select a row", "No row selected");
        }
    }

    protected final void selectCell(int n, int n2) {
        this.current_table[active_table].setRowSelectionInterval(n, n);
        this.current_table[active_table].setColumnSelectionInterval(n2, n2);
    }

    protected final void showNone() {
        int n = 0;
        while (n < this.data_lines) {
            this.line_is_hidden.setElementAt(true, n);
            ++n;
        }
        this.values_hidden = true;
    }

    protected final void populateTable(Rectangle rectangle) {
        int n;
        this.tooltips = new String[this.getRowsNeeded()];
        boolean bl = false;
        boolean bl2 = true;
        this.min_widths = this.createHeaders(this.total_columns, headings);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.getViewport().add(jPanel);
        this.setHorizontalScrollBarPolicy(30);
        this.title = new JTable(1, this.total_columns);
        this.title.setBackground(Color.lightGray);
        this.title.setFont(this.headerfont);
        int n2 = 0;
        while (n2 < this.total_columns) {
            this.title.setValueAt(headings[n2], 0, n2);
            ++n2;
        }
        jPanel.add(this.title);
        int[] nArray = new int[this.max_tables + 1];
        if (is_user_section) {
            nArray[0] = this.data_lines;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
        } else {
            nArray[0] = ConfigurationDefault.getUserNonBooleanCount(section);
            nArray[1] = ConfigurationDefault.getUserBooleanCount(section);
            nArray[2] = ConfigurationDefault.getEnterpriseNonBooleanCount(section);
            nArray[3] = ConfigurationDefault.getEnterpriseBooleanCount(section);
        }
        int n3 = nArray[0] + nArray[1] + nArray[2] + nArray[3];
        Object[][][] objectArray = this.getDataAsTables(n3, this.total_columns, bl2);
        int n4 = 0;
        while (n4 < this.max_tables) {
            n = nArray[n4];
            if (n3 == 0 & !this.values_hidden & n4 == 0) {
                n3 = 6;
                nArray[0] = 6;
                n = 6;
            } else if (n > this.getRowsNeeded()) {
                n = this.getRowsNeeded();
            }
            Object[][] objectArray2 = new Object[n][this.total_columns];
            int n5 = 0;
            while (n5 < n) {
                int n6 = 0;
                while (n6 < this.total_columns) {
                    String string;
                    Object object = objectArray[n4][n5][n6];
                    if (object == null) {
                        object = "";
                    }
                    if ((string = ((String)object).toLowerCase().trim()).length() == 4 && string.indexOf("true") != -1) {
                        object = Boolean.TRUE;
                    } else if (string.length() == 5 && string.indexOf("false") != -1) {
                        object = Boolean.FALSE;
                    }
                    objectArray2[n5][n6] = object;
                    ++n6;
                }
                ++n5;
            }
            this.current_table[n4] = new JTable(new NewTableModel(n, this.total_columns, objectArray2, headings));
            this.current_table[n4].setSelectionMode(0);
            this.current_table[n4].setFont(this.tablefont);
            this.current_table[n4].setAutoResizeMode(0);
            if (this.license_level > 2 | n4 < 2) {
                jPanel.add(this.current_table[n4]);
            }
            ++n4;
        }
        this.resizeColumns(this.dialog_width - 20);
        n = 0;
        while (n < this.max_tables) {
            this.current_table[n].addMouseListener(new MyTableListener(this.current_table, n));
            ++n;
        }
        if (rectangle != null) {
            jPanel.scrollRectToVisible(rectangle);
        }
        this.validate();
    }

    protected final void highlightRow(int n) {
        highlight_row = n;
    }

    protected final String getValueAt(int n, int n2) {
        String string = "";
        Object object = this.current_table[active_table].getValueAt(n, n2);
        if (object instanceof String) {
            string = ((String)object).trim();
        } else if (object instanceof Boolean) {
            string = object.equals(Boolean.TRUE) ? "true" : "false";
        }
        return string;
    }

    protected final JTable getTable() {
        return this.current_table[active_table];
    }

    protected final void showAll() {
        int n = 0;
        while (n < this.line_is_hidden.size()) {
            this.line_is_hidden.setElementAt(false, n);
            ++n;
        }
        this.values_hidden = false;
    }

    protected final boolean filterOnSelectedCell() {
        boolean bl = false;
        int n = this.current_table[active_table].getSelectedRow();
        int n2 = this.current_table[active_table].getSelectedColumn();
        int n3 = active_table;
        if (n == -1 | n2 == -1) {
            ShowGUIMessage.showGUIMessage("A cell must be selected for filter", "No cell selected");
        } else {
            bl = true;
            Object object = this.current_table[active_table].getValueAt(n, n2);
            if (object instanceof String) {
                String string = (String)object;
                int n4 = 0;
                while (n4 < 4) {
                    active_table = n4++;
                    this.filterOnValue(string.trim(), n2);
                }
                active_table = n3;
            }
        }
        return bl;
    }

    protected final void clearSelection() {
        this.current_table[active_table].clearSelection();
    }

    protected final void resizeColumns(int n, JTable jTable) {
        TableColumn tableColumn;
        int n2 = 0;
        int n3 = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int[] nArray = new int[this.total_columns];
        TableColumn tableColumn2 = tableColumnModel.getColumn(0);
        tableColumn2.setPreferredWidth(10);
        int n4 = 0;
        while (n4 < this.total_columns) {
            tableColumn = tableColumnModel.getColumn(n4);
            nArray[n4] = n2 = this.widestCellInCol(tableColumn) + 2;
            n3 += n2;
            ++n4;
        }
        int n5 = n - n3;
        if (n > n3) {
            nArray[this.total_columns - 1] = nArray[this.total_columns - 1] + n5 - 1;
            this.setHorizontalScrollBarPolicy(31);
        } else {
            this.setHorizontalScrollBarPolicy(30);
        }
        int n6 = 0;
        while (n6 < this.total_columns) {
            tableColumn = tableColumnModel.getColumn(n6);
            tableColumn.setPreferredWidth(nArray[n6]);
            ++n6;
        }
    }

    protected final void updateValues() {
        int n = this.getRowCount();
        int n2 = headings.length;
        String string = "";
        this.new_shortcuts = new HashMap();
        String string2 = "";
        String string3 = "";
        Element element = null;
        int n3 = this.config_values.size();
        int n4 = 0;
        while (n4 < 4) {
            active_table = n4;
            int n5 = 0;
            while (n5 < this.current_table[n4].getRowCount()) {
                string = this.getValueAt(n5, 0);
                if (string.length() > 0) {
                    int n6 = Integer.parseInt(string);
                    string2 = (String)this.current_table[n4].getValueAt(n5, 1);
                    if (string2.length() > 0) {
                        if (!is_user_section) {
                            element = new Element("Setting");
                            this.new_shortcuts.put(string2.trim(), this.getValueAt(n5, 3));
                            element.setAttribute(this.getValueAt(n5, 1), this.getValueAt(n5, 2));
                            element.setAttribute("Comment", this.getValueAt(n5, 4));
                        } else {
                            element = new Element("Rule");
                            int n7 = 1;
                            while (n7 < n2) {
                                element.setAttribute(headings[n7], this.getValueAt(n5, n7));
                                ++n7;
                            }
                        }
                        if (n3 == 0 | n6 > this.config_values.size()) {
                            this.config_values.add(element);
                        } else {
                            this.config_values.set(n6, element);
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        active_table = 0;
    }

    protected final void insert(boolean bl) {
        int n = this.current_table[active_table].getSelectedRow();
        Rectangle rectangle = this.current_table[active_table].getVisibleRect();
        if (n != -1) {
            this.updateValues();
            int n2 = Integer.parseInt(this.getValueAt(n, 0));
            Element element = (Element)this.config_values.get(n2);
            Element element2 = new Element("Rule");
            int n3 = 1;
            while (n3 < headings.length) {
                String string = bl ? element.getAttributeValue(headings[n3]) : ConfigurationDefault.getDefaultCellValue(headings[n3]);
                element2.setAttribute(headings[n3], string);
                ++n3;
            }
            this.config_values.add(n2, element2);
            this.line_is_hidden.insertElementAt(false, n2);
            ++this.data_lines;
            this.populateTable(rectangle);
        } else {
            ShowGUIMessage.showGUIMessage("Please select a row", "No row selected");
        }
    }

    protected final void filterOnValue(String string, int n) {
        if (is_user_section) {
            this.showNone();
            int n2 = 0;
            while (n2 < this.data_lines) {
                Element element = (Element)this.config_values.get(n2);
                String string2 = element.getAttributeValue(headings[n]);
                if (string2.indexOf(string) != -1) {
                    this.line_is_hidden.setElementAt(false, n2);
                }
                ++n2;
            }
            this.values_hidden = true;
        }
    }

    protected final List getValues() {
        return this.config_values;
    }

    protected final void resizeColumns(int n) {
        int n2 = 0;
        while (n2 < 4) {
            this.resizeColumns(n, this.current_table[n2]);
            ++n2;
        }
        this.resizeColumns(n, this.title);
    }

    private final int widestCellInCol(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        int n2 = 0;
        int n3 = this.min_widths[n];
        int n4 = 0;
        while (n4 < 4) {
            active_table = n4;
            int n5 = 0;
            while (n5 < this.current_table[n4].getRowCount()) {
                TableCellRenderer tableCellRenderer = this.current_table[n4].getCellRenderer(n5, n);
                if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.current_table[n4], this.current_table[n4].getValueAt(n5, n), false, false, n5, n);
                    n2 = component.getPreferredSize().width;
                    n3 = n2 > n3 ? n2 : n3;
                }
                ++n5;
            }
            ++n4;
        }
        active_table = 0;
        if (n3 < this.min_widths[n]) {
            n3 = this.min_widths[n];
        }
        return n3;
    }

    private final int[] createHeaders(int n, String[] stringArray) {
        String string = "";
        String string2 = "";
        this.min_widths = new int[n + 1];
        int n2 = 0;
        while (n2 < n) {
            JLabel jLabel = new JLabel(stringArray[n2]);
            this.min_widths[n2] = (int)jLabel.getPreferredSize().getWidth() + 10;
            ++n2;
        }
        return this.min_widths;
    }

    private final Object[][][] getDataAsTables(int n, int n2, boolean bl) {
        Object[][][] objectArray = new Object[4][this.getRowsNeeded()][n2];
        if (n == 0) {
            objectArray = new Object[4][6][n2];
            int n3 = 0;
            while (n3 < 6) {
                objectArray[0][n3][0] = n3 + " ";
                ++n3;
            }
            int n4 = 1;
            while (n4 < n2) {
                String string = ConfigurationDefault.getDefaultCellValue(headings[n4]);
                int n5 = 0;
                while (n5 < 6) {
                    objectArray[0][n5][n4] = string;
                    ++n5;
                }
                ++n4;
            }
        } else {
            int[] nArray = new int[this.max_tables + 1];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.data_lines) {
                if (!this.line_is_hidden.elementAt(n8)) {
                    Element element = (Element)this.config_values.get(n8);
                    Attribute attribute = (Attribute)element.getAttributes().get(0);
                    Iterator iterator = element.getAttributes().iterator();
                    String string = attribute.getName();
                    n6 = 0;
                    if (!is_user_section) {
                        if (ConfigurationDefault.isVariableBoolean(string)) {
                            ++n6;
                        }
                        if (ConfigurationDefault.isVariableEnterprise(string)) {
                            n6 += 2;
                        }
                        n7 = nArray[n6];
                        objectArray[n6][n7][1] = string + " ";
                        objectArray[n6][n7][2] = attribute.getValue() + " ";
                        String string2 = (String)this.shortcuts.get(string);
                        string2 = string2 == null ? "false" : string2.toLowerCase();
                        objectArray[n6][n7][3] = string2;
                        if (bl) {
                            objectArray[n6][n7][4] = element.getAttributeValue("Comment");
                        }
                    } else {
                        n7 = nArray[0];
                        int n9 = 1;
                        int n10 = 1;
                        while (n10 < n2) {
                            objectArray[n6][n7][n9] = element.getAttributeValue(headings[n9]);
                            ++n9;
                            ++n10;
                        }
                    }
                    this.tooltips[nArray[n6]] = element.getAttributeValue("Comment");
                    objectArray[n6][n7][0] = n8 + " ";
                    int n11 = n6;
                    nArray[n11] = nArray[n11] + 1;
                }
                ++n8;
            }
        }
        return objectArray;
    }

    static {
        is_user_section = false;
    }

    private static class NewTableModel
    extends AbstractTableModel {
        private int column_count = 0;
        private Object[][] table_data;
        private int row_count = 0;
        private String[] table_headers;

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            highlight_row = -1;
            if (object == null) {
                object = "";
            }
            this.table_data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public int getRowCount() {
            return this.row_count;
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = true;
            if (!is_user_section & n2 == 1 | n2 == 0) {
                bl = false;
            }
            return bl;
        }

        public String getToolTip() {
            return "no tip";
        }

        public int getColumnCount() {
            return this.column_count;
        }

        public Object getValueAt(int n, int n2) {
            return this.table_data[n][n2];
        }

        public String getColumnName(int n) {
            int n2;
            String string = "ID";
            if (n > 0 && (n2 = (string = headings[n]).indexOf("|")) != -1) {
                string = string.substring(0, n2);
            }
            return string;
        }

        NewTableModel(int n, int n2, Object[][] objectArray, String[] stringArray) {
            this.table_data = objectArray;
            this.table_headers = stringArray;
            this.row_count = n;
            this.column_count = n2;
        }
    }

    class MyTableListener
    extends MouseAdapter {
        private int i = 0;
        private JTable[] current_table;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = 0;
            while (n < 4) {
                if (this.i != n) {
                    this.current_table[n].clearSelection();
                }
                ++n;
            }
            active_table = this.i;
        }

        public MyTableListener(JTable[] jTableArray, int n) {
            this.current_table = jTableArray;
            this.i = n;
        }
    }
}

