/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.objects;

import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.gui.CommandList;
import com.idrsolutions.storypad.objects.ConfigurationDefault;
import com.idrsolutions.storypad.objects.reorderConfigurationData;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.utils.functions.GetComment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public final class ConfigurationData
extends ConfigurationDefault {
    public static final String[] default_user_headers = new String[]{"Field|Name of field|TYPE-Name of flag which allows control over program function", "value|Current setting|TYPE-Current setting which may be a boolean (true/false), a value, a field or several SPACE separated values. Apart from booleans, values ARE CASE SENSITIVE", "Comment|User comment|TYPE-Comment which describes the command"};
    public static final int Aliases = 28;
    public static final int Overwrite = 22;
    public static final int Keywords = 11;
    public static final int Filters = 21;
    public static final int Font_space_thresholds = 18;
    public static final int Rules = 31;
    public static final int TextOnlyFields = 19;
    public static final int Encapsulation = 29;
    public static final int Remove_Furniture = 16;
    public static final int Email_reports = 10;
    public static final int Maximum_Font_Size = 15;
    public static final int Pdf = 0;
    public static final int General = 5;
    public static final int Data_dictionary = 27;
    public static final int Display = 20;
    public static final int Database = 2;
    public static final int Decomposition = 32;
    public static final int Markup = 26;
    public static final int Substitution = 30;
    public static final int Sorting = 3;
    public static final int Geometry_data = 17;
    public static final int Default_field_value = 25;
    public static final int Incremental = 7;
    public static final int Geometry = 4;
    public static final int Token_definition = 12;
    public static final int client_parameters = 13;
    public static final int Editing = 9;
    public static final int Mandatory = 24;
    public static final int End = 14;
    public static final int Link_items = 6;
    public static final int table_extraction = 33;
    public static final String[] default_system_headers = new String[]{"Field|Name of field|TYPE-Name of flag which allows control over program function", "value|Current setting|TYPE-Current setting which may be a boolean (true/false), a value, a field or several SPACE separated values. Apart from booleans, values ARE CASE SENSITIVE", "Shortcut|Tick to add to toolbar|TYPE - A flag (true/false) which allows a shortcut to appear on the GUI client (where the value can be edited directly without having to access the menu).", "Comment|User comment|TYPE-Comment which describes the command"};
    public static final int Iteration = 23;
    public static final int Mapping = 8;
    public static final int Orphan_objects = 1;
    private HashMap field_name = new HashMap();
    private Document config_doc = new Document();
    private HashMap variable_table = new HashMap();
    private Document doc;
    private List[] section_values = new List[section_count];
    private static String[] initial_client_values = new String[]{"dialog_width", "500", "width of window displaying options", "dialog_height", "500", "heigth of window dispalying options", "max_text_size", "0", "truncates values over this size in display fields. useful when developing rules to speed up work 0=off", "forbidden_chars", "[]", "characters user is not allowed to enter into fields (ie token deliminators"};
    private static int TOKEN = 0;
    private static int CONFIG = 1;
    private static int PATHS = 2;
    private static final String[] section_names = new String[]{"client_parameters", "Pdf", "Orphan_objects", "Database", "Sorting", "Geometry", "General", "Link_items", "Incremental", "Mapping", "Editing", "Email_reports", "Keywords", "Token_definition", "End", "Maximum_Font_Size", "Remove_Furniture", "Geometry_data", "Font_space_thresholds", "TextOnlyFields", "Display", "Filters", "Overwrite", "Iteration", "Mandatory", "Default_field_value", "Markup", "Data_dictionary", "Aliases", "Encapsulation", "Substitution", "Rules", "Decomposition", "table_extraction"};
    private static int section_count = section_names.length;

    public ConfigurationData() {
        this.config_doc.setRootElement(new Element("configuration"));
        Element element = new Element("client_parameters");
        int n = 0;
        while (n < initial_client_values.length) {
            Element element2 = new Element("Setting");
            element2.setAttribute(initial_client_values[n], initial_client_values[n + 1]);
            element2.setAttribute("Comment", initial_client_values[n + 2]);
            element.addContent(element2);
            n += 3;
        }
        this.config_doc.getRootElement().addContent(element);
    }

    public final void writeToSystemTable(int n) {
        int n2 = this.section_values[n].size();
        int n3 = 0;
        while (n3 < n2) {
            Element element = (Element)this.section_values[n].get(n3);
            Attribute attribute = (Attribute)element.getAttributes().get(0);
            String string = attribute.getName();
            String string2 = attribute.getValue();
            if (ConfigurationDefault.getDefaultValue(string) == null) {
                LogWriter.writeLog("Value " + string + " no longer used");
                --n2;
                this.section_values[n].remove(n3);
                --n3;
            } else {
                this.variable_table.put(string, string2);
            }
            ++n3;
        }
    }

    public final void updateSection(boolean bl, String string, List list) {
        int n = 0;
        int n2 = 0;
        while (n2 < section_count) {
            if (section_names[n2].equals(string)) {
                n = n2;
                n2 = section_count;
            }
            ++n2;
        }
        this.section_values[n] = list;
        if (!bl) {
            this.writeToSystemTable(n);
        }
    }

    public final HashMap getFields() {
        return this.field_name;
    }

    public final void addField(String string) {
        this.field_name.put(string, "x");
    }

    public final double getDoubleValue(String string) {
        return Double.parseDouble(this.getSystemValue(string));
    }

    public final List getSection(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < section_count) {
            if (section_names[n2].equals(string)) {
                n = n2;
                n2 = section_count;
            }
            ++n2;
        }
        return this.section_values[n];
    }

    public final boolean getBooleanValue(String string) {
        boolean bl = false;
        if (this.getSystemValue(string).toLowerCase().indexOf("true") != -1) {
            bl = true;
        }
        return bl;
    }

    public final void saveConfigAsXML(String string) throws IOException {
        FileOutputStream fileOutputStream;
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            fileOutputStream = new FileOutputStream(string);
            xMLOutputter.setIndent("  ");
            xMLOutputter.setNewlines(true);
            xMLOutputter.output(this.doc, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing xml file " + string);
        }
        LogWriter.writeLog("Saved: " + string);
        string = Decoder.config_dir + "client.xml";
        xMLOutputter = new XMLOutputter();
        try {
            fileOutputStream = new FileOutputStream(string);
            xMLOutputter.setIndent("  ");
            xMLOutputter.setNewlines(true);
            xMLOutputter.output(this.config_doc, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing xml file " + string);
        }
        LogWriter.writeLog("Saved: " + string);
    }

    public final String getSystemValue(String string) {
        String string2 = "";
        String string3 = "";
        string2 = (String)this.variable_table.get(string);
        if (string2 == null) {
            LogWriter.writeLog(string + " Not in config - using default");
            string2 = ConfigurationDefault.getDefaultValue(string);
            string3 = ConfigurationDefault.getDefaultSection();
            if (string2 == null) {
                try {
                    PrintWriter printWriter = new PrintWriter(new FileWriter("configuration.err"));
                    printWriter.println("Date: " + new Date());
                    printWriter.println("Config directory: " + DecoderPaths.config_dir);
                    printWriter.println(string);
                    printWriter.close();
                    LogWriter.writeLog(string);
                    LogWriter.writeLog("Config directory: " + DecoderPaths.config_dir);
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException + " with " + string);
                }
                ExitDecoder.exitWithMessage("Mandatory configuration: " + string + " missing or unable to locate config file");
            } else {
                this.setSystemValue(string3, string, string2);
            }
        }
        if (!string.equals("common_value")) {
            string2 = DecoderPaths.replaceVariables(string2);
        }
        return string2;
    }

    public final void loadXMLConfiguration(BufferedReader bufferedReader) {
        this.flushFields();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            this.doc = sAXBuilder.build(bufferedReader);
            Element element = this.doc.getRootElement();
            int n = 1;
            while (n < section_count) {
                Element element2 = element.getChild(section_names[n]);
                if (element2 == null) {
                    this.section_values[n] = new ArrayList();
                    if (!ConfigurationDefault.isDefaultUserSection(section_names[n])) {
                        Object object;
                        Vector vector = this.getDefaultSystemSection(section_names[n]);
                        Element element3 = new Element(section_names[n]);
                        element3.setAttribute("Type", "system");
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            object = (String)vector.get(n2);
                            String string = ConfigurationDefault.getDefaultValue((String)object);
                            try {
                                Element element4 = new Element("Setting");
                                String string2 = Strip.stripComment(string).trim();
                                element4.setAttribute((String)object, string2);
                                element4.setAttribute("Comment", GetComment.get(string));
                                this.section_values[n].add(element4);
                                this.setSystemValue(section_names[n], (String)object, string2);
                                element3.addContent(element4);
                            }
                            catch (Exception exception) {
                                LogWriter.writeLog("Exception " + exception + " with value \n" + (String)object + " \n" + string);
                            }
                            ++n2;
                        }
                        object = element.getChild("End");
                        element.removeChild("End");
                        element.addContent(element3);
                        element.addContent((Element)object);
                    }
                } else {
                    this.section_values[n] = element2.getChildren();
                    if (element2.getAttributes().size() > 0 && element2.getAttributeValue("Type").equals("system")) {
                        this.writeToSystemTable(n);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading config file ");
            ExitDecoder.exitWithMessage("Unable to read config file");
        }
        this.loadClientParameters();
    }

    public final Element getUserValue(String string, String string2, int n) {
        Element element = null;
        List list = this.section_values[n];
        if (list != null) {
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                Element element2 = (Element)list.get(n3);
                String string3 = element2.getAttributeValue(string);
                if (string3.equals(string2)) {
                    n3 = n2;
                    element = element2;
                }
                ++n3;
            }
        }
        return element;
    }

    public final List getSection(int n) {
        return this.section_values[n];
    }

    public final void setSystemValue(String string, String string2, String string3) {
        this.variable_table.put(string2.trim(), string3.trim());
        List list = this.getSection(string);
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)list.get(n2);
                String string4 = ((Attribute)element.getAttributes().get(0)).getName();
                if (string4.equals(string2)) {
                    element.setAttribute(string2, string3);
                    list.set(n2, element);
                    n2 = n;
                }
                ++n2;
            }
        }
    }

    public final int getIntValue(String string) {
        return Integer.parseInt(this.getSystemValue(string));
    }

    public static final void convertToXML(BufferedReader bufferedReader, String string, String string2, int n) throws IOException {
        Object object;
        int n2;
        File file;
        CommandList commandList = new CommandList();
        boolean bl = true;
        String[] stringArray = null;
        Element element = new Element("empty");
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        Vector vector = new Vector();
        Document document = new Document();
        document.setRootElement(new Element("configuration"));
        if (n == TOKEN) {
            element = new Element("token_values");
            document.getRootElement().addContent(element);
        }
        if (!(file = new File(string)).exists() & n == CONFIG) {
            vector = ConfigurationDefault.getDefaultConfigurationValues();
            LogWriter.writeLog("File does not exist - using default configuration");
        } else {
            if (n == CONFIG) {
                ConfigurationData.resaveToCorrectOrder(string);
            }
            n2 = 1;
            while ((string6 = bufferedReader.readLine()) != null) {
                vector.addElement(string6);
                ++n2;
            }
            bufferedReader.close();
        }
        n2 = 0;
        while (n2 < vector.size()) {
            int n3;
            string6 = ConfigurationData.backwardCompatible((String)vector.elementAt(n2), string9);
            if (string6.indexOf("_SECTION:") != -1) {
                string9 = ConfigurationDefault.extractDefaultSectionName(string6);
                element = new Element(string9);
                document.getRootElement().addContent(element);
                bl = n == CONFIG ? ConfigurationDefault.isDefaultUserSection(string9) : false;
                n3 = 1;
                while (n3 < section_count) {
                    if (section_names[n3].equals(string9)) {
                        if (bl) {
                            element.setAttribute("Type", "user");
                        } else {
                            element.setAttribute("Type", "system");
                        }
                        object = (Object[])commandList.get(string9);
                        if (object == null) {
                            object = (Object[])commandList.get(string9.toLowerCase());
                        }
                        if (object != null) {
                            if (object[1] == null) {
                                object = !bl ? default_system_headers : default_user_headers;
                                stringArray = (String[])object;
                                string3 = "";
                            } else {
                                stringArray = (String[])object[1];
                                string3 = (String)object[3];
                            }
                            string4 = (String)object[0];
                        }
                        n3 = section_count;
                    }
                    ++n3;
                }
            }
            if (string6.indexOf(":", 0) != -1 & !string6.startsWith("<!-") & !string6.startsWith("**")) {
                LogWriter.writeLog("Converting>>" + string6 + "<<");
                n3 = string6.indexOf(":", 0);
                string7 = string6.substring(0, n3).trim();
                if (!bl && string7.indexOf(" ") != -1) {
                    object = new StringBuffer();
                    int n4 = 0;
                    while (n4 < string7.length()) {
                        char c = string7.charAt(n4);
                        if (c == ' ') {
                            ((StringBuffer)object).append("_");
                        } else {
                            ((StringBuffer)object).append(c);
                        }
                        ++n4;
                    }
                    string7 = ((StringBuffer)object).toString();
                }
                string8 = string6.substring(n3 + 1, string6.length()).trim();
                if (n == TOKEN) {
                    try {
                        object = new Element("Setting");
                        String string10 = "";
                        n3 = string7.indexOf(".");
                        if (n3 != -1) {
                            string10 = string7.substring(0, n3).trim();
                            string7 = string7.substring(n3 + 1);
                        }
                        ((Element)object).setAttribute("Token", string7);
                        ((Element)object).setAttribute("Filter", string10);
                        ((Element)object).setAttribute("Mapping", Strip.stripComment(string8).trim());
                        ((Element)object).setAttribute("Comment", GetComment.get(string8) + " ");
                        element.addContent((Element)object);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " with value \n" + string7 + " \n" + string8);
                    }
                } else if (bl) {
                    int n5;
                    object = string7.substring(string3.length()).trim();
                    Element element2 = new Element("Rule");
                    String string11 = stringArray[0];
                    int n6 = string11.indexOf("|");
                    if (n6 != -1) {
                        string11 = string11.substring(0, n6);
                    }
                    if (string9.equals("Markup") && (n5 = ((String)object).indexOf(".")) != -1) {
                        object = ((String)object).substring(0, n5);
                    }
                    if (((String)object).startsWith("_")) {
                        object = ((String)object).substring(1);
                    }
                    element2.setAttribute(string11, (String)object);
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, "|");
                    int n7 = 1;
                    while (n7 < stringArray.length) {
                        string11 = stringArray[n7];
                        n6 = string11.indexOf("|");
                        if (n6 != -1) {
                            string11 = string11.substring(0, n6);
                        }
                        try {
                            String string12 = stringTokenizer.nextToken().trim();
                            n6 = string12.indexOf("**");
                            if (n6 != -1) {
                                string12 = Strip.stripComment(string12);
                            }
                            if (string12.length() == 0) {
                                string12 = ConfigurationDefault.getDefaultCellValue(string11);
                            }
                            if (string12.startsWith("true")) {
                                string12 = "true";
                            }
                            element2.setAttribute(string11, string12);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception " + exception + " translating line");
                            String string13 = "";
                            element2.setAttribute(string11, string13);
                        }
                        ++n7;
                    }
                    element.addContent(element2);
                } else if (n == CONFIG & ConfigurationDefault.getDefaultValue(string7) == null) {
                    LogWriter.writeLog("Value " + string7 + " no longer used");
                } else {
                    try {
                        object = new Element("Setting");
                        String string14 = Strip.stripComment(string8).trim();
                        ((Element)object).setAttribute(string7, string14);
                        ((Element)object).setAttribute("Comment", " " + GetComment.get("  " + ConfigurationDefault.getDefaultValue(string7)));
                        element.addContent((Element)object);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " with value \n" + string7 + " \n" + string8);
                    }
                }
            }
            ++n2;
        }
        if (!string2.endsWith(".xml")) {
            string2 = string2 + ".xml";
        }
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            xMLOutputter.setIndent("  ");
            xMLOutputter.setNewlines(true);
            xMLOutputter.output(document, (OutputStream)new FileOutputStream(Decoder.config_dir + string2.toLowerCase()));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing xml file for ");
        }
        LogWriter.writeLog("Saved as " + Decoder.config_dir + string2);
        if (string.indexOf("htoken") == -1) {
            object = new File(string);
            File file2 = new File(string + ".backup");
            if (((File)object).exists()) {
                if (file2.exists()) {
                    file2.delete();
                }
                ((File)object).renameTo(file2);
                LogWriter.writeLog("Existing file backed up as " + file2);
            }
        }
    }

    private void loadClientParameters() {
        Object object;
        File file = new File(Decoder.config_dir + "client.xml");
        if (file.exists()) {
            object = new SAXBuilder();
            try {
                this.config_doc = ((SAXBuilder)object).build(Decoder.config_dir + "client.xml");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " - Unable to load user settings");
            }
        }
        object = this.config_doc.getRootElement();
        Element element = ((Element)object).getChild(section_names[0]);
        this.section_values[0] = element.getChildren();
        this.writeToSystemTable(0);
    }

    private final void flushFields() {
        this.field_name.clear();
    }

    private static String backwardCompatible(String string, String string2) {
        if (string != null) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            Object object;
            Object object2;
            String string8;
            String string9;
            int n;
            if (string.indexOf("mandatory_fields_TEXT : HEADLINE |3 | |") != -1) {
                string = "";
            }
            if (string.indexOf("Substitution_in_TEXT  : NULL |</FONT><FONT face=\"AvantMediumG\" |><TAB | | | | | |style=\"font-size:4pt\",style=\"font-size:5pt\" |. |</FONT><BR><TAB |Put in break on letters page | |") != -1) {
                string = "Substitution_in_TEXT  : NULL |</FONT><FONT face=\"AvantMediumG\" |><TAB | | | | | |style=\"font-size:4pt\",style=\"font-size:5pt\" |. |</FONT><BR><TAB | |Put in break on letters page |";
            }
            if (string.indexOf("Substitution_in_TEXTx  : NULL |<FONT_SIZE_INCREASES><FONT |face=\"ExcelReg\" style=\"font-size:5pt\">  | | | | | | |. |<P> |Put in break on letters page | |") != -1) {
                string = "Substitution_in_TEXTx  : NULL |<FONT_SIZE_INCREASES><FONT |face=\"ExcelReg\" style=\"font-size:5pt\">  | | | | | | |. |<P> | |Put in break on letters page |";
            }
            if (string.startsWith("Substitution_in_")) {
                n = string.indexOf(":");
                string9 = "";
                if (n != -1) {
                    string8 = string.substring(0, n + 1);
                    object2 = string.substring(n + 1).trim();
                    object = new StringTokenizer((String)object2, "|");
                    if (((StringTokenizer)object).countTokens() == 13) {
                        string = string8 + " ";
                        int n2 = 0;
                        while (n2 < 13) {
                            string7 = ((StringTokenizer)object).nextToken();
                            if (n2 == 0) {
                                string6 = "false";
                                string5 = "false";
                                string4 = "false";
                                string3 = "false";
                                n = string7.toLowerCase().indexOf(".mustbecaps");
                                if (n != -1) {
                                    string3 = "true";
                                }
                                if ((n = string7.toLowerCase().indexOf(".iterate")) != -1) {
                                    string6 = "true";
                                }
                                if ((n = string7.toLowerCase().indexOf(".ifempty")) != -1) {
                                    string4 = "true";
                                }
                                if ((n = string7.toLowerCase().indexOf(".allstories")) != -1) {
                                    string5 = "true";
                                }
                                if ((n = string7.indexOf(".")) != -1) {
                                    string7 = string7.substring(0, n);
                                }
                                string9 = " | " + string5 + " | " + string4 + "|" + string6 + " | " + string3 + " | ";
                                string = string + string7 + " | ";
                            } else if (n2 == 2) {
                                string = string + string7 + string9;
                            } else if (!(n2 == 4 | n2 == 5)) {
                                string = n2 == 10 ? (string7.startsWith("true") ? string + "true| |" : (string7.startsWith("false") ? string + "false| |" : (string7.trim().length() > 0 ? string + "true|" + string7 + "|" : string + "false| |"))) : string + string7 + "|";
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (string.startsWith("Substitute_") && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n + 1);
                string8 = string.substring(n + 1).trim();
                object2 = Strip.stripComment(string8).trim();
                object = "false";
                String string10 = GetComment.get(string8).trim();
                n = ((String)object2).toLowerCase().indexOf(".iterate");
                if (n != -1) {
                    object = "true";
                }
                if ((n = ((String)object2).indexOf(".")) != -1) {
                    object2 = ((String)object2).substring(0, n);
                }
                string = string9 + " " + (String)object2 + " | " + (String)object + " | " + string10 + "|";
            }
            if (!string.startsWith("**") & string2.indexOf("TextOnlyFields") != -1 && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n).trim();
                string = string9 + ": **";
            }
            if (!string.startsWith("**") & string2.indexOf("Geometry_data") != -1 && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n + 1);
                string8 = string.substring(n + 1).trim();
                object2 = new StringTokenizer(string8, "|");
                string = string9 + " ";
                int n3 = ((StringTokenizer)object2).countTokens();
                int n4 = 0;
                while (n4 < n3) {
                    string7 = ((StringTokenizer)object2).nextToken();
                    if (n4 != 7) {
                        string = string + string7 + "|";
                    }
                    ++n4;
                }
            }
            if (string.startsWith("Decomposition_") && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n + 1);
                string8 = string.substring(n + 1).trim();
                object2 = new StringTokenizer(string8, "|");
                string = string9 + " ";
                String string11 = "";
                int n5 = ((StringTokenizer)object2).countTokens();
                int n6 = 0;
                while (n6 < n5) {
                    string6 = ((StringTokenizer)object2).nextToken();
                    if (n6 == 0) {
                        string5 = "false";
                        string4 = "false";
                        n = string6.toLowerCase().indexOf(".ifempty");
                        if (n != -1) {
                            string5 = "true";
                        }
                        if ((n = string6.toLowerCase().indexOf(".iterate")) != -1) {
                            string4 = "true";
                        }
                        if ((n = string6.indexOf(".")) != -1) {
                            string6 = string6.substring(0, n);
                        }
                        string11 = " | " + string5 + " | " + string4 + " | ";
                        string = string + string6 + " | ";
                    } else {
                        string = n6 == 2 ? string + string6 + string11 : string + string6 + "|";
                    }
                    ++n6;
                }
            }
            if (string.startsWith("Alias") && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n);
                string8 = string.substring(n + 1).trim();
                n = string9.indexOf(".");
                if (n != -1) {
                    object2 = string9.substring(n + 1).trim();
                    string9 = string9.substring(0, n).trim();
                    string = string9 + " : " + (String)object2 + " | " + string8;
                }
            }
            if (string.startsWith("Alias") && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n + 1);
                string8 = string.substring(n + 1).trim();
                object2 = new StringTokenizer(string8, "|");
                int n7 = ((StringTokenizer)object2).countTokens();
                string = string9 + " ";
                int n8 = 0;
                while (n8 < n7) {
                    String string12 = ((StringTokenizer)object2).nextToken();
                    if (n8 != 2) {
                        string = string + string12 + "|";
                    }
                    ++n8;
                }
            }
            if (string.startsWith("Iteration_in_") && (n = string.indexOf(":")) != -1) {
                string9 = string.substring(0, n + 1);
                string8 = string.substring(n + 1).trim();
                object2 = new StringTokenizer(string8, "|");
                if (((StringTokenizer)object2).countTokens() == 11) {
                    string = string9 + " ";
                    String string13 = "";
                    int n9 = 0;
                    while (n9 < 11) {
                        String string14 = ((StringTokenizer)object2).nextToken();
                        if (n9 == 0) {
                            string6 = "false";
                            string5 = "false";
                            string4 = "false";
                            string3 = "false";
                            n = string14.toLowerCase().indexOf(".mustbecaps");
                            if (n != -1) {
                                string3 = "true";
                            }
                            if ((n = string14.toLowerCase().indexOf(".iterate")) != -1) {
                                string6 = "true";
                            }
                            if ((n = string14.toLowerCase().indexOf(".ifempty")) != -1) {
                                string4 = "true";
                            }
                            if ((n = string14.toLowerCase().indexOf(".allstories")) != -1) {
                                string5 = "true";
                            }
                            if ((n = string14.indexOf(".")) != -1) {
                                string14 = string14.substring(0, n);
                            }
                            string13 = " | " + string5 + " | " + string4 + "|" + string6 + " | " + string3 + " | ";
                            string = string + string14 + " | ";
                        } else if (n9 == 1) {
                            string = string + string14 + string13;
                        } else if (!(n9 == 3 | n9 == 4)) {
                            string = n9 == 10 ? (string14.startsWith("true") ? string + "true| |" : (string14.startsWith("false") ? string + "false| |" : (string14.trim().length() > 0 ? string + "true|" + string14 + "|" : string + "false| |"))) : string + string14 + "|";
                        }
                        ++n9;
                    }
                }
            }
        }
        return string;
    }

    private static void resaveToCorrectOrder(String string) {
        try {
            String string2 = System.getProperty("file.encoding");
            reorderConfigurationData reorderConfigurationData2 = new reorderConfigurationData();
            reorderConfigurationData2.initConfiguration(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2)));
            reorderConfigurationData2.rewriteConfigFile(string);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " translating file");
        }
    }
}

