/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.objects;

import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.FileInfo;
import com.idrsolutions.utils.functions.IsWriteable;
import com.idrsolutions.utils.functions.SendEmail;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.JLabel;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.LogWriter;

public final class License {
    public final String[] version_text = new String[]{"", "Enterprise Demo", "Personal", "Enterprise"};
    public static boolean decode_pdf = true;
    private HashMap values = new HashMap();
    private boolean allow_saves = false;
    private Object[] raw_values = new Object[]{"licensee", "Demo version of Storypad", "serial", "0", "ServerIP", "all", "ClientIP", "all", "Start_time", "all", "End_time", "all", "Start_date", "all", "Password", "", "Admin_Password", "", "Allow_pdf", "true", "expires", "never"};
    private static int level = 0;
    private static boolean include_images = true;

    public final void init(String string) {
        String string2;
        int n = 0;
        while (n < this.raw_values.length) {
            this.values.put(this.raw_values[n], this.raw_values[n + 1]);
            n += 2;
        }
        String string3 = string + "sp.lic";
        File file = new File(string3);
        if (file.exists()) {
            LogWriter.writeLog("Reading sp.lic file");
            this.loadspFile(string3);
        } else {
            string3 = string + "sp.xml";
            file = new File(string3);
            if (file.exists()) {
                this.loadXMLFile(string3);
            }
        }
        String string4 = this.getLicenseValue("Allow_pdf");
        if (string4.toLowerCase().indexOf("true") != -1) {
            decode_pdf = true;
        }
        if ((string2 = this.getLicenseValue("level")) == null) {
            level = 2;
            this.allow_saves = false;
        } else {
            level = Integer.parseInt(string2);
        }
        if (level == 0) {
            this.allow_saves = false;
            level = 2;
        } else if (level >= 2) {
            this.allow_saves = true;
        }
        if (level > 3) {
            level = 3;
        }
        if (level < 1) {
            level = 1;
        }
        if (level == 3) {
            this.allow_saves = true;
        }
        if (this.getLicenseValue("licensee").indexOf("News I") != -1) {
            include_images = false;
        }
    }

    public final String checkFile(String string) {
        String string2;
        String string3;
        if (string != null && (string3 = "SUN021GM03SUN011GM2606.01.1GE.20010910165556TIM161FM22timbizbiz03003").indexOf(string2 = FileInfo.extractFileNameWithoutExtension(string)) == -1) {
            string = null;
            ShowGUIMessage.showGUIMessage("Demo version will only open demo files", "Demo limitation");
        }
        return string;
    }

    public final void checkTime(boolean bl) {
        block19: {
            Calendar calendar;
            Object object;
            int n;
            String string;
            Object object2;
            String string2 = " " + this.getLicenseValue("ServerIP") + " ";
            String string3 = " " + this.getLicenseValue("ClientIP") + " ";
            try {
                object2 = " " + InetAddress.getLocalHost().getHostName() + " ";
                string = " " + InetAddress.getLocalHost().getHostAddress() + " ";
                boolean bl2 = false;
                if (string2.indexOf("all") != -1 | string2.indexOf((String)object2) != -1 | string2.indexOf(string) != -1) {
                    bl2 = true;
                }
                boolean bl3 = false;
                if (string3.indexOf("all") != -1 | string3.indexOf((String)object2) != -1 | string3.indexOf(string) != -1) {
                    bl3 = true;
                }
                if (!bl & !bl2) {
                    ExitDecoder.exitWithMessage("This machine is not licensed to run Storypad in server mode");
                }
                if (bl & !bl3) {
                    ExitDecoder.exitWithMessage("This machine is not licensed to run Storypad in client mode");
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " accessing host information");
            }
            object2 = Calendar.getInstance();
            ((Calendar)object2).setTime(new Date());
            string = this.getLicenseValue("Start_time");
            String string4 = this.getLicenseValue("End_time");
            long l = ((Calendar)object2).get(11);
            if (string4 != null && !string4.equals("all")) {
                try {
                    n = Integer.parseInt(string4);
                    if (l >= (long)n) {
                        object = "This software is not licensed to run after 00" + n + " hours.";
                        ExitDecoder.exitWithMessage((String)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string != null && !string.equals("all")) {
                try {
                    n = Integer.parseInt(string);
                    if (l < (long)n) {
                        object = "This software is not licensed to run before 00" + n + " hours.";
                        ExitDecoder.exitWithMessage((String)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((calendar = this.getExpiryDate("expires")) == null) break block19;
            try {
                object = Calendar.getInstance();
                if (((Calendar)object).after(calendar)) {
                    ExitDecoder.exitWithMessage("This software license has expired.");
                }
                ((Calendar)object).add(2, 1);
                if (((Calendar)object).after(calendar)) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    String string5 = dateFormat.format(calendar.getTime());
                    String string6 = "License file will expire on " + string5;
                    if (bl) {
                        ShowGUIMessage.showGUIMessage(string6, "License warning");
                    }
                    LogWriter.writeLog(string6);
                    SendEmail.post(null, string6, null, "License expiry warning", 1);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in accessing license file");
            }
        }
    }

    public final boolean canSave() {
        return this.allow_saves;
    }

    public final Calendar getExpiryDate(String string) {
        Calendar calendar;
        block5: {
            Object v = this.values.get(string);
            calendar = null;
            try {
                if (((String)v).indexOf("never") != -1) {
                    v = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (v == null) break block5;
            try {
                calendar = (Calendar)v;
            }
            catch (Exception exception) {
                ExitDecoder.exitWithMessage("Corrupted license file");
            }
        }
        return calendar;
    }

    private final void showLicenseMessage(String string) {
        JLabel jLabel;
        if (level == 2 && !this.canSave()) {
            jLabel = new JLabel();
            jLabel.setFont(new Font("SansSerif", 0, 14));
            jLabel.setText("<HTML><BODY><CENTER><B>DEMO version of Storypad</B><BR><P><CENTER>Personal version</CENTER><BR><CENTER>Sample pdf files copyright of News International</CENTER><BR><CENTER><FONT COLOR=blue>Visit www.idrsolutions.com for full details</BODY></HTML>");
            ShowGUIMessage.showGUIMessage(string, jLabel, "Non-commercial version limitations");
        }
        if (level == 1) {
            jLabel = new JLabel();
            jLabel.setFont(new Font("SansSerif", 0, 14));
            jLabel.setText("<HTML><BODY><CENTER><B>DEMO version of Storypad</B><BR><P><CENTER>FULL version</CENTER><CENTER><I>Demonstrating extraction of text and images</I></CENTER><P><CENTER>Configuration optimized for Sun Samples</CENTER><CENTER>Files copyright of News International</CENTER><BR><CENTER><FONT COLOR=blue>Visit www.idrsolutions.com for full details</BODY></HTML>");
            ShowGUIMessage.showGUIMessage(string, jLabel, "Non-commercial version limitations");
        }
    }

    public final String getLicenseValue(String string) {
        String string2 = (String)this.values.get(string);
        if (string2 == null) {
            string2 = string.equals("level") ? "0" : "not registered";
        }
        return string2;
    }

    public static final boolean canAccessImages() {
        return include_images;
    }

    public static final int getLevel() {
        return level;
    }

    private final void loadspFile(String string) {
        block11: {
            Key key = null;
            Key key2 = null;
            Signature signature = null;
            boolean bl = false;
            Vector vector = null;
            try {
                Object object;
                Object object2;
                ObjectInputStream objectInputStream = null;
                if (IsWriteable.writeable(string)) {
                    object2 = new File(string);
                    if (((File)object2).exists()) {
                        objectInputStream = new ObjectInputStream(new GZIPInputStream(new FileInputStream((File)object2)));
                    }
                } else {
                    object2 = new URL(string);
                    object = ((URL)object2).openConnection();
                    ((URLConnection)object).setDoOutput(true);
                    ((URLConnection)object).setAllowUserInteraction(false);
                    objectInputStream = new ObjectInputStream(new GZIPInputStream(((URLConnection)object).getInputStream()));
                }
                object2 = objectInputStream.readObject();
                vector = (Vector)object2;
                objectInputStream.close();
                if (vector == null) {
                    ExitDecoder.exitWithMessage("No license file");
                    break block11;
                }
                key = (Key)vector.elementAt(0);
                key2 = (Key)vector.elementAt(1);
                PublicKey publicKey = (PublicKey)vector.elementAt(2);
                this.values = (HashMap)vector.elementAt(3);
                object = (byte[])vector.elementAt(4);
                try {
                    signature = Signature.getInstance("SHA1withDSA", "SUN");
                    signature.initVerify(publicKey);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error generating signature");
                }
                String string2 = "" + this.values.values();
                byte[] byArray = string2.getBytes();
                try {
                    signature.update(byArray);
                    bl = true;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Signing error " + exception);
                }
                if (!bl) {
                    LogWriter.writeLog("License file failed validation");
                }
            }
            catch (Exception exception) {
                ExitDecoder.exitWithMessage("Exception " + exception + " with license file - please contact IDRsolutions");
            }
        }
    }

    private final void loadXMLFile(String string) {
        try {
            Object object;
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(string);
            Element element = document.getRootElement();
            List list = element.getChildren();
            int n = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n2 = 0;
            while (n2 < list.size()) {
                object = (Element)list.get(n2);
                List list2 = ((Element)object).getAttributes();
                int n3 = 0;
                while (n3 < this.values.size() + 1) {
                    Attribute attribute = (Attribute)list2.get(n3);
                    string4 = attribute.getName();
                    string3 = attribute.getValue();
                    if (!string4.equals("id")) {
                        int n4;
                        int n5 = 0;
                        while (n5 < string3.length()) {
                            n4 = string3.charAt(n5);
                            n += n4;
                            string2 = string2 + (char)n4;
                            ++n5;
                        }
                        n4 = 0;
                        while (n4 < string4.length()) {
                            char c = string4.charAt(n4);
                            n += c;
                            string2 = string2 + c;
                            ++n4;
                        }
                        this.values.put(string4, string3);
                    }
                    ++n3;
                }
                ++n2;
            }
            object = "";
            int n6 = 0;
            while (n6 < 4) {
                object = (String)object + string3.charAt(n6 + n6 * 5);
                ++n6;
            }
            String string5 = "" + n;
            int n7 = string5.length();
            if (n7 > 4) {
                string5 = string5.substring(n7 - 4);
            } else if (n7 < 4) {
                LogWriter.writeLog("Unable to generate a 4 digit key!");
                System.exit(1);
            }
            if (!((String)object).equals(string5)) {
                ExitDecoder.exitWithMessage("Invalid license key");
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading license");
            ExitDecoder.exitWithMessage("Invalid license key");
        }
    }
}

