/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.objects;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jpedal.utils.LogWriter;

public class SpellChecker {
    private ClassLoader loader = this.getClass().getClassLoader();
    private boolean loaded = false;
    private static HashMap dictionary = new HashMap();

    public final void loadDictionary() {
        String string = "fulldic.bin";
        if (!this.loaded) {
            LogWriter.writeLog("Reading wordList object");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.loader.getResourceAsStream("com/res/wordlists/" + string));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                dictionary = (HashMap)object;
                LogWriter.writeLog("WordList read - " + dictionary.keySet().size() + " words");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " trying to read Wordlist object.");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Object var2_3 = null;
                System.gc();
                dictionary = new HashMap();
                LogWriter.writeLog("Insufficient menory to load WordList");
            }
            this.loaded = true;
        }
    }

    public final boolean inDictionary(String string) {
        return dictionary.containsKey(string);
    }

    public final void flushDictionary() {
        dictionary = null;
        dictionary = new HashMap();
        System.gc();
        this.loaded = false;
    }

    private final void convertDictionaries(String string) {
        Object object;
        Document document = new Document();
        document.setRootElement(new Element("wordlist"));
        Object[] objectArray = dictionary.keySet().toArray();
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n].toString().trim();
            boolean bl = true;
            int n2 = 0;
            while (n2 < ((String)object).length()) {
                if (!Character.isLetter(((String)object).charAt(n2))) {
                    bl = false;
                }
                ++n2;
            }
            if (((String)object).length() > 1 & bl) {
                document.getRootElement().addContent(new Element((String)object));
            } else {
                LogWriter.writeLog((String)object + "<");
            }
            ++n;
        }
        object = new XMLOutputter();
        try {
            ((XMLOutputter)object).setIndent("  ");
            ((XMLOutputter)object).setNewlines(true);
            ((XMLOutputter)object).output(document, (OutputStream)new FileOutputStream(string + ".xml"));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing file ");
        }
    }

    private final void checkDictionary() {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        try {
            object2 = new ObjectInputStream(new GZIPInputStream(this.loader.getResourceAsStream("com/res/wordlists/dic.zip")));
            object = ((ObjectInputStream)object2).readObject();
            ((ObjectInputStream)object2).close();
            hashMap = (HashMap)object;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " trying to read Wordlist object.");
        }
        LogWriter.writeLog("WordList read - " + hashMap.keySet().size() + " words");
        try {
            object2 = new ObjectInputStream(new GZIPInputStream(this.loader.getResourceAsStream("com/res/wordlists/largedic.zip")));
            object = ((ObjectInputStream)object2).readObject();
            ((ObjectInputStream)object2).close();
            hashMap2 = (HashMap)object;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " trying to read Wordlist object.");
        }
        LogWriter.writeLog("WordList read - " + hashMap2.keySet().size() + " words");
        object2 = hashMap.keySet().iterator();
    }

    private final void createNewDic() {
        Object object;
        Object object2;
        BufferedReader bufferedReader = null;
        String[] stringArray = new String[]{"wb1913_a.html", "wb1913_b.html", "wb1913_c.html", "wb1913_d.html", "wb1913_e.html", "wb1913_f.html", "wb1913_g.html", "wb1913_h.html", "wb1913_i.html", "wb1913_j.html", "wb1913_k.html", "wb1913_l.html", "wb1913_m.html", "wb1913_new.html", "wb1913_n.html", "wb1913_o.html", "wb1913_p.html", "wb1913_q.html", "wb1913_r.html", "wb1913_s.html", "wb1913_t.html", "wb1913_u.html", "wb1913_v.html", "wb1913_w.html", "wb1913_x.html", "wb1913_y.html", "wb1913_z.html", "missed.txt"};
        Object object3 = dictionary;
        String string = "";
        String string2 = "";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("/mnt/win_d/words.txt"));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading  file - " + stringArray);
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                String string3;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/mnt/win_d/v003/" + stringArray[n])));
                while ((string3 = bufferedReader.readLine()) != null) {
                    object2 = new StringTokenizer(string3, "< >", true);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string = ((StringTokenizer)object2).nextToken();
                        while (string.indexOf("<") != -1 & string.indexOf(">") == -1) {
                            string = string + ((StringTokenizer)object2).nextToken();
                        }
                        if (((HashMap)object3).get(string = string.toLowerCase()) == null & string.length() > 2 & string.indexOf("<") == -1 & string.indexOf("-") == -1 & string2.equals("<b>")) {
                            ((HashMap)object3).put(string, "x");
                        }
                        string2 = string;
                    }
                }
                bufferedReader.close();
                LogWriter.writeLog("current file " + stringArray[n] + " size=" + ((HashMap)object3).size());
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in reading  file - " + stringArray);
            }
            ++n;
        }
        printWriter.flush();
        printWriter.close();
        int n2 = 0;
        object2 = new HashMap();
        Iterator iterator = ((HashMap)object3).keySet().iterator();
        String[] stringArray2 = new String[]{"ant", "d", "dly", "ed", "edly", "er", "ent", "ese", "est", "iest", "ing", "ised", "ising", "ish", "ist", "ly", "s", "st", "y"};
        String[] stringArray3 = new String[]{"anti", "de", "dis", "ex", "non", "over", "post", "pre", "re", "un", "under"};
        String[] stringArray4 = new String[]{"y", "ies", "y", "iest"};
        int n3 = 0;
        while (iterator.hasNext()) {
            int n4;
            int n5;
            int n6;
            object = (String)iterator.next();
            int n7 = ((String)object).length();
            ++n3;
            boolean bl = true;
            String string4 = "";
            int n8 = 0;
            while (n8 < stringArray2.length) {
                if (((String)object).endsWith(stringArray2[n8]) && ((HashMap)object3).containsKey(string4 = ((String)object).substring(0, n7 - (n6 = stringArray2[n8].length())))) {
                    ++n2;
                    bl = false;
                }
                ++n8;
            }
            n6 = 0;
            while (n6 < stringArray3.length) {
                if (((String)object).startsWith(stringArray3[n6]) && ((HashMap)object3).containsKey(string4 = ((String)object).substring(n5 = stringArray3[n6].length()))) {
                    ++n2;
                    bl = false;
                }
                ++n6;
            }
            n5 = 0;
            while (n5 < stringArray4.length) {
                if (((String)object).endsWith(stringArray4[n5]) && ((HashMap)object3).containsKey(string4 = ((String)object).substring(0, n7 - (n4 = stringArray4[n5].length())) + stringArray4[n5 + 1])) {
                    ++n2;
                    bl = false;
                }
                n5 += 2;
            }
            n4 = 0;
            while (n4 < stringArray4.length) {
                int n9;
                if (((String)object).endsWith(stringArray4[n4 + 1]) && ((HashMap)object3).containsKey(string4 = ((String)object).substring(0, n7 - (n9 = stringArray4[n4 + 1].length())) + stringArray4[n4])) {
                    ++n2;
                    bl = false;
                }
                n4 += 2;
            }
            if (!bl) continue;
            ((HashMap)object2).put(object, "x");
        }
        object3 = object2;
        try {
            object = object3;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("/mnt/win_d/new.bin"));
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing serialised object");
        }
    }

    private final void getHyphenatedWords() {
        BufferedReader bufferedReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        String string2 = "";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("/mnt/win_d/missed.txt"));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading  file - ");
        }
        try {
            String string3;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/mnt/win_d/baseline/report/changes.txt")));
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "< >", true);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (hashMap.get(string = string.toLowerCase()) == null & string.length() > 2 & string.indexOf("-") != -1) {
                        hashMap.put(string, "x");
                    }
                    string2 = string;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading  file - ");
        }
        printWriter.flush();
        printWriter.close();
    }

    private final void loadXMLDictionary() {
        LogWriter.writeLog("Reading wordList object");
        String string = "";
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(this.loader.getResourceAsStream("com/res/wordlists/" + string));
            Element element = document.getRootElement();
            List list = element.getChildren();
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < list.size()) {
                hashMap.put(list.get(n), "x");
                ++n;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to load wordlist " + string);
        }
        System.exit(1);
    }
}

