/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.objects;

import com.idrsolutions.utils.ToUnicode;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jpedal.utils.LogWriter;

public class Tokens {
    private HashMap single_char_tokens = new HashMap();
    private HashMap weights = new HashMap();
    private List token_section;
    private Document doc = new Document();
    private HashMap existing_tokens = new HashMap();

    public Tokens() {
        this.doc.setRootElement(new Element("configuration"));
        Element element = new Element("token_values");
        this.doc.getRootElement().addContent(element);
        this.token_section = element.getChildren();
    }

    public final String getWeight(String string) {
        return (String)this.weights.get(string);
    }

    public final boolean isTokenDefined(String string) {
        boolean bl = false;
        if (this.existing_tokens.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public final void addToken(String string) {
        this.existing_tokens.put(string, "");
        DateFormat dateFormat = DateFormat.getDateInstance();
        String string2 = dateFormat.format(new Date());
        String string3 = "Added on " + string2;
        Element element = new Element("Setting");
        element.setAttribute("Token", string);
        element.setAttribute("Filter", "");
        element.setAttribute("Mapping", "");
        element.setAttribute("Comment", string3);
        this.token_section.add(element);
    }

    public final void loadTokens(BufferedReader bufferedReader, boolean bl, String string) {
        this.weights = new HashMap();
        this.single_char_tokens = new HashMap();
        this.existing_tokens = new HashMap();
        if (bl | bufferedReader != null) {
            LogWriter.writeLog("Reading token file");
            try {
                HashMap hashMap = new HashMap();
                if (!bl) {
                    SAXBuilder sAXBuilder = new SAXBuilder();
                    this.doc = sAXBuilder.build(bufferedReader);
                    Element element = this.doc.getRootElement().getChild("token_values");
                    this.token_section = element.getChildren();
                }
                int n = 0;
                while (n < this.token_section.size()) {
                    Element element = (Element)this.token_section.get(n);
                    String string2 = element.getAttributeValue("Token");
                    String string3 = element.getAttributeValue("Filter");
                    String string4 = element.getAttributeValue("Mapping");
                    if (string3.length() > 0) {
                        string2 = string3 + "." + string2;
                    }
                    if (this.existing_tokens.get(string2) != null | this.weights.get(string2) != null | this.single_char_tokens.get(string2) != null) {
                        this.token_section.remove(n);
                        LogWriter.writeLog("Duplicate for " + string2 + " rejected");
                    } else if (string2.toLowerCase().startsWith("weight_")) {
                        string2 = string2.substring(7);
                        this.weights.put(string2, string4);
                    } else {
                        if (string2.indexOf("\\u") != -1) {
                            string2 = ToUnicode.remapUnicodeEscapes(string2);
                        }
                        int n2 = string2.length();
                        int n3 = string2.lastIndexOf(".");
                        if (n2 > 0) {
                            if (n2 == 1 | string.indexOf(string2.charAt(0)) == -1 & n3 > 0 & n2 - n3 == 2) {
                                this.single_char_tokens.put(string2, string4);
                            } else {
                                this.existing_tokens.put(string2, string4);
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading token file");
            }
        }
        LogWriter.writeLog("Total tokens loaded: \nSingle character=" + this.single_char_tokens.size() + "\nWeights=" + this.weights.size() + " \nTokens=" + this.existing_tokens.size());
    }

    public final void updateSection(List list) {
        this.token_section = list;
    }

    public final void saveTokensAsXML(String string) {
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            xMLOutputter.setIndent("  ");
            xMLOutputter.setNewlines(true);
            xMLOutputter.output(this.doc, (OutputStream)new FileOutputStream(string));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing token file " + string);
        }
        LogWriter.writeLog("Saved: " + string);
    }

    public final String getSingleCharToken(String string) {
        return (String)this.single_char_tokens.get(string);
    }

    public final String getToken(String string) {
        return (String)this.existing_tokens.get(string);
    }

    public final List getTokenList() {
        ArrayList arrayList = new ArrayList(this.token_section);
        Collections.sort(arrayList, new ContentTagComparator());
        this.token_section.clear();
        int n = 0;
        while (n < arrayList.size()) {
            this.token_section.add(arrayList.get(n));
            ++n;
        }
        return this.token_section;
    }

    public class ContentTagComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = this.getFirstChar(((Element)object).getAttributeValue("Token"));
            String string2 = this.getFirstChar(((Element)object2).getAttributeValue("Token"));
            int n = string.compareTo(string2);
            return n;
        }

        private String getFirstChar(String string) {
            String string2 = "x";
            int n = string.length();
            int n2 = 0;
            while (n2 < string.length()) {
                if (Character.isLetterOrDigit(string.charAt(n2))) {
                    string2 = string.substring(n2, n2 + 1);
                    n2 = n;
                }
                ++n2;
            }
            return string2.toLowerCase();
        }
    }
}

