/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.storypad.utils;

import com.idrsolutions.storypad.Decoder;
import com.idrsolutions.storypad.DecoderPaths;
import com.idrsolutions.storypad.utils.ExitDecoder;
import com.idrsolutions.storypad.utils.sleep;
import com.idrsolutions.utils.ToUnicode;
import com.idrsolutions.utils.functions.SendEmail;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;

public class SQL {
    private String driver_name = "";
    private String alt_dbUrl = "";
    private String non_escalator_flags = "";
    private Connection sql_connection = null;
    private boolean use_client = false;
    private String dbUrl = "";
    private JTextPane messages = null;
    private String image_table = "";
    private String SQL_prefix = "";
    private int number_of_bind_values_used_so_far = 0;
    private boolean output_is_unicode = false;
    private String text_table = "";
    private boolean sql_debug = false;
    private String user_message = null;
    private String user = "";
    private int escalator = 0;
    private boolean text_displayed = false;
    private String password = "";

    public SQL() {
    }

    public SQL(String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{setupSQL}");
        }
        this.dbUrl = string;
        this.text_table = string5;
        this.image_table = string6;
        this.user = string2;
        this.password = string3;
        this.driver_name = string4;
        this.use_client = bl;
        if (string4.toLowerCase().indexOf("postgre") == -1 & string4.toLowerCase().indexOf("mysql") == -1 & string.toLowerCase().indexOf("postgre") == -1 & string.toLowerCase().indexOf("mysql") == -1) {
            ExitDecoder.exitWithMessage("Postgres or MySQL must be used");
        }
    }

    public SQL(boolean bl, String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String string8, boolean bl2) {
        this.output_is_unicode = bl;
        if (string.indexOf("SQL") != -1) {
            LogWriter.writeLog("SQL debugging will display additional information");
            this.sql_debug = true;
        }
        this.dbUrl = string2;
        this.alt_dbUrl = string3;
        this.escalator = n;
        this.non_escalator_flags = string4;
        this.user = string5;
        this.password = string6;
        this.driver_name = string7;
        this.SQL_prefix = string8;
        this.use_client = bl2;
    }

    public final boolean writeImage(String string, byte[] byArray) {
        boolean bl;
        block5: {
            bl = false;
            if (this.sql_connection == null) {
                this.createSQLConnection(0);
            }
            try {
                PreparedStatement preparedStatement = this.sql_connection.prepareStatement("INSERT INTO " + this.image_table + " (name, image) " + "VALUES (?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setBytes(2, byArray);
                preparedStatement.execute();
                preparedStatement.close();
                bl = true;
            }
            catch (SQLException sQLException) {
                if (this.use_client) {
                    this.messages.setText("SQL exception:" + sQLException.getMessage());
                    ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB SQL insert failure");
                }
                LogWriter.writeLog("SQL exception" + sQLException.getMessage());
            }
            catch (Exception exception) {
                if (!this.use_client) break block5;
                this.messages.setText("Exception message:" + exception);
                ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "Exception");
            }
        }
        return bl;
    }

    public final boolean writeText(String string, String string2) {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        if (this.sql_connection == null) {
            this.createSQLConnection(0);
        }
        try {
            preparedStatement = this.sql_connection.prepareStatement("INSERT INTO " + this.text_table + " (name, text) " + "VALUES (?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
        }
        catch (SQLException sQLException) {
            if (this.use_client) {
                this.messages.setText("SQL exception:" + sQLException.getMessage());
                ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB SQL insert failure");
            }
            LogWriter.writeLog("SQL exception:" + sQLException.getMessage());
        }
        try {
            preparedStatement.execute();
            preparedStatement.close();
            bl = true;
        }
        catch (SQLException sQLException) {
            if (this.use_client) {
                this.messages.setText("SQL exception:" + sQLException.getMessage());
                ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB SQL insert failure");
            }
            LogWriter.writeLog("SQL exception:" + sQLException.getMessage());
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean insertSQL(Vector var1_1, Vector var2_2, Vector var3_3, String var4_4, int var5_5, int var6_6) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{insertSQL}");
        }
        var7_7 = false;
        var8_8 = false;
        this.number_of_bind_values_used_so_far = 0;
        var9_9 = this.SQL_prefix.length();
        var10_10 = 0;
        var11_11 = 0;
        var12_12 = "";
        var13_13 = null;
        if (this.use_client) {
            this.messages = new JTextPane();
        }
        var4_4 = this.cleanSQL(var4_4);
        if (this.sql_debug) {
            LogWriter.writeLog("Attempting to execute SQL :" + var4_4);
        }
        while (true) {
            block34: {
                if (Decoder.debug_level > 2 | this.sql_debug == true) {
                    LogWriter.writeLog("*******SQL BIND VARIABLES********");
                    LogWriter.writeLog("**Total= " + var3_3.size());
                    if (var3_3.size() != var2_2.size()) {
                        LogWriter.writeLog("Error - number of variables does not match number of values");
                        var14_15 = new sleep(2);
                    }
                    var14_14 = 0;
                    while (var14_14 < var3_3.size()) {
                        LogWriter.writeLog(var14_14 + " " + var3_3.elementAt(var14_14) + ":" + var2_2.elementAt(var14_14));
                        ++var14_14;
                    }
                    LogWriter.writeLog("*********************************");
                }
                if (this.sql_connection == null) {
                    this.createSQLConnection(var5_5);
                }
                if ((var14_14 = var4_4.indexOf(this.SQL_prefix, var10_10 + var9_9)) == -1) {
                    var14_14 = var4_4.length();
                }
                var12_12 = this.cleanSQL(var4_4.substring(var10_10 + var9_9, var14_14));
                if (this.sql_debug) {
                    LogWriter.writeLog(var12_12);
                }
                try {
                    var13_13 = this.sql_connection.prepareStatement(var12_12);
                }
                catch (Exception var15_17) {
                    LogWriter.writeLog("Exception " + var15_17 + " preparing field " + var12_12);
                }
                var15_16 = new StringTokenizer(var12_12, "?");
                var16_18 = var15_16.countTokens();
                var17_19 = 1;
                var18_20 = "";
                var19_21 = "";
                if (var16_18 > 1) {
                    var17_19 = 1 + this.number_of_bind_values_used_so_far;
                    while (var17_19 < var16_18 + this.number_of_bind_values_used_so_far) {
                        try {
                            var18_20 = (String)var1_1.elementAt(var17_19 - 1);
                            if (this.sql_debug) {
                                LogWriter.writeLog("Getting data for field " + var18_20);
                            }
                            if (var18_20.startsWith("BINARY_")) {
                                var19_21 = "Object";
                                var20_22 = (byte[])var2_2.elementAt(var17_19 - 1);
                                var13_13.setBytes(var17_19 - this.number_of_bind_values_used_so_far, (byte[])var20_22);
                            } else {
                                var19_21 = "text";
                                var20_22 = (String)var2_2.elementAt(var17_19 - 1);
                                if (this.sql_debug) {
                                    LogWriter.writeLog("SQL value =" + ToUnicode.insertUnicodeEscapes((String)var20_22));
                                }
                                var13_13.setCharacterStream(var17_19 - this.number_of_bind_values_used_so_far, (Reader)new StringReader((String)var20_22), var20_22.length());
                            }
                        }
                        catch (Exception var20_23) {
                            LogWriter.writeLog("Exception " + var20_23 + " in creating bind for field " + var18_20);
                            if (this.use_client) {
                                ShowGUIMessage.showGUIMessage("Exception " + var20_23 + " in creating bind for field " + var18_20, "DB bind failure");
                            }
                            LogWriter.writeLog("Storypad has identified field as type- " + var19_21);
                            var21_25 = "Exception " + var20_23 + " in creating bind for field " + var18_20 + "Storypad has identified field as type- " + var19_21;
                            SendEmail.post(null, var21_25, null, "Failure binding variable", 2);
                        }
                        ++var17_19;
                    }
                }
                try {
                    var13_13.execute();
                    var13_13.close();
                    var10_10 = var4_4.indexOf("@@", var10_10 + var9_9);
                    this.number_of_bind_values_used_so_far = var17_19 - 1;
                }
                catch (SQLException var20_24) {
                    if (this.use_client) {
                        this.messages.setText("SQL Error message:" + var20_24 + "\n" + "SQL State:" + var20_24.getSQLState() + "\n" + "attempting Insert statement: " + var12_12);
                        ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB SQL insert failure");
                    }
                    this.number_of_bind_values_used_so_far = 0;
                    var10_10 = 0;
                    LogWriter.writeLog("SQL Error message:" + var20_24);
                    LogWriter.writeLog("SQL State:" + var20_24.getSQLState());
                    LogWriter.writeLog("attempting Insert statement: " + var12_12);
                    var21_25 = "Error message" + var20_24 + "\nSQL Error reported " + var20_24.getSQLState() + "Executing\n " + var12_12 + "\n";
                    var22_27 = var3_3.size();
                    var23_28 = 0;
                    ** while (var23_28 < var22_27)
                }
lbl-1000:
                // 1 sources

                {
                    var18_20 = (String)var1_1.elementAt(var23_28);
                    var24_29 = "";
                    if (var18_20.startsWith("BINARY_")) {
                        var24_29 = var18_20 + ": Binary object\n";
                    } else if (var18_20.startsWith("LENGTH_")) {
                        var25_30 = (String)var2_2.elementAt(var23_28);
                        var24_29 = var18_20 + ": Length object " + var25_30.length() + " \n";
                    } else {
                        var25_30 = (String)var2_2.elementAt(var23_28);
                        var26_31 = var25_30.length();
                        if (var26_31 > 30) {
                            var25_30 = var25_30.substring(0, 30) + "..." + var25_30.substring(var26_31 - 30) + "[TRUNCATED]";
                        }
                        var24_29 = "[" + var23_28 + "/" + (var22_27 - 1) + "] " + var18_20 + " " + var25_30 + " [Length = " + var26_31 + " ]";
                    }
                    LogWriter.writeLog((String)var24_29);
                    var21_25 = var21_25 + (String)var24_29 + "\n";
                    ++var23_28;
                    continue;
                }
lbl111:
                // 1 sources

                var24_29 = new StringTokenizer(this.non_escalator_flags, ",");
                while (var24_29.hasMoreTokens()) {
                    var25_30 = var24_29.nextToken();
                    if (var21_25.indexOf(var25_30) == -1) continue;
                    var11_11 = var5_5;
                    var8_8 = true;
                    LogWriter.writeLog("Message contains value " + var25_30 + " - no escalator");
                }
                SendEmail.post(null, var21_25, null, "SQL insert error", 2);
                this.rollBack();
                ++var11_11;
                this.sql_connection = null;
                break block34;
                catch (Exception var21_26) {
                    if (this.use_client) {
                        ShowGUIMessage.showGUIMessage("Error message" + var21_26, "General error in SQL command");
                    }
                    var10_10 = 0;
                    LogWriter.writeLog("Exception on insert " + var21_26);
                    this.rollBack();
                    ++var11_11;
                    this.sql_connection = null;
                }
            }
            if (var10_10 == -1 | var11_11 > var5_5) break;
            if (var11_11 <= 0) continue;
            LogWriter.writeLog("SQL insert attempt " + var11_11 + " out of " + var5_5 + " failed - retrying in " + var6_6 + " seconds.");
            var20_22 = new sleep(var6_6);
        }
        if (var10_10 == -1 && var11_11 < var5_5 && !var8_8) {
            LogWriter.writeLog("SQL insert successful");
            var7_7 = true;
        }
        return var7_7;
    }

    public final void createSQLConnection(int n) {
        Object object;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{createSQLConnection}");
        }
        int n2 = 0;
        this.sql_connection = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.use_client) {
            this.messages = new JTextPane();
        }
        if (this.sql_debug) {
            LogWriter.writeLog("Creating SQL connection");
        }
        try {
            Class.forName(this.driver_name);
        }
        catch (Exception exception) {
            String string = "Unable to load driver " + this.driver_name + " - not configured";
            ExitDecoder.exitWithMessage(string);
        }
        while (true) {
            try {
                this.sql_connection = DriverManager.getConnection(this.dbUrl, this.user, this.password);
                this.sql_connection.setAutoCommit(false);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = true;
                stringBuffer.append(sQLException.getMessage() + "\n" + sQLException.getSQLState() + "\n");
                if (this.use_client) {
                    this.messages.setText("Attempting to connect to " + this.dbUrl + "\n\n" + "SQL message:" + sQLException.getMessage() + "\n" + "SQL state:" + sQLException.getSQLState() + "\n\n");
                }
                LogWriter.writeLog("Exception " + sQLException + " establishing SQL connection to " + this.dbUrl);
            }
            if (bl && this.alt_dbUrl.length() > 1) {
                try {
                    this.sql_connection = DriverManager.getConnection(this.alt_dbUrl, this.user, this.password);
                    this.sql_connection.setAutoCommit(false);
                    bl = false;
                }
                catch (SQLException sQLException) {
                    bl = true;
                    stringBuffer.append(sQLException.getMessage() + "\n" + sQLException.getSQLState() + "\n");
                    if (this.use_client) {
                        this.messages.setText("Attempting to connect to " + this.alt_dbUrl + "\n\n" + "SQL message:" + sQLException.getMessage() + "\n" + "SQL state:" + sQLException.getSQLState() + "\n");
                    }
                    LogWriter.writeLog("Exception " + sQLException + " establishing alternate SQL connection to " + this.alt_dbUrl);
                }
            }
            if (++n2 > n | this.sql_connection != null) break;
            if (this.escalator == 0) continue;
            LogWriter.writeLog("Program pausing for " + Math.abs(this.escalator) + " seconds before retrying JDBC connection");
            object = new sleep(Math.abs(this.escalator));
            ((Thread)object).stop();
            if (this.escalator >= 0) continue;
            this.escalator *= 2;
        }
        if (bl) {
            if (this.use_client) {
                ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB connection failure");
            }
            object = "Failure to connect to either " + this.dbUrl + " or " + this.alt_dbUrl + ".\nSQL messages:-\n" + stringBuffer;
            ExitDecoder.exitWithMessage((String)object);
        }
    }

    public final JPanel createSQLDisplay(String string, String string2, String string3) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{createSQLDisplay}");
        }
        this.user_message = string3;
        String string4 = this.cleanSQL(string2);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JTable jTable = this.genTable(string, string4);
        jScrollPane.getViewport().add(jTable);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(TimeNow.getTimeNow() + " " + string2), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jTable.addMouseListener(new SQL_view_listener());
        return jPanel;
    }

    public final boolean trackUsers(String string, String string2) {
        if (LogWriter.debug) {
            LogWriter.writeMethod("{trackUsers}");
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "";
        String string4 = "";
        try {
            string3 = System.getProperty("user.name");
            string4 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " Unable to get user/host");
        }
        String string5 = TimeNow.getTimeNow();
        while (true) {
            Object object;
            if (this.sql_connection == null) {
                this.createSQLConnection(5);
            }
            ResultSet resultSet = this.executeSQL(string, "select * from " + string + " where host_name='" + string4 + "';", false, 5);
            try {
                int n2 = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    object = new Object[n2 + 1];
                    int n3 = 1;
                    while (n3 < ((Object[])object).length) {
                        String string6 = resultSet.getString(n3);
                        if (string6 == null) {
                            string6 = "";
                        }
                        if (string6.indexOf(DecoderPaths.group_id) != -1) {
                            bl = true;
                        }
                        ++n3;
                    }
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in getting columns");
            }
            try {
                if (bl) {
                    this.executeSQL(string, "Update " + string + " set version ='" + string2 + "' where host_name='" + string4 + "'", true, 5);
                    this.executeSQL(string, "Update " + string + " set user_name ='" + string3 + "' where host_name='" + string4 + "'", true, 5);
                    this.executeSQL(string, "Update " + string + " set accessed ='" + string5 + "' where host_name='" + string4 + "'", true, 5);
                    this.executeSQL(string, "Update " + string + " set alias='" + DecoderPaths.group_id + "' where host_name='" + string4 + "'", true, 5);
                } else {
                    object = "Insert into " + string + " (host_name,user_name,version,accessed,alias) values(" + "'" + string4 + "','" + string3 + "','" + string2 + "','" + new Date() + "','" + DecoderPaths.group_id + "')";
                    this.executeSQL(string, (String)object, false, 5);
                }
                this.executeSQL(string, "commit;", true, 5);
                LogWriter.writeLog("Entry written to central log table");
                bl2 = true;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " attempting to log user");
                sleep sleep2 = new sleep(5);
            }
            if (bl2 | n > 5) break;
            if (!bl2) {
                LogWriter.writeLog("Retrying write to central log");
            }
            ++n;
        }
        if (!bl2) {
            LogWriter.writeLog("Unable to log details in database");
        }
        return bl2;
    }

    private final ResultSet executeSQL(String string, String string2, boolean bl, int n) {
        ResultSet resultSet;
        block8: {
            if (LogWriter.debug) {
                LogWriter.writeMethod("{executeSQL}");
            }
            if (this.use_client) {
                this.messages = new JTextPane();
            }
            string2 = this.cleanSQL(string2);
            if (this.sql_connection == null) {
                this.createSQLConnection(n);
            }
            if (this.sql_debug) {
                LogWriter.writeLog("Attempting to execute SQL :" + string2);
            }
            Statement statement = null;
            resultSet = null;
            try {
                statement = this.sql_connection.createStatement();
                if (!bl) {
                    resultSet = statement.executeQuery(string2);
                    if (resultSet != null) break block8;
                    String string3 = "Unable to read any data from " + string;
                    ExitDecoder.exitWithMessage(string3);
                    break block8;
                }
                statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                if (this.use_client) {
                    this.messages.setText("SQL message:" + sQLException + "\n" + "SQL state:" + sQLException.getSQLState() + "\n" + "Executing " + string2);
                    ShowGUIMessage.showGUIMessage(this.user_message, this.messages, "DB SQL execution failure");
                }
                LogWriter.writeLog("Exception executing " + string2);
                LogWriter.writeLog("SQL " + sQLException.getSQLState());
                LogWriter.writeLog("SQL " + sQLException);
            }
        }
        return resultSet;
    }

    private final JTable genTable(String string, String string2) {
        int n;
        int n2;
        JTable jTable;
        Vector<Object[]> vector;
        block12: {
            this.sql_connection = null;
            vector = new Vector<Object[]>();
            jTable = null;
            ResultSet resultSet = this.executeSQL(string, string2, false, 5);
            n2 = 0;
            int n3 = 0;
            try {
                n2 = resultSet.getMetaData().getColumnCount() + 1;
                while (resultSet.next()) {
                    Object[] objectArray = new Object[n2 + 1];
                    int n4 = 1;
                    while (n4 < n2) {
                        String string3 = resultSet.getString(n4);
                        if (string3 == null) {
                            string3 = "";
                        }
                        objectArray[n4 + 1] = string3;
                        ++n4;
                    }
                    objectArray[1] = "" + ++n3;
                    vector.add(objectArray);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("No table data with exception " + exception);
            }
            n = vector.size();
            jTable = new JTable(n, n2);
            Font font = new Font("SansSerif", 1, 12);
            jTable.getTableHeader().setFont(font);
            jTable.getTableHeader().setBackground(Color.gray);
            try {
                jTable.getColumnModel().getColumn(0).setHeaderValue("Count");
                int n5 = 1;
                while (n5 < n2) {
                    jTable.getColumnModel().getColumn(n5).setHeaderValue(resultSet.getMetaData().getColumnName(n5));
                    ++n5;
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem " + exception + " generating table colums");
                if (!this.use_client) break block12;
                ShowGUIMessage.showGUIMessage("Problem " + exception + " generating table colums", "DB access failure");
            }
        }
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n2) {
                Object object = ((Object[])vector.get(n6))[n7 + 1];
                if (object == null) {
                    object = "**";
                }
                jTable.setValueAt(object, n6, n7);
                ++n7;
            }
            ++n6;
        }
        if (jTable == null) {
            jTable = new JTable();
            LogWriter.writeLog("Empty table for SQL values");
        }
        return jTable;
    }

    private final String cleanSQL(String string) {
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private final void rollBack() {
        block3: {
            try {
                if (this.sql_connection != null) {
                    this.sql_connection.rollback();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " attempting to roll transactions");
                if (!this.use_client) break block3;
                ShowGUIMessage.showGUIMessage("Error " + exception + " attempting to roll transactions", "DB rollback failure");
            }
        }
    }

    private class SQL_view_listener
    extends MouseAdapter {
        private SQL_view_listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SQL.this.text_displayed) {
                SQL.this.text_displayed = true;
                try {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    String string = (String)jTable.getValueAt(n, n2);
                    String string2 = "Cell data - " + jTable.getColumnModel().getColumn(n2).getHeaderValue();
                    Container container = null;
                    JTextPane jTextPane = new JTextPane();
                    jTextPane.setText(string);
                    jTextPane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane();
                    jScrollPane.getViewport().add(jTextPane);
                    jScrollPane.setPreferredSize(new Dimension(300, 200));
                    jScrollPane.setHorizontalScrollBarPolicy(31);
                    Object[] objectArray = new Object[]{"Ok"};
                    int n3 = JOptionPane.showOptionDialog(container, jScrollPane, string2, -1, -1, null, objectArray, "Ok");
                    container.validate();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("No data in SQL");
                }
                SQL.this.text_displayed = false;
            }
        }
    }
}

