/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.utils.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    private int max_used = 0;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel jLabel = new JLabel("Sample Rate");
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.controls.add(jLabel);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        jLabel = new JLabel("ms");
        this.controls.add(jLabel);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] stringArray) {
        final MemoryMonitor memoryMonitor = new MemoryMonitor();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                memoryMonitor.surf.stop();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                memoryMonitor.surf.start();
            }
        };
        JFrame jFrame = new JFrame("Java2D Demo - MemoryMonitor");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", memoryMonitor);
        jFrame.pack();
        jFrame.setSize(new Dimension(200, 200));
        jFrame.setVisible(true);
        memoryMonitor.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public long sleepAmount = 1000L;
        public Thread thread;
        private Color mfColor = new Color(0, 100, 0);
        private int w;
        private int h;
        private Color graphColor = new Color(46, 139, 87);
        private Rectangle graphOutlineRect = new Rectangle();
        private int ptNum;
        private int columnInc;
        private BufferedImage bimg;
        private String usedStr;
        private Graphics2D big;
        private Runtime r = Runtime.getRuntime();
        private Line2D graphLine = new Line2D.Float();
        private Font font = new Font("Times New Roman", 0, 11);
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private int ascent;
        private int descent;
        private Rectangle2D muRect = new Rectangle2D.Float();
        private float freeMemory;
        private float totalMemory;
        private int[] pts;

        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float f = this.r.freeMemory();
            float f2 = this.r.totalMemory();
            int n = (int)((f2 - f) / 1024.0f);
            if (n > MemoryMonitor.this.max_used) {
                MemoryMonitor.this.max_used = n;
            }
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)f2 / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf(n + "K used (Max=" + MemoryMonitor.this.max_used + ")");
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float f3 = this.ascent + this.descent;
            float f4 = (float)this.h - f3 * 2.0f - 0.5f;
            float f5 = f4 / 10.0f;
            float f6 = 20.0f;
            float f7 = (float)this.w - f6 - 10.0f;
            this.big.setColor(this.mfColor);
            int n2 = (int)(f / f2 * 10.0f);
            int n3 = 0;
            while (n3 < n2) {
                this.mfRect.setRect(5.0, f3 + (float)n3 * f5, f6, f5 - 1.0f);
                this.big.fill(this.mfRect);
                ++n3;
            }
            this.big.setColor(Color.green);
            while (n3 < 10) {
                this.muRect.setRect(5.0, f3 + (float)n3 * f5, f6, f5 - 1.0f);
                this.big.fill(this.muRect);
                ++n3;
            }
            this.big.setColor(this.graphColor);
            int n4 = 30;
            int n5 = (int)f3;
            int n6 = this.w - n4 - 5;
            int n7 = (int)f4;
            this.graphOutlineRect.setRect(n4, n5, n6, n7);
            this.big.draw(this.graphOutlineRect);
            int n8 = n7 / 10;
            int n9 = n5;
            while (n9 <= n7 + n5) {
                this.graphLine.setLine(n4, n9, n4 + n6, n9);
                this.big.draw(this.graphLine);
                n9 += n8;
            }
            int n10 = n6 / 15;
            if (this.columnInc == 0) {
                this.columnInc = n10;
            }
            int n11 = n4 + this.columnInc;
            while (n11 < n6 + n4) {
                this.graphLine.setLine(n11, n5, n11, n5 + n7);
                this.big.draw(this.graphLine);
                n11 += n10;
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[n6];
                this.ptNum = 0;
            } else if (this.pts.length != n6) {
                int[] nArray = null;
                if (this.ptNum < n6) {
                    nArray = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, nArray, 0, nArray.length);
                } else {
                    nArray = new int[n6];
                    System.arraycopy(this.pts, this.pts.length - nArray.length, nArray, 0, nArray.length);
                    this.ptNum = nArray.length - 2;
                }
                this.pts = new int[n6];
                System.arraycopy(nArray, 0, this.pts, 0, nArray.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)n5 + (float)n7 * (f / f2));
                int n12 = n4 + n6 - this.ptNum;
                int n13 = 0;
                while (n13 < this.ptNum) {
                    if (n13 != 0) {
                        if (this.pts[n13] != this.pts[n13 - 1]) {
                            this.big.drawLine(n12 - 1, this.pts[n13 - 1], n12, this.pts[n13]);
                        } else {
                            this.big.fillRect(n12, this.pts[n13], 1, 1);
                        }
                    }
                    ++n13;
                    ++n12;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    int n14 = 1;
                    while (n14 < this.ptNum) {
                        this.pts[n14 - 1] = this.pts[n14];
                        ++n14;
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            while (this.thread == thread && this.isShowing()) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.thread = null;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$1;
                {
                    this.this$1 = surface;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }
    }
}

