/*
 * Decompiled with CFR 0.152.
 */
package com.wpedal;

import com.idrsolutions.grouping.PdfAlgorithm;
import com.idrsolutions.grouping.PdfStoryGrouping;
import com.idrsolutions.storypad.pdf.PdfMasterTextFonts;
import com.idrsolutions.utils.DoctorContent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jpedal.PdfDecoder;
import org.jpedal.gui.PdfToolTips;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.text.PdfThreshold;
import org.jpedal.utils.LogWriter;

public class ExtractTextAsXML {
    private PdfStoryGrouping grouping = new PdfStoryGrouping();
    private static String algorithm_name = "";
    private boolean is_demo = true;
    private static String file_name = "";

    public ExtractTextAsXML(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = "";
        LogWriter.writeLog("WinPedal version :1.79");
        if (!string.toLowerCase().endsWith(".pdf")) {
            LogWriter.writeLog("File does not have a pdf ending");
            System.exit(1);
        } else {
            int n = string.toLowerCase().indexOf(".pdf");
            string3 = string.substring(0, n);
        }
        LogWriter.writeLog("File will be saved as " + string3);
        PdfDecoder pdfDecoder = null;
        ObjectStore.init("wpedal");
        try {
            pdfDecoder = new PdfDecoder(false);
            LogWriter.writeLog("Opening file :" + string);
            pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
            System.exit(1);
        }
        int n = pdfDecoder.getPageCount();
        LogWriter.writeLog("File contains " + n + " pages which will be saved as xml");
        if (n > 1) {
            LogWriter.writeLog("Each page will be saved as a single xml file");
        }
        try {
            int n2 = 1;
            while (n2 < n + 1) {
                pdfDecoder.decodePage(false, n2);
                PdfData pdfData = pdfDecoder.getPdfData();
                PdfData pdfData2 = pdfDecoder.getPdfData();
                PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
                int n3 = pdfDecoder.getMinX(n2);
                int n4 = pdfDecoder.getMaxX(n2);
                if (algorithm_name.length() > 1 && algorithm_name.indexOf("Nothing") == -1) {
                    this.grouping.setValues("-", "-", algorithm_name, false, new PdfThreshold(), pdfPageData, pdfData2, new PdfMasterTextFonts());
                    this.grouping.applyGrouping(new PdfToolTips(), pdfData.getBlankTextList(), n2, false, algorithm_name, 5, n3, n4);
                } else {
                    this.grouping.decodePageFragments(pdfData, n2);
                }
                XMLOutputter xMLOutputter = new XMLOutputter();
                String string4 = string3 + "-" + n2 + ".xml";
                if (this.is_demo) {
                    int n5 = pdfData.getTextElementCount();
                    int n6 = 0;
                    while (n6 < n5) {
                        Element element = pdfData.getTextElementAt(n6);
                        String string5 = element.getAttributeValue("content");
                        string5 = DoctorContent.doctorText(string5);
                        element.setAttribute("content", string5);
                        pdfData.setTextElementAt(n6, element);
                        ++n6;
                    }
                }
                Document document = pdfData.getAllTextElements();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string4);
                    xMLOutputter.setIndent("  ");
                    xMLOutputter.setNewlines(true);
                    xMLOutputter.output(document, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " writing token file " + string4);
                }
                LogWriter.writeLog("Saved: " + file_name);
                pdfDecoder.flushObjectValues(false);
                ++n2;
            }
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            System.err.println("Exception " + exception.getMessage());
            System.exit(1);
        }
        pdfDecoder.markAllPagesAsUnread();
        pdfDecoder.flushObjectValues(false);
        LogWriter.writeLog("Text read");
        pdfDecoder.closePdfFile();
        ObjectStore.flush();
        System.exit(0);
    }

    public ExtractTextAsXML() {
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        if (stringArray.length > 2) {
            object = stringArray[2];
            n = LogWriter.testLogFileWriteable((String)object, false);
            if (n != 0) {
                System.err.println("Unable to use " + (String)object + " as cannot be accessed");
                System.exit(1);
            }
            LogWriter.log_name = object;
            LogWriter.setupLogFile(false, 0, "wpedal", "v", false);
        } else {
            LogWriter.noLogging();
        }
        if (stringArray.length == 0) {
            System.err.println("No file name set");
            System.exit(1);
        } else {
            file_name = stringArray[0];
            LogWriter.writeLog("Translating file :" + file_name);
        }
        if (stringArray.length > 1) {
            algorithm_name = stringArray[1];
            if (PdfAlgorithm.validateAlgorithmName(algorithm_name)) {
                LogWriter.writeLog("Using algorithm :" + algorithm_name);
            } else {
                LogWriter.writeLog("Incorrect value used >" + algorithm_name + "< - please use ");
                LogWriter.writeLog("No value (ie \"\" or nothing at all");
                object = PdfAlgorithm.getAlgorithmsAvailable();
                n = 0;
                while (n < ((String[])object).length) {
                    LogWriter.writeLog(object[n]);
                    n += 2;
                }
                System.exit(1);
            }
        }
        if (!(object = new File(file_name)).exists()) {
            LogWriter.writeLog("File " + file_name + " not found");
            System.exit(1);
        }
        ExtractTextAsXML extractTextAsXML = new ExtractTextAsXML(file_name);
    }
}

