/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public final class BorderExtenderReflect
extends BorderExtender {
    BorderExtenderReflect() {
    }

    private void flipX(WritableRaster writableRaster) {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = n + n4 - 1;
        int n6 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n3 * n6];
                int[] nArray2 = new int[n3 * n6];
                int n7 = 0;
                while (n7 < n4 / 2) {
                    writableRaster.getPixels(n + n7, n2, 1, n3, nArray);
                    writableRaster.getPixels(n5 - n7, n2, 1, n3, nArray2);
                    writableRaster.setPixels(n + n7, n2, 1, n3, nArray2);
                    writableRaster.setPixels(n5 - n7, n2, 1, n3, nArray);
                    ++n7;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n3 * n6];
                float[] fArray2 = new float[n3 * n6];
                int n8 = 0;
                while (n8 < n4 / 2) {
                    writableRaster.getPixels(n + n8, n2, 1, n3, fArray);
                    writableRaster.getPixels(n5 - n8, n2, 1, n3, fArray2);
                    writableRaster.setPixels(n + n8, n2, 1, n3, fArray2);
                    writableRaster.setPixels(n5 - n8, n2, 1, n3, fArray);
                    ++n8;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n3 * n6];
                double[] dArray2 = new double[n3 * n6];
                int n9 = 0;
                while (n9 < n4 / 2) {
                    writableRaster.getPixels(n + n9, n2, 1, n3, dArray);
                    writableRaster.getPixels(n5 - n9, n2, 1, n3, dArray2);
                    writableRaster.setPixels(n + n9, n2, 1, n3, dArray2);
                    writableRaster.setPixels(n5 - n9, n2, 1, n3, dArray);
                    ++n9;
                }
                break;
            }
        }
    }

    private void flipY(WritableRaster writableRaster) {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = n2 + n3 - 1;
        int n6 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n4 * n6];
                int[] nArray2 = new int[n4 * n6];
                int n7 = 0;
                while (n7 < n3 / 2) {
                    writableRaster.getPixels(n, n2 + n7, n4, 1, nArray);
                    writableRaster.getPixels(n, n5 - n7, n4, 1, nArray2);
                    writableRaster.setPixels(n, n2 + n7, n4, 1, nArray2);
                    writableRaster.setPixels(n, n5 - n7, n4, 1, nArray);
                    ++n7;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n4 * n6];
                float[] fArray2 = new float[n4 * n6];
                int n8 = 0;
                while (n8 < n3 / 2) {
                    writableRaster.getPixels(n, n2 + n8, n4, 1, fArray);
                    writableRaster.getPixels(n, n5 - n8, n4, 1, fArray2);
                    writableRaster.setPixels(n, n2 + n8, n4, 1, fArray2);
                    writableRaster.setPixels(n, n5 - n8, n4, 1, fArray);
                    ++n8;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n4 * n6];
                double[] dArray2 = new double[n4 * n6];
                int n9 = 0;
                while (n9 < n3 / 2) {
                    writableRaster.getPixels(n, n2 + n9, n4, 1, dArray);
                    writableRaster.getPixels(n, n5 - n9, n4, 1, dArray2);
                    writableRaster.setPixels(n, n2 + n9, n4, 1, dArray2);
                    writableRaster.setPixels(n, n5 - n9, n4, 1, dArray);
                    ++n9;
                }
                break;
            }
        }
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = n3 + n;
        int n5 = writableRaster.getMinY();
        int n6 = n5 + n2;
        int n7 = planarImage.getMinX();
        int n8 = planarImage.getMinY();
        int n9 = planarImage.getWidth();
        int n10 = planarImage.getHeight();
        int n11 = Math.max(n7, n3);
        int n12 = Math.min(n7 + n9, n4);
        int n13 = Math.max(n8, n5);
        int n14 = Math.min(n8 + n10, n6);
        if (n11 > n12 || n13 > n14) {
            if (n11 > n12) {
                if (n3 == n11) {
                    n3 = planarImage.getMaxX() - 1;
                } else {
                    n4 = planarImage.getMinX();
                }
            }
            if (n13 > n14) {
                if (n5 == n13) {
                    n5 = planarImage.getMaxY() - 1;
                } else {
                    n6 = planarImage.getMinY();
                }
            }
            WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster(n3, n5, n4 - n3, n6 - n5);
            this.extend(writableRaster2, planarImage);
            Raster raster = writableRaster2.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), null);
            JDKWorkarounds.setRect((WritableRaster)writableRaster, (Raster)raster, (int)0, (int)0);
            return;
        }
        Rectangle rectangle = new Rectangle();
        int n15 = PlanarImage.XToTileX(n3, n7, n9);
        int n16 = PlanarImage.XToTileX(n4 - 1, n7, n9);
        int n17 = PlanarImage.YToTileY(n5, n8, n10);
        int n18 = PlanarImage.YToTileY(n6 - 1, n8, n10);
        int n19 = n17;
        while (n19 <= n18) {
            int n20 = n19 * n10 + n8;
            int n21 = n15;
            while (n21 <= n16) {
                int n22 = n21 * n9 + n7;
                if (n21 != 0 || n19 != 0) {
                    boolean bl = Math.abs(n21) % 2 == 1;
                    boolean bl2 = Math.abs(n19) % 2 == 1;
                    rectangle.x = n22;
                    rectangle.y = n20;
                    rectangle.width = n9;
                    rectangle.height = n10;
                    int n23 = 0;
                    if (rectangle.x < n3) {
                        n23 = n3 - rectangle.x;
                        rectangle.x = n3;
                        rectangle.width -= n23;
                    }
                    int n24 = 0;
                    if (rectangle.y < n5) {
                        n24 = n5 - rectangle.y;
                        rectangle.y = n5;
                        rectangle.height -= n24;
                    }
                    if (rectangle.x + rectangle.width > n4) {
                        rectangle.width = n4 - rectangle.x;
                    }
                    if (rectangle.y + rectangle.height > n6) {
                        rectangle.height = n6 - rectangle.y;
                    }
                    int n25 = bl ? (n23 == 0 ? n7 + n9 - rectangle.width : n7) : n7 + n23;
                    int n26 = bl2 ? (n24 == 0 ? n8 + n10 - rectangle.height : n8) : n8 + n24;
                    WritableRaster writableRaster3 = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n25, n26, null);
                    planarImage.copyData(writableRaster3);
                    if (bl) {
                        this.flipX(writableRaster3);
                    }
                    if (bl2) {
                        this.flipY(writableRaster3);
                    }
                }
                ++n21;
            }
            ++n19;
        }
    }
}

