/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.media.jai.CollectionChangeEvent;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationNodeSupport;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceChangeEvent;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.registry.CIFRegistry;
import javax.media.jai.registry.RCIFRegistry;

public class CollectionOp
extends CollectionImage
implements OperationNode,
PropertyChangeListener {
    protected OperationNodeSupport nodeSupport;
    protected PropertySource thePropertySource;
    protected boolean isRenderable = false;
    private transient RenderingHints oldHints;
    private static Set nodeEventNames = null;

    public CollectionOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        parameterBlock = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
        this.nodeSupport = new OperationNodeSupport(this.getRegistryModeName(), string, operationRegistry, parameterBlock, renderingHints, this.eventManager);
        this.isRenderable = bl;
        this.addPropertyChangeListener("OperationName", this);
        this.addPropertyChangeListener("OperationRegistry", this);
        this.addPropertyChangeListener("ParameterBlock", this);
        this.addPropertyChangeListener("Sources", this);
        this.addPropertyChangeListener("Parameters", this);
        this.addPropertyChangeListener("RenderingHints", this);
        Vector<Object> vector = parameterBlock.getSources();
        if (vector != null) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CollectionImage) {
                    ((CollectionImage)e).addSink(this);
                    continue;
                }
                if (!(e instanceof PlanarImage)) continue;
                ((PlanarImage)e).addSink(this);
            }
        }
    }

    public CollectionOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(operationRegistry, string, parameterBlock, renderingHints, false);
    }

    public CollectionOp(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(null, string, parameterBlock, renderingHints);
    }

    public CollectionOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        this(operationRegistry, string, parameterBlock, null);
    }

    public boolean isRenderable() {
        return this.isRenderable;
    }

    public String getRegistryModeName() {
        return this.isRenderable ? "renderableCollection" : "collection";
    }

    public synchronized OperationRegistry getRegistry() {
        return this.nodeSupport.getRegistry();
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        this.nodeSupport.setRegistry(operationRegistry);
    }

    public String getOperationName() {
        return this.nodeSupport.getOperationName();
    }

    public synchronized void setOperationName(String string) {
        this.nodeSupport.setOperationName(string);
    }

    public ParameterBlock getParameterBlock() {
        return (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        Object object;
        Object object2;
        Vector<Object> vector = this.nodeSupport.getParameterBlock().getSources();
        if (vector != null && vector.size() > 0) {
            object2 = ((AbstractList)vector).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof PlanarImage) {
                    ((PlanarImage)object).removeSink(this);
                    continue;
                }
                if (!(object instanceof CollectionImage)) continue;
                ((CollectionImage)object).removeSink(this);
            }
        }
        if (parameterBlock != null && (object2 = parameterBlock.getSources()) != null && ((Vector)object2).size() > 0) {
            object = ((AbstractList)object2).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof PlanarImage) {
                    ((PlanarImage)e).addSink(this);
                    continue;
                }
                if (!(e instanceof CollectionImage)) continue;
                ((CollectionImage)e).addSink(this);
            }
        }
        this.nodeSupport.setParameterBlock(parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone());
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : (RenderingHints)renderingHints.clone();
    }

    public synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.nodeSupport.setRenderingHints(renderingHints);
    }

    public Collection getCollection() {
        this.createCollection();
        return this.imageCollection;
    }

    private synchronized void createCollection() {
        if (this.imageCollection == null) {
            this.imageCollection = this.createInstance(true);
        }
    }

    public synchronized Collection createInstance() {
        return this.createInstance(false);
    }

    private synchronized Collection createInstance(boolean bl) {
        Object object;
        Object object2;
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters((ParameterBlock)this.nodeSupport.getParameterBlock());
        ParameterBlock parameterBlock2 = new ParameterBlock();
        parameterBlock2.setParameters(parameterBlock.getParameters());
        int n = parameterBlock.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            object2 = parameterBlock.getSource(n2);
            object = null;
            if (object2 instanceof RenderedOp) {
                object = bl ? ((RenderedOp)object2).getRendering() : ((RenderedOp)object2).createInstance();
            } else if (object2 instanceof CollectionOp) {
                CollectionOp collectionOp = (CollectionOp)object2;
                object = bl ? collectionOp.getCollection() : collectionOp.createInstance();
            } else {
                object = object2 instanceof RenderedImage || object2 instanceof RenderableImage || object2 instanceof Collection ? object2 : object2;
            }
            parameterBlock2.addSource(object);
            ++n2;
        }
        object2 = null;
        if (this.isRenderable) {
            object2 = RCIFRegistry.create(this.nodeSupport.getRegistry(), this.nodeSupport.getOperationName(), parameterBlock2);
        } else {
            object = CIFRegistry.get(this.nodeSupport.getRegistry(), this.nodeSupport.getOperationName());
            object2 = object.create(parameterBlock2, this.nodeSupport.getRenderingHints());
            if (object2 != null) {
                ((CollectionImage)object2).setImageFactory((CollectionImageFactory)object);
            }
        }
        if (object2 == null) {
            throw new RuntimeException(JaiI18N.getString("CollectionOp0"));
        }
        this.oldHints = this.nodeSupport.getRenderingHints() == null ? null : (RenderingHints)this.nodeSupport.getRenderingHints().clone();
        return object2;
    }

    public Collection createRendering(RenderContext renderContext) {
        if (!this.isRenderable) {
            return this;
        }
        RenderingHints renderingHints = JAI.mergeRenderingHints(this.nodeSupport.getRenderingHints(), renderContext.getRenderingHints());
        if (renderingHints != renderContext.getRenderingHints()) {
            renderContext = (RenderContext)renderContext.clone();
            renderContext.setRenderingHints(renderingHints);
        }
        return this.renderCollection(this.imageCollection, renderContext);
    }

    private Collection renderCollection(Collection collection, RenderContext renderContext) {
        Object object;
        Collection<Object> collection2;
        if (collection == null || renderContext == null) {
            throw new IllegalArgumentException();
        }
        if (collection instanceof Set) {
            collection2 = Collections.synchronizedSet(new HashSet(collection.size()));
        } else if (collection instanceof SortedSet) {
            object = ((SortedSet)collection).comparator();
            collection2 = Collections.synchronizedSortedSet(new TreeSet(object));
        } else {
            collection2 = new Vector(collection.size());
        }
        object = collection.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e instanceof RenderableImage) {
                collection2.add(((RenderableImage)((Object)collection)).createRendering(renderContext));
                continue;
            }
            if (e instanceof Collection) {
                collection2.add(this.renderCollection((Collection)e, renderContext));
                continue;
            }
            collection2.add(e);
        }
        return collection2;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isRenderable()) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        Vector<Object> vector = this.nodeSupport.getParameterBlock().getSources();
        String string = propertyChangeEvent.getPropertyName().toLowerCase();
        if (this.imageCollection != null && (propertyChangeEvent instanceof PropertyChangeEventJAI && object == this && !(propertyChangeEvent instanceof PropertySourceChangeEvent) && nodeEventNames.contains(string) || (propertyChangeEvent instanceof CollectionChangeEvent || propertyChangeEvent instanceof RenderingChangeEvent) && vector.contains(object))) {
            Cloneable cloneable;
            ParameterBlock parameterBlock;
            Object object2;
            Object object3;
            Object object4;
            Collection collection = this.imageCollection;
            boolean bl = false;
            if (!(this.imageCollection instanceof CollectionImage)) {
                bl = true;
                this.imageCollection = null;
            } else if (object == this && (string.equals("operationname") || string.equals("operationregistry"))) {
                bl = true;
                this.imageCollection = null;
            } else if (propertyChangeEvent instanceof CollectionChangeEvent) {
                bl = true;
                object4 = ((CollectionImage)collection).getImageFactory();
                if (object4 == null) {
                    this.imageCollection = null;
                } else {
                    object3 = (CollectionChangeEvent)propertyChangeEvent;
                    object2 = this.nodeSupport.getParameterBlock().getParameters();
                    object2 = ImageUtil.evaluateParameters(object2);
                    parameterBlock = new ParameterBlock((Vector)vector.clone(), (Vector<Object>)object2);
                    cloneable = new ParameterBlock((Vector)vector.clone(), (Vector<Object>)object2);
                    int n = vector.indexOf(((EventObject)object3).getSource());
                    parameterBlock.setSource(((PropertyChangeEvent)object3).getOldValue(), n);
                    cloneable.setSource(((PropertyChangeEvent)object3).getNewValue(), n);
                    this.imageCollection = object4.update(parameterBlock, this.oldHints, (ParameterBlock)cloneable, this.oldHints, (CollectionImage)collection, this);
                }
            } else {
                object4 = ((CollectionImage)collection).getImageFactory();
                if (object4 == null || object4 != CIFRegistry.get(this.nodeSupport.getRegistry(), this.nodeSupport.getOperationName())) {
                    this.imageCollection = null;
                    bl = true;
                } else {
                    object3 = null;
                    object2 = null;
                    boolean bl2 = false;
                    if (string.equals("parameterblock")) {
                        object3 = (ParameterBlock)propertyChangeEvent.getOldValue();
                        object2 = (ParameterBlock)propertyChangeEvent.getNewValue();
                        bl2 = true;
                    } else if (string.equals("sources")) {
                        Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getParameters();
                        object3 = new ParameterBlock((Vector)propertyChangeEvent.getOldValue(), vector2);
                        object2 = new ParameterBlock((Vector)propertyChangeEvent.getNewValue(), vector2);
                        bl2 = true;
                    } else if (string.equals("parameters")) {
                        object3 = new ParameterBlock(vector, (Vector)propertyChangeEvent.getOldValue());
                        object2 = new ParameterBlock(vector, (Vector)propertyChangeEvent.getNewValue());
                        bl2 = true;
                    } else if (string.equals("renderinghints")) {
                        object3 = object2 = this.nodeSupport.getParameterBlock();
                        bl2 = true;
                    } else if (propertyChangeEvent instanceof RenderingChangeEvent) {
                        int n = vector.indexOf(propertyChangeEvent.getSource());
                        Vector vector3 = (Vector)vector.clone();
                        Vector vector4 = (Vector)vector.clone();
                        vector3.set(n, propertyChangeEvent.getOldValue());
                        vector4.set(n, propertyChangeEvent.getNewValue());
                        Vector<Object> vector5 = this.nodeSupport.getParameterBlock().getParameters();
                        object3 = new ParameterBlock(vector3, vector5);
                        object2 = new ParameterBlock(vector4, vector5);
                        bl2 = true;
                    }
                    if (bl2) {
                        bl = true;
                        this.imageCollection = object4.update((ParameterBlock)(object3 = ImageUtil.evaluateParameters((ParameterBlock)object3)), this.oldHints, (ParameterBlock)(object2 = ImageUtil.evaluateParameters((ParameterBlock)object2)), (RenderingHints)(cloneable = this.nodeSupport.getRenderingHints()), (CollectionImage)collection, this);
                        if (this.imageCollection != null) {
                            this.oldHints = cloneable;
                        }
                    }
                }
            }
            this.getCollection();
            if (bl) {
                this.resetProperties(true);
                object4 = new CollectionChangeEvent(this, collection, this.imageCollection);
                this.eventManager.firePropertyChange((PropertyChangeEvent)object4);
                object3 = this.getSinks();
                if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        parameterBlock = object2.next();
                        if (!(parameterBlock instanceof PropertyChangeListener)) continue;
                        ((PropertyChangeListener)((Object)parameterBlock)).propertyChange((PropertyChangeEvent)object4);
                    }
                }
            }
        }
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            this.thePropertySource = this.nodeSupport.getPropertySource(this, null);
            this.properties.addProperties(this.thePropertySource);
        }
    }

    protected synchronized void resetProperties(boolean bl) {
        this.properties.clearCachedProperties();
        if (bl && this.thePropertySource != null) {
            this.properties.removePropertySource(this.thePropertySource);
            this.thePropertySource = null;
        }
    }

    public synchronized String[] getPropertyNames() {
        this.createPropertySource();
        return this.properties.getPropertyNames();
    }

    public Class getPropertyClass(String string) {
        this.createPropertySource();
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        this.createPropertySource();
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.createPropertySource();
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.createPropertySource();
        this.properties.removeProperty(string);
    }

    public synchronized Object getDynamicProperty(String string) {
        this.createPropertySource();
        return this.thePropertySource.getProperty(string);
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.nodeSupport.addPropertyGenerator(propertyGenerator);
    }

    public synchronized void copyPropertyFromSource(String string, int n) {
        this.nodeSupport.copyPropertyFromSource(string, n);
    }

    public void suppressProperty(String string) {
        this.nodeSupport.suppressProperty(string);
    }

    public int size() {
        this.createCollection();
        return this.imageCollection.size();
    }

    public boolean isEmpty() {
        this.createCollection();
        return this.imageCollection.isEmpty();
    }

    public boolean contains(Object object) {
        this.createCollection();
        return this.imageCollection.contains(object);
    }

    public Iterator iterator() {
        this.createCollection();
        return this.imageCollection.iterator();
    }

    public Object[] toArray() {
        this.createCollection();
        return this.imageCollection.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.createCollection();
        return this.imageCollection.toArray(objectArray);
    }

    public boolean add(Object object) {
        this.createCollection();
        return this.imageCollection.add(object);
    }

    public boolean remove(Object object) {
        this.createCollection();
        return this.imageCollection.remove(object);
    }

    public boolean containsAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.createCollection();
        return this.imageCollection.retainAll(collection);
    }

    public void clear() {
        this.createCollection();
        this.imageCollection.clear();
    }

    static {
        nodeEventNames = new HashSet();
        nodeEventNames.add("operationname");
        nodeEventNames.add("operationregistry");
        nodeEventNames.add("parameterblock");
        nodeEventNames.add("sources");
        nodeEventNames.add("parameters");
        nodeEventNames.add("renderinghints");
    }
}

