/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.SunTileCache;
import com.sun.media.jai.util.SunTileScheduler;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.CollectionOp;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;

public final class JAI {
    private static final int HINT_IMAGE_LAYOUT = 101;
    private static final int HINT_INTERPOLATION = 102;
    private static final int HINT_OPERATION_REGISTRY = 103;
    private static final int HINT_OPERATION_BOUND = 104;
    private static final int HINT_BORDER_EXTENDER = 105;
    private static final int HINT_TILE_CACHE = 106;
    private static final int HINT_TILE_SCHEDULER = 107;
    private static final int HINT_DEFAULT_COLOR_MODEL_ENABLED = 108;
    private static final int HINT_DEFAULT_COLOR_MODEL_METHOD = 109;
    private static final int HINT_TILE_CACHE_METRIC = 110;
    private static final int HINT_SERIALIZE_DEEP_COPY = 111;
    private static final int HINT_TILE_CODEC_FORMAT = 112;
    private static final int HINT_TILE_ENCODING_PARAM = 113;
    private static final int HINT_TILE_DECODING_PARAM = 114;
    private static final int HINT_RETRY_INTERVAL = 115;
    private static final int HINT_NUM_RETRIES = 116;
    private static final int HINT_NEGOTIATION_PREFERENCES = 117;
    private static final int HINT_DEFAULT_RENDERING_SIZE = 118;
    public static RenderingHints.Key KEY_IMAGE_LAYOUT = new RenderingKey(101, class$javax$media$jai$ImageLayout == null ? (class$javax$media$jai$ImageLayout = JAI.class$("javax.media.jai.ImageLayout")) : class$javax$media$jai$ImageLayout);
    public static RenderingHints.Key KEY_INTERPOLATION = new RenderingKey(102, class$javax$media$jai$Interpolation == null ? (class$javax$media$jai$Interpolation = JAI.class$("javax.media.jai.Interpolation")) : class$javax$media$jai$Interpolation);
    public static RenderingHints.Key KEY_OPERATION_REGISTRY = new RenderingKey(103, class$javax$media$jai$OperationRegistry == null ? (class$javax$media$jai$OperationRegistry = JAI.class$("javax.media.jai.OperationRegistry")) : class$javax$media$jai$OperationRegistry);
    public static RenderingHints.Key KEY_OPERATION_BOUND = new RenderingKey(104, class$java$lang$Integer == null ? (class$java$lang$Integer = JAI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static RenderingHints.Key KEY_BORDER_EXTENDER = new RenderingKey(105, class$javax$media$jai$BorderExtender == null ? (class$javax$media$jai$BorderExtender = JAI.class$("javax.media.jai.BorderExtender")) : class$javax$media$jai$BorderExtender);
    public static RenderingHints.Key KEY_TILE_CACHE = new RenderingKey(106, class$javax$media$jai$TileCache == null ? (class$javax$media$jai$TileCache = JAI.class$("javax.media.jai.TileCache")) : class$javax$media$jai$TileCache);
    public static RenderingHints.Key KEY_TILE_CACHE_METRIC = new RenderingKey(110, class$java$lang$Object == null ? (class$java$lang$Object = JAI.class$("java.lang.Object")) : class$java$lang$Object);
    public static RenderingHints.Key KEY_TILE_SCHEDULER = new RenderingKey(107, class$javax$media$jai$TileScheduler == null ? (class$javax$media$jai$TileScheduler = JAI.class$("javax.media.jai.TileScheduler")) : class$javax$media$jai$TileScheduler);
    public static RenderingHints.Key KEY_DEFAULT_COLOR_MODEL_ENABLED = new RenderingKey(108, class$java$lang$Boolean == null ? (class$java$lang$Boolean = JAI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static RenderingHints.Key KEY_DEFAULT_COLOR_MODEL_METHOD = new RenderingKey(109, class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = JAI.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
    public static final RenderingHints.Key KEY_DEFAULT_RENDERING_SIZE = new RenderingKey(118, class$java$awt$Dimension == null ? (class$java$awt$Dimension = JAI.class$("java.awt.Dimension")) : class$java$awt$Dimension);
    public static RenderingHints.Key KEY_SERIALIZE_DEEP_COPY = new RenderingKey(111, class$java$lang$Boolean == null ? (class$java$lang$Boolean = JAI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static RenderingHints.Key KEY_TILE_CODEC_FORMAT = new RenderingKey(112, class$java$lang$String == null ? (class$java$lang$String = JAI.class$("java.lang.String")) : class$java$lang$String);
    public static RenderingHints.Key KEY_TILE_ENCODING_PARAM = new RenderingKey(113, class$javax$media$jai$tilecodec$TileCodecParameterList == null ? (class$javax$media$jai$tilecodec$TileCodecParameterList = JAI.class$("javax.media.jai.tilecodec.TileCodecParameterList")) : class$javax$media$jai$tilecodec$TileCodecParameterList);
    public static RenderingHints.Key KEY_TILE_DECODING_PARAM = new RenderingKey(114, class$javax$media$jai$tilecodec$TileCodecParameterList == null ? (class$javax$media$jai$tilecodec$TileCodecParameterList = JAI.class$("javax.media.jai.tilecodec.TileCodecParameterList")) : class$javax$media$jai$tilecodec$TileCodecParameterList);
    public static RenderingHints.Key KEY_RETRY_INTERVAL = new RenderingKey(115, class$java$lang$Integer == null ? (class$java$lang$Integer = JAI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static RenderingHints.Key KEY_NUM_RETRIES = new RenderingKey(116, class$java$lang$Integer == null ? (class$java$lang$Integer = JAI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static RenderingHints.Key KEY_NEGOTIATION_PREFERENCES = new RenderingKey(117, class$javax$media$jai$remote$NegotiableCapabilitySet == null ? (class$javax$media$jai$remote$NegotiableCapabilitySet = JAI.class$("javax.media.jai.remote.NegotiableCapabilitySet")) : class$javax$media$jai$remote$NegotiableCapabilitySet);
    private static final int DEFAULT_TILE_SIZE = 512;
    private static Dimension defaultTileSize = new Dimension(512, 512);
    private static Dimension defaultRenderingSize = new Dimension(0, 512);
    private OperationRegistry operationRegistry;
    private TileScheduler tileScheduler;
    private TileCache tileCache;
    private RenderingHints renderingHints;
    private static JAI defaultInstance = new JAI(OperationRegistry.initializeRegistry(), (TileScheduler)new SunTileScheduler(), (TileCache)new SunTileCache(), new RenderingHints(null));
    static /* synthetic */ Class class$javax$media$jai$ImageLayout;
    static /* synthetic */ Class class$javax$media$jai$Interpolation;
    static /* synthetic */ Class class$javax$media$jai$OperationRegistry;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$media$jai$BorderExtender;
    static /* synthetic */ Class class$javax$media$jai$TileCache;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$media$jai$TileScheduler;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$media$jai$tilecodec$TileCodecParameterList;
    static /* synthetic */ Class class$javax$media$jai$remote$NegotiableCapabilitySet;
    static /* synthetic */ Class class$javax$media$jai$JAI;
    static /* synthetic */ Class class$java$awt$image$RenderedImage;
    static /* synthetic */ Class class$javax$media$jai$CollectionImage;
    static /* synthetic */ Class class$java$awt$image$renderable$RenderableImage;

    private JAI(OperationRegistry operationRegistry, TileScheduler tileScheduler, TileCache tileCache, RenderingHints renderingHints) {
        this.operationRegistry = operationRegistry;
        this.tileScheduler = tileScheduler;
        this.tileCache = tileCache;
        this.renderingHints = renderingHints;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
        this.renderingHints.put(KEY_TILE_SCHEDULER, tileScheduler);
    }

    public static final String getBuildVersion() {
        try {
            String string;
            InputStream inputStream = (class$javax$media$jai$JAI == null ? (class$javax$media$jai$JAI = JAI.class$("javax.media.jai.JAI")) : class$javax$media$jai$JAI).getResourceAsStream("buildVersion");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(string);
                bl = true;
            }
            bufferedWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            return JaiI18N.getString("JAI13");
        }
    }

    public static final void disableDefaultTileCache() {
        TileCache tileCache = defaultInstance.getTileCache();
        if (tileCache != null) {
            tileCache.flush();
        }
        JAI.defaultInstance.renderingHints.remove(KEY_TILE_CACHE);
    }

    public static final void enableDefaultTileCache() {
        JAI.defaultInstance.renderingHints.put(KEY_TILE_CACHE, defaultInstance.getTileCache());
    }

    public static final void setDefaultTileSize(Dimension dimension) {
        if (dimension != null && (dimension.width <= 0 || dimension.height <= 0)) {
            throw new IllegalArgumentException();
        }
        defaultTileSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    public static final Dimension getDefaultTileSize() {
        return defaultTileSize != null ? (Dimension)defaultTileSize.clone() : null;
    }

    public static final void setDefaultRenderingSize(Dimension dimension) {
        if (dimension != null && dimension.width <= 0 && dimension.height <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI8"));
        }
        defaultRenderingSize = dimension == null ? null : new Dimension(dimension);
    }

    public static final Dimension getDefaultRenderingSize() {
        return defaultRenderingSize == null ? null : new Dimension(defaultRenderingSize);
    }

    public static JAI getDefaultInstance() {
        return defaultInstance;
    }

    static RenderingHints mergeRenderingHints(RenderingHints renderingHints, RenderingHints renderingHints2) {
        RenderingHints renderingHints3;
        if (renderingHints2 == null || renderingHints2.isEmpty()) {
            renderingHints3 = renderingHints;
        } else if (renderingHints == null || renderingHints.isEmpty()) {
            renderingHints3 = renderingHints2;
        } else {
            renderingHints3 = new RenderingHints(renderingHints);
            renderingHints3.add(renderingHints2);
        }
        return renderingHints3;
    }

    public JAI() {
        this.operationRegistry = JAI.defaultInstance.operationRegistry;
        this.tileScheduler = JAI.defaultInstance.tileScheduler;
        this.tileCache = JAI.defaultInstance.tileCache;
        this.renderingHints = (RenderingHints)JAI.defaultInstance.renderingHints.clone();
    }

    public OperationRegistry getOperationRegistry() {
        return this.operationRegistry;
    }

    public void setOperationRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.operationRegistry = operationRegistry;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
    }

    public TileScheduler getTileScheduler() {
        return this.tileScheduler;
    }

    public void setTileScheduler(TileScheduler tileScheduler) {
        if (tileScheduler == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.tileScheduler = tileScheduler;
        this.renderingHints.put(KEY_TILE_SCHEDULER, tileScheduler);
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(TileCache tileCache) {
        if (tileCache == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.tileCache = tileCache;
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
    }

    public static TileCache createTileCache(int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI10"));
        }
        return new SunTileCache(l);
    }

    public static TileCache createTileCache(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI10"));
        }
        return new SunTileCache(l);
    }

    public static TileCache createTileCache() {
        return new SunTileCache();
    }

    public static TileScheduler createTileScheduler() {
        return new SunTileScheduler();
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createNS(string, parameterBlock, renderingHints);
    }

    public RenderedOp createNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "rendered";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!(class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage).isAssignableFrom(operationDescriptor.getDestClass(string2))) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI2"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        RenderedOp renderedOp = new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2);
        if (operationDescriptor.isImmediate()) {
            PlanarImage planarImage = null;
            try {
                planarImage = renderedOp.getRendering();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (planarImage == null) {
                return null;
            }
        }
        return renderedOp;
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createCollectionNS(string, parameterBlock, renderingHints);
    }

    public Collection createCollectionNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Collection<Collection> collection;
        Class clazz;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "collection";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!(class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage).isAssignableFrom(clazz = operationDescriptor.getDestClass(string2)) && !(class$javax$media$jai$CollectionImage == null ? (class$javax$media$jai$CollectionImage = JAI.class$("javax.media.jai.CollectionImage")) : class$javax$media$jai$CollectionImage).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI5"));
        }
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        StringBuffer stringBuffer = new StringBuffer();
        if (operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            if ((class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage).isAssignableFrom(clazz)) {
                Vector<RenderedOp> vector = new Vector<RenderedOp>(1);
                vector.add(new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2));
                return vector;
            }
            CollectionOp collectionOp = new CollectionOp(this.operationRegistry, string, parameterBlock, renderingHints2);
            if (operationDescriptor.isImmediate()) {
                Collection collection2 = null;
                try {
                    collection2 = collectionOp.getCollection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (collection2 == null) {
                    return null;
                }
            }
            return collectionOp;
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n) {
            collection = vector.elementAt(n3);
            if (collection instanceof Collection) {
                iteratorArray[n3] = ((Collection)collection).iterator();
                if (iterator == null || ((Collection)collection).size() < n2) {
                    iterator = iteratorArray[n3];
                    n2 = ((Collection)collection).size();
                }
            }
            ++n3;
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        collection = null;
        int n4 = 0;
        while (n4 < n) {
            object = vector.elementAt(n4);
            if (object instanceof Collection) {
                try {
                    collection = (Collection)object.getClass().newInstance();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n4;
        }
        if (collection == null) {
            collection = new Vector();
        }
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            int n5 = 0;
            while (n5 < n) {
                if (iteratorArray[n5] == null) {
                    ((ParameterBlock)object).addSource(vector.elementAt(n5));
                } else {
                    ((ParameterBlock)object).addSource(iteratorArray[n5].next());
                }
                ++n5;
            }
            Collection collection3 = this.createCollectionNS(string, (ParameterBlock)object, renderingHints2);
            if (collection3 instanceof Vector && collection3.size() == 1 && ((Vector)collection3).elementAt(0) instanceof RenderedOp) {
                collection.add((Collection)((Vector)collection3).elementAt(0));
                continue;
            }
            collection.add(collection3);
        }
        return collection;
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock) {
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, int n, int n2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n, Object object2, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(object2);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Collection collection) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(collection);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, float f) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(f);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, float f4, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(f4);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, int n, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(n);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        parameterBlock.add(object6);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        parameterBlock.add(n5);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock) {
        return JAI.createCollection(string, parameterBlock, null);
    }

    public static RenderableOp createRenderable(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createRenderableNS(string, parameterBlock, renderingHints);
    }

    public static RenderableOp createRenderable(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableNS(string, parameterBlock, null);
    }

    public RenderableOp createRenderableNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "renderable";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!(class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage).isAssignableFrom(operationDescriptor.getDestClass(string2))) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI4"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        RenderableOp renderableOp = new RenderableOp(this.operationRegistry, string, parameterBlock, JAI.mergeRenderingHints(this.renderingHints, renderingHints));
        return renderableOp;
    }

    public RenderableOp createRenderableNS(String string, ParameterBlock parameterBlock) {
        return this.createRenderableNS(string, parameterBlock, null);
    }

    public static Collection createRenderableCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createRenderableCollectionNS(string, parameterBlock, renderingHints);
    }

    public static Collection createRenderableCollection(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableCollectionNS(string, parameterBlock, null);
    }

    public Collection createRenderableCollectionNS(String string, ParameterBlock parameterBlock) {
        return this.createRenderableCollectionNS(string, parameterBlock, null);
    }

    public Collection createRenderableCollectionNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Collection<Collection> collection;
        Class clazz;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "renderableCollection";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!(class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage).isAssignableFrom(clazz = operationDescriptor.getDestClass(string2)) && !(class$javax$media$jai$CollectionImage == null ? (class$javax$media$jai$CollectionImage = JAI.class$("javax.media.jai.CollectionImage")) : class$javax$media$jai$CollectionImage).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI6"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        parameterBlock = (ParameterBlock)parameterBlock.clone();
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        if (operationDescriptor.validateArguments(string2, parameterBlock, stringBuffer)) {
            if ((class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage).isAssignableFrom(clazz)) {
                Vector<RenderableOp> vector = new Vector<RenderableOp>(1);
                RenderableOp renderableOp = new RenderableOp(this.operationRegistry, string, parameterBlock, renderingHints2);
                vector.add(renderableOp);
                return vector;
            }
            CollectionOp collectionOp = new CollectionOp(this.operationRegistry, string, parameterBlock, renderingHints2, true);
            if (operationDescriptor.isImmediate()) {
                Collection collection2 = null;
                try {
                    collection2 = collectionOp.getCollection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (collection2 == null) {
                    return null;
                }
            }
            return collectionOp;
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n) {
            collection = vector.elementAt(n3);
            if (collection instanceof Collection) {
                iteratorArray[n3] = ((Collection)collection).iterator();
                if (iterator == null || ((Collection)collection).size() < n2) {
                    iterator = iteratorArray[n3];
                    n2 = ((Collection)collection).size();
                }
            }
            ++n3;
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        collection = null;
        int n4 = 0;
        while (n4 < n) {
            object = vector.elementAt(n4);
            if (object instanceof Collection) {
                try {
                    collection = (Collection)object.getClass().newInstance();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n4;
        }
        if (collection == null) {
            collection = new Vector();
        }
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            int n5 = 0;
            while (n5 < n) {
                if (iteratorArray[n5] == null) {
                    ((ParameterBlock)object).addSource(vector.elementAt(n5));
                } else {
                    ((ParameterBlock)object).addSource(iteratorArray[n5].next());
                }
                ++n5;
            }
            Collection collection3 = this.createRenderableCollectionNS(string, (ParameterBlock)object, renderingHints2);
            if (collection3 instanceof Vector && collection3.size() == 1 && ((Vector)collection3).elementAt(0) instanceof RenderableOp) {
                collection.add((Collection)((Vector)collection3).elementAt(0));
                continue;
            }
            collection.add(collection3);
        }
        return collection;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.renderingHints = renderingHints;
    }

    public void clearRenderingHints() {
        this.renderingHints = new RenderingHints(null);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI7"));
        }
        return this.renderingHints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI7"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI9"));
        }
        try {
            this.renderingHints.put(key, object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public void removeRenderingHint(RenderingHints.Key key) {
        this.renderingHints.remove(key);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class RenderingKey
    extends RenderingHints.Key {
        private Class objectClass;

        RenderingKey(int n, Class clazz) {
            super(n);
            this.objectClass = clazz;
        }

        public boolean isCompatibleValue(Object object) {
            return this.objectClass.isInstance(object);
        }
    }
}

