/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringKeyHashtable;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.util.CaselessStringKey;

class PropertyEnvironment
implements PropertySource {
    Vector pg;
    Vector sources;
    private static final Object PRESENT = new Object();
    CaselessStringKeyHashtable suppressed;
    CaselessStringKeyHashtable sourceForProp;
    private Object op;
    private CaselessStringKeyHashtable propNames;
    private PropertySource defaultPropertySource = null;
    private boolean areDefaultsMapped = true;

    public PropertyEnvironment(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, Object object) {
        this.sources = vector;
        this.pg = vector2 == null ? null : (Vector)vector2.clone();
        this.suppressed = new CaselessStringKeyHashtable();
        if (vector3 != null) {
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                this.suppressed.put(enumeration.nextElement(), PRESENT);
            }
        }
        this.sourceForProp = hashtable == null ? null : new CaselessStringKeyHashtable((Map)hashtable);
        this.op = object;
        this.hashNames();
    }

    public String[] getPropertyNames() {
        this.mapDefaults();
        int n = 0;
        String[] stringArray = new String[this.propNames.size()];
        Enumeration enumeration = this.propNames.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((CaselessStringKey)enumeration.nextElement()).getName();
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PropertyUtil.getPropertyNames((String[])stringArray, (String)string);
    }

    public Class getPropertyClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.mapDefaults();
        Object object = this.propNames.get(string);
        Object object2 = null;
        if (object == null) {
            return Image.UndefinedProperty;
        }
        if (object instanceof PropertyGenerator) {
            object2 = ((PropertyGenerator)object).getProperty(string, this.op);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            PropertySource propertySource = (PropertySource)this.sources.elementAt(n);
            object2 = propertySource.getProperty(string);
        } else if (object instanceof PropertySource) {
            object2 = ((PropertySource)object).getProperty(string);
        }
        return object2;
    }

    public void copyPropertyFromSource(String string, int n) {
        PropertySource propertySource = (PropertySource)this.sources.elementAt(n);
        this.propNames.put(string, (Object)propertySource);
        this.suppressed.remove(string);
    }

    public void suppressProperty(String string) {
        this.suppressed.put(string, PRESENT);
        this.hashNames();
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (this.pg == null) {
            this.pg = new Vector();
        }
        this.pg.addElement(propertyGenerator);
        this.removeSuppressedProps(propertyGenerator);
        this.hashNames();
    }

    public void setDefaultPropertySource(PropertySource propertySource) {
        if (propertySource == this.defaultPropertySource) {
            return;
        }
        if (this.defaultPropertySource != null) {
            this.hashNames();
        }
        this.areDefaultsMapped = false;
        this.defaultPropertySource = propertySource;
    }

    private void mapDefaults() {
        if (!this.areDefaultsMapped) {
            String[] stringArray;
            this.areDefaultsMapped = true;
            if (this.defaultPropertySource != null && (stringArray = this.defaultPropertySource.getPropertyNames()) != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    if (!this.suppressed.containsKey(stringArray[n2]) && ((object = this.propNames.get(stringArray[n2])) == null || object instanceof Integer)) {
                        this.propNames.put(stringArray[n2], (Object)this.defaultPropertySource);
                    }
                    ++n2;
                }
            }
        }
    }

    private void removeSuppressedProps(PropertyGenerator propertyGenerator) {
        String[] stringArray = propertyGenerator.getPropertyNames();
        int n = 0;
        while (n < stringArray.length) {
            this.suppressed.remove(stringArray[n]);
            ++n;
        }
    }

    private void hashNames() {
        Object object;
        Object object2;
        Object object3;
        this.propNames = new CaselessStringKeyHashtable();
        if (this.sources != null) {
            int n = this.sources.size() - 1;
            while (n >= 0) {
                object3 = this.sources.elementAt(n);
                if (object3 instanceof PropertySource && (object2 = (object = (String[])object3).getPropertyNames()) != null) {
                    int n2 = 0;
                    while (n2 < ((String[])object2).length) {
                        String string = object2[n2];
                        if (!this.suppressed.containsKey(string)) {
                            this.propNames.put(string, (Object)new Integer(n));
                        }
                        ++n2;
                    }
                }
                --n;
            }
        }
        if (this.pg != null) {
            object3 = ((AbstractList)this.pg).iterator();
            while (object3.hasNext()) {
                PropertyGenerator propertyGenerator = (PropertyGenerator)object3.next();
                if (!propertyGenerator.canGenerateProperties(this.op) || (object = propertyGenerator.getPropertyNames()) == null) continue;
                int n = 0;
                while (n < ((String[])object).length) {
                    Object object4 = object[n];
                    if (!this.suppressed.containsKey((String)object4)) {
                        this.propNames.put((String)object4, (Object)propertyGenerator);
                    }
                    ++n;
                }
            }
        }
        if (this.sourceForProp != null) {
            Enumeration enumeration = this.sourceForProp.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (CaselessStringKey)enumeration.nextElement();
                if (this.suppressed.containsKey((CaselessStringKey)object3)) continue;
                object = (Integer)this.sourceForProp.get((CaselessStringKey)object3);
                object2 = (PropertySource)this.sources.elementAt((Integer)object);
                this.propNames.put((CaselessStringKey)object3, object2);
            }
        }
        this.areDefaultsMapped = false;
    }
}

