/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfEngine;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfCIDFontsData;
import org.jpedal.fonts.PdfFontsData;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.images.PdfImages;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.text.PdfThreshold;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.xobjects.PdfXObjects;

public class PdfDecoder
extends PdfEngine {
    public static final String version = "1.79";
    private String values_deliminator = "";
    private int page_count = 0;
    private HashMap pages_references = new HashMap();

    public PdfDecoder(boolean bl) throws PdfException {
        this.use_client = bl;
        this.init();
    }

    public final void closePdfFile() {
        this.current_pdf_file.closePdfFile();
    }

    public final void initValues(boolean bl, boolean bl2, boolean bl3, boolean bl4, PdfThreshold pdfThreshold, int n, boolean bl5, String string, int n2, boolean bl6) {
        this.embed_width_data = bl4;
        this.current_thresholds = pdfThreshold;
        PdfImages.dpi = n;
        this.draw_screen_interactively = bl5;
        this.use_client = this.use_client;
        this.debug_level = n2;
        this.values_deliminator = string;
        this.can_access_images = bl6;
        this.process_text = bl;
        this.process_images = bl2;
        this.process_shapes = bl3;
    }

    public final void initValues(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.draw_screen_interactively = bl4;
        this.process_text = bl;
        this.process_images = bl2;
        this.process_shapes = bl3;
    }

    public final int getRotation(int n) {
        return this.rotation.elementAt(n);
    }

    public final String[] getInformationFields() {
        PdfDecoder pdfDecoder = this;
        return pdfDecoder.current_pdf_file.getInformationFields();
    }

    public final boolean decodePage(boolean bl, int n) throws PdfException {
        boolean bl2;
        String string = (String)this.pages_references.get("" + n);
        String string2 = "";
        this.use_client = bl;
        this.page_data.reset_page_shapes();
        boolean bl3 = bl2 = this.pages_read.get(string) != null;
        if (!this.current_pdf_file.isEncrypted()) {
            if (string != null & !bl2) {
                this.pages_read.put(string, "x");
                if (this.debug_level > 1) {
                    LogWriter.writeLog("Processing content from page " + n);
                }
                this.page_number = n;
                HashMap hashMap = this.readValues(string, false);
                String string3 = (String)hashMap.get("Annots");
                if (string3 != null) {
                    this.readAnnots(string3);
                }
                if ((string3 = (String)hashMap.get("Resources")) != null) {
                    this.readResources(string3);
                }
                if ((string3 = (String)hashMap.get("Contents")) != null && (string2 = string3).indexOf("[") != -1) {
                    string2 = Strip.removeArrayMarkers(string2);
                }
                this.decodePageContent(string2);
                this.current_font_data.flushFontData();
                this.current_CID_font_data.flushFontData();
                if (bl) {
                    this.refreshDisplay(1500.0f);
                    this.flushShapeCache();
                    this.completeImage(this.getMaxY(this.page_number));
                    ObjectStore.saveStoredImage("_" + this.page_number, this.pdf_selected_image, false, false, "jpg");
                }
            } else {
                LogWriter.writeLog("Content from page " + n + " already decoded");
            }
        }
        return bl2;
    }

    public final int getPageCount() {
        return this.page_count;
    }

    public final String getPageReport() {
        String string = "";
        if (this.current_color_data.hasCMYKColors()) {
            string = string + "File contains CMYK colours which will be approximated\n";
        }
        if (this.current_color_data.hasSeparationColors()) {
            string = string + "File contains Separation colours which will be shown in false colours\n";
        }
        return string;
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        this.current_pdf_file.openPdfFile(byArray);
        String string = this.current_pdf_file.getType();
        LogWriter.writeLog("Pdf version : " + string);
        String string2 = this.current_pdf_file.readReferenceTable(this.use_client);
        LogWriter.writeLog("Reading catalog");
        HashMap hashMap = this.current_pdf_file.readObjectData(string2, false, false, false);
        String string3 = (String)hashMap.get("Pages");
        if (string3 != null) {
            this.readAllPageReferences(string3);
        }
        this.current_Xobject_data.storeFileName("<raw data>");
    }

    public final void openPdfFile(String string) throws PdfException {
        this.current_pdf_file.openPdfFile(string);
        String string2 = this.current_pdf_file.getType();
        LogWriter.writeLog("Pdf version : " + string2);
        String string3 = this.current_pdf_file.readReferenceTable(this.use_client);
        LogWriter.writeLog("Reading catalog");
        HashMap hashMap = this.current_pdf_file.readObjectData(string3, false, false, false);
        String string4 = (String)hashMap.get("Pages");
        if (string4 != null) {
            this.readAllPageReferences(string4);
        }
        if (this.debug_level > 0) {
            LogWriter.writeLog("Pages read");
        }
        this.current_Xobject_data.storeFileName(string);
    }

    private final void init() {
        this.setupCommandList();
        this.current_image_data = new PdfImages();
        this.current_pdf_file = new PdfObjectReader();
        this.current_font_data = new PdfFontsData(this.current_pdf_file);
        this.current_CID_font_data = new PdfCIDFontsData(this.current_pdf_file);
        this.current_height_lookup_data = new PdfHeightTable(this.current_pdf_file);
        this.current_Xobject_data = new PdfXObjects(this.current_pdf_file, this.current_image_data);
        this.current_color_data = new PdfColor(this.current_pdf_file);
        this.pdf_data = new PdfData();
        this.pdf_images = new PdfImageData();
        LogWriter.writeLog("Pdf code initialised");
    }

    private final void readAllPageReferences(String string) throws PdfException {
        String string2 = string;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.debug_level > 0) {
            LogWriter.writeLog("pages_id=" + string + "<");
        }
        boolean bl = false;
        if (this.debug_level > 0) {
            bl = true;
        }
        Vector<Object> vector = new Vector<Object>();
        this.page_number = 1;
        float f = 4.0f;
        LogWriter.writeLog("Page metadata being read");
        while (true) {
            Object object;
            Object object2;
            String string6;
            if (this.debug_level > 0) {
                LogWriter.writeLog("page value=" + string2 + "<");
            }
            if ((string6 = this.current_pdf_file.isObjectList(string2, false)) != null) {
                if (this.debug_level > 0) {
                    LogWriter.writeLog("Indirect");
                }
                string6 = string6.substring(1, string6.length() - 1).trim();
                try {
                    object2 = new StringTokenizer(string6, "R");
                    string2 = ((StringTokenizer)object2).nextToken().trim() + " R";
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim() + " R";
                        vector.addElement(object);
                        if (this.debug_level <= 0) continue;
                        LogWriter.writeLog("added=" + (String)object);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " putting initial pages in queue with value >" + string6 + "<");
                    throw new PdfException("Exception");
                }
            }
            if ((string3 = (String)((HashMap)(object2 = this.readValues(string2, bl))).get("Kids")) != null) {
                if (this.debug_level > 0) {
                    LogWriter.writeLog("Kids");
                }
                if ((string4 = string3).startsWith("[")) {
                    string4 = string4.substring(1, string4.length() - 1).trim();
                }
            }
            if ((string3 = (String)((HashMap)object2).get("Type")) != null) {
                string5 = string3;
            }
            if (string5.indexOf("/Pages") != -1) {
                if (this.debug_level > 0) {
                    LogWriter.writeLog("Pages >" + string4 + "<");
                }
                try {
                    object = new StringTokenizer(string4, "R");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string7 = ((StringTokenizer)object).nextToken().trim() + " R";
                        vector.addElement(string7);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " putting pages in queue with value >" + string4 + "<");
                    throw new PdfException("Exception");
                }
            } else if (string5.indexOf("/Page") != -1) {
                if (this.debug_level > 0) {
                    LogWriter.writeLog("Page");
                }
                this.pages_references.put("" + this.page_number, string2);
                ++this.page_number;
            } else if (string5.indexOf("/Catalog") != -1) {
                if (this.debug_level > 0) {
                    LogWriter.writeLog("Catalog");
                }
                if ((object = (String)((HashMap)object2).get("Pages")) != null) {
                    vector.addElement(object);
                }
            }
            if (vector.isEmpty()) break;
            if (this.debug_level > 0) {
                LogWriter.writeLog("IS queue empty=" + vector.isEmpty());
            }
            string2 = (String)vector.firstElement();
            if (this.debug_level > 0) {
                LogWriter.writeLog("new page=" + string2);
            }
            vector.removeElement(string2);
            if (this.debug_level <= 0) continue;
            LogWriter.writeLog("removed");
        }
        this.page_count = this.page_number - 1;
        this.page_number = 0;
        if (this.debug_level > 0) {
            LogWriter.writeLog("============================");
        }
    }
}

