/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfFormRasterizer;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.Fonts;
import org.jpedal.fonts.PdfFontsData;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.PdfImages;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.TextState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.xobjects.PdfXObjects;

public class PdfEngine
extends PdfFormRasterizer {
    private boolean is_clip = false;
    private Shape current_shape = null;
    private int token_number = 0;
    private boolean isPageContent = true;
    private Vector_Object graphics_state_stack = new Vector_Object(50);
    private Vector_Object text_state_stack = new Vector_Object(50);
    private byte[] current_byte_stream;
    private int data_pointer = 0;
    private String inline_decode_parameters = "";
    private int inline_start_pointer = 0;
    private int inline_end_pointer = 0;
    private PdfShape current_draw_shape = new PdfShape();
    private Vector number_values = new Vector();
    private int text_start_pointer = 0;
    private int text_end_pointer = 0;
    private int inline_image_id = 0;
    private String current_token = "";
    private HashMap commands = new HashMap();
    private int move_command = 0;
    private byte[] character_stream;
    private String current_colorspace_id = "";
    private boolean in_marked_sequence = false;
    private String current_image = "";
    private StringBuffer commands_processed = new StringBuffer();
    private boolean is_inline_stream = false;
    private boolean inTextTokenStream = false;
    private String inline_filter_value = null;
    private final String[] text_commands = new String[]{"BT", "ET", "Tc", "Tw", "Tz", "TL", "Tf", "Tr", "Ts", "Td", "TD", "Tm", "T*", "Tj", "TJ", "'", "\""};
    private final String[] general_commands = new String[]{"w", "j", "J", "M", "d", "ri", "i", "gs", "q", "Q", "cm", "d0", "d1", "cs", "CS", "sc", "scn", "SC", "SCN", "g", "G", "rg", "RG", "k", "K", "sh", "BMC", "BDC", "EMC", "MP", "DP", "BX", "EX"};
    private final String[] shape_commands = new String[]{"m", "l", "c", "v", "y", "h", "re", "S", "s", "f", "F", "f*", "B", "B*", "b", "b*", "n", "W", "W*"};
    private final String[] image_commands = new String[]{"BI", "ID", "EI", "Do"};

    public PdfEngine(PdfObjectReader pdfObjectReader, PdfFontsData pdfFontsData) {
        this.current_pdf_file = pdfObjectReader;
        this.current_font_data = pdfFontsData;
        this.setupCommandList();
        this.current_image_data = new PdfImages();
        this.current_height_lookup_data = new PdfHeightTable(pdfObjectReader);
        this.current_Xobject_data = new PdfXObjects(pdfObjectReader, this.current_image_data);
        this.current_color_data = new PdfColor(pdfObjectReader);
        this.pdf_data = new PdfData();
        this.pdf_images = new PdfImageData();
    }

    public PdfEngine() {
    }

    protected final void decodePageContent(String string) throws PdfException {
        String string2 = "";
        this.data_pointer = 0;
        byte[] byArray = this.readPageIntoStream(string);
        if (byArray.length > 0) {
            this.current_graphics_state.resetCTM();
            this.character_stream = new byte[byArray.length];
            try {
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
                dataInputStream.readFully(this.character_stream);
                dataInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading data");
            }
            this.decodeStreamIntoObjects();
            LogWriter.writeLog("Processed page " + this.page_number);
            this.character_stream = new byte[0];
        }
    }

    public final void decodeGlyphContent(String string) throws PdfException {
        String string2 = "";
        this.isPageContent = false;
        this.data_pointer = 0;
        byte[] byArray = this.current_pdf_file.readStreamObject(string);
        if (byArray.length > 0) {
            this.current_graphics_state.resetCTM();
            this.character_stream = new byte[byArray.length];
            try {
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
                dataInputStream.readFully(this.character_stream);
                dataInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading data");
            }
            this.decodeStreamIntoObjects();
            this.character_stream = new byte[0];
        }
    }

    protected final void setupCommandList() {
        int n = 0;
        while (n < this.text_commands.length) {
            this.commands.put(this.text_commands[n], "t");
            ++n;
        }
        int n2 = 0;
        while (n2 < this.image_commands.length) {
            this.commands.put(this.image_commands[n2], "i");
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.shape_commands.length) {
            this.commands.put(this.shape_commands[n3], "s");
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.general_commands.length) {
            this.commands.put(this.general_commands[n4], "g");
            ++n4;
        }
    }

    private final void decodeStreamIntoObjects() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 32;
        int n2 = 32;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 32;
        this.data_pointer = 0;
        byte by = 0;
        int n4 = this.character_stream.length;
        boolean bl3 = false;
        do {
            boolean bl4 = false;
            n2 = n;
            by = this.character_stream[this.data_pointer];
            n = (char)by;
            if (!bl && n == 13 | n == 10) {
                n = 32;
            }
            if (n == 40 | n == 91 && this.inTextTokenStream && n2 != 32 && n2 != 91 && bl2 | this.commands.get(stringBuffer.toString()) != null) {
                --this.data_pointer;
                n = 32;
            }
            if (this.inTextTokenStream && n != 32 && bl2) {
                --this.data_pointer;
                n = 32;
                bl4 = true;
            }
            if (bl | n != 32 && (stringBuffer.length() >= 1 || n != 32)) {
                stringBuffer.append((char)n);
                if ((n3 == 116 | n3 == 84) & (n == 106 | n == 74)) {
                    bl2 = true;
                } else if (n3 == 41 & (n == 39 | n == 34)) {
                    bl2 = true;
                    n2 = 32;
                } else {
                    bl2 = false;
                }
                n3 = n3 == 92 ? 88 : n;
            }
            if (!bl && (n == 40 | n == 91) & n2 != 92 & this.inTextTokenStream) {
                bl = true;
            }
            if (bl && n2 != 92 && bl2) {
                bl = false;
            }
            if (!bl && stringBuffer.length() > 0 && n == 32 && n2 != 41) {
                n = 32;
                bl2 = false;
                n3 = 32;
                this.current_token = stringBuffer.toString();
                stringBuffer.setLength(0);
                if (this.inTextTokenStream && this.current_token.toUpperCase().endsWith("TJ") | this.current_token.endsWith("\"") | this.current_token.endsWith("'")) {
                    int n5 = this.data_pointer;
                    if (bl4) {
                        ++n5;
                    }
                    this.current_byte_stream = new byte[n5 - this.text_start_pointer];
                    int n6 = this.text_start_pointer;
                    while (n6 < n5) {
                        this.current_byte_stream[n6 - this.text_start_pointer] = this.character_stream[n6];
                        ++n6;
                    }
                }
                try {
                    if (this.is_inline_stream && this.process_images) {
                        if (this.current_token.equals("EI")) {
                            this.EI();
                        }
                        ++this.token_number;
                    } else {
                        this.processToken();
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " processing token >" + this.current_token + "<");
                }
                this.current_byte_stream = null;
                this.text_start_pointer = this.data_pointer + 1;
            }
            ++this.data_pointer;
        } while (n4 > this.data_pointer);
    }

    private final void d1() {
        this.d_x = Float.parseFloat((String)this.number_values.elementAt(5));
        this.d_y = Float.parseFloat((String)this.number_values.elementAt(0)) - Float.parseFloat((String)this.number_values.elementAt(2)) + 1.0f;
        this.initGlyphDisplay();
    }

    private final void d0() {
        this.d_x = Float.parseFloat((String)this.number_values.elementAt(1));
        this.d_y = Float.parseFloat((String)this.number_values.elementAt(0));
        this.initGlyphDisplay();
    }

    private final void TD() {
        float f = Float.parseFloat((String)this.number_values.elementAt(1));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
        this.relativeMove(f, f2);
        if (this.current_token.equals("TD")) {
            float f3 = -f2;
            this.current_text_state.setLeading(f3);
            this.flushShapeCache();
        }
    }

    private final byte[] readPageIntoStream(String string) throws PdfException {
        String string2;
        LogWriter.writeLog("Extracting content from stream");
        this.setRotationMatrix(this.rotation.elementAt(this.page_number), this.max_x.elementAt(this.page_number), this.max_y.elementAt(this.page_number));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "R");
        byte[] byArray = new byte[]{};
        this.current_text_state = new TextState();
        if (stringTokenizer.countTokens() == 1) {
            string2 = stringTokenizer.nextToken() + "R";
            if ((string = this.current_pdf_file.readRef(string, string2)).startsWith("[")) {
                string = string.substring(1);
            }
            stringTokenizer = new StringTokenizer(string, "R");
        }
        while (stringTokenizer.hasMoreTokens()) {
            byte[] byArray2;
            string2 = stringTokenizer.nextToken().trim();
            if (this.debug_level > 1) {
                LogWriter.writeLog("Processing object " + string2 + " from page " + this.page_number);
            }
            if ((byArray2 = this.current_pdf_file.readStreamObject(string2)) == null) {
                LogWriter.writeLog("Null stream returned");
                continue;
            }
            int n = byArray.length + 1;
            int n2 = byArray2.length;
            if (n2 <= 0) continue;
            while (byArray2[n2 - 1] == 0) {
                --n2;
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n - 1);
            byArray3[n - 1] = 32;
            byArray = new byte[n + n2];
            System.arraycopy(byArray3, 0, byArray, 0, n);
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        return byArray;
    }

    private final void BT() {
        this.current_text_state.resetTm();
        this.current_graphics_state.setClippingShape(null);
        this.inTextTokenStream = true;
        this.current_font = this.current_text_state.getFontName();
        this.current_text_state.setCurrentFontSize(0);
        this.font_ID = this.current_text_state.getFontID();
        if (this.use_client) {
            this.unscaled_font = Fonts.getFontObject(1, this.current_font);
        }
        this.flushShapeCache();
    }

    private final void restoreGraphicsState() {
        this.current_graphics_state = (GraphicsState)this.graphics_state_stack.pull();
        this.current_text_state = (TextState)this.text_state_stack.pull();
    }

    private final void EI() {
        block5: {
            String string = this.current_Xobject_data.getFilename() + "-IN-" + this.inline_image_id;
            this.is_inline_stream = false;
            if (!this.can_access_images) break block5;
            this.inline_end_pointer = this.data_pointer - 3;
            byte[] byArray = new byte[this.inline_end_pointer - this.inline_start_pointer];
            int n = this.inline_start_pointer;
            while (n < this.inline_end_pointer) {
                byArray[n - this.inline_start_pointer] = this.character_stream[n];
                ++n;
            }
            if (this.inline_filter_value != null && !this.inline_filter_value.startsWith("/DCTDecode")) {
                byArray = this.current_pdf_file.decodeFilters(byArray, 0L, 0L, this.inline_filter_value, this.inline_decode_parameters);
            }
            String string2 = "Processing Inline image: " + string;
            if (this.debug_level > 1) {
                LogWriter.writeLog(string2);
            }
            try {
                BufferedImage bufferedImage = this.current_image_data.processInlineImage(byArray, string, this.current_graphics_state);
                this.current_image = string;
                this.saveCurrentImage(bufferedImage, true);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with inline image");
            }
        }
    }

    private final void L() {
        float f = Float.parseFloat((String)this.number_values.elementAt(1));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
        this.current_draw_shape.lineTo(f, f2);
    }

    private final void F() {
        if (this.current_token.endsWith("*")) {
            this.current_draw_shape.setEVENODDWindingRule();
        } else {
            this.current_draw_shape.setNONZEROWindingRule();
        }
        this.current_draw_shape.closeShape();
        boolean bl = true;
        if (this.current_token.startsWith("f")) {
            bl = false;
        }
        this.current_shape = this.current_draw_shape.generateShapeFromPath(this.current_graphics_state.CTM, this.is_clip, this.af_rotation);
        if (this.use_client) {
            this.drawShape(this.current_graphics_state, 2, this.current_shape);
        }
        boolean bl2 = this.current_graphics_state.is_NonStrokewhite();
        if (this.isPageContent && this.current_draw_shape.getSegmentCount() <= 30 && !this.current_draw_shape.hasCurves() | this.current_shape.getBounds().getWidth() > 20.0 | this.current_shape.getBounds().getHeight() > 20.0) {
            this.page_data.addShapeForCalculatingFurniture(this.af_rotation, this.current_graphics_state, this.current_draw_shape, bl, this.current_graphics_state.getClippingShape(), 2, new Area(this.current_shape), this.token_number, bl2);
        }
        this.is_clip = false;
        this.current_draw_shape.resetPath();
    }

    private final void TC() {
        this.current_text_state.setCharacterSpacing(Float.parseFloat((String)this.number_values.elementAt(0)));
    }

    private final void CM() {
        float[][] fArray = new float[3][3];
        fArray[0][0] = Float.parseFloat((String)this.number_values.elementAt(5));
        fArray[0][1] = Float.parseFloat((String)this.number_values.elementAt(4));
        fArray[0][2] = 0.0f;
        fArray[1][0] = Float.parseFloat((String)this.number_values.elementAt(3));
        fArray[1][1] = Float.parseFloat((String)this.number_values.elementAt(2));
        fArray[1][2] = 0.0f;
        fArray[2][0] = Float.parseFloat((String)this.number_values.elementAt(1));
        fArray[2][1] = Float.parseFloat((String)this.number_values.elementAt(0));
        fArray[2][2] = 1.0f;
        this.current_graphics_state.CTM = Matrix.multiply(fArray, this.current_graphics_state.CTM);
    }

    private final void BI() {
        ++this.inline_image_id;
    }

    private final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.current_text_state.Tm = Matrix.multiply(fArray, this.current_text_state.Tm);
        this.move_command = 2;
    }

    private final void S() {
        boolean bl = true;
        if (this.current_token.startsWith("s")) {
            this.current_draw_shape.closeShape();
        }
        this.current_shape = this.current_draw_shape.generateShapeFromPath(this.current_graphics_state.CTM, this.is_clip, this.af_rotation);
        if (this.use_client) {
            this.drawShape(this.current_graphics_state, 1, this.current_shape);
        }
        boolean bl2 = this.current_graphics_state.is_Strokewhite();
        if (this.isPageContent && this.current_draw_shape.getSegmentCount() <= 30 && !this.current_draw_shape.hasCurves() | this.current_shape.getBounds().getWidth() > 20.0 | this.current_shape.getBounds().getHeight() > 20.0) {
            this.page_data.addShapeForCalculatingFurniture(this.af_rotation, this.current_graphics_state, this.current_draw_shape, bl, this.current_graphics_state.getClippingShape(), 1, new Area(this.current_shape), this.token_number, bl2);
        }
        this.is_clip = false;
        this.current_draw_shape.resetPath();
    }

    private final void I() {
        if (this.current_token.equals("i")) {
            int n = (int)Float.parseFloat((String)this.number_values.elementAt(0));
            this.current_graphics_state.setFlatness(n);
        }
    }

    private final void C() {
        float f = Float.parseFloat((String)this.number_values.elementAt(1));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
        float f3 = Float.parseFloat((String)this.number_values.elementAt(3));
        float f4 = Float.parseFloat((String)this.number_values.elementAt(2));
        float f5 = Float.parseFloat((String)this.number_values.elementAt(5));
        float f6 = Float.parseFloat((String)this.number_values.elementAt(4));
        this.current_draw_shape.addBezierCurveC(f5, f6, f3, f4, f, f2);
    }

    private final void D() {
        if (this.number_values.elementAt(0).equals("[]0")) {
            this.current_graphics_state.setDashPhase(0);
            this.current_graphics_state.setDashArray(new float[0]);
        } else {
            String string = "";
            int n = this.number_values.size();
            int n2 = n - 1;
            while (n2 > -1) {
                string = string + this.number_values.elementAt(n2) + " ";
                --n2;
            }
            float[] fArray = new float[n - 1];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[ ]");
            int n3 = 0;
            while (n3 < n - 1) {
                fArray[n3] = Float.parseFloat(stringTokenizer.nextToken());
                ++n3;
            }
            this.current_graphics_state.setDashArray(fArray);
            String string2 = stringTokenizer.nextToken();
            this.current_graphics_state.setDashPhase((int)Float.parseFloat(string2));
        }
    }

    private final void SCN() throws PdfException {
        Color color = Color.black;
        int n = this.number_values.size();
        boolean bl = false;
        if (this.current_token.startsWith("SC")) {
            int n2 = this.current_graphics_state.getStrokeColorspaceID();
            ColorSpace colorSpace = this.current_graphics_state.getStrokeColorspace();
            if (n2 == 10) {
                color = this.current_color_data.getSepFalseColor(this.current_colorspace_id);
                if (color == null) {
                    color = new Color((int)(256.0 * Math.random()), (int)(256.0 * Math.random()), (int)(256.0 * Math.random()));
                }
                this.current_graphics_state.setStrokeColor(color, false);
            } else if (n2 == 1) {
                this.current_token = "G";
                this.G();
            } else if (n2 == 3) {
                this.current_token = "K";
                this.K();
            } else if (n2 == 7) {
                int n3 = this.number_values.size();
                if (n3 == 3) {
                    this.current_token = "RG";
                    this.RG();
                } else {
                    this.current_token = "K";
                    this.K();
                }
            } else if (n2 == 4) {
                color = this.current_color_data.setCalGray(colorSpace, this.number_values);
                this.current_graphics_state.setStrokeColor(color, bl);
            } else if (n2 == 5) {
                color = this.current_color_data.setCalRGB(colorSpace, this.number_values);
                this.current_graphics_state.setStrokeColor(color, bl);
            } else if (n2 == 2) {
                this.current_token = "RG";
                this.RG();
            } else {
                LogWriter.writeLog("Color space not set");
            }
        } else {
            int n4 = this.current_graphics_state.getNonStrokeColorspaceID();
            ColorSpace colorSpace = this.current_graphics_state.getNonStrokeColorspace();
            if (n4 == 10) {
                color = this.current_color_data.getSepFalseColor(this.current_colorspace_id);
                if (color == null) {
                    color = new Color((int)(256.0 * Math.random()), (int)(256.0 * Math.random()), (int)(256.0 * Math.random()));
                }
                this.current_graphics_state.setNonStrokeColor(color, false);
            } else if (n4 == 1) {
                this.current_token = "g";
                this.G();
            } else if (n4 == 3) {
                this.current_token = "k";
                this.K();
            } else if (n4 == 4) {
                color = this.current_color_data.setCalGray(colorSpace, this.number_values);
                this.current_graphics_state.setNonStrokeColor(color, bl);
            } else if (n4 == 7) {
                int n5 = this.number_values.size();
                if (n5 == 3) {
                    this.current_token = "rg";
                    this.RG();
                } else {
                    this.current_token = "k";
                    this.K();
                }
            } else if (n4 == 5) {
                color = this.current_color_data.setCalRGB(colorSpace, this.number_values);
                this.current_graphics_state.setNonStrokeColor(color, bl);
            } else if (n4 == 2) {
                this.current_token = "rg";
                this.RG();
            } else {
                LogWriter.writeLog("Color space not set");
            }
        }
    }

    private final void B() {
        boolean bl;
        boolean bl2 = true;
        if (this.current_token.endsWith("*")) {
            this.current_draw_shape.setEVENODDWindingRule();
        } else {
            this.current_draw_shape.setNONZEROWindingRule();
        }
        if (this.current_token.startsWith("b")) {
            this.current_draw_shape.closeShape();
            bl2 = false;
        }
        this.current_shape = this.current_draw_shape.generateShapeFromPath(this.current_graphics_state.CTM, this.is_clip, this.af_rotation);
        if (this.use_client) {
            this.drawShape(this.current_graphics_state, 3, this.current_shape);
        }
        boolean bl3 = false;
        boolean bl4 = this.current_graphics_state.is_NonStrokewhite();
        if (bl4 & (bl = this.current_graphics_state.is_Strokewhite())) {
            bl3 = true;
        }
        if (this.isPageContent && this.current_draw_shape.getSegmentCount() <= 30 && !this.current_draw_shape.hasCurves() | this.current_shape.getBounds().getWidth() > 20.0 | this.current_shape.getBounds().getHeight() > 20.0) {
            this.page_data.addShapeForCalculatingFurniture(this.af_rotation, this.current_graphics_state, this.current_draw_shape, bl2, this.current_graphics_state.getClippingShape(), 3, new Area(this.current_shape), this.token_number, bl3);
        }
        this.is_clip = false;
        this.current_draw_shape.resetPath();
    }

    private final void M() {
        if (this.current_token.equals("m")) {
            float f = Float.parseFloat((String)this.number_values.elementAt(1));
            float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
            this.current_draw_shape.moveTo(f, f2);
        } else {
            int n = (int)Float.parseFloat((String)this.number_values.elementAt(0));
            this.current_graphics_state.setMitreLimit(n);
        }
    }

    private final void J() {
        int n = Integer.parseInt((String)this.number_values.elementAt(0));
        int n2 = 0;
        if (this.current_token.equals("J")) {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.current_graphics_state.setJoinStyle(n2);
        } else {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.current_graphics_state.setCapStyle(n2);
        }
    }

    private final void RG() throws PdfException {
        boolean bl = false;
        boolean bl2 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.number_values.size() == 3) {
            f = 1.0f - Float.parseFloat((String)this.number_values.elementAt(2));
            f2 = 1.0f - Float.parseFloat((String)this.number_values.elementAt(1));
            f3 = 1.0f - Float.parseFloat((String)this.number_values.elementAt(0));
        } else {
            int n = Integer.parseInt((String)this.number_values.elementAt(0));
            String string = this.current_color_data.getIndexedColorComponent(this.current_colorspace_id, n, 0);
            if (string != null) {
                f = 1.0f - (float)Integer.parseInt(string, 16) / 255.0f;
            }
            if ((string = this.current_color_data.getIndexedColorComponent(this.current_colorspace_id, n, 1)) != null) {
                f2 = 1.0f - (float)Integer.parseInt(string, 16) / 255.0f;
            }
            if ((string = this.current_color_data.getIndexedColorComponent(this.current_colorspace_id, n, 2)) != null) {
                f3 = 1.0f - (float)Integer.parseInt(string, 16) / 255.0f;
            }
        }
        if (this.current_token.equals("RG")) {
            bl = true;
        }
        this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, "/DeviceRGB", bl, this.current_colorspace_id);
        Color color = PdfColor.setColor(f, f2, f3);
        if (bl) {
            this.current_graphics_state.setStrokeColor(color, bl2);
        } else {
            this.current_graphics_state.setNonStrokeColor(color, bl2);
        }
    }

    private final void Y() {
        float f = Float.parseFloat((String)this.number_values.elementAt(1));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
        float f3 = Float.parseFloat((String)this.number_values.elementAt(3));
        float f4 = Float.parseFloat((String)this.number_values.elementAt(2));
        this.current_draw_shape.addBezierCurveY(f3, f4, f, f2);
    }

    private final void saveCurrentImage(BufferedImage bufferedImage, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            Area area = this.current_graphics_state.getClippingShape();
            try {
                boolean bl2;
                ImageTransformer imageTransformer = this.isPageContent ? new ImageTransformer(this.r_matrix, this.getMaxX(this.page_number), this.getMaxY(this.page_number), this.current_graphics_state, bufferedImage) : new ImageTransformer(this.r_matrix, (int)this.d_x, (int)this.d_y, this.current_graphics_state, bufferedImage);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
                bufferedImage = imageTransformer.getImage();
                if (bufferedImage != null & area != null && !(bl2 = area.contains(f, f2, f3, f4))) {
                    imageTransformer.clipImage(area);
                    f = imageTransformer.getImageX();
                    f2 = imageTransformer.getImageY();
                    f3 = imageTransformer.getImageW();
                    f4 = imageTransformer.getImageH();
                }
                bufferedImage = imageTransformer.getImage();
                imageTransformer = null;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in clipping image " + this.current_image);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LogWriter.writeLog("Memory error with image " + this.current_image);
                bufferedImage = null;
                System.gc();
            }
            if (bufferedImage != null) {
                this.pdf_images.setImageInfo(this.current_image, this.page_number, f, f2, f3, f4);
                String string = ObjectStore.getImageType(this.current_image);
                ObjectStore.saveStoredImage(this.current_image, bufferedImage, false, false, string);
                if (this.use_client | !this.isPageContent) {
                    this.drawImage(bufferedImage, (int)f, (int)f2, this.current_graphics_state);
                    if (this.draw_screen_interactively) {
                        this.refreshDisplay(f3 * f4);
                    }
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final void TZ() {
        float f = Integer.parseInt((String)this.number_values.elementAt(0)) / 100;
        this.current_text_state.setHorizontalScaling(f);
    }

    private final void RE() {
        float f = Float.parseFloat((String)this.number_values.elementAt(3));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(2));
        float f3 = Float.parseFloat((String)this.number_values.elementAt(1));
        float f4 = Float.parseFloat((String)this.number_values.elementAt(0));
        this.current_draw_shape.appendRectangle(f, f2, f3, f4);
    }

    private final String processTextToStandardEncoding(String string) {
        String string2 = "";
        int n = 32;
        int n2 = 32;
        int n3 = 32;
        int n4 = 0;
        int n5 = 0;
        String string3 = this.current_text_state.getFontName();
        String string4 = this.current_text_state.getFontID();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n6 = this.current_byte_stream.length;
        if ((char)this.current_byte_stream[0] == '[') {
            n5 = 1;
            --n6;
            stringBuffer.append("[");
        }
        int n7 = 0;
        while (n7 < n6) {
            n = n3;
            n4 = this.current_byte_stream[n7 + n5];
            if (n4 < 0) {
                n4 = 256 + n4;
            }
            if (bl & (n3 = (int)((char)n4)) != 92 & n3 == 41) {
                bl = false;
            }
            if (bl) {
                string2 = this.current_font_data.convertCodeToUnicodeGlyph(n4, string3, string4);
                stringBuffer.append(string2);
            } else {
                stringBuffer.append((char)n4);
            }
            if (!bl & n != 92 & n3 == 40) {
                bl = true;
            }
            ++n7;
        }
        return stringBuffer.toString();
    }

    private final void ET() {
        this.inTextTokenStream = false;
    }

    private final void pushGraphicsState() {
        this.graphics_state_stack.push(this.current_graphics_state.clone());
        this.text_state_stack.push(this.current_text_state.clone());
    }

    private final void EDC() {
        this.in_marked_sequence = false;
    }

    private final void TJ() {
        StringBuffer stringBuffer = null;
        this.current_font = this.current_text_state.getFontName();
        if (this.use_client) {
            int n = this.current_text_state.getTextRenderType();
            if ((n & 2) == 2) {
                this.pdf_selected_image_g2.setPaint(this.current_graphics_state.getNonStrokeColor());
            }
            if ((n & 1) == 1) {
                this.pdf_selected_image_g2.setPaint(this.current_graphics_state.getStrokeColor());
            }
        }
        if (this.current_token.equals("()Tj")) {
            stringBuffer = null;
        } else {
            stringBuffer = this.current_CID_font_data.isCIDFont(this.current_font) ? this.processCIDTextArray(this.move_command, this.current_token, this.current_byte_stream, this.r_matrix) : this.processTextArray(this.move_command, this.current_token, this.current_byte_stream, this.r_matrix);
            if (this.use_client) {
                if (this.current_CID_font_data.isCIDFont(this.current_font)) {
                    this.printCIDTextLine(this.pdf_selected_image_g2, this.current_byte_stream, this.current_text_state);
                } else {
                    this.printTextLine(this.pdf_selected_image_g2, this.current_byte_stream, this.current_text_state);
                }
                if (this.draw_screen_interactively) {
                    this.refreshDisplay(0.0f);
                }
            }
        }
        if (stringBuffer != null & this.isPageContent) {
            String string = this.setPlotString(this.current_token);
            float f = this.current_font_data.getCurrentFontSpaceWidth(this.current_font, this.current_text_state.getFontID(), this.current_text_state.getTfs());
            String string2 = this.current_text_state.getFontName();
            String string3 = Fonts.createFontToken(string2, this.current_text_state.getCurrentFontSize());
            float f2 = this.current_thresholds.get_threshold(string3);
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c > '\u001f') {
                    stringBuffer2.append(c);
                } else {
                    stringBuffer2.append("&#" + c + ";");
                }
                ++n;
            }
            stringBuffer = stringBuffer2;
            this.pdf_data.addRawTextElement(this.character_spacing * 1000.0f, this.current_text_state.is_horizontal_writing_mode, string3, f2, f, this.current_text_state, this.x1, this.y1, this.x2, this.y2, this.move_command, this.commands_processed, stringBuffer, string, this.token_number, this.text_length);
        }
        this.commands_processed.setLength(0);
        this.move_command = -1;
    }

    private final void G() throws PdfException {
        int n = (int)(255.0f * Float.parseFloat((String)this.number_values.elementAt(0)));
        Color color = new Color(n, n, n);
        boolean bl = false;
        boolean bl2 = false;
        if (n == 255) {
            bl2 = true;
        }
        if (this.current_token.startsWith("g")) {
            this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, "/DeviceGray", false, this.current_colorspace_id);
            this.current_graphics_state.setNonStrokeColor(color, bl2);
        } else {
            this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, "/DeviceGray", true, this.current_colorspace_id);
            this.current_graphics_state.setStrokeColor(color, bl2);
        }
    }

    private final void TL() {
        float f = Float.parseFloat((String)this.number_values.elementAt(0));
        this.current_text_state.setLeading(f);
    }

    private final void BDC() {
        this.in_marked_sequence = true;
    }

    private final void TM() {
        boolean bl = false;
        this.current_text_state.Tm[0][0] = Float.parseFloat((String)this.number_values.elementAt(5));
        this.current_text_state.Tm[0][1] = Float.parseFloat((String)this.number_values.elementAt(4));
        this.current_text_state.Tm[0][2] = 0.0f;
        this.current_text_state.Tm[1][0] = Float.parseFloat((String)this.number_values.elementAt(3));
        this.current_text_state.Tm[1][1] = Float.parseFloat((String)this.number_values.elementAt(2));
        this.current_text_state.Tm[1][2] = 0.0f;
        this.current_text_state.Tm[2][0] = Float.parseFloat((String)this.number_values.elementAt(1));
        this.current_text_state.Tm[2][1] = Float.parseFloat((String)this.number_values.elementAt(0));
        this.current_text_state.Tm[2][2] = 1.0f;
        this.move_command = 1;
        this.flushShapeCache();
    }

    private final void H() {
        this.current_draw_shape.closeShape();
    }

    private final void TR() {
        int n;
        int n2 = n = Integer.parseInt((String)this.number_values.elementAt(0));
        if (n == 0) {
            n2 = 2;
        } else if (n == 1) {
            n2 = 1;
        } else if (n == 2) {
            n2 = 3;
        }
        this.current_text_state.setTextRenderType(n2);
    }

    private final void Q() {
        if (this.current_token.equals("q")) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
        }
    }

    private final String setPlotString(String string) {
        return this.x1 + " " + this.y1 + " " + this.x2 + " " + this.y2 + " " + this.page_number + " " + "-1" + " ";
    }

    private final void ID() throws PdfException {
        String string;
        String string2 = null;
        String string3 = "";
        this.inline_decode_parameters = "";
        this.inline_filter_value = null;
        this.is_inline_stream = true;
        boolean bl = false;
        String string4 = "[0 1]";
        this.inline_start_pointer = this.data_pointer + 1;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        int n4 = this.number_values.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < n4) {
            stringBuffer.append(this.number_values.elementAt(n4 - n5 - 1));
            stringBuffer.append(" ");
            ++n5;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString().trim(), "[]/ ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.equals("/")) {
                vector.add(string5 + stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("[")) {
                while (string5.indexOf("]") == -1) {
                    string = stringTokenizer.nextToken();
                    string5 = string.equals("/") ? string5 + " " + string : string5 + string;
                }
                vector.add(string5);
                continue;
            }
            if (string5.equals(" ")) continue;
            vector.add(string5);
        }
        this.number_values = vector;
        n4 = this.number_values.size();
        int n6 = 0;
        while (n6 < n4) {
            string3 = (String)this.number_values.elementAt(n6);
            if (string3.equals("/W")) {
                n = Integer.parseInt((String)this.number_values.elementAt(++n6));
            } else if (string3.equals("/IM")) {
                if (((String)this.number_values.elementAt(++n6)).indexOf("true") != -1) {
                    bl = true;
                }
            } else if (string3.equals("/D")) {
                string4 = (String)this.number_values.elementAt(++n6);
            } else if (string3.equals("/H")) {
                n2 = Integer.parseInt((String)this.number_values.elementAt(++n6));
            } else if (string3.equals("/BPC")) {
                n3 = Integer.parseInt((String)this.number_values.elementAt(++n6));
            } else if (string3.equals("/CS")) {
                string = (String)this.number_values.elementAt(++n6);
                this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, string, false, this.current_colorspace_id);
            } else if (string3.equals("/F")) {
                string2 = "";
                if (string2.indexOf("[") != -1) {
                    while (string2.indexOf("]") == -1) {
                        string = (String)this.number_values.elementAt(++n6);
                        string2 = string2 + " " + string;
                    }
                } else {
                    string2 = (String)this.number_values.elementAt(++n6);
                }
            } else if (string3.equals("/DP")) {
                if ((string = (String)this.number_values.elementAt(++n6)).startsWith("[")) {
                    while (string.indexOf("]") == -1) {
                        string = string + this.number_values.elementAt(++n6);
                    }
                }
                if (string.startsWith("<<")) {
                    while (string.indexOf(">>") == -1) {
                        string = string + this.number_values.elementAt(++n6);
                    }
                }
                this.inline_decode_parameters = string;
            }
            ++n6;
        }
        this.inline_filter_value = string2;
        this.current_pdf_file.setImageSize(n, n2, n3);
        this.current_image_data.setInlineValues(string4, bl, n, n2, n3, this.inline_decode_parameters, this.inline_filter_value);
    }

    private final void TS() {
        float f = Integer.parseInt((String)this.number_values.elementAt(0));
        this.current_text_state.setTextRise(f);
    }

    private final void double_quote() {
        this.current_text_state.setCharacterSpacing(Float.parseFloat((String)this.number_values.elementAt(0)));
        this.current_text_state.setWordSpacing(Float.parseFloat((String)this.number_values.elementAt(1)));
        this.TSTAR();
        this.current_token = "TJ";
        this.TJ();
    }

    private final void TSTAR() {
        this.relativeMove(0.0f, -this.current_text_state.getLeading());
        this.move_command = 0;
    }

    private final void K() throws PdfException {
        float f;
        float f2;
        float f3;
        boolean bl = false;
        boolean bl2 = false;
        float f4 = Float.parseFloat((String)this.number_values.elementAt(3));
        if (f4 == 0.0f & (f3 = Float.parseFloat((String)this.number_values.elementAt(2))) == 0.0f & (f2 = Float.parseFloat((String)this.number_values.elementAt(1))) == 0.0f & (f = Float.parseFloat((String)this.number_values.elementAt(0))) == 0.0f) {
            bl2 = true;
        }
        if (this.current_token.equals("K")) {
            bl = true;
        }
        Color color = PdfColor.setCMYKColor(f4, f3, f2, f);
        this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, "/DeviceCMYK", bl, this.current_colorspace_id);
        if (bl) {
            this.current_graphics_state.setStrokeColor(color, bl2);
        } else {
            this.current_graphics_state.setNonStrokeColor(color, bl2);
        }
    }

    private final void W() {
        if (this.current_token.startsWith("W")) {
            if (this.current_token.endsWith("*")) {
                this.current_draw_shape.setEVENODDWindingRule();
            } else {
                this.current_draw_shape.setNONZEROWindingRule();
            }
            this.is_clip = true;
        } else {
            float f = Float.parseFloat((String)this.number_values.elementAt(0));
            this.current_graphics_state.setLineWidth(f);
        }
    }

    private final void one_quote() {
        this.TSTAR();
        this.current_token = "TJ";
        this.TJ();
    }

    private final void GS() {
        String string = (String)this.number_values.get(0);
        String string2 = this.getGSParamter(string + "OP");
        if (string2 != null) {
            if (string2.equals("true")) {
                this.current_graphics_state.setOP(true);
            } else {
                this.current_graphics_state.setOP(false);
            }
        }
    }

    private final void N() {
        if (this.current_token.equals("n") && this.is_clip) {
            if (this.use_client) {
                StatusBar.updateStatus("Processing Shape", 0);
            }
            this.current_draw_shape.closeShape();
            Area area = (Area)this.current_draw_shape.generateShapeFromPath(this.current_graphics_state.CTM, this.is_clip, this.af_rotation);
            this.current_graphics_state.updateClip(area);
            this.current_graphics_state.checkWholePageClip(this.getMaxY(this.page_number));
            this.is_clip = false;
            this.current_draw_shape.resetPath();
            if (this.use_client) {
                StatusBar.updateStatus("", 0);
            }
        }
    }

    private final void TW() {
        this.current_text_state.setWordSpacing(Float.parseFloat((String)this.number_values.elementAt(0)));
    }

    private final void CS() throws PdfException {
        String string = (String)this.number_values.elementAt(0);
        String string2 = this.current_color_data.getColorSpaceName(string);
        this.current_colorspace_id = string;
        if (string2 != null) {
            string = string2;
        }
        boolean bl = false;
        if (this.current_token.equals("CS")) {
            bl = true;
        }
        this.current_color_data.setColorSpace(this.use_client, this.current_graphics_state, string, bl, this.current_colorspace_id);
    }

    private final void V() {
        float f = Float.parseFloat((String)this.number_values.elementAt(1));
        float f2 = Float.parseFloat((String)this.number_values.elementAt(0));
        float f3 = Float.parseFloat((String)this.number_values.elementAt(3));
        float f4 = Float.parseFloat((String)this.number_values.elementAt(2));
        this.current_draw_shape.addBezierCurveV(f3, f4, f, f2);
    }

    private final void TF() {
        float f = Float.parseFloat((String)this.number_values.elementAt(0));
        this.font_ID = ((String)this.number_values.elementAt(1)).substring(2);
        this.current_text_state.setFontTfs(f);
        this.current_font = this.current_font_data.getFontName(this.font_ID);
        this.current_text_state.setFontName(this.current_font);
        this.current_text_state.setFontID(this.font_ID);
        if (this.use_client) {
            this.unscaled_font = Fonts.getFontObject(1, this.current_font);
            this.flushShapeCache();
        }
    }

    private final void processToken() throws PdfException {
        String string = this.current_token.toUpperCase();
        String string2 = this.current_token;
        if (this.inTextTokenStream) {
            if (string.endsWith("TJ") | string.endsWith("'") | string.endsWith("\"")) {
                this.current_token = this.processTextToStandardEncoding(this.current_token);
            }
            if (string.endsWith("TJ")) {
                string = "TJ";
                string2 = "TJ";
            } else if (this.current_token.equals("T*")) {
                string = "TSTAR";
            }
            this.commands_processed.append(this.current_token + " \n");
        }
        if (string.equals("B*")) {
            string = "B";
        } else if (string.endsWith("F*")) {
            string = "F";
        } else if (this.current_token.endsWith("W*")) {
            string = "W";
        } else if (this.current_token.equals("'")) {
            string = "one_quote";
        } else if (this.current_token.equals("\"")) {
            string = "double_quote";
        }
        String string3 = (String)this.commands.get(string2);
        if (string3 != null) {
            if (string3.equals("t") && this.process_text) {
                if (string.equals("TC")) {
                    this.TC();
                } else if (string.equals("BT")) {
                    this.BT();
                } else if (string.equals("ET")) {
                    this.ET();
                } else if (string.equals("TD")) {
                    this.TD();
                } else if (string.equals("TF")) {
                    this.TF();
                } else if (string.equals("TJ")) {
                    this.TJ();
                } else if (string.equals("TL")) {
                    this.TL();
                } else if (string.equals("TM")) {
                    this.TM();
                } else if (string.equals("TR")) {
                    this.TR();
                } else if (string.equals("TS")) {
                    this.TS();
                } else if (string.equals("TSTAR")) {
                    this.TSTAR();
                } else if (string.equals("TW")) {
                    this.TW();
                } else if (string.equals("TZ")) {
                    this.TZ();
                } else if (string.equals("one_quote")) {
                    this.one_quote();
                } else if (string.equals("double_quote")) {
                    this.double_quote();
                }
            } else if (string3.equals("i") && this.process_images) {
                if (string.equals("BI")) {
                    this.BI();
                } else if (string.equals("DO")) {
                    this.DO();
                } else if (string.equals("EI")) {
                    this.EI();
                } else if (string.equals("ID")) {
                    this.ID();
                }
            } else if (string3.equals("s") && this.process_shapes) {
                if (string.equals("B")) {
                    this.B();
                } else if (string.equals("C")) {
                    this.C();
                } else if (string.equals("D")) {
                    this.D();
                } else if (string.equals("F")) {
                    this.F();
                } else if (string.equals("H")) {
                    this.H();
                } else if (string.equals("L")) {
                    this.L();
                } else if (string.equals("M")) {
                    this.M();
                } else if (string.equals("N")) {
                    this.N();
                } else if (string.equals("RE")) {
                    this.RE();
                } else if (string.equals("S")) {
                    this.S();
                } else if (string.equals("V")) {
                    this.V();
                } else if (string.equals("W")) {
                    this.W();
                } else if (string.equals("Y")) {
                    this.Y();
                }
            } else if (string.equals("CM")) {
                this.CM();
            } else if (string.equals("CS")) {
                this.CS();
            } else if (string.equals("G")) {
                this.G();
            } else if (string.equals("GS")) {
                this.GS();
            } else if (string.equals("I")) {
                this.I();
            } else if (string.equals("J")) {
                this.J();
            } else if (string.equals("K")) {
                this.K();
            } else if (string.equals("Q")) {
                this.Q();
            } else if (string.equals("RG")) {
                this.RG();
            } else if (string.equals("SCN")) {
                this.SCN();
            } else if (string.equals("SC")) {
                this.SCN();
            } else if (string.equals("BDC")) {
                this.BDC();
            } else if (string.equals("D0")) {
                this.d0();
            } else if (string.equals("D1")) {
                this.d1();
            } else if (string.equals("EDC")) {
                this.EDC();
            }
            this.number_values = new Vector();
            ++this.token_number;
        } else {
            int n = this.current_token.length();
            if (n > 0 && n < 200) {
                this.number_values.insertElementAt(this.current_token, 0);
            }
        }
    }

    private final void DO() {
        String string = (String)this.number_values.elementAt(0);
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.startsWith("Fm")) {
            LogWriter.writeLog("Forms not supported");
        } else {
            BufferedImage bufferedImage = this.current_Xobject_data.processImageXObject(this.current_Xobject_data.getXObjectColor(string), this.use_client, this.current_graphics_state, this.current_Xobject_data.getXObjectPosition(string), string, this.current_Xobject_data.getXObjectValues(string));
            this.current_image = this.current_Xobject_data.getFilename() + "-" + string;
            if (this.can_access_images) {
                this.saveCurrentImage(bufferedImage, false);
            }
        }
    }
}

