/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfCIDFontsData;
import org.jpedal.fonts.PdfFontsData;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.images.PdfImages;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfAnnotsData;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.TextState;
import org.jpedal.text.PdfThreshold;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.xobjects.PdfXObjects;

public class PdfObjects {
    protected int debug_level = 0;
    protected boolean use_client = false;
    protected Vector_Int min_x = new Vector_Int(20);
    protected PdfThreshold current_thresholds = new PdfThreshold();
    protected Vector_Int rotation = new Vector_Int(20);
    protected boolean process_text = true;
    protected HashMap pages_read = new HashMap();
    protected boolean process_shapes = true;
    protected boolean process_images = true;
    protected GraphicsState current_graphics_state = new GraphicsState();
    protected Vector_Int page_size_set = new Vector_Int(20);
    protected PdfImages current_image_data;
    protected int page_number = 0;
    protected TextState current_text_state = new TextState();
    protected PdfFormData pdf_form_data;
    protected PdfXObjects current_Xobject_data;
    protected Vector_Int min_y = new Vector_Int(20);
    protected AffineTransform af_rotation = new AffineTransform();
    protected Vector_Int max_x = new Vector_Int(20);
    protected PdfData pdf_data;
    protected int current_min_x;
    protected int current_min_y;
    protected int current_max_x;
    protected int current_max_y;
    protected float[][] r_matrix;
    protected boolean can_access_images = true;
    protected PdfImageData pdf_images;
    protected Vector_Int max_y = new Vector_Int(20);
    protected PdfObjectReader current_pdf_file;
    protected PdfFontsData current_font_data;
    protected PdfCIDFontsData current_CID_font_data;
    protected PdfHeightTable current_height_lookup_data;
    protected PdfPageData page_data = new PdfPageData();
    protected PdfColor current_color_data;
    protected PdfAnnotsData annots_data = new PdfAnnotsData();
    protected boolean embed_width_data = false;
    private HashMap gs_state = new HashMap();

    protected final void readAnnots(String string) throws PdfException {
        LogWriter.writeMethod("{pdf-readAnnots: " + string + "}", 1);
        int n = 1;
        int n2 = string.indexOf(82);
        while (n2 != -1) {
            this.readAnnot("[" + string.substring(n, n2 + 1) + "]");
            n = n2 + 1;
            n2 = string.indexOf(82, n);
        }
    }

    protected final void readAnnot(String string) throws PdfException {
        String string2;
        LogWriter.writeMethod("{pdf-readAnnot: " + string + "}", 1);
        HashMap hashMap = this.current_pdf_file.readObjectData(string, false, false, false);
        LogWriter.writeMethod("{pdf-readResources-Annots-values:}", 4);
        LogWriter.write(hashMap, 4);
        if (hashMap.get("Type") != null && ((String)hashMap.get("Type")).equals("/Annot") && hashMap.get("Subtype") != null && ((String)hashMap.get("Subtype")).equals("/Link") && (string2 = (String)hashMap.get("A")) != null) {
            HashMap hashMap2 = this.current_pdf_file.decodeStringIntoValue(string2, false);
            LogWriter.writeMethod("{pdf-readResources-Annots-A-values:}", 4);
            LogWriter.write(hashMap2, 4);
            if (((String)hashMap2.get("S")).equals("/URI")) {
                this.annots_data.addRawElement((String)hashMap2.get("URI"), (String)hashMap.get("Rect"));
            }
        }
    }

    public final PdfAnnotsData getPdfAnnotsData() {
        return this.annots_data;
    }

    public final PdfPageData getPdfPageData() {
        return this.page_data;
    }

    public final PdfData getPdfData() {
        return this.pdf_data;
    }

    public final String[] getInformation() {
        return this.current_pdf_file.getInformation();
    }

    public final int getPageNumber() {
        return this.page_number;
    }

    public final PdfFormData getPdfFormData() {
        return this.pdf_form_data;
    }

    public final int getMinX(int n) {
        int n2 = this.min_x.elementAt(n);
        int n3 = this.min_y.elementAt(n);
        int n4 = this.rotation.elementAt(n);
        if (n4 == 90 | n4 == 270) {
            n2 = n3;
        }
        return n2;
    }

    public final void markAllPagesAsUnread() {
        this.pages_read = new HashMap();
    }

    public final int getMinY(int n) {
        int n2 = this.min_x.elementAt(n);
        int n3 = this.min_y.elementAt(n);
        int n4 = this.rotation.elementAt(n);
        if (n4 == 90 | n4 == 270) {
            n3 = n2;
        }
        return n3;
    }

    public final void flushObjectValues(boolean bl) {
        this.pdf_data.flushTextList(bl);
        this.annots_data.flushTextList();
        if (!bl) {
            this.pdf_images.clearImageData();
        }
    }

    public final int getMaxY(int n) {
        int n2 = this.max_x.elementAt(n);
        int n3 = this.max_y.elementAt(n);
        int n4 = this.rotation.elementAt(n);
        if (n4 == 90 | n4 == 270) {
            n3 = n2;
        }
        if (n3 == 0) {
            n3 = this.current_max_y;
        }
        return n3;
    }

    public final void flushFormValues() {
        this.pdf_form_data = new PdfFormData();
    }

    public final int getMaxX(int n) {
        int n2 = this.max_x.elementAt(n);
        int n3 = this.max_y.elementAt(n);
        int n4 = this.rotation.elementAt(n);
        if (n4 == 90 | n4 == 270) {
            n2 = n3;
        }
        if (n2 == 0) {
            n2 = this.current_max_x;
        }
        return n2;
    }

    public final void clearPdfImageData() {
        this.pdf_images.clearImageData();
    }

    public final PdfImageData getPdfImageData() {
        return this.pdf_images;
    }

    protected String getGSParamter(String string) {
        return (String)this.gs_state.get(string);
    }

    protected final void setRotationMatrix(int n, int n2, int n3) {
        double d = Math.PI * (double)n / 180.0;
        this.r_matrix = new float[3][3];
        float f = (float)Math.cos(d);
        float f2 = (float)Math.sin(d);
        this.r_matrix[0][0] = f;
        this.r_matrix[0][1] = -f2;
        this.r_matrix[0][2] = 0.0f;
        this.r_matrix[1][0] = f2;
        this.r_matrix[1][1] = f;
        this.r_matrix[1][2] = 0.0f;
        this.r_matrix[2][0] = 0.0f;
        this.r_matrix[2][1] = 0.0f;
        this.r_matrix[2][2] = 1.0f;
        this.af_rotation = AffineTransform.getRotateInstance(-d);
        if (n == 90) {
            this.r_matrix[2][1] = n2;
            this.af_rotation.translate(-n2, 0.0);
        } else if (n == 270) {
            this.r_matrix[2][0] = n3;
            this.af_rotation.translate(0.0, -n3);
        }
    }

    protected final HashMap readValues(String string, boolean bl) throws PdfException {
        if (this.debug_level > 1) {
            LogWriter.writeLog("Reading values");
        }
        String string2 = "";
        HashMap hashMap = this.current_pdf_file.readObjectData(string, bl, false, false);
        if (this.debug_level > 1) {
            LogWriter.writeLog("values=" + hashMap);
        }
        if ((string2 = this.current_pdf_file.getValue((String)hashMap.get("Rotate"))) != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 0) {
                    n = 360 + n;
                }
                this.rotation.setElementAt(n, this.page_number);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading rotation");
                throw new PdfException("Exception " + exception + " reading rotation");
            }
        }
        if ((string2 = this.current_pdf_file.getValue((String)hashMap.get("MediaBox"))) != null) {
            String string3 = Strip.removeArrayMarkers(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            this.current_min_x = (int)Float.parseFloat(stringTokenizer.nextToken());
            this.current_min_y = (int)Float.parseFloat(stringTokenizer.nextToken());
            this.current_max_x = (int)Float.parseFloat(stringTokenizer.nextToken());
            this.current_max_y = (int)Float.parseFloat(stringTokenizer.nextToken());
        }
        if (this.page_size_set.elementAt(this.page_number) == 0 & this.current_max_x > 0 & this.current_max_y > 0) {
            this.min_x.setElementAt(this.current_min_x, this.page_number);
            this.min_y.setElementAt(this.current_min_y, this.page_number);
            this.max_x.setElementAt(this.current_max_x, this.page_number);
            this.max_y.setElementAt(this.current_max_y, this.page_number);
            this.page_size_set.setElementAt(1, this.page_number);
        }
        return hashMap;
    }

    protected final void readResources(String string) throws PdfException {
        HashMap hashMap;
        String string2;
        long l = this.current_pdf_file.getPointer();
        if (this.debug_level > 1) {
            LogWriter.writeLog("Reading resources object " + string);
        }
        if ((string2 = (String)(hashMap = string.endsWith("R") ? this.current_pdf_file.readObjectData(string, false, false, false) : this.current_pdf_file.decodeStringIntoValue(string, false)).get("Font")) != null) {
            this.readFonts(string2);
        }
        if ((string2 = (String)hashMap.get("ColorSpace")) != null) {
            this.current_color_data.readColorSpaces(this.current_pdf_file.getValue(string2));
        }
        if ((string2 = (String)hashMap.get("ProcSet")) != null) {
            this.readProc(string2);
        }
        if ((string2 = (String)hashMap.get("XObject")) != null && this.can_access_images && this.process_images) {
            try {
                this.current_Xobject_data.processXObjects(this.current_color_data, this.use_client, string2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " processing XObjects");
            }
        }
        if ((string2 = (String)hashMap.get("ExtGState")) != null) {
            try {
                this.readGraphicsState(string2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " processing Graphics State " + string2);
            }
        }
        this.current_pdf_file.movePointer(l);
    }

    protected final void setGSParamter(String string, String string2) {
        this.gs_state.put(string, string2);
    }

    private final void readProc(String string) {
        if (this.debug_level > 1) {
            if (string.indexOf("/Text") != -1) {
                LogWriter.writeLog("Current page has text");
            }
            if (string.indexOf("/ImageC") != -1) {
                LogWriter.writeLog("Current page has Colour Image");
            }
            if (string.indexOf("/ImageC") != -1) {
                LogWriter.writeLog("Current page has Indexed Image");
            }
        }
    }

    private final void readFonts(String string) throws PdfException {
        if (this.debug_level > 1) {
            LogWriter.writeLog("Reading fonts");
        }
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        long l = this.current_pdf_file.getPointer();
        this.current_pdf_file.movePointer(l);
        string = Strip.stripMainBraces(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() == 3) {
            string = this.current_pdf_file.readXObjectHeader(string);
            stringTokenizer = new StringTokenizer(string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().substring(2);
            string2 = stringTokenizer.nextToken() + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
            HashMap hashMap = this.current_pdf_file.readObjectData(string2, false, false, false);
            string3 = (String)hashMap.get("Type");
            if (string3.equals("/Font")) {
                string4 = (String)hashMap.get("Subtype");
                if (string4.equals("ADD_VALUE_HERE")) {
                    this.current_CID_font_data.readCIDFont(hashMap, string5);
                    continue;
                }
                if (string4.equals("/Type1") || string4.equals("/Type1C") || string4.equals("/TrueType") || string4.equals("/Type3")) {
                    this.current_font_data.readAllTypeFont(hashMap, string5);
                    continue;
                }
                LogWriter.writeLog("Font type " + string4 + " not supported");
                continue;
            }
            LogWriter.writeLog("Not a font object");
        }
        if (this.debug_level > 1) {
            LogWriter.writeLog("Fonts read");
        }
    }

    private final void readGraphicsState(String string) throws PdfException {
        if (this.debug_level > 1) {
            LogWriter.writeLog("Reading GraphicsStates");
        }
        String string2 = "";
        string = Strip.stripMainBraces(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken() + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
            HashMap hashMap = this.current_pdf_file.readObjectData(string4, false, false, false);
            string2 = (String)hashMap.get("SA");
            if (string2 != null) {
                this.setGSParamter(string3 + "SA", string2);
            }
            if ((string2 = (String)hashMap.get("OP")) != null) {
                this.setGSParamter(string3 + "OP", string2);
            }
            if ((string2 = (String)hashMap.get("HT")) == null) continue;
            this.setGSParamter(string3 + "HT", string2);
        }
        if (this.debug_level > 1) {
            LogWriter.writeLog("ExtGState read");
        }
    }
}

