/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.jpedal.PdfObjects;
import org.jpedal.color.PdfColor;
import org.jpedal.fonts.Fonts;
import org.jpedal.gui.PdfPanel;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.utils.Matrix;

public class PdfRasterizer
extends PdfObjects {
    protected Graphics2D pdf_selected_image_g2;
    protected float character_spacing = 0.0f;
    protected int text_length = 0;
    protected boolean draw_screen_interactively = false;
    protected BufferedImage pdf_selected_image;
    protected float x1;
    protected float y1;
    protected float x2;
    protected float y2;
    private int objects_since_redraw = 0;
    private int i;
    private double screen_res = 1.0;
    private int raw_int = 0;
    private String screen_file = "x";
    private String text_value = "";
    private PdfPanel pdf_display = null;
    protected float d_x = 20.0f;
    protected float d_y = 20.0f;
    private float[][] old_Tm = new float[3][3];
    private char last_char = (char)32;
    private char next_char = (char)32;
    private char raw_char = (char)32;
    protected String current_font = "";
    protected String font_ID = "";
    protected Font unscaled_font = null;
    private Area[] cached_shapes = new Area[256];
    protected static final FontRenderContext frc = new FontRenderContext(null, true, true);

    public final void setPanel(PdfPanel pdfPanel, int n) {
        this.pdf_display = pdfPanel;
        this.initDisplay(n);
        if (this.draw_screen_interactively) {
            this.refreshDisplay(1500.0f);
        }
        this.objects_since_redraw = 15;
    }

    public final BufferedImage getPageAsImage() {
        return this.pdf_selected_image;
    }

    public final void refreshDisplay(float f) {
        if (this.pdf_display != null) {
            if (this.objects_since_redraw > 90 | f > 900.0f) {
                this.pdf_display.setImage(this.pdf_selected_image);
                this.objects_since_redraw = 0;
            } else {
                ++this.objects_since_redraw;
            }
        }
    }

    public final void addMergingDisplayForDebugging(JFrame jFrame, String[] stringArray, Color[] colorArray) {
        this.page_data.showLines(jFrame, this.pdf_selected_image.createGraphics(), this.getMaxY(this.page_number), stringArray, colorArray);
        ObjectStore.saveStoredImage("_" + this.page_number, this.pdf_selected_image, false, false, "jpg");
    }

    public final void initGlyphDisplay() {
        this.pdf_selected_image = new BufferedImage((int)this.d_x, (int)this.d_y, 2);
        this.pdf_selected_image_g2 = this.pdf_selected_image.createGraphics();
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public final void initDisplay(int n) {
        int n2 = this.getMaxX(n);
        int n3 = this.getMaxY(n);
        this.pdf_selected_image = new BufferedImage((int)((double)n2 * this.screen_res), (int)((double)n3 * this.screen_res), 1);
        this.pdf_selected_image_g2 = this.pdf_selected_image.createGraphics();
        this.pdf_selected_image_g2.scale(this.screen_res, this.screen_res);
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.pdf_selected_image_g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.pdf_selected_image_g2.setColor(Color.white);
        this.pdf_selected_image_g2.fillRect(0, 0, n2, n3);
    }

    public final void completeImage(int n) {
        int n2 = (int)((double)n * this.screen_res);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -n2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        this.pdf_selected_image = affineTransformOp.filter(this.pdf_selected_image, null);
        this.pdf_selected_image.getGraphics().fillRect(0, 0, 0, n);
    }

    protected final void drawImage(BufferedImage bufferedImage, int n, int n2, GraphicsState graphicsState) {
        if (bufferedImage != null) {
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            if (n4 > 1) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(n3, n4);
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(-n3, 0.0);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, PdfColor.hints);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
            this.pdf_selected_image_g2.drawImage((Image)bufferedImage, n, n2, null);
        }
    }

    protected final StringBuffer processCIDTextArray(int n, String string, byte[] byArray, float[][] fArray) {
        return null;
    }

    protected final void printCIDTextLine(Graphics2D graphics2D, byte[] byArray, TextState textState) {
    }

    protected final void drawShape(GraphicsState graphicsState, int n, Shape shape) {
        Color color = graphicsState.getStrokeColor();
        Color color2 = graphicsState.getNonStrokeColor();
        Stroke stroke = graphicsState.getStroke();
        this.pdf_selected_image_g2.setStroke(stroke);
        Shape shape2 = this.pdf_selected_image_g2.getClip();
        Area area = graphicsState.getClippingShape();
        if (area != null) {
            this.pdf_selected_image_g2.setClip(area);
        }
        if (n == 2 | n == 3) {
            this.pdf_selected_image_g2.setPaint(color2);
            this.pdf_selected_image_g2.fill(shape);
        }
        if (n == 1 | n == 3) {
            this.pdf_selected_image_g2.setPaint(color);
            this.pdf_selected_image_g2.draw(shape);
        }
        this.pdf_selected_image_g2.setClip(shape2);
    }

    protected final StringBuffer processTextArray(int n, String string, byte[] byArray, float[][] fArray) {
        float f;
        boolean bl;
        this.text_length = 0;
        boolean bl2 = false;
        float[][] fArray2 = new float[3][3];
        this.last_char = (char)32;
        this.next_char = (char)32;
        this.raw_char = (char)32;
        int n2 = 0;
        int n3 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = byArray.length - 3;
        float f8 = 1.0f;
        if (this.current_thresholds != null) {
            f8 = this.current_thresholds.get_threshold(this.current_font);
        }
        float f9 = this.current_text_state.getTfs();
        float f10 = this.current_font_data.getTextYScale(this.font_ID);
        float f11 = this.current_font_data.getTextXScale(this.font_ID);
        fArray2 = n == -1 ? Matrix.multiply(this.old_Tm, this.current_graphics_state.CTM) : Matrix.multiply(this.current_text_state.Tm, this.current_graphics_state.CTM);
        fArray2 = Matrix.multiply(fArray2, fArray);
        float f12 = fArray2[2][0];
        float f13 = fArray2[2][1];
        float[][] fArray3 = new float[3][3];
        fArray3[0][0] = f9 * this.current_text_state.getHorizontalScaling();
        fArray3[0][1] = 0.0f;
        fArray3[0][2] = 0.0f;
        fArray3[1][0] = 0.0f;
        fArray3[1][1] = f9;
        fArray3[1][2] = 0.0f;
        fArray3[2][0] = 0.0f;
        fArray3[2][1] = this.current_text_state.getTextRise();
        fArray3[2][2] = 1.0f;
        fArray2 = Matrix.multiply(fArray3, fArray2);
        this.current_text_state.setTrm(fArray2);
        if (fArray2[1][1] != 0.0f) {
            bl = true;
            n2 = Math.round(fArray2[1][1] * 1000.0f / f10);
            f2 = f12;
            f3 = f12;
            f = f9 * fArray2[0][0];
            f5 = fArray2[0][0];
        } else {
            bl = false;
            n2 = Math.round(fArray2[1][0] * 1000.0f / f10);
            if (fArray2[1][0] < 0.0f) {
                f12 += (float)n2;
                n2 = -n2;
            }
            f2 = f13;
            f3 = f13;
            f = f9 * fArray2[0][1];
            f5 = fArray2[0][1];
        }
        this.current_text_state.is_horizontal_writing_mode = bl;
        this.current_text_state.setCurrentFontSize(Math.abs(n2));
        this.character_spacing = this.current_text_state.getCharacterSpacing() / f9;
        float f14 = this.current_text_state.getWordSpacing() / f9;
        float f15 = n2 / 2;
        float f16 = this.current_font_data.getCurrentFontSpaceWidth(this.current_font, this.font_ID, f9);
        if ((char)byArray[0] == '[') {
            n3 = 1;
            --n4;
        }
        this.i = 0;
        while (this.i < n4 - n3) {
            this.last_char = this.raw_char;
            this.raw_int = byArray[this.i + n3];
            if (this.raw_int < 0) {
                this.raw_int = 256 + this.raw_int;
            }
            this.raw_char = (char)this.raw_int;
            if (bl2 && this.last_char != '\\' && this.raw_char == ')') {
                bl2 = false;
            }
            if (bl2) {
                string2 = this.raw_char == '\\' ? this.processEscape(n3, byArray) : this.current_font_data.convertCodeToUnicodeGlyph(this.raw_int, this.current_font, this.font_ID);
                float f17 = this.current_height_lookup_data.getCharHeight(this.raw_char, Math.abs(n2));
                if (f15 < f17) {
                    f15 = f17;
                }
                f2 = f3 + f5 * f4;
                f7 = (f4 += this.character_spacing) - f6;
                float f18 = this.current_font_data.getWidth(this.font_ID, this.raw_int);
                if (f7 > 0.0f & f6 > 0.0f) {
                    stringBuffer.append(this.getSpaces(f7, f16, f8));
                }
                if (this.raw_char == ' ') {
                    f4 += f14;
                }
                ++this.text_length;
                f6 = f4 += f18;
                if (string2.length() > 0) {
                    if (this.embed_width_data) {
                        stringBuffer.append(PdfData.marker + f2);
                        stringBuffer.append(PdfData.marker + f18 * f5 + PdfData.marker);
                    }
                    stringBuffer.append(string2);
                }
            } else if (this.raw_char == '(') {
                bl2 = true;
            } else if (n4 - this.i - n3 > 4) {
                f4 -= this.processLeading(byArray, n3, this.raw_char) / 1000.0f;
                this.next_char = (char)40;
            }
            ++this.i;
        }
        float f19 = f4 -= this.character_spacing;
        float f20 = f15 * 1000.0f / ((float)n2 * f10);
        if (f20 == 0.0f) {
            f20 = 1.0f;
        }
        AffineTransform affineTransform = new AffineTransform(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1]);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(f19, 0.0f);
        generalPath.lineTo(f19, f20);
        generalPath.lineTo(0.0f, f20);
        generalPath.closePath();
        Shape shape = affineTransform.createTransformedShape(generalPath);
        this.x1 = (float)shape.getBounds2D().getX();
        this.x2 = (float)shape.getBounds2D().getMaxX();
        this.y2 = (float)shape.getBounds2D().getMinY();
        this.y1 = (float)shape.getBounds2D().getMaxY();
        if (stringBuffer.length() == 0) {
            stringBuffer = null;
        }
        this.old_Tm[0][0] = this.current_text_state.Tm[0][0];
        this.old_Tm[0][1] = this.current_text_state.Tm[0][1];
        this.old_Tm[0][2] = this.current_text_state.Tm[0][2];
        this.old_Tm[1][0] = this.current_text_state.Tm[1][0];
        this.old_Tm[1][1] = this.current_text_state.Tm[1][1];
        this.old_Tm[1][2] = this.current_text_state.Tm[1][2];
        this.old_Tm[2][0] = this.x2;
        this.old_Tm[2][1] = this.y2;
        this.old_Tm[2][2] = this.current_text_state.Tm[2][2];
        return stringBuffer;
    }

    protected final void printTextLine(Graphics2D graphics2D, byte[] byArray, TextState textState) {
        float[][] fArray = textState.getTrm();
        float[][] fArray2 = new float[3][3];
        String string = "";
        this.last_char = (char)32;
        this.next_char = (char)32;
        this.raw_char = (char)32;
        this.raw_int = 0;
        float f = 0.0f;
        int n = byArray.length - 3;
        int n2 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        boolean bl = textState.is_horizontal_writing_mode;
        boolean bl2 = false;
        int n3 = textState.getCurrentFontSize();
        float f4 = textState.getTfs();
        float f5 = textState.getWordSpacing() / f4;
        float f6 = textState.getCharacterSpacing() / f4;
        String string2 = textState.getFontName();
        String string3 = textState.getFontID();
        Font font = Fonts.getFontObject(1, string2);
        float f7 = this.current_font_data.getTextYScale(string3);
        if ((char)byArray[0] == '[') {
            n2 = 1;
            --n;
        }
        this.i = 0;
        while (this.i < n - n2) {
            this.last_char = this.raw_char;
            this.raw_int = byArray[this.i + n2];
            if (this.raw_int < 0) {
                this.raw_int = 256 + this.raw_int;
            }
            this.raw_char = (char)this.raw_int;
            if (bl2 & this.last_char != '\\' & this.raw_char == ')') {
                bl2 = false;
            }
            if (bl2) {
                string = this.raw_char == '\\' ? this.processEscape(n2, byArray) : this.current_font_data.convertCodeToUnicodeGlyph(this.raw_int, string2, string3);
                if (string.length() > 0) {
                    AffineTransform affineTransform;
                    Area area;
                    fArray2 = new float[3][3];
                    fArray2[0][0] = 1.0f;
                    fArray2[0][1] = 0.0f;
                    fArray2[0][2] = 0.0f;
                    fArray2[1][0] = 0.0f;
                    fArray2[1][1] = 1.0f;
                    fArray2[1][2] = 0.0f;
                    fArray2[2][0] = f3 + f;
                    fArray2[2][1] = 0.0f;
                    fArray2[2][2] = 1.0f;
                    fArray = Matrix.multiply(fArray2, fArray);
                    f = 0.0f;
                    f2 = this.current_font_data.getWidth(string3, this.raw_int);
                    if (this.cached_shapes[this.raw_int] != null) {
                        area = this.cached_shapes[this.raw_int];
                    } else {
                        GlyphVector glyphVector = font.createGlyphVector(frc, string);
                        area = new Area(glyphVector.getOutline());
                        affineTransform = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1] * (1000.0f / f7), 0.0f, 0.0f);
                        affineTransform.scale((double)f2 / glyphVector.getLogicalBounds().getMaxX(), -1.0);
                        area.transform(affineTransform);
                        this.cached_shapes[this.raw_int] = area;
                    }
                    affineTransform = AffineTransform.getTranslateInstance(fArray[2][0], fArray[2][1]);
                    AffineTransform affineTransform2 = this.pdf_selected_image_g2.getTransform();
                    this.pdf_selected_image_g2.setTransform(affineTransform);
                    this.pdf_selected_image_g2.fill(area);
                    this.pdf_selected_image_g2.setTransform(affineTransform2);
                    if (this.raw_char == ' ') {
                        f2 += f5;
                    }
                    f3 = f2 += f6;
                }
            } else if (this.raw_char == '(') {
                bl2 = true;
            } else if (n - this.i - n2 > 4) {
                this.next_char = (char)40;
                float f8 = -this.processLeading(byArray, n2, this.raw_char) / 1000.0f;
                f += f8;
            }
            ++this.i;
        }
    }

    private final String getSpaces(float f, float f2, float f3) {
        String string = "";
        if (f2 > 0.0f) {
            if (f > f2) {
                while (f >= f2) {
                    string = " " + string;
                    f -= f2;
                }
            } else if (f > f2 * f3) {
                string = string + " ";
            }
        }
        return string;
    }

    private final float processLeading(byte[] byArray, int n, char c) {
        char c2;
        float f = 0.0f;
        if (c == ')' & (c2 = (char)byArray[this.i + 1 + n]) != '(' & c2 != 'T' & c2 != 't') {
            StringBuffer stringBuffer = new StringBuffer();
            ++this.i;
            while (true) {
                c = c2;
                stringBuffer.append(c);
                c2 = (char)byArray[this.i + 1 + n];
                if (c2 == '(') break;
                ++this.i;
            }
            f = Float.parseFloat(stringBuffer.toString());
        }
        return f;
    }

    private final int readEscapeValue(byte[] byArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append((char)byArray[n + n4]);
            ++n4;
        }
        int n5 = Integer.parseInt(stringBuffer.toString(), n3);
        return n5;
    }

    protected void flushShapeCache() {
        this.cached_shapes = new Area[256];
    }

    private final String processEscape(int n, byte[] byArray) {
        String string = "";
        ++this.i;
        this.raw_int = byArray[this.i + n];
        this.raw_char = (char)this.raw_int;
        if (this.raw_int != 13) {
            string = this.current_font_data.convertCodeToUnicodeGlyph(this.raw_int, this.current_font, this.font_ID);
            if (string.length() > 0) {
                this.raw_char = string.charAt(0);
            }
            if (this.raw_char == 't') {
                this.raw_char = (char)32;
                string = " ";
            } else if (this.raw_char == 'u') {
                this.raw_int = this.readEscapeValue(byArray, this.i + n + 1, 4, 16);
                this.i += 4;
                string = this.current_font_data.convertCodeToUnicodeGlyph(this.raw_int, this.current_font, this.font_ID);
            } else if (Character.isDigit((char)byArray[this.i + n])) {
                this.raw_int = this.readEscapeValue(byArray, this.i + n, 3, 8);
                this.i += 2;
                this.raw_char = (char)this.raw_int;
                string = this.current_font_data.convertCodeToUnicodeGlyph(this.raw_int, this.current_font, this.font_ID);
            }
        }
        return string;
    }
}

