/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfColor {
    public static RenderingHints hints = null;
    private HashMap indexedColors = new HashMap();
    public static final int ICCBased = 7;
    public static final int CalGray = 4;
    public static final int DeviceGray = 1;
    public static final int DeviceN = 11;
    public static final int Separation = 10;
    public static final int Pattern = 9;
    public static final int Lab = 6;
    public static final int Indexed = 8;
    public static final int DeviceRGB = 2;
    public static final int CalRGB = 5;
    public static final int DeviceCMYK = 3;
    private float[] W;
    private float[] G;
    private float[] Ma;
    private float[] B;
    private float[] R;
    private boolean flag_separation = false;
    private boolean flag_lab = false;
    private PdfObjectReader current_pdf_file;
    private HashMap sep_color = new HashMap();
    private boolean flag_cmyk = false;
    private HashMap colorspaces = new HashMap();
    private final int[] div = new int[]{0x1000000, 65536, 256, 1};
    private final int[] factors = new int[]{-16777216, 0xFF0000, 65280, 255};

    public PdfColor(PdfObjectReader pdfObjectReader) {
        this.current_pdf_file = pdfObjectReader;
    }

    public String getIndexedColorComponent(String string, int n, int n2) {
        return (String)this.indexedColors.get(string + ":" + n + ":" + n2);
    }

    /*
     * Unable to fully structure code
     */
    public final void setColorSpace(boolean var1_1, GraphicsState var2_2, String var3_3, boolean var4_4, String var5_5) throws PdfException {
        block39: {
            block37: {
                block38: {
                    var6_6 = 2;
                    var7_7 = ColorSpace.getInstance(1000);
                    var8_8 = Color.black;
                    if (var3_3.indexOf("/Indexed") != -1) {
                        try {
                            var10_9 = new StringTokenizer(var3_3, "[]<> ");
                            var10_9.nextToken();
                            var10_9.nextToken();
                            var11_12 = Integer.parseInt(var10_9.nextToken()) + 1;
                            var12_15 = var10_9.nextToken();
                            if (var12_15.startsWith("(\\")) {
                                var13_16 = new StringTokenizer((String)var12_15, "(\\)");
                                var9_20 = new StringBuffer();
                                while (var13_16.hasMoreTokens()) {
                                    var14_21 = Integer.parseInt(var13_16.nextToken(), 8);
                                    var15_22 = Integer.toHexString(var14_21);
                                    if (var15_22.length() < 2) {
                                        var9_20.append("0");
                                    }
                                    var9_20.append(var15_22);
                                }
                            } else {
                                var9_20 = new StringBuffer((String)var12_15);
                                while (var10_9.hasMoreTokens()) {
                                    var9_20.append(var10_9.nextToken());
                                }
                            }
                            var13_17 = var9_20.length() / (var11_12 * 2);
                            var14_21 = 0;
                            while (var14_21 < var11_12) {
                                var15_23 = 0;
                                while (var15_23 < var13_17) {
                                    var16_24 = var14_21 * var13_17 * 2 + var15_23 * 2;
                                    var17_25 = var9_20.substring(var16_24, var16_24 + 2);
                                    this.indexedColors.put(var5_5 + ":" + var14_21 + ":" + var15_23, var17_25);
                                    ++var15_23;
                                }
                                ++var14_21;
                            }
                        }
                        catch (Exception var10_10) {
                            LogWriter.writeLog("Exception " + var10_10 + " reading indexed colourspace");
                        }
                    }
                    if ((var10_11 = var3_3.indexOf("/Separation")) == -1) break block37;
                    var11_13 = "";
                    if ((var10_11 = (var3_3 = var3_3.substring(var10_11)).indexOf("]")) != -1) {
                        var3_3 = var3_3.substring(0, var10_11);
                    }
                    var12_15 = new StringTokenizer(var3_3, " ");
                    var13_18 = var12_15.nextToken();
                    var13_18 = var12_15.nextToken();
                    var11_13 = var12_15.nextToken();
                    if (var11_13.indexOf("/") != -1) ** GOTO lbl60
                    var11_13 = var11_13 + " " + var12_15.nextToken() + " " + var12_15.nextToken();
                    var11_13 = this.current_pdf_file.getValue(var11_13);
                    break block38;
lbl-1000:
                    // 1 sources

                    {
                        var11_13 = var11_13 + " " + var12_15.nextToken();
lbl60:
                        // 2 sources

                        ** while (var11_13.indexOf((String)">>") == -1 && var12_15.hasMoreTokens())
                    }
                }
                var3_3 = Strip.removeArrayMarkers(var11_13);
                var6_6 = 10;
                this.flag_separation = true;
                break block39;
            }
            if (var3_3.indexOf("/DeviceGray") != -1 | var3_3.indexOf("/G ") != -1) {
                var6_6 = 1;
                var7_7 = ColorSpace.getInstance(1003);
                var8_8 = Color.black;
            } else if (var3_3.indexOf("/DeviceRGB") != -1 | var3_3.indexOf("/RGB") != -1) {
                var6_6 = 2;
                var7_7 = ColorSpace.getInstance(1000);
                var8_8 = Color.black;
            } else if (var3_3.indexOf("/DeviceCMYK") != -1 | var3_3.indexOf("/CMYK") != -1) {
                var6_6 = 3;
                this.flag_cmyk = true;
            } else if (var3_3.indexOf("/CalGray") != -1) {
                var6_6 = 4;
                var8_8 = Color.black;
                var7_7 = this.createCIEXYZColorSpace(this.getCIEValues(var3_3));
            } else if (var3_3.indexOf("/CalRGB") != -1) {
                var6_6 = 5;
                var8_8 = Color.black;
                var7_7 = this.createCIEXYZColorSpace(this.getCIEValues(var3_3));
            } else if (var3_3.indexOf("/Lab") != -1) {
                var6_6 = 6;
                var8_8 = Color.black;
                var7_7 = this.createCIEXYZColorSpace(this.getCIEValues(var3_3));
                if (var1_1 == true & this.flag_lab == false) {
                    ShowGUIMessage.showGUIMessage("Lab colorspace has been used - will display with false colours", "Lab colorspaces");
                    this.flag_lab = true;
                }
            } else if (var3_3.indexOf("/ICCBased") != -1) {
                var6_6 = 7;
                var8_8 = Color.black;
                var10_11 = var3_3.indexOf("/ICCBased");
                var11_14 = var3_3.substring(var10_11 + 9);
                if ((var10_11 = var11_14.indexOf("]")) != -1) {
                    var11_14 = var11_14.substring(0, var10_11 - 1).trim();
                }
                if ((var12_15 = (Object)this.current_pdf_file.getICCData(var11_14)) == null) {
                    LogWriter.writeLog("Error in reading ICC data with ref " + var11_14);
                } else {
                    var13_19 = ICC_Profile.getInstance((byte[])var12_15);
                    var7_7 = new ICC_ColorSpace(var13_19);
                }
            } else if (var3_3.indexOf("/Indexed") != -1) {
                var6_6 = 8;
            } else if (var3_3.indexOf("/Pattern") != -1) {
                var6_6 = 9;
            } else if (var3_3.indexOf("/DeviceN") != -1) {
                var6_6 = 11;
            }
        }
        if (var4_4) {
            var2_2.setStrokeColorspace(var6_6, var7_7);
            var2_2.setStrokeColor(var8_8, false);
            var2_2.setStrokeColorspaceNumber(var6_6);
        } else {
            var2_2.setNonStrokeColorspace(var6_6, var7_7);
            var2_2.setNonStrokeColor(var8_8, false);
            var2_2.setNonStrokeColorspaceNumber(var6_6);
        }
    }

    public final Color setCalGray(ColorSpace colorSpace, Vector vector) {
        float f = Float.parseFloat((String)vector.elementAt(0));
        float[] fArray = new float[3];
        float f2 = (float)Math.pow(f, this.G[0]);
        fArray[0] = this.W[0] * f2;
        fArray[1] = this.W[1] * f2;
        fArray[2] = this.W[2] * f2;
        Color color = Color.red;
        try {
            color = new Color(colorSpace, fArray, 1.0f);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception creating colour with " + fArray[0] + " " + fArray[1] + " " + fArray[2]);
        }
        return color;
    }

    public final String getColorSpaceName(String string) {
        return (String)this.colorspaces.get(string);
    }

    public final boolean hasSeparationColors() {
        boolean bl = this.flag_separation;
        this.flag_separation = false;
        return bl;
    }

    public final Color getSepFalseColor(String string) {
        return (Color)this.sep_color.get(string);
    }

    public final void readColorSpaces(String string) throws PdfException {
        String string2 = "";
        string = Strip.stripMainBraces(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = "";
            if (string4.equals("[")) {
                try {
                    while (string4.indexOf("]") == -1) {
                        string4 = string4 + " " + stringTokenizer.nextToken();
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading colorspace from " + string);
                }
                string5 = string4;
            } else {
                string4 = string4 + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
                string5 = this.current_pdf_file.readObjectDataLine(string4, false);
            }
            this.colorspaces.put(string3, string5);
            if (this.getSepFalseColor(string3) != null) continue;
            this.sep_color.put(string3, new Color((int)(256.0 * Math.random()), (int)(256.0 * Math.random()), (int)(256.0 * Math.random())));
        }
    }

    public final Color setCalRGB(ColorSpace colorSpace, Vector vector) {
        int n = vector.size();
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
        if (n == 3) {
            int n2 = 0;
            while (n2 < n) {
                fArray[n2] = Float.parseFloat((String)vector.elementAt(2 - n2));
                ++n2;
            }
        }
        float[] fArray2 = new float[3];
        float f = (float)Math.pow(fArray[0], this.G[0]);
        float f2 = (float)Math.pow(fArray[1], this.G[1]);
        float f3 = (float)Math.pow(fArray[2], this.G[2]);
        fArray2[0] = this.Ma[0] * f + this.Ma[3] * f2 + this.Ma[6] * f3;
        fArray2[1] = this.Ma[1] * f + this.Ma[4] * f2 + this.Ma[7] * f3;
        fArray2[2] = this.Ma[2] * f + this.Ma[5] * f2 + this.Ma[8] * f3;
        int n3 = 0;
        while (n3 < 3) {
            fArray2[n3] = this.calibrateValues(fArray2[n3], n3);
            ++n3;
        }
        Color color = Color.red;
        try {
            color = new Color(colorSpace, fArray2, 1.0f);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " creating colour with " + fArray2[0] + " " + fArray2[1] + " " + fArray2[2]);
        }
        return color;
    }

    public final boolean hasCMYKColors() {
        boolean bl = this.flag_cmyk;
        this.flag_cmyk = false;
        return bl;
    }

    public static final Color setCMYKColor(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7 = f + f4;
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        if ((f6 = f2 + f4) > 1.0f) {
            f6 = 1.0f;
        }
        if ((f5 = f3 + f4) > 1.0f) {
            f5 = 1.0f;
        }
        return PdfColor.setColor(f7, f6, f5);
    }

    public static final Color setColor(float f, float f2, float f3) {
        return new Color((int)(255.0f * (1.0f - f)), (int)(255.0f * (1.0f - f2)), (int)(255.0f * (1.0f - f3)));
    }

    private final ColorSpace createCIEXYZColorSpace(HashMap hashMap) {
        int n;
        StringTokenizer stringTokenizer;
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1001);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
        float[] fArray = new float[]{-100.1f, -100.0f, 100.0f};
        float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f};
        float[] fArray5 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        String string = (String)hashMap.get("WhitePoint");
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray2[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if ((string = (String)hashMap.get("BlackPoint")) != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray3[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if ((string = (String)hashMap.get("Range")) != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if ((string = (String)hashMap.get("Matrix")) != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray5[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if ((string = (String)hashMap.get("Gamma")) != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray4[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        this.G = fArray4;
        this.Ma = fArray5;
        this.W = fArray2;
        this.B = fArray3;
        this.R = fArray;
        return iCC_ColorSpace;
    }

    private final HashMap getCIEValues(String string) throws PdfException {
        HashMap hashMap;
        int n = string.indexOf(" ");
        String string2 = string.substring(n);
        if (string2.endsWith("R")) {
            hashMap = this.current_pdf_file.readObjectData(string2, false, false, false);
        } else {
            if (string2.endsWith("]")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            hashMap = this.current_pdf_file.decodeStringIntoValue(string2, false);
        }
        return hashMap;
    }

    private final float calibrateValues(float f, int n) {
        float f2 = this.W[n] - this.B[n];
        float f3 = f / f2;
        return f3;
    }

    private final byte[] setXYZNumber(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            byte[] byArray = new byte[]{88, 89, 90, 32, 0, 0, 0, 0};
            byteArrayOutputStream.write(byArray);
            while (stringTokenizer.hasMoreTokens()) {
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Math.abs(d);
                int n = (int)(d * 65536.0);
                int n2 = 0;
                while (n2 < 4) {
                    byteArrayOutputStream.write((n & this.factors[n2]) / this.div[n2]);
                    ++n2;
                }
            }
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " with XYZ number");
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

