/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfImageData;

public class ExtractImages {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    public ExtractImages() {
    }

    public ExtractImages(String string) {
        String string2 = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(string2)) {
            this.user_dir = this.user_dir + string2;
        }
        PdfDecoder pdfDecoder = null;
        ObjectStore.init("demo");
        int n = 1;
        int n2 = 1;
        try {
            pdfDecoder = new PdfDecoder(false);
            System.out.println("Opening file :" + string);
            pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
            System.exit(1);
        }
        String string3 = "jpg";
        String string4 = this.user_dir + "demo_images" + string2;
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        System.out.println("Images will be in directory " + string4);
        try {
            int n3 = n;
            while (n3 < n2 + 1) {
                pdfDecoder.decodePage(false, n3);
                PdfImageData pdfImageData = pdfDecoder.getPdfImageData();
                int n4 = pdfImageData.getImageCount();
                if (n4 > 0) {
                    System.out.println("This page contains " + n4 + " images");
                }
                int n5 = 0;
                while (n5 < n4) {
                    String string5 = pdfImageData.getImageName(n5);
                    try {
                        String string6 = ObjectStore.getImageType(string5);
                        BufferedImage bufferedImage = ObjectStore.loadStoredImage("R" + string5);
                        ObjectStore.saveStoredImage(string4 + n3 + "R" + string5, bufferedImage, true, false, string3);
                        bufferedImage = ObjectStore.loadStoredImage(string5);
                        if (string3.indexOf("jp") != -1) {
                            bufferedImage = ObjectStore.convertToRGB(bufferedImage);
                        }
                        ObjectStore.saveStoredImage(string4 + n3 + string5, bufferedImage, true, false, string3);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception " + exception + " in extracting images");
                    }
                    ++n5;
                }
                pdfDecoder.clearPdfImageData();
                ++n3;
            }
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            System.err.println("Exception " + exception.getMessage());
            System.exit(1);
        }
        pdfDecoder.markAllPagesAsUnread();
        pdfDecoder.flushObjectValues(false);
        System.out.println("Images read");
        pdfDecoder.closePdfFile();
        ObjectStore.flush();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract images from a page");
        String string = test_file;
        if (stringArray.length != 1) {
            System.out.println("Default test file used");
        } else {
            string = stringArray[0];
            System.out.println("File :" + string);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
            System.exit(1);
        }
        ExtractImages extractImages = new ExtractImages(string);
    }
}

