/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.io.ObjectStore;

public class ExtractPagesAsThumbnails {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    public ExtractPagesAsThumbnails() {
    }

    public ExtractPagesAsThumbnails(String string) {
        String string2 = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(string2)) {
            this.user_dir = this.user_dir + string2;
        }
        PdfDecoder pdfDecoder = null;
        ObjectStore.init("demo");
        int n = 1;
        int n2 = 1;
        String string3 = "jpg";
        String string4 = this.user_dir + "demo_thumbnails" + string2;
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            pdfDecoder = new PdfDecoder(true);
            System.out.println("Opening file :" + string);
            pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
            System.exit(1);
        }
        System.out.println("Thumbnails will be in directory " + string4);
        try {
            int n3 = n;
            while (n3 < n2 + 1) {
                pdfDecoder.initDisplay(n3);
                pdfDecoder.decodePage(true, n3);
                String string5 = "page_" + n3;
                try {
                    BufferedImage bufferedImage = pdfDecoder.getPageAsImage();
                    if (bufferedImage == null) {
                        System.out.println("No image generated - are you using client mode");
                    } else {
                        AffineTransform affineTransform = new AffineTransform();
                        affineTransform.scale(0.1, 0.1);
                        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
                        bufferedImage = affineTransformOp.filter(bufferedImage, null);
                        ObjectStore.saveStoredImage(string4 + n3 + string5, bufferedImage, true, false, string3);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception " + exception + " in extracting images");
                }
                pdfDecoder.clearPdfImageData();
                ++n3;
            }
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            System.err.println("Exception " + exception.getMessage());
            System.exit(1);
        }
        pdfDecoder.markAllPagesAsUnread();
        pdfDecoder.flushObjectValues(false);
        System.out.println("Thumbnails created");
        pdfDecoder.closePdfFile();
        ObjectStore.flush();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract images from a page");
        String string = test_file;
        if (stringArray.length != 1) {
            System.out.println("Default test file used");
        } else {
            string = stringArray[0];
            System.out.println("File :" + string);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
            System.exit(1);
        }
        ExtractPagesAsThumbnails extractPagesAsThumbnails = new ExtractPagesAsThumbnails(string);
    }
}

