/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.io.File;
import org.jdom.Element;
import org.jpedal.PdfDecoder;
import org.jpedal.grouping.PdfGenericGrouping;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfData;

public class ExtractTextObjects {
    private String user_dir = System.getProperty("user.dir");
    private PdfGenericGrouping no_grouping = new PdfGenericGrouping();
    private static String test_file = "/mnt/win_d/sample.pdf";

    public ExtractTextObjects() {
    }

    public ExtractTextObjects(String string) {
        String string2 = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(string2)) {
            this.user_dir = this.user_dir + string2;
        }
        PdfDecoder pdfDecoder = null;
        int n = 1;
        int n2 = 1;
        ObjectStore.init("demo");
        try {
            pdfDecoder = new PdfDecoder(false);
            System.out.println("Opening file :" + string);
            pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
            System.exit(1);
        }
        try {
            int n3 = n;
            while (n3 < n2 + 1) {
                pdfDecoder.decodePage(false, n3);
                PdfData pdfData = pdfDecoder.getPdfData();
                this.no_grouping.decodePageFragments(pdfData, n3);
                int n4 = pdfData.getTextElementCount();
                System.out.println("This page contains " + n4 + " text objects");
                int n5 = 0;
                while (n5 < n4) {
                    Element element = pdfData.getTextElementAt(n5);
                    String string3 = element.getAttributeValue("content");
                    float f = Float.parseFloat(element.getAttributeValue("x1"));
                    float f2 = Float.parseFloat(element.getAttributeValue("y1"));
                    float f3 = Float.parseFloat(element.getAttributeValue("x2"));
                    float f4 = Float.parseFloat(element.getAttributeValue("y2"));
                    String string4 = element.getAttributeValue("fonts_used");
                    System.out.println("============ITEM  " + n5 + "========================");
                    System.out.println("Text=" + string3);
                    System.out.println("==");
                    System.out.println("Rectangular shape=" + f + " " + f2 + " " + f3 + " " + f4);
                    System.out.println("==");
                    System.out.println("Fonts=" + string4);
                    ++n5;
                }
                pdfDecoder.flushObjectValues(false);
                ++n3;
            }
        }
        catch (Exception exception) {
            pdfDecoder.closePdfFile();
            System.err.println("Exception " + exception.getMessage());
            System.exit(1);
        }
        pdfDecoder.markAllPagesAsUnread();
        pdfDecoder.flushObjectValues(false);
        System.out.println("Text read");
        pdfDecoder.closePdfFile();
        ObjectStore.flush();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract text objects");
        String string = test_file;
        if (stringArray.length != 1) {
            System.out.println("Default test file used");
        } else {
            string = stringArray[0];
            System.out.println("File :" + string);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
            System.exit(1);
        }
        ExtractTextObjects extractTextObjects = new ExtractTextObjects(string);
    }
}

