/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.rasterviewer;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.examples.rasterviewer.PageLoader;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.PdfPanel;
import org.jpedal.gui.SafePdfPanel;

public class AsynchronousPageLoader
extends PageLoader
implements Runnable {
    private transient Vector changeListeners;
    private ArrayList commandQueue = new ArrayList();
    private Thread thread = new Thread((Runnable)this, "pdf_page_loader_" + instanceCounter++);
    private static int instanceCounter = 0;
    private boolean interrupted = false;

    public AsynchronousPageLoader(SafePdfPanel safePdfPanel, byte[] byArray) throws PdfException {
        super((PdfPanel)safePdfPanel, byArray);
        this.thread.start();
    }

    public AsynchronousPageLoader(SafePdfPanel safePdfPanel, String string) throws PdfException {
        super((PdfPanel)safePdfPanel, string);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        ArrayList arrayList = this.commandQueue;
        synchronized (arrayList) {
            this.commandQueue.clear();
            this.interrupted = true;
            this.commandQueue.notifyAll();
        }
        super.finalize();
    }

    public void loadPage(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            public void run() {
                AsynchronousPageLoader.this.cmdLoadPage(n2);
            }
        };
        this.enqueueCommand(runnable);
    }

    public void zoomIn() {
        Runnable runnable = new Runnable(){

            public void run() {
                AsynchronousPageLoader.this.cmdZoomIn();
            }
        };
        this.enqueueCommand(runnable);
    }

    public void zoomOut() {
        Runnable runnable = new Runnable(){

            public void run() {
                AsynchronousPageLoader.this.cmdZoomOut();
            }
        };
        this.enqueueCommand(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueCommand(Runnable runnable) {
        if (this.commandQueue == null) {
            this.commandQueue = new ArrayList();
        }
        ArrayList arrayList = this.commandQueue;
        synchronized (arrayList) {
            this.commandQueue.add(runnable);
            this.commandQueue.notifyAll();
        }
    }

    private void cmdLoadPage(int n) {
        super.loadPage(n);
        this.fireStateChanged(new ChangeEvent(this));
    }

    private void cmdZoomIn() {
        super.zoomIn();
        this.fireStateChanged(new ChangeEvent(this));
    }

    private void cmdZoomOut() {
        super.zoomOut();
        this.fireStateChanged(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.interrupted) {
            Runnable runnable = null;
            ArrayList arrayList = this.commandQueue;
            synchronized (arrayList) {
                if (this.commandQueue.size() == 0) {
                    try {
                        this.commandQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        break;
                    }
                }
                if (this.commandQueue.size() > 0) {
                    runnable = (Runnable)this.commandQueue.get(0);
                    this.commandQueue.remove(0);
                }
            }
            if (runnable == null) continue;
            runnable.run();
        }
    }

    public synchronized void removeChangeListener(ChangeListener changeListener2) {
        if (this.changeListeners != null && this.changeListeners.contains(changeListener2)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(changeListener2);
            this.changeListeners = vector;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener2) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(changeListener2)) {
            vector.addElement(changeListener2);
            this.changeListeners = vector;
        }
    }

    protected void safeFireStateChanged(ChangeEvent changeEvent) {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ChangeListener)vector.elementAt(n2)).stateChanged(changeEvent);
                ++n2;
            }
        }
    }

    protected void fireStateChanged(ChangeEvent changeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.safeFireStateChanged(changeEvent);
        } else {
            final ChangeEvent changeEvent2 = changeEvent;
            Runnable runnable = new Runnable(){

                public void run() {
                    AsynchronousPageLoader.this.safeFireStateChanged(changeEvent2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

