/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.rasterviewer;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.PdfPanel;
import org.jpedal.text.PdfThreshold;

public class PageLoader {
    public static final int BACK = -1;
    public static final int FORWARD = 1;
    public static final int FLAT = 0;
    private double zoomFactor;
    private PdfPanel panel;
    private String document;
    private int currentPage;
    private int pageCount;
    private PdfDecoder decoder;
    private final double MAX_ZOOM = 3.0;
    private final double MIN_ZOOM = 0.05;
    private final double ZOOM_INC = 0.2;

    public void zoomIn() {
        this.zoomFactor += 0.2;
        if (this.zoomFactor >= 3.0) {
            this.zoomFactor -= 0.2;
        } else {
            int n = (int)((double)this.panel.getWidth() + (double)this.panel.getWidth() * this.zoomFactor);
            int n2 = (int)((double)this.panel.getHeight() + (double)this.panel.getHeight() * this.zoomFactor);
            this.panel.setSize(new Dimension(n, n2));
            this.loadPage(0);
        }
    }

    public PageLoader(PdfPanel pdfPanel, String string) throws PdfException {
        this.panel = pdfPanel;
        this.document = string;
        this.decoder = new PdfDecoder(true);
        this.decoder.openPdfFile(string);
        this.pageCount = this.decoder.getPageCount();
        this.currentPage = 1;
        this.zoomFactor = 1.0;
        this.loadPage(0);
    }

    public PageLoader(PdfPanel pdfPanel, byte[] byArray) throws PdfException {
        this.panel = pdfPanel;
        this.document = this.document;
        this.decoder = new PdfDecoder(true);
        this.decoder.openPdfFile(byArray);
        this.pageCount = this.decoder.getPageCount();
        this.currentPage = 1;
        this.zoomFactor = 1.0;
        this.loadPage(0);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void zoomOut() {
        this.zoomFactor -= 0.2;
        if (this.zoomFactor <= 0.05) {
            this.zoomFactor += 0.2;
        } else {
            int n = (int)((double)this.panel.getWidth() - (double)this.panel.getWidth() * this.zoomFactor);
            int n2 = (int)((double)this.panel.getHeight() - (double)this.panel.getHeight() * this.zoomFactor);
            this.panel.setSize(new Dimension(n, n2));
            this.loadPage(0);
        }
    }

    public void loadPage(int n) {
        this.panel.flushImage();
        int n2 = this.currentPage + n;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n2 > this.pageCount) {
            n2 = this.pageCount;
        }
        this.currentPage = n2;
        this.panel.initForDecodeDisplay((float)this.zoomFactor, this.decoder.getMaxX(n2), this.decoder.getMaxY(n2));
        this.decoder.initValues(true, true, true, false, new PdfThreshold(), 72, false, "", 0, true);
        this.decoder.setPanel(this.panel, n2);
        try {
            BufferedImage bufferedImage;
            if (this.decoder.decodePage(true, n2) && (bufferedImage = this.decoder.getPageAsImage()) != null) {
                this.panel.setImage(bufferedImage, this.decoder.getMaxY(n2), this.zoomFactor, n2);
                this.decoder.clearPdfImageData();
            }
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace(System.err);
        }
        this.decoder.markAllPagesAsUnread();
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

