/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.rasterviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import org.jpedal.examples.rasterviewer.PageLoader;
import org.jpedal.examples.rasterviewer.ViewerFrame_AboutBoxPanel1;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.PdfPanel;
import org.jpedal.utils.LogWriter;

public class ViewerFrame
extends JFrame {
    public String document;
    public boolean file_being_opened = false;
    public String input_dir = System.getProperty("user.dir");
    JMenuItem menuFileExit = new JMenuItem();
    ImageIcon imageBack = new ImageIcon((class$org$jpedal$examples$rasterviewer$ViewerFrame == null ? (class$org$jpedal$examples$rasterviewer$ViewerFrame = ViewerFrame.class$("org.jpedal.examples.rasterviewer.ViewerFrame")) : class$org$jpedal$examples$rasterviewer$ViewerFrame).getResource("backpage.gif"));
    JToolBar toolBar = new JToolBar();
    ImageIcon imageZoomOut = new ImageIcon((class$org$jpedal$examples$rasterviewer$ViewerFrame == null ? (class$org$jpedal$examples$rasterviewer$ViewerFrame = ViewerFrame.class$("org.jpedal.examples.rasterviewer.ViewerFrame")) : class$org$jpedal$examples$rasterviewer$ViewerFrame).getResource("zoomout.gif"));
    JButton buttonZoomIn = new JButton();
    PdfPanel pdfPanel = new PdfPanel();
    ImageIcon imageForward = new ImageIcon((class$org$jpedal$examples$rasterviewer$ViewerFrame == null ? (class$org$jpedal$examples$rasterviewer$ViewerFrame = ViewerFrame.class$("org.jpedal.examples.rasterviewer.ViewerFrame")) : class$org$jpedal$examples$rasterviewer$ViewerFrame).getResource("forwardpage.gif"));
    JMenuItem menuHelpAbout = new JMenuItem();
    ImageIcon imageZoomIn = new ImageIcon((class$org$jpedal$examples$rasterviewer$ViewerFrame == null ? (class$org$jpedal$examples$rasterviewer$ViewerFrame = ViewerFrame.class$("org.jpedal.examples.rasterviewer.ViewerFrame")) : class$org$jpedal$examples$rasterviewer$ViewerFrame).getResource("zoomin.gif"));
    JMenuBar menuBar1 = new JMenuBar();
    PageLoader pageLoader;
    JButton buttonZoomOut = new JButton();
    JButton buttonOpen = new JButton();
    JButton buttonForward = new JButton();
    JLabel pageTracker = new JLabel();
    JButton buttonBack = new JButton();
    JScrollPane scrollPane = new JScrollPane();
    ImageIcon imageOpen = new ImageIcon((class$org$jpedal$examples$rasterviewer$ViewerFrame == null ? (class$org$jpedal$examples$rasterviewer$ViewerFrame = ViewerFrame.class$("org.jpedal.examples.rasterviewer.ViewerFrame")) : class$org$jpedal$examples$rasterviewer$ViewerFrame).getResource("openfile.gif"));
    JPanel statusBar = new JPanel();
    JMenu menuHelp = new JMenu();
    BorderLayout borderLayout1 = new BorderLayout();
    JMenu menuFile = new JMenu();
    static /* synthetic */ Class class$org$jpedal$examples$rasterviewer$ViewerFrame;

    public ViewerFrame() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String selectFlatFile(String string) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(0);
        Container container = this.getContentPane();
        String string2 = null;
        while (true) {
            int n = jFileChooser.showOpenDialog(container);
            File file = jFileChooser.getSelectedFile();
            if (file != null && n == 0) {
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " getting paths");
                }
            } else if (n == 1) {
                JOptionPane.showMessageDialog(container, "Nothing selected");
                file = null;
            } else if (n == -1) {
                JOptionPane.showMessageDialog(container, "Error!");
            }
            if (file == null || file.isFile()) break;
            jFileChooser.grabFocus();
        }
        container.repaint();
        return string2;
    }

    void back_ActionPerformed(ActionEvent actionEvent) {
        this.pageLoader.loadPage(-1);
        this.updatePageTracker();
    }

    void forward_ActionPerformed(ActionEvent actionEvent) {
        this.pageLoader.loadPage(1);
        this.updatePageTracker();
    }

    void updatePageTracker() {
        this.pageTracker.setText("Page " + this.pageLoader.getCurrentPage() + " of " + this.pageLoader.getPageCount());
    }

    void helpAbout_ActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, new ViewerFrame_AboutBoxPanel1(), "About", -1);
    }

    void open_ActionPerformed(ActionEvent actionEvent) {
        if (!this.file_being_opened) {
            this.file_being_opened = true;
            this.document = this.selectFlatFile(this.input_dir);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ViewerFrame.this.pageLoader = new PageLoader(ViewerFrame.this.pdfPanel, ViewerFrame.this.document);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace(System.err);
                    }
                    ViewerFrame.this.file_being_opened = false;
                }
            });
            this.scrollPane.updateUI();
        }
    }

    void zoomOut_ActionPerformed(ActionEvent actionEvent) {
        this.pageLoader.zoomOut();
    }

    void zoomIn_ActionPerformed(ActionEvent actionEvent) {
        this.pageLoader.zoomIn();
    }

    void fileExit_ActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.menuBar1);
        this.getContentPane().setLayout(this.borderLayout1);
        this.setSize(new Dimension(700, 700));
        this.setTitle("RasterViewer Example");
        this.menuFile.setText("File");
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.fileExit_ActionPerformed(actionEvent);
            }
        });
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        this.menuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.helpAbout_ActionPerformed(actionEvent);
            }
        });
        this.buttonOpen.setToolTipText("Open File");
        this.buttonOpen.setIcon(this.imageOpen);
        this.buttonOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.open_ActionPerformed(actionEvent);
            }
        });
        this.buttonBack.setToolTipText("Back 1 Page");
        this.buttonBack.setIcon(this.imageBack);
        this.buttonBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.back_ActionPerformed(actionEvent);
            }
        });
        this.buttonForward.setToolTipText("Forward 1 Page");
        this.buttonForward.setIcon(this.imageForward);
        this.buttonForward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.forward_ActionPerformed(actionEvent);
            }
        });
        this.buttonZoomIn.setToolTipText("Zoom In");
        this.buttonZoomIn.setIcon(this.imageZoomIn);
        this.buttonZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.zoomIn_ActionPerformed(actionEvent);
            }
        });
        this.buttonZoomOut.setToolTipText("Zoom Out");
        this.buttonZoomOut.setIcon(this.imageZoomOut);
        this.buttonZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.zoomOut_ActionPerformed(actionEvent);
            }
        });
        this.menuFile.add(this.menuFileExit);
        this.menuBar1.add(this.menuFile);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuBar1.add(this.menuHelp);
        this.toolBar.add(this.buttonOpen);
        this.toolBar.add(this.buttonBack);
        this.toolBar.add(this.buttonForward);
        this.toolBar.add(this.buttonZoomIn);
        this.toolBar.add(this.buttonZoomOut);
        this.pdfPanel.setBackground(Color.darkGray);
        this.scrollPane.setLayout(new ScrollPaneLayout());
        this.scrollPane.getViewport().setBackground(Color.darkGray);
        this.scrollPane.getViewport().add(this.pdfPanel);
        this.statusBar.add(this.pageTracker);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

